<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;"> 
    <div class="col-md-8  col-sm-8 col-lg-8" style="padding:0px">
    
        <div class="form-group">
            <label class="col-lg-2 control-label">SALES ORDER</label>
            <div class="col-lg-4">
                <select id="select_salesorder" class="form-control select_box"  style="width:100%">
                        <option value="">SELECT SALES ORDER</option>
                </select>
            </div> 

            <div class="col-lg-2">
                <button type="button" class="btn btn-green" id="get_so_report">GET</button>
            </div>
        
            <div class="col-lg-2">
                <button type="button" class="btn btn-success" id="download_so_excel_report" onclick="getSalesorderYieldExcel()" >
                    <span class="fa fa-file-excel-o"></span>&nbsp;&nbsp;Download

                </button>
            </div>

          
        </div>
    </div>    
</div>

<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="SalesOrderWiseList_table">
    <thead>
            <th>DATE</th>
            <th>SALES ORDER NO</th>
            <th>CUSTOMER NAME</th>
            <th>STOCK TYPE</th>
            <th>QUANTITY</th>
            <th>TOTAL<br> AMOUNT</th>
            <th>TAX<br> AMOUNT</th>
            <th>SALES <br> PRICE</th>
            <th>COST<br> PRICE</th>	
            <th>PRICE<br> COLLECTED</th>	
            <th>TCS<br> AMOUNT</th>	
            <th>NET<br> AMOUNT</th>	
            <th>YIELD<br> AMOUNT</th>
            <th>YIELD<br> (%)</th>
    </thead>		
</table>

<script>
    getSalesorderList()
    var so_sales_channel = []

    function getSalesorderList(){

        $.ajax({
            "url": "<?=base_url()?>admin/Yieldreports/getSalesorderList",
            "type": "GET",
            "dataType": "json",
            "success": function(data){

                if(data.status != '1'){
                    return false
                }

                $.each(data.result, function(i,v){
                    var option = '<option value="'+data.result[i].salesorder_id+'">'
                        option += data.result[i].salesorder_code+' / '+data.result[i].vendor_name+'</option>'
                        
                        so_sales_channel[data.result[i].salesorder_id] = data.result[i].sales_channel

                    $("#select_salesorder").append(option)
                })
            },
            "error": function(data){
                toast.error("Failed to get Salesorder List")
            }
        })
    }

$(document).ready(function(){
        
    $("#get_so_report").click(function(){
        
        var salesorder_id = $("#select_salesorder").val()
        var controller = ''

        if(so_sales_channel[salesorder_id] == 'OFFLINE'){
            controller = 'getYieldOfflineSalesorder'
        }else{
            controller = 'getYieldOnlineSalesorder'
        }
        var rmon_list = $('#SalesOrderWiseList_table').DataTable({
                        "paging":true,
                        "destroy":true,
                        "searching":true,
                        "processing": true,
                        "serverSide": false,  
                        //"scrollY": 390,
                       // "scrollX": true,
                        //"scrollCollapse": true,
                        //"autoWidth": false,
                        "aaSorting": [],
                        "ajax": {
                            "url": "<?php echo base_url(); ?>admin/Yieldreports/"+controller,
							"data": {"salesorder_id": salesorder_id},
							"type": "GET",
                            "dataSrc": "data"
                        },
                        "columns": [
                          
                            { "data": "date"},
                            { "data": "salesorder_no" },	
                            { "data": "vendor_name" },
                            { "data": "device_sub_category" },
                            { "data": "quantity" },
                            { "data": "total_amount"},
                            { "data": "tax_amount"},
                            { "data": "sale_price"},
                            { "data": "cost_price"},
                            { "data": "price_collected"},
                            { "data": "tcs_amount"},
                            { "data": "net_amount"},
                            { "data": "yield_amount"},
                            { "data": "yield_perc"},
                        ]
            })
        })
    })
    

    function getSalesorderYieldExcel(){

        var salesorder_id = $("#select_salesorder").val()
        var controller = ''
        if(salesorder_id == '' || salesorder_id == null || salesorder_id == '0' || salesorder_id == 'null'){
            alert("Please select Sales order")
            return false
        }

        if(so_sales_channel[salesorder_id] == 'OFFLINE'){
            controller = 'getSalesorderOfflineYieldExcel'
        }else{
            controller = 'getSalesorderYieldExcel'
        }

        window.open("<?=base_url()?>admin/Yieldreports/"+controller+"?salesorder_id="+salesorder_id, '_blank')
       
    }
</script>