<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 th, td { white-space: nowrap; }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_new">NEW
	</label>
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_whapproved">WH APPROVED
	</label>
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_whrejected">WH REJECTED
	</label>
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_admin_approved">ADMIN APPROVED
    </label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_admin_received">ADMIN RECEIVED
    </label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_admin_part_received">ADMIN PARTLY RECEIVED
    </label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_received_rejected">RECEIVED REJECTED
    </label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_wh_received">RECEIVED
    </label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_wh_part_received">PARTLY RECEIVED
	</label>
		
</div>
<p style="line-height:10px;"></p>

<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="rmonList_table">
	<thead>
		<tr>
            <th></th>
            <th>RMON NO</th>
            <th>SERVICE CENTER NAME</th>
            <th>TYPE</th>
            <th>PURPOSE</th>
            <th>TOTAL<br>QUANTITY</th>
            <th>RECEIVED<br>QUANTITY</th>
            <th>EXPECTED DATE</th>
            <th>CREATED BY</th>
            <th>LAST<br> UPDATED BY</th>					
            <th>LAST<br> UPDATE DATE</th>
            <th></th>
		</tr>
	</thead>		
</table>
							
<script>

var rmon_list;

var department_id = getUserdata('department_id')
var designations_id = getUserdata('designations_id')

function getUserdata(attribute){
    
    var a='';
    $.ajax({
        "url": "<?=base_url()?>Web_api/getUserData/"+attribute,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            a = data.result;
        }
    })
     return a;
}

function rmon_childRows ( d ) {
	// `d` is the original data object for the row
	var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/Triage/getRmonDetails?rmon_id="+d.rmon_id),
		type:"GET",
		dataType: 'json',
		async: false,
		success: function ( data ) {
			if(data.result==null){
                childtable+='<tr><td>No Records Found</td></tr>';
                
			}else{
				childtable += '<th>DEVICE ID</th><th>Product Name</th><th>Category</th><th>SKU</th>'
				childtable += '<th>GRADE</th><th>IMEI</th><th>RETURN STATUS</th>'
                childtable += '<thRemarks</th><th>Received Notes</th>';

				$.each(data.result, function (i, d) { // loop through data returned from ajax 
				childtable+='<tr>'+
					'<td>'+data.result[i].device_id+'</td>'+
					'<td>'+data.result[i].device_name+'</td>'+
					'<td>'+data.result[i].category+'</td>'+
					'<td>'+data.result[i].sku+'</td>'+
					'<td>'+data.result[i].grade+'</td>'+
					'<td>'+data.result[i].imei+'</td>'+
                    '<td>'+data.result[i].return_status+'</td>'+
                    '<td>'+data.result[i].remarks+'</td>'+
                    '<td>'+data.result[i].received_notes+'</td>'+
					
					'</tr>';
				});
			}
		}
	} );
		
	childtable+='</table>';
    childtable+=remarks_table(d.rmon_id);
	return childtable
}

function remarks_table(rmon_id){
	var tableData = '<p></p>';
	tableData += '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
	$.ajax({
		url:"<?php echo base_url();?>web_api/getRemarks/?id="+rmon_id+"&type=trg_rmon",
		type: "GET",
		dataType: 'json',
		async:false,
		success: function (data){
			if(data.status==1){
				tableData+="<thead><th>Date</th><th>By</th><th>Remark</th></thead>"
				$.each(data.remarks,function(i,v){
					tableData+="<tr><td>"+data.remarks[i].date+"</td><td>"+data.remarks[i].username+"</td><td>"+data.remarks[i].remark+"</td></tr>";
				})
			}
		}
	});
	tableData+='</table>'
	return tableData;
  }

$(document).ready(function(){

    getRmonList('NEW')

    function getRmonList(status){

        rmon_list = $('#rmonList_table').DataTable({
                        "paging":true,
                        "destroy":true,
                        "searching":true,
                        "processing": true,
                        "serverSide": false,  
                        "scrollY": 390,
                        "scrollX": true,
                        "scrollCollapse": true,
                        //"autoWidth": false,
                        "aaSorting": [1, 'asc'],
                        "ajax": {
                            "url": "<?php echo base_url(); ?>admin/Triage/getRmonList",
							"data": {"status": status},
							"type": "GET",
                            "dataSrc": "data"
                        },
                        "columns": [
                            {
									"className":      "details-control",
									"orderable":      false,
									"data":           null,
									"defaultContent": ''
							},
                            { "data": "rmon_code", "type":"any-number"},
                            { "data": "service_center" },	
                            { "data": "type" },
                            { "data": "purpose" },
                            { "data": "total_qty" },
                            { "data": "received_qty" },
                            { "data": "EXPECTED_DATE"},
                            { "data": "CREATED_BY"},
                            { "data": "LAST_UPDATED_BY"},
                            { "data": "LAST_UPDATE_DATE"},
                            
                            { "data": function(data){

                                            if(data.status == "NEW"){

                                                if(department_id == '5'){
                                                    
                                                    return '<a class="btn btn-primary" href="<?=base_url()?>admin/Triage/updateRmonForm/'+data.rmon_id+'">UPDATE</a>'
                                                
                                                }else if(department_id == '10'){
                                                    
                                                    return '<a class="btn btn-primary" href="<?=base_url()?>admin/Triage/editRmonForm/'+data.rmon_id+'">EDIT</a>'
                                                }else{
                                                    return null
                                                }
                                           
                                            }else if(data.status == "WH APPROVED" && designations_id == '46'){

                                                return '<a class="btn btn-primary" href="<?=base_url()?>admin/Triage/validateRmonBysecurityAdminForm/'+data.rmon_id+'">UPDATE</a>'
                                            
                                            }else if(data.status == 'WH REJECTED' && department_id == '10'){

                                                return '<a class="btn btn-primary" href="<?=base_url()?>admin/Triage/editRmonForm/'+data.rmon_id+'">EDIT</a>'

                                            }else if(data.status == "ADMIN APPROVED"){

                                                var a = ''
                                                
                                                if(designations_id == '46'){
                                        
                                                    a +=  '<a class="btn btn-primary" href="<?=base_url()?>admin/Triage/receiveAdminRmonForm/'+data.rmon_id+'">RECEIVE</a>'
                                                
                                                }
                                                    a += '<a class="btn btn-primary" href="<?=base_url()?>admin/Triage/rmon_pdf/'+data.rmon_id+'" target="_blank">DOWNLOAD</a>'
                                                
                                                return a
                                            
                                            }else if(data.status == 'ADMIN PARTLY RECEIVED'){

                                                if(designations_id == '46'){
                                                
                                                    return '<a class="btn btn-primary" href="<?=base_url()?>admin/Triage/receiveAdminRmonForm/'+data.rmon_id+'">RECEIVE</a>'
                                                
                                                }else if(department_id == '5'){
                                                    
                                                    return '<a class="btn btn-primary" href="<?=base_url()?>admin/Triage/receiveWHRmonForm/'+data.rmon_id+'">APPROVE</a>'
                                                
                                                }else{
                                                    return null
                                                }
                                            }else if(data.status == 'RECEIVED REJECTED'){
                                                    if(designations_id == '46'){
                                                        return '<a class="btn btn-primary" href="<?=base_url()?>admin/Triage/receiveRejectedRmonForm/'+data.rmon_id+'">UPDATE</a>'
                                                    }else{
                                                        return null
                                                    }
                                            }else if(data.status == 'ADMIN RECEIVED'){

                                                if(department_id == '5'){

                                                    return '<a class="btn btn-primary" href="<?=base_url()?>admin/Triage/receiveWHRmonForm/'+data.rmon_id+'">APPROVE</a>'
                                                
                                                }else{
                                                   
                                                    return null
                                                }

                                            }else if( data.status == 'PARTLY RECEIVED'){
                                                
                                                if(designations_id == '46'){
                                                    return '<a class="btn btn-primary" href="<?=base_url()?>admin/Triage/receiveAdminRmonForm/'+data.rmon_id+'">RECEIVE</a>'
                                                
                                                }else{
                                                    return null
                                                }
                                            }else{
                                                return null;
                                            }
                                        }
                            }

                        ]
        });

    }

    $('#rmonList_table tbody').on('click', 'td.details-control', function () {
        var tr = $(this).closest('tr');
        var row = rmon_list.row( tr );
        if ( row.child.isShown() ) {
            row.child.hide();
            tr.removeClass('shown');
        }else {
            row.child( rmon_childRows(row.data()) ).show();
            tr.addClass('shown');
        }
    }) ;

    $('#button_new').change(function(){
        getRmonList('NEW')
	});

    $('#button_whapproved').change(function(){
        getRmonList('WH_APPROVED')
	});

    $('#button_whrejected').change(function(){
        getRmonList('WH_REJECTED')
	});

    $('#button_admin_approved').change(function(){
        getRmonList('ADMIN_APPROVED')
	});

    $('#button_admin_received').change(function(){
        getRmonList('ADMIN_RECEIVED')
	});

    $('#button_admin_part_received').change(function(){
        getRmonList('ADMIN_PARTLY_RECEIVED')
	});

    $('#button_received_rejected').change(function(){
        getRmonList('RECEIVED_REJECTED')
	});

    $('#button_wh_received').change(function(){
        getRmonList('RECEIVED')
	});

    $('#button_wh_part_received').change(function(){
        getRmonList('PARTLY_RECEIVED')
	});
})

</script>