<p style="line-height:10px;"></p>
<input type="hidden" id = "edit_rmon_id" value="<?=$rmon_id?>">
<h4>RMON Details</h4>
<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="rmonHeader_edit_table">
	<thead>
		<tr>
            <th>RMON NO</th>
            <th>SERVICE CENTER NAME</th>
            <th>STATUS</th>
            <th>TYPE</th>
            <th>PURPOSE</th>
            <th>EXPECTED DATE</th>
            <th>CREATED BY</th>
            <th>LAST<br>UPDATED BY</th>					
            <th>LAST<br>UPDATE DATE</th>
		</tr>
	</thead>		
</table>

<hr style="border: 3px solid #e4eaec">
<h4>Remarks</h4>
<table class="table table-stripped DataTables" id="remarks_table">
    <tr>
        <td>REMARKS</td>
        <td><textarea id="edit_remarks_header" class="form-control" maxlength="200" ></textarea></td>
    </tr>
</table>

<hr style="border: 3px solid #e4eaec">
<h4 style="margin-left: 15px;">Add Products </h4>
<div class="table-responsive" style="width:100%; overflow-x:auto;" > 
    <table class="table table-bordered table-stripped" style="margin-left:15px;" >
        <tbody>
        <tr>
                <td style="width: 200px;">
                    <input type="text" class="form-control"  id="edit_input_deviceid" onchange="getDeviceDetailsforEdit()" placeholder="INWARD ID">
                </td>

                <td>
                    <input type="text" class="form-control" id="edit_input_product_name" placeholder="PRODUCT NAME" readonly>
                </td>

                <td style="width: 150px;">
                    <input type="text" class="form-control"  id="edit_input_category" placeholder="CATEGORY" readonly>
                </td>
                
                <td>
                    <input type="text" class="form-control"  id="edit_input_sku" placeholder="SKU" readonly>
                </td>

                <td rowspan="2">
                    <input type="hidden" id="edit_input_grnreport_id" value="" readonly>

                    <button class="btn btn-secondary" id="edit_btn_add" onclick="addDeviceRowsforEdit()">Add</button>
                </td>
            </tr>
            <tr>
                <td style="width: 150px;">
                    <input type="text" class="form-control"  id="edit_input_grade" placeholder="GRADE" readonly>
                </td>

                <td>
                    <input type="text" class="form-control"  id="edit_input_imei" placeholder="IMEI" readonly>
                </td>

                <td style="width: 150px;">
                    <input type="text" class="form-control"  id="edit_input_status" placeholder="STATUS" readonly>
                </td>

                <td>
                    <textarea class="form-control"  id="edit_textarea_remarks" placeholder="Remarks" ></textarea>
                </td>
              
            </tr>
        </tbody>
    </table>
</div>

<hr style="border: 3px solid #e4eaec">
<div class="form-group table-responsive"> 
    <h4 style="margin-left:15px">DEVICE DETAILS</h4>		
    <table class="table table-bordered table-stripped" style="margin-left:15px; width:100%;" id="rmon_edit_items_table">
        <thead class="priceIcon">
            <tr>
               <th>DEVICE ID</th>
               <th>PRODUCT NAME</th>
               <th>CATEGORY</th>
               <th>SKU</th>
               <th style="width: 100px;">GRADE</th>
               <th>IMEI</th>
               <th>PRODUCT<br> STATUS</th>
               <th>REMARKS</th>
               <th>ACTION</th>
            </tr>
        </thead>	
        <tbody id = "edit_device_tr">
           
        </tbody>
    </table>
</div>

<table>
    <tr>
        <td colspan="13" style="text-align: center;">
            <button class="btn btn-primary" id="edit_submit" name="action" onclick="editRmon()" >Submit</button>
            &nbsp;&nbsp;&nbsp;&nbsp;
            
            <button class="btn btn-red" id="cancel" type="button" onclick="window.location.replace('<?=base_url()?>admin/Triage/manage_triage')">BACK</button>
        </td>
    </tr>
</table>

<script>

var rmon_header;

var rmon_id = $("#edit_rmon_id").val()


edit_rmon_childRows()

function checkNull(entity, message){
		
        if(entity=='0' || entity==0 || entity=='' || entity==null || entity==undefined){ 
				return message;
		}		
		return '';
}

function getServiceCenterListforEdit(selected = ''){
    var s=''
    $.ajax({
        "url": "<?=base_url()?>admin/Triage/getServiceCenterList",
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
                if(data.data !=null){

                    $.each(data.data, function(i,v){

                        if(selected == data.data[i].trg_service_center_id){

                            selected_option = 'selected'
                        }else{
                            selected_option = ''
                        }

                        s += "<option value ='"+data.data[i].trg_service_center_id+"' "+selected_option+">"
                        s += data.data[i].sc_name+'-'+data.data[i].sc_location
                        s += "</option>"
                    })
                }
        }
    })

    return s
}

function getDeviceDetailsforEdit(){

        var device_id = $("#edit_input_deviceid").val()

        $("#edit_input_grnreport_id").val('')
        $("#edit_input_product_name").val('')
        $("#edit_input_imei").val('')
        $("#edit_input_sku").val('')
        $("#edit_input_category").val('')
        $("#edit_input_grade").val('')
        $("#edit_input_status").val('')
        $("#edit_textarea_remarks").val('')

        if(device_id == '' || device_id == null){
            return false
        }
        

        $.ajax({
         
            "url": "<?=base_url()?>admin/Triage/getDeviceDetails",
            "data": { "device_id": device_id},
            "type": "GET",
            "dataType": "json",
            "success": function(data){

                if(data.status == 1){

                    $("#edit_input_grnreport_id").val(data.result.grnreport_id)
                    $("#edit_input_product_name").val(data.result.device_name)
                    $("#edit_input_sku").val(data.result.sku)
                    $("#edit_input_category").val(data.result.stock_type)
                    $("#edit_input_grade").val(data.result.grade)
                    $("#edit_input_imei").val(data.result.imei)
                    $("#edit_input_status").val(data.result.status)



                }else{

                    toastr.error("Enter Valid Inward ID")
                    return false
                }
            }
        })
    }

function edit_rmon_childRows () {
	// `d` is the original data object for the row
	var childtable= '';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/Triage/getRmonDetails"),
        type:"GET",
        data: { "rmon_id": rmon_id},
		dataType: 'json',
		async: false,
		success: function ( data ) {
			if(data.result==null){
                childtable+='<tr><td>No Records Found</td></tr>';
                
			}else{

				$.each(data.result, function (i, d) { // loop through data returned from ajax 
                
                    childtable += '<tr class="tr_edit_device_rows">'+
                                
                    '<td>'+data.result[i].device_id+'</td>'+
                                    '<td>'+data.result[i].device_name+'</td>'+
                                    '<td>'+data.result[i].category+'</td>'+
                                    '<td>'+data.result[i].sku+'</td>'+
                                    '<td>'+data.result[i].grade+'</td>'+
                                    '<td>'+data.result[i].imei+'</td>'+
                                    '<td>'+data.result[i].product_status+'</td>'+
                                    '<td class="td_edit_input_remarks">'+data.result[i].remarks+'</td>'+
                                
                                '<td onclick="edit_trg_delete_row(this)">'+
                                    '<img src="<?php echo base_url(); ?>assets/img/delete.png">'+
                                    '<input type="hidden" class="td_edit_input_rmon_item_id" value="'+data.result[i].rmon_item_id+'" readonly>'+
                                    '<input type="hidden" class="td_edit_grnreport_id" value="'+data.result[i].grnreport_id+'" readonly>'+
                                '</td>'+

                                '</tr>';
                });
                
                $("#edit_device_tr").append(childtable)
			}
		}
	} );
		
	childtable+='</table>';
	return childtable
}

$(document).ready(function(){

    getRmonHeaderforEdit()

    function getRmonHeaderforEdit(){

        rmon_header = $('#rmonHeader_edit_table').DataTable({
                        "paging":false,
                        "destroy":true,
                        "searching":false,
                        "info": false,
                        "processing": true,
                        "serverSide": false,  
                        "scrollY": 390,
                        "scrollX": true,
                        "scrollCollapse": true,
                        //"autoWidth": false,
                        "aaSorting": [1, 'asc'],
                        "ajax": {
                            "url": "<?php echo base_url(); ?>admin/Triage/getRmonHeader",
							"data": { "rmon_id": rmon_id},
							"type": "GET",
                            "dataSrc": "data"
                        },
                        "columns": [
                            { "data": "rmon_code"},
                            { "data": "service_center_id"},	
                            { "data": "status" },	
                            { "data": "type" },
                            { "data": "purpose" },
                            { "data": "EXPECTED_DATE"},
                            { "data": "CREATED_BY"},
                            { "data": "LAST_UPDATED_BY"},
                            { "data": "LAST_UPDATE_DATE"}

                        ],
                        "aoColumnDefs": [
                            {
                                "aTargets":1,
                                "render": function(data){
                                                var sc = '<select class="form-control select_box"  id="edit_rmon_service_center" >'
                                                    sc += '<option value="">SERVICE CENTER</option>'
                                                    sc += getServiceCenterListforEdit(data)
                                                    sc += '</select>'
                                                return sc
                                            }
                            }
                        ]
        });

    }
})

    function addDeviceRowsforEdit(){

        var device_name = $("#edit_input_product_name").val()
        var grnreport_id = $("#edit_input_grnreport_id").val()
        var device_id = $("#edit_input_deviceid").val()
        var imei = $("#edit_input_imei").val()
        var sku = $("#edit_input_sku").val()
        var status = $("#edit_input_status").val()
        var category = $("#edit_input_category").val()
        var grade = $("#edit_input_grade").val()
        var remarks = $("#edit_textarea_remarks").val()
        var fields_required = '';
        var newRow = ''

        fields_required += checkNull(grnreport_id, 'Device ID ')

        if(fields_required != ''){

            alert("Please Add a device")
            return false
        }

        newRow += '<tr class="tr_edit_device_rows">'
        newRow += '<td class="td_edit_deviceid">'+device_id+'</td>'
        newRow += '<td class="td_edit_product_name">'+device_name+'</td>'
        newRow += '<td class="td_edit_brand">'+category+'</td>'
        newRow += '<td class="td_edit_product_name">'+sku+'</td>'
        newRow += '<td class="td_edit_deviceid">'+grade+'</td>'
        newRow += '<td class="td_edit_imei">'+imei+'</td>'
        newRow += '<td class="td_edit_rom">'+status+'</td>'
        newRow += '<td class="td_edit_input_remarks">'+remarks+'</td>'

        newRow += '<td onclick="edit_trg_delete_row(this)">'
        newRow +=   '<img src="<?php echo base_url(); ?>assets/img/delete.png">'
        newRow +=   '<input type="hidden" class="td_edit_input_rmon_item_id" value="new_row" readonly>'
        newRow +=   '<input type="hidden" class="td_edit_grnreport_id" value="'+grnreport_id+'">'
        newRow += '</td>'

        newRow += '</tr>'

        $("#edit_device_tr").append(newRow)

        $("#edit_input_grnreport_id").val('')
        $("#edit_input_product_name").val('')
        $("#edit_input_deviceid").val('')
        $("#edit_input_imei").val('')
        $("#edit_input_sku").val('')
        $("#edit_input_category").val('')
        $("#edit_input_grade").val('')
        $("#edit_input_status").val('')
        $("#edit_textarea_remarks").val('')
    }


    function editRmon(action){

        if (rmon_id == 0 || rmon_id =='' || rmon_id == '0' || rmon_id == null) {
            return false
        }

        var service_center_id = $("#edit_rmon_service_center").val();

        if (service_center_id == 0 || service_center_id =='' || service_center_id == '0' || service_center_id == null) {
            
            alert('Please Select Service Center ')
            return false
        }

        var remarks = $("#edit_remarks_header").val();
        var rows = []
        var data = []


        $("tr.tr_edit_device_rows").each(function(){

            var td_grnreport_id = $(this).find(".td_edit_grnreport_id").val().trim()
            var td_remarks = $(this).find(".td_edit_input_remarks").text().trim()
            var td_rmon_item_id = $(this).find(".td_edit_input_rmon_item_id").val().trim()

            rows.push({
                
                "trg_rmon_item_id": td_rmon_item_id,
                "grnreport_id": td_grnreport_id,
                "remarks": td_remarks
            })

        })

        if(rows.length <= 0){
            alert("No Products Added")
            return false
        }

        data.push({
                "rmon_id" : rmon_id,
                "service_center": service_center_id,
                "remarks_header" : remarks,
                "rows": rows
            })
        var jsonObject = JSON.stringify(data)

        $("#edit_submit").attr('disabled',true)
        $.ajax({
            url: "<?php echo base_url(); ?>admin/Triage/editRmon",
            dataType: 'json',
            data: jsonObject,
            type: 'POST', 
            success: function(data){
                if(data.status==1){

                    window.location.replace("<?=base_url()?>admin/Triage/manage_triage");

                }else{
                    $("#edit_submit").attr("disabled", false);
                    toastr.error('Failed to Edit RMON'); 
                }				
            },
            error: function(){ 
                $("#edit_submit").attr("disabled", false);
                toastr.error('Failed to Edit RMON'); 				  
            }
        });
    }

    function edit_trg_delete_row(btn){

        var yes= confirm("Do you want to delete the record?")
        
        if(yes){
            
            $(btn).closest("tr").remove();
		}
    }
</script>