<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 th, td { white-space: nowrap; }
     td.stn_id{
         font-size: 0;
     }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_new">NEW
	</label>

    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_invoiced">INVOICED
    </label>
    
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_packed">PACKED
    </label>
    
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_dispatch">DISPATCHED
    </label>
    
</div>
<p style="line-height:10px;"></p>

<table class="table table-striped DataTables" style="margin-left:5px" id="stocktransferList_table">
	<thead>
		<tr>
            <th></th>
            <th></th>
            <th>STN NO</th>
			<th>FROM <br>WAREHOUSE</th>					
            <th>TO <br>WAREHOUSE</th>
			<th>QUANTITY</th>
            <th>STOCK<br>TRANSFER DATE</th>
            <th>LAST UPDATED BY</th>			
			<th>LAST UPDATED DATE</th>
            <th></th>
		</tr>
	</thead>		
</table>
<div class="modal fade" id="modalFileUpload" tabindex="-1" role="dialog" aria-labelledby="myModalFileUploadLabel"
  aria-hidden="true" data-backdrop="false">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header text-center">
        <button type="button" class="close" onclick="UploadFile()" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <input type="hidden" id="fileupload_st_code">
      <div class="modal-body mx-3">
      <div class="form-group">
            <label class="col-lg-3 control-label">STOCKTRANSFER ID</label>
            <div class="col-lg-9">
                <input class="form-control" id="fileupload_st_id" readonly>
            </div> 
        </div>
      </div><br>
      <div class="form-group">
            <label class="col-lg-3 control-label">SELECT FILE</label>
            <div class="col-lg-9 file-upload-wrapper">
                <input type="file" class="form-control file-upload" id="fileupload_st_file" >
            </div> 
        </div>
      <div class="modal-footer d-flex justify-content-center">
        <button class="btn btn-success" id="fileupload_submit" onclick="fileupload_submit()" CausesValidation="False">UPLOAD</button>
        <button class="btn btn-danger" id="fileupload_modal_close" CausesValidation="False">Close</button>
      </div>
    </div>
  </div>
</div>

							
<script>

var sr_table;
var department_id = getUserdata('department_id')

function getStocktransferList(status){
    sr_table = $('#stocktransferList_table').DataTable({
                    "paging":true,  
                    "destroy":true,
                    "searching":true,
                    "processing": true,
                    "serverSide": false,  
                    // "scrollY": 380,
                    // "scrollX": true,
                    // "scrollCollapse": true,
                   // "autoWidth": false,
                    "aaSorting": [[9, 'desc'],[1,'desc']],
                    "ajax": {
                        "url": "<?php echo base_url(); ?>admin/Stocktransfer_out/getStocktransferList?status="+status,
                        "type": "GET",
                        "dataSrc": "data"
                    },
                    "columns": [
                        {
                                "className":      "details-control stn_id",
                                "orderable":      false,
                                "data":           'stn_id',
                                "defaultContent": ''
                        },
                        
                        {  "data":function(data){
                            var pdf_menu = '<div class="dropdown" style="text-align:left">'
						    pdf_menu += '<a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">'
					        pdf_menu += '<img src="<?=base_url()?>assets/img/export_pdf.png" title="Export" alt="Export">'
						    pdf_menu += '</a>'

						    pdf_menu += '<div class="btn dropdown-menu">'

							pdf_menu += '<a class="btn dropdown-item" href="<?php echo base_url();?>admin/Stocktransfer_out/pickListpdf?stn_id='+data.stn_id+'" target="_blank">Pick List</a><br>'

							pdf_menu += '</div>'
				
							pdf_menu += '</div>'
                            return pdf_menu;
                          }
                        },
                        { "data": "stn_no" },									
                        { "data": "from_loc" },
                        { "data": "to_loc" },
                        { "data": "total_quantity" },
                        { "data": "stn_date"},						
                        { "data": "LAST_UPDATED_BY" },
                        { "data": "LAST_UPDATE_DATE" },
                        {
                            "data": function(data){
                                var arr = [];
                                if(data.status=='NEW' && department_id == '6'){
                                    
                                        
                                        var stn_id =  data.stn_id
                                        var status = "INVOICED"
                                        return '<button class="btn btn-success" onclick="approveStocktransfer(\'' + stn_id + '\',\'' + status + '\')">INVOICE</button>'
                            
                                        
                                    }else if(data.status == 'INVOICED' && department_id == '13'){

                                        var stn_id =  data.stn_id
                                        var status = "PACKED"
                                        return '<button class="btn btn-success" onclick="approveStocktransfer(\'' + stn_id + '\',\'' + status + '\')">PACK</button>'
                                
                                }else{
                                    return null
                                }
                             
                            }

                        }
                    ]
    });

} 
function format ( d ) {
	// `d` is the original data object for the row
	var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/Stocktransfer_out/getStocktransferDetails?stn_id="+d.stn_id),
		type:"GET",
		dataType: 'json',
		async: false,
		success: function ( data ) {          
			if(data.result==null){
				childtable+='<tr><td>No Records Found</td></tr>';
			}else{
				childtable += '<th>Category</th><th>TD Id</th><th>Device Name</th><th>SKU</th><th>Grade</th>';

				$.each(data.result, function (i, d) {
                  
				childtable+='<tr>'+
					'<td>'+data.result[i].stock_type+'</td>'+
					'<td>'+data.result[i].nhdin+'</td>'+
					'<td>'+data.result[i].device_name+'</td>'+
					'<td>'+data.result[i].sku+'</td>'+
					'<td>'+data.result[i].grade+'</td>'+
					'</tr>';
				});
			}
		}
	} );
		
	childtable+='</table>';
    childtable += '<button class="btn btn-info" onclick="downloadTraceBulkDevice('+d.stn_id+')">Download</button>'
            //childtable += getSOFilesList(d.stn_id)
	return childtable
}

function getUserdata(attribute){
     
    var a='';
    $.ajax({
        "url": "<?=base_url()?>Web_api/getUserData/"+attribute,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            a = data.result;
        }
    })
     return a;
}

function approveStocktransfer(stn_id, status){
    
    var user_confirm = window.confirm("Do you want to Approve the Stocktransfer?")

    if(user_confirm != true){
        return false
    }

    $.ajax({
        "url": "<?=base_url()?>admin/Stocktransfer_out/approveStockTransfer",
        "type": "GET",
        "dataType": "json",
        "data" : {"stn_id" : stn_id, "status" : status},
        "async": false,
        "success": function(data){
            if(data.status==1){
                
                toastr.success("Success: Stocktransfer approved successfully")
                window.location.replace("<?=base_url()?>admin/Stocktransfer_out/manage_stocktransfer");
            }else{
                toastr.error("Error: Failed to Approve Stocktransfer")
            }
        },
        "error": function(){
            toastr.error("Error: Failed to Approve Stocktransfer")
        }
    })
}

$(document).ready(function(){

    getStocktransferList('NEW')
    
    $('#button_new').change(function(){
        getStocktransferList('NEW')
    });

    $('#button_invoiced').change(function(){
        getStocktransferList('INVOICED')
    });
    
    $('#button_packed').change(function(){
        getStocktransferList('PACKED')
    });
    
    $('#button_dispatch').change(function(){
        getStocktransferList('DISPATCHED')
    });

    $('#stocktransferList_table tbody').on('click', 'td.details-control', function () {
        var tr = $(this).closest('tr');
        var row = sr_table.row( tr );
        if ( row.child.isShown() ) {
            row.child.hide();
            tr.removeClass('shown');
        }else {
            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
    }) ;
})
    
function downloadTraceBulkDevice(stn_id){

    window.location.href = '<?php echo base_url(); ?>admin/Stocktransfer_out/dowloadStocktransferItems?stn_id='+stn_id
    
}

</script>
	 
