<!DOCTYPE html>
<html>
<meta charset="utf-8">
    <title><?= lang('invoice') ?></title>
    <head>
    <style type="text/css">
        font-face {
            font-family: "Source Sans Pro", sans-serif;
        }
     
        .clearfix:after {
            content: "";
            display: table;
            clear: both;
        }

        a {
            color: #0087C3;
            text-decoration: none;
        }

        body {
            color: #555555;
            background: #FFFFFF;
            font-size: 9px;
            font-family: "Source Sans Pro", sans-serif; 
            width: 100%;
            margin:0;
        }

        #header_logo{
            float:left;
        }
        #header_title{
            float:right;
        }
       
        #client_address p{
            margin:0;
        }
        #ship_to p{
            margin:0;
        }
      
                   
        #client_detail_table td {
            width:110px;
            border-bottom: 0.5px solid grey;
            text-align: left;
            padding-top: 0;
            padding-bottom: 0;
        }
         .left {text-align:left;}
         .right {text-align:right !important;}
         .center {text-align:center;}

        #invoice_table{ 
            width:100%;
            margin-left: 2px;
            margin-right: 2px;
        }
       
        #invoice_table th, td, tr {
            border-bottom: 0.5px solid grey;
            padding-top: 4px;
            padding-bottom: 2px;
            margin: 0;
            }
        #invoice_table .footer_table{
                font-weight:bold;
        }
        #invoice_table th{
            border-top: 0.5px solid grey;
        }

        header {
                position: fixed;
                top: -20px;
                left: 0px;
                right: 0px;
                height: 20px; 
                width: 100%;

            }

            footer {
                position: fixed; 
                bottom: 0; 
                left: 0px; 
                right: 0px;
                height: 20px; 
                border-top: 1px solid #AAAAAA;
                color: #777777;
                width: 100%;
                padding: 8px 0;
                text-align: center;
            }

        .rupee::before{
            padding-left:5px;
            white-space:nowrap;
        }

        
        .footer_margin{
            margin-bottom: 0;
            margin-left : 1px;
            position: absolute;
            bottom: 0;
            float:right;
            font-size:12px;
        }
        .signature{
            margin-bottom: 40px;
            margin-left : 1px;
            position: absolute;
            bottom: 0;
            float:right;
            font-size:12px;
        }
        .container td{
            border-bottom:none;
        }

    </style>
    </head>
    <body>
    <header>
           
        </header>

    <footer id="footer"><span style="font-weight:bold;">SLOYD VENTURES (P) LTD,</span> <?= $from_wh["address"] ?>, IN.<p style="margin:0;">|| CIN: U52390TG2012PTC083950 | PAN: AASCS2801C | Tel: +91-40-27900059 | Email: accounts@sloyd.in | web: www.sloyd.in ||</p>
</footer>
<div class="footmargin"></div>
        <table id="heading" style="text-align:center;width:100%;border-bottom:none;margin-top:-30px;">
            <tr style="border-bottom:none;"><td style="align-content:left;text-align:left;border-bottom:none;"><img src="<?php base_url();?>assets/img/logo_invoice.png" height="50px" width="140px"></td>
            <td  style="text-align:left;border-bottom:none;"><h1><?=strtoupper($title)?></h1></td>
            <td style="border-bottom:none;"><div style="font-size:14px;font-weight:700;text-align:right;"><?=$type?></div></td></tr>
    </table>
        <table class="container" style="width:100%;">
        <tr><td  style="width:30%;vertical-align:top;">
            <div id="client_address">
                <p>
                    <span style="font-weight:bold;">FROM</span><br>
                    <p>Sloyd Ventures Pvt. Ltd.</p>
                    <p><?php echo $from_wh["address"]; ?></p>
                    <p>INDIA</p>
                    <?php if(strtolower($title) == 'tax invoice'){ ?>
                    <p>GST: <?=$from_wh["gst_number"]?></p>
                    <?php } ?>
                   
                </p>
            </div></td><td style="width:37%;text-align:left;padding-left:1px;vertical-align:top;">
            <div id="ship_to" >
                    <span style="font-weight:bold;">To</span><br>
                    <p>Sloyd Ventures Pvt. Ltd.,</p>
                    <p><?php echo $to_wh["address"]; ?></p>
                    <p>INDIA</p>
                    <p> GST: <?=$to_wh["gst_number"];?>

            </div></td><td  style="width:33%;vertical-align:top;">
            <div id="client_details">
                <table id="client_detail_table">
                    <tr>
                        <td class="left" style="text-align: left;">GSTIN</td>
                        <td class="left">36AASCS2801C1ZI</td>
                    </tr>
                    <tr>
                        <td class="left"><?=$invoice_type?></td>
                        <td class="left"><?=$st_invoice_no?></td>
                    </tr>
                    <tr>
                        <td class="left">Date</td>
                        <td class="left"><?=$date?></td>
                    </tr>
                    <tr>
                        <td class="left">Place of Supply</td>
                            <td class="left"><?=$to_wh["state_id"].'-'.$to_wh["state"]?></td>
                    </tr>
                    <tr>
                        <td class="left">HSN Code</td>
                        <td class="left">851713 - Mobile Phone</td>
                    </tr>
                    <tr>
                        <td class="left">Currency</td>
                        <td class="left">INR</td>
                    </tr>
                </table>
                </div>
                </td></tr>
            </table>
            
        <p style="clear:both;"></p><br>
        <div id="invoice_div">
            <table id="invoice_table" style="width:100%;" cellspacing="0">
                <thead style="text-align: center;font-size:9px;">
                <tr><th style="white-space:nowrap;text-align:left">Category</th><th style="width:170px;text-align:left;"></th><th style="width:5px;">Qty</th><th class="right">Price</th><th class="right">Taxable<p style="margin:0;"> Amount</p></th><th class="right">Exempt<p style="margin:0;"> Amount</p></th><th class="right" style="width:50px;padding-left:10px;padding-right:0px;text-align:right;">Tax <p style="margin:0;">Rate</p></th><th style="overflow-wrap: break-word;text-align:right;"  class="right">Tax <p style="margin:0;">Amount</p></th></tr>
                </thead>
                <tbody>
                   
                    <tr>
                        <td style="white-space:nowrap;border-bottom:none;"><?= $category ?></td>
                        <td style="padding-left:1px;border-bottom:none;"></td>
                        <td style="border-bottom:none;text-align:center;width:5px;"><?= $total_qty ?></td>
                        <td style="border-bottom:none;text-align:right;"><span class="right rupee"><?=IND_money_format($total_amount)?></span></td>
                        <td style="border-bottom:none;text-align:right;"><span class="right rupee"><?=IND_money_format($total_taxable)?></span></td>
                        <td style="border-bottom:none;text-align:right;"><span class="right rupee"><?=IND_money_format($total_exempt)?></span></td>
                        <td style="border-bottom:none;text-align:right;"><?=$tax_rate." %"?></td>
                        <td style="border-bottom:none;text-align:right;"><span class="right rupee"><?=IND_money_format($total_tax)?></span></td>
                    </tr>
                            
                    <tr class="bottom-border">
                        
                        
                        <td colspan="8"></td>
                    </tr>
                            
                            
                <tfoot class="footer_table">
                   
                    <tr style="line-height:15px;">
                        <td colspan="2" ><?=$amount_words?></td>
                        <td style="text-align:center;padding-bottom:2px;padding-top:2px;"><?=$total_qty?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($total_amount,2))?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($total_taxable,2))?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($total_exempt,2))?></td>
                        <td colspan="2" class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?=IND_money_format($total_tax)?></td>
                    </tr>
                   
                    <tr style="line-height:15px;">
                        <?php if($tax_type=='IGST18'){ ?>
                            <td colspan="6" class="right">Tax Break-Up</td><td colspan="2" class="right" style="padding-bottom:2px;padding-top:1px;">IGST <span class="rupee"><?=IND_money_format($total_tax)?></td>
                       <?php } ?>
                        
                    </tr>
                    
               
                </tfoot>
            </table>
        </div>
        <p></p><br>
        <p></p>
             
        <div style="font-size:10px;">
            <p>
            <div style="page-break-inside:avoid;">
            <div style="float:left;page-break-inside:avoid;width:60%;height:40px;">
                <p style="font-weight: bold;">Notes</p>
                <p> <?php if($salesman){?>  Sales Code: <?=$salesman?> | <?php }?>
               <?php if($sales_channel){ ?> Sales Channel: <?=$sales_channel?><?php }?></p>
               <p> <?php if($tracking_name){ ?>  Tracking Name : <?=$tracking_name?> | <?php }?>
                <?php if($tracking_id){ ?>  Tracking ID: <?=$tracking_id?> <?php }?></p>
                <p>This is not a sale. Stock Transfer from one location to other location.</p>
            </div>
                <div style="float:right;page-break-inside:avoid;">
                        <br>
                    <span style="font-weight:700;">For Sloyd Ventures (P) Ltd.,</span>
                    <p style="width:50px;height:50px;"></p>
                    <p>Authorised Signature</p>
                </div>
            </div>
            
        </div>
        
        <div class="signature">
        </div>
        </body>
</html>

<?php
    function IND_money_format($number){    	
        $decimal = (string)($number - floor($number));
        $money = floor($number);
        $length = strlen($money);
        $delimiter = '';
        $money = strrev($money);
 
        for($i=0;$i<$length;$i++){
            if(( $i==3 || ($i>3 && ($i-1)%2==0) )&& $i!=$length){
                $delimiter .=',';
            }
            $delimiter .=$money[$i];
        }
 
        $result = strrev($delimiter);
        $decimal = preg_replace("/0\./i", ".", $decimal);
        $decimal = substr($decimal, 0, 3);
 
        if( $decimal != '0'){
            $result = $result.$decimal;
        }
        if($decimal=="0"){
            $result = $result.'.00';
        }
 
        return $result;
    }
?>