<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 th, td { white-space: nowrap; }
     td.stocktransfer_id{
         font-size: 0;
     }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">

	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_inward_admin_pending">ADMIN PENDING
    </label>

    <label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_inward_warehouse_pending">WAREHOUSE PENDING
    </label>

    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_inward_finance_pending">FINANCE PENDING
    </label>

    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_inward_in_progress">IN PROGRESS
    </label>

    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_inward_completed">COMPLETED
    </label>
    
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_inward_cancelled">CANCELLED
	</label>

    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_inward_claim_required">CLAIM REQUIRED
	</label>
</div>
<p style="line-height:10px;"></p>
<div style="overflow-x: auto; width:100%">
    <table class="table table-striped DataTables" style="margin-left:5px" id="inwardStocktransferList_table">
        <thead>
            <tr>
                <th></th>
                <th></th>
                <th></th>
                <th>WEBSITE</th>
                <th>TYPE</th>
                <th>FROM <br>WAREHOUSE</th>					
                <th>TO <br>WAREHOUSE</th>
                <th>REMOVABLE ID</th>
                <th>CLAIM REQUIRED</th>
                <th>QUANTITY</th>
                <th>RECEIVED DATE</th>
                <th>STOCK<br>TRANSFER DATE</th>
                <th>CREATED<br>BY</th>			
                <th>LAST UPDATED<br> BY</th>			
                <th>LAST UPDATED<br> DATE</th>
            </tr>
        </thead>		
    </table>
</div>
<div class="modal fade" id="modalFileUpload" tabindex="-1" role="dialog" aria-labelledby="myModalFileUploadLabel"
  aria-hidden="true" data-backdrop="false">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header text-center">
        <button type="button" class="close" onclick="UploadFile()" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <input type="hidden" id="fileupload_st_code">
      <div class="modal-body mx-3">
      <div class="form-group">
            <label class="col-lg-3 control-label">STOCKTRANSFER ID</label>
            <div class="col-lg-9">
                <input class="form-control" id="fileupload_st_id" readonly>
            </div> 
        </div>
      </div><br>
      <div class="form-group">
            <label class="col-lg-3 control-label">SELECT FILE</label>
            <div class="col-lg-9 file-upload-wrapper">
                <input type="file" class="form-control file-upload" id="fileupload_st_file" >
            </div> 
        </div>
      <div class="modal-footer d-flex justify-content-center">
        <button class="btn btn-success" id="fileupload_submit" onclick="fileupload_submit()" CausesValidation="False">UPLOAD</button>
        <button class="btn btn-danger" id="fileupload_modal_close" CausesValidation="False">Close</button>
      </div>
    </div>
  </div>
</div>

							
<script>
var inward_sr_table;
var department_id = getUserdata('department_id')

function st_invoice_list_rows ( d ) {
	// `d` is the original data object for the row
	var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/Stocktransfer/getStocktransferInvoiceDetails?stocktransfer_id="+d.stocktransfer_id),
		type:"GET",
		dataType: 'json',
		async: false,
		success: function ( data ) {
			if(data.result==null || data.result.length <= 0 ){
				childtable+='<tr><td>No Records Found</td></tr>';
			}else{
				childtable+= '<th>Inwardid</th><th>SKU</th><th>Product Name</th><th>CATEGORY</th><th>GRADE</th><th>FNSKU</th>';
                childtable+= '<th>LPN NUMBER</th><th>PRICE</th><th>TAXABLE AMOUNT</th><th>EXEMPT AMOUNT</th><th>Tax Amount</th><th>TAX TYPE</th>';

				$.each(data.result, function (i, d) { // loop through data returned from ajax 
				childtable+='<tr>'+
					'<td>'+data.result[i].nhdin+'</td>'+
					'<td>'+data.result[i].sku+'</td>'+
					'<td>'+data.result[i].device_name+'</td>'+
					'<td>'+data.result[i].stock_type+'</td>'+
					'<td>'+data.result[i].grade+'</td>'+
					'<td>'+data.result[i].fnsku+'</td>'+
                    '<td>'+data.result[i].lpn_number+'</td>'+
					'<td>'+data.result[i].price+'</td>'+
					'<td>'+data.result[i].taxable_amount+'</td>'+
					'<td>'+data.result[i].exempt_amount+'</td>'+
					'<td>'+data.result[i].tax_amount+'</td>'+
					'<td>'+data.result[i].tax_type+'</td>'+
					
					'</tr>';
				});
			}
		}
	} );
		
	childtable+='</table>';
	return childtable
}

function getInwardStocktransferList(status){
    inward_sr_table = $('#inwardStocktransferList_table').DataTable({
                    "paging":true,  
                    "destroy":true,
                    "searching":true,
                    "processing": true,
                    "serverSide": false,  
                   // "scrollY": 380,
                   // "scrollX": true,
                   // "scrollCollapse": true,
                   // "autoWidth": false,
                    "aaSorting": [],
                    "ajax": {
                        "url": "<?php echo base_url(); ?>admin/Stocktransfer_inward/getInwardStocktransferList?status="+status,
                        "type": "GET",
                        "dataSrc": "data"
                    },
                    "columns": [
                        {
                                "className":      "details-control stocktransfer_id",
                                "orderable":      false,
                                "data":           'stocktransfer_id',
                                "defaultContent": ''
                        },
                        {
                          "data":function(data){
                            return '<span class="fa fa-cloud-upload" onclick="openModal(this)"></span>'
                            }
                        },
                        {
                            "data": function(data){

                                    var a = '<div class="dropdown" style="text-align:left">'
                                            +'<a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">'
                                                +'<img src="<?=base_url()?>assets/img/export_pdf.png" title="Export" alt="Export">'
                                            +'</a>'

                                            +'<div class="btn dropdown-menu">'
                                                +'<a class="btn dropdown-item" href="<?php echo base_url();?>admin/Stocktransfer_inward/invoicePdf?stocktransfer_id='+data.stocktransfer_id+'&type=Original" target="_blank">Original</a><br>'
                                                +'<a class="btn dropdown-item" href="<?php echo base_url();?>admin/Stocktransfer_inward/invoicePdf?stocktransfer_id='+data.stocktransfer_id+'&type=Duplicate" target="_blank">Duplicate</a><br>'
                                                +'<a class="btn dropdown-item" href="<?php echo base_url();?>admin/Stocktransfer_inward/invoicePdf?stocktransfer_id='+data.stocktransfer_id+'&type=Triplicate" target="_blank">Triplicate</a><br>'
                                            +'</div>'
                                        
                                if(data.status == 'ADMIN_PENDING' && department_id == 13  ){
                                        a += '&nbsp;&nbsp;&nbsp;&nbsp;<a class="fa fa-edit" href="<?=base_url()?>admin/Stocktransfer_inward/updateInwardStocktransferForm/'+data.stocktransfer_id+'"></a>'
                                        a += '&nbsp;&nbsp;&nbsp;&nbsp;<span class="fa fa-ban" onclick="cancelStocktransfer('+data.stocktransfer_id+')" style="color:red;"></span>'
                                    

                                }else if(data.status == 'WAREHOUSE_PENDING' && (department_id == 17 || department_id == 5)){
                                        a += '&nbsp;&nbsp;&nbsp;&nbsp;<a class="fa fa-edit" href="<?=base_url()?>admin/Stocktransfer_inward/updateInwardStocktransferForm_WH/'+data.stocktransfer_id+'"></a>'

                                }else if(data.status == 'FINANCE_PENDING' && department_id == 6 ){
                                        a += '&nbsp;&nbsp;&nbsp;&nbsp;<a class="fa fa-edit" href="<?=base_url()?>admin/Stocktransfer_inward/updateInwardStocktransferForm_Finance/'+data.stocktransfer_id+'"></a>'

                                }else if(data.status == 'IN_PROGRESS' && department_id == 13 ){
                                        a += '&nbsp;&nbsp;&nbsp;&nbsp;<a class="fa fa-edit" href="<?=base_url()?>admin/Stocktransfer_inward/updateInwardStocktransferForm_Inprogress/'+data.stocktransfer_id+'"></a>'

                                }else if(data.status == 'COMPLETED' && department_id == 8 && data.claim_required == 'Y'){
                                    a += '&nbsp;&nbsp;&nbsp;&nbsp;<a class="fa fa-edit" href="<?=base_url()?>admin/Claims/newFFClaim/'+data.stocktransfer_id+'" ></a>'

                                }
                                a += '</div>'
                                return a
                            },
                        },
                        { "data": "website"},
                        { "data": "stocktransfer_type" },									
                        { "data": "from_loc" },
                        { "data": "to_loc" },
                        //{ "data": "tracking_id" },
                        {"data": "removable_id"},
                        {"data": "claim_required"},
                        { "data": "total_quantity" },
                        {"data": "received_date"},
                        { "data": "stocktransfer_date"},						
                        { "data": "CREATED_BY" },
                        { "data": "LAST_UPDATED_BY" },
                        { "data": "LAST_UPDATE_DATE" }
 
                    ]
    });

} 

function format ( d ) {
	// `d` is the original data object for the row
	var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/Stocktransfer_inward/getStocktransferDetails?stocktransfer_id="+d.stocktransfer_id),
		type:"GET",
		dataType: 'json',
		async: false,
		success: function ( data ) {
			if(data.result == null){
				childtable+='<tr><td>No Records Found</td></tr>';
			}else{
				
				childtable += '<th>TRACKING ID</th><th>FNSKU</th><th>Quantity</th>';

				$.each(data.result, function (i, d) { // loop through data returned from ajax 
				childtable+='<tr>'+
					
					'<td>'+data.result[i].tracking_id+'</td>'+
					'<td>'+data.result[i].fnsku+'</td>'+
					'<td>'+data.result[i].quantity+'</td>'+
                    '</tr>';    
				});
			}
		}
	} );
		
	childtable+='</table>';
    
    childtable += st_invoice_list_rows(d)
    childtable += getSOFilesList(d.stocktransfer_id)
	return childtable
}

function getUserdata(attribute){
    
    var a='';
    $.ajax({
        "url": "<?=base_url()?>Web_api/getUserData/"+attribute,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            a = data.result;
        }
    })
     return a;
}

function cancelStocktransfer(stocktransfer_id){
    
    var user_confirm = window.confirm("Do you want to Cancel the Stocktransfer?")

    if(user_confirm != true){
        return false
    }

    $.ajax({
        "url": "<?=base_url()?>admin/Stocktransfer_inward/cancelStocktransfer/"+stocktransfer_id,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            if(data.status==1){
                
                toastr.success("Success: Stocktransfer canceled successfully")
                $('#button_canceled').click();
            }else{
                toastr.error("Error: Failed to Cancel Stocktransfer")
            }
        },
        "error": function(){
            toastr.error("Error: Failed to Cancel Stocktransfer")
        }
    })
}


$(document).ready(function(){

    getInwardStocktransferList('ADMIN_PENDING')

    $('#button_inward_admin_pending').change(function(){
        getInwardStocktransferList('ADMIN_PENDING')
    });

    $('#button_inward_finance_pending').change(function(){
        getInwardStocktransferList('FINANCE_PENDING')
    });

    $('#button_inward_in_progress').change(function(){
        getInwardStocktransferList('IN_PROGRESS')
    });

    $('#button_inward_completed').change(function(){
        getInwardStocktransferList('COMPLETED')
    });

    $('#button_inward_warehouse_pending').change(function(){
        getInwardStocktransferList('WAREHOUSE_PENDING')
    });

    $('#button_inward_cancelled').change(function(){
        getInwardStocktransferList('CANCELLED')
    });

    $('#button_inward_claim_required').change(function(){
            
        getInwardStocktransferList('COMPLETED')
        
        inward_sr_table.columns( 8 ).search('Y').draw();
    });


    $('#inwardStocktransferList_table tbody').on('click', 'td.details-control', function () {
        var tr = $(this).closest('tr');
        var row = inward_sr_table.row( tr );
        if ( row.child.isShown() ) {
            row.child.hide();
            tr.removeClass('shown');
        }else {
            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
    }) ;
})
    $(document).delegate("#fileupload_modal_close","click", function(){
        
        $("#fileupload_st_id").val('')
        $('#fileupload_file').val('')

        $("#modalFileUpload").modal('hide');
    })

    function openModal(btn){
        $("#fileupload_st_id").val('')
        
        $('#fileupload_file').val('')
        
        var stocktransfer_id = $(btn).closest('tr').find('.stocktransfer_id').text()
        var tracking_name = $(btn).closest('tr').find('.tracking_name').text()
        if(stocktransfer_id>0){

            $("#fileupload_st_id").val(tracking_name)

            $("#modalFileUpload").modal('show');
        }
    }

    function fileupload_submit(){

        var stocktransfer_id = $("#fileupload_st_id").val();
        var file_data = $('#fileupload_st_file').prop('files')[0];   
        var form_data = new FormData();             
        
        form_data.append('file', file_data);
        
        var file_name = file_data.name
        var file_extension = file_name.split('.').pop().toLowerCase();

        if(jQuery.inArray(file_extension,['pdf']) == -1){
            alert("Invalid PDF file");
            return false;
        }

        if(stocktransfer_id == '0' || stocktransfer_id == null || stocktransfer_id == 0 || parseInt(stocktransfer_id) == NaN){
            return false
        }

        $.ajax({
            url: "<?=base_url()?>admin/Stocktransfer/uploadFiles/"+stocktransfer_id, // point to server-side PHP script 
            dataType: 'json',  // what to expect back from the PHP script, if anything
            cache: false,
            contentType: false,
            processData: false,
            data: form_data,                         
            type: 'post',
            success: function(data){

                if(data.status == 1){
                    toastr.success("file uploaded successfully");
                    $("#fileupload_modal_close").click()

                }else{
                    alert("Error: "+data.error);
                }
            }
     });
    }
    
    function getSOFilesList(stocktransfer_id){

        var tableData = '<br><h5 style="text-align:left; font-weight:700;">Files List</h5>';
        tableData += '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';

        $.ajax({
            url:"<?=base_url();?>admin/Stocktransfer/getSOFilesList",
            type: "GET",
            data: { "stocktransfer_id": stocktransfer_id},
            dataType: 'json',
            async:false,
            success: function (data){
                if(data.status==1){

                    tableData+="<thead><th>S.No</th><th>File Name</th><th>Download</th></thead>"

                    $.each(data.result,function(i,v){

                        tableData += "<tr>"
                        tableData += "<td>"+(i+1)+"</td>"
                        tableData += "<td>"+data.result[i].file_name+"</td>"
                        tableData += "<td><a class='btn btn-downlaod' href='<?=base_url()?>"+data.directory+"/"+encodeURIComponent(data.result[i].file_name)+"' download>Download</a></td>"
                        tableData += "</tr>";
                    })
                }
            }
        });
        tableData+='</table>'
        console.log(tableData)
        return tableData;
    }


</script>
	 
