<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 th, td { white-space: nowrap; }
     td.stocktransfer_id{
         font-size: 0;
     }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_new">NEW
	</label>
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_approved">FINANCE APPROVED
    </label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_rejected">FINANCE REJECTED
    </label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_invoiced">INVOICED
    </label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_dispatched">DISPATCHED
    </label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_intransit">IN TRANSIT
    </label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_shipped">SHIPPED
    </label>
    <label class="btn btn-primary">
	  <input type="radio" name="options" id="button_canceled">CANCELED
	</label>
</div>
<p style="line-height:10px;"></p>

<table class="table table-striped DataTables" style="margin-left:5px" id="stocktransferList_table">
	<thead>
		<tr>
            <th></th>
            <th></th>
            <th></th>
            <th>WEBSITE</th>
			<th>TYPE</th>
			<th>FROM <br>WAREHOUSE</th>					
            <th>TO <br>WAREHOUSE</th>
			<th>TRACKING ID</th>
            <th>TRACKING NAME</th>
            <th>QUANTITY</th>
            <th>STOCK<br>TRANSFER DATE</th>
            <th>CREATED BY</th>			
			<th>LAST UPDATED BY</th>			
			<th>LAST UPDATED DATE</th>
            <th></th>
		</tr>
	</thead>		
</table>
<div class="modal fade" id="modalFileUpload" tabindex="-1" role="dialog" aria-labelledby="myModalFileUploadLabel"
  aria-hidden="true" data-backdrop="false">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header text-center">
        <button type="button" class="close" onclick="UploadFile()" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <input type="hidden" id="fileupload_st_code">
      <div class="modal-body mx-3">
      <div class="form-group">
            <label class="col-lg-3 control-label">STOCKTRANSFER ID</label>
            <div class="col-lg-9">
                <input class="form-control" id="fileupload_st_id" readonly>
            </div> 
        </div>
      </div><br>
      <div class="form-group">
            <label class="col-lg-3 control-label">SELECT FILE</label>
            <div class="col-lg-9 file-upload-wrapper">
                <input type="file" class="form-control file-upload" id="fileupload_st_file" >
            </div> 
        </div>
      <div class="modal-footer d-flex justify-content-center">
        <button class="btn btn-success" id="fileupload_submit" onclick="fileupload_submit()" CausesValidation="False">UPLOAD</button>
        <button class="btn btn-danger" id="fileupload_modal_close" CausesValidation="False">Close</button>
      </div>
    </div>
  </div>
</div>

							
<script>
var sr_table;
var department_id = getUserdata('department_id')

function getStocktransferList(status){
    sr_table = $('#stocktransferList_table').DataTable({
                    "paging":true,  
                    "destroy":true,
                    "searching":true,
                    "processing": true,
                    "serverSide": false,  
                    "scrollY": 380,
                    "scrollX": true,
                    "scrollCollapse": true,
                   // "autoWidth": false,
                    "aaSorting": [[9, 'desc'],[1,'desc']],
                    "ajax": {
                        "url": "<?php echo base_url(); ?>admin/Stocktransfer/getStocktransferList?status="+status,
                        "type": "GET",
                        "dataSrc": "data"
                    },
                    "columns": [
                        {
                                "className":      "details-control stocktransfer_id",
                                "orderable":      false,
                                "data":           'stocktransfer_id',
                                "defaultContent": ''
                        },
                        {
                          "data":function(data){
                            return '<span class="fa fa-cloud-upload" onclick="openModal(this)"></span>'
                           }
                        },
                        {  "data":function(data){
                            var pdf_menu = '<div class="dropdown" style="text-align:left">'
						    pdf_menu += '<a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">'
					        pdf_menu += '<img src="<?=base_url()?>assets/img/export_pdf.png" title="Export" alt="Export">'
						    pdf_menu += '</a>'

						    pdf_menu += '<div class="btn dropdown-menu">'

								pdf_menu += '<a class="btn dropdown-item" href="<?php echo base_url();?>admin/Stocktransfer/pickListpdf?stocktransfer_id='+data.stocktransfer_id+'&grade=no" target="_blank">Pick List - W/O GRADE</a><br>'
								pdf_menu += '<a class="btn dropdown-item" href="<?php echo base_url();?>admin/Stocktransfer/pickListpdf?stocktransfer_id='+data.stocktransfer_id+'" target="_blank">Pick List - WITH GRADE</a><br>'

								pdf_menu += '</div>'
				
								pdf_menu += '</div>'
                                return pdf_menu;
                          }
                        },
                        { "data": "website"},
                        { "data": "stocktransfer_type" },									
                        { "data": "from_loc" },
                        { "data": "to_loc" },
                        { "data": "tracking_id" },
                        { "data": "tracking_name", "className": "tracking_name" },
                        { "data": "total_quantity" },
                        { "data": "stocktransfer_date"},						
                        { "data": "CREATED_BY" },
                        { "data": "LAST_UPDATED_BY" },
                        { "data": "LAST_UPDATE_DATE" },
                        {
                            "data": function(data){
                                if(data.status=='NEW'){
                                    if(department_id == '6'){
                                        
                                        return '<a class="btn btn-primary" href="<?=base_url()?>admin/Stocktransfer/updateStocktransferForm/'+data.stocktransfer_id+'">UPDATE</a>'
                                    }else if(department_id== '8'){

                                        return '<a class="btn btn-info" href="<?=base_url()?>admin/Stocktransfer/editStocktransferForm/'+data.stocktransfer_id+'">EDIT</a>'
                                                + '&nbsp;&nbsp;&nbsp;&nbsp;<button class="btn btn-danger" onclick="cancelStocktransfer('+data.stocktransfer_id+')">CANCEL</button>'
                                    }else{
                                        return null;
                                    }
                                }else if(data.status == 'FINANCE_APPROVED' && department_id == '5'){

                                    return '<a class="btn btn-primary" href="<?=base_url()?>admin/Stocktransfer/createSTInvoiceForm/'+data.stocktransfer_id+'">CREATE INVOICE</a>'
                                
                                }else if(data.status == 'FINANCE_REJECTED'){
                                    if(department_id== '8'){

                                        return '<a class="btn btn-info" href="<?=base_url()?>admin/Stocktransfer/editStocktransferForm/'+data.stocktransfer_id+'">EDIT</a>'
                                    }else{
                                        return null;
                                    }
                                }else if(data.status == 'DISPATCHED'){
                                   
                                    if(department_id == '8'){
                                        
                                        return '<button class="btn btn-primary" onclick= "intransitSTN('+data.stocktransfer_id+')">IN TRANSIT</button>'
                                                + '&nbsp;&nbsp;<button class="btn btn-info" onclick= "shipSTN('+data.stocktransfer_id+')">SHIPPED</button>'
                                    }else{
                                        return null
                                    }

                                }else if(data.status == 'IN_TRANSIT'){
                                   
                                   if(department_id == '8'){
                                       
                                       return '<button class="btn btn-primary" onclick= "shipSTN('+data.stocktransfer_id+')">SHIPPED</button>'
                                   }else{
                                       return null
                                   }

                               }else{
                                    return null
                                }
                             
                            }

                        }
                    ]
    });

} 



function format ( d ) {
	// `d` is the original data object for the row
	var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/Stocktransfer/getStocktransferDetails?stocktransfer_id="+d.stocktransfer_id),
		type:"GET",
		dataType: 'json',
		async: false,
		success: function ( data ) {          
			if(data.result==null){
				childtable+='<tr><td>No Records Found</td></tr>';
			}else{
				childtable += '<th>Category</th><th>SKU</th><th>Device Name</th><th>Grade</th>'
				childtable += '<th>FNSKU</th><th>Quantity</th>';

				$.each(data.result, function (i, d) {
                  
				childtable+='<tr>'+
					'<td>'+data.result[i].stock_type+'</td>'+
					'<td>'+data.result[i].sku+'</td>'+
					'<td>'+data.result[i].device_name+'</td>'+
					'<td>'+data.result[i].grade+'</td>'+
					'<td>'+data.result[i].fnsku+'</td>'+
					'<td>'+data.result[i].quantity+'</td>'+
					
					'</tr>';
				});
			}
		}
	} );
		
	childtable+='</table>';
    childtable += '<button class="btn btn-info" onclick="downloadTraceBulkDevice()">Download</button>'
            childtable += getSOFilesList(d.stocktransfer_id)
	return childtable
}

function getUserdata(attribute){
     
    var a='';
    $.ajax({
        "url": "<?=base_url()?>Web_api/getUserData/"+attribute,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            a = data.result;
        }
    })
     return a;
}

function cancelStocktransfer(stocktransfer_id){
    
    var user_confirm = window.confirm("Do you want to Cancel the Stocktransfer?")

    if(user_confirm != true){
        return false
    }

    $.ajax({
        "url": "<?=base_url()?>admin/Stocktransfer/cancelStocktransfer/"+stocktransfer_id,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            if(data.status==1){
                
                toastr.success("Success: Stocktransfer canceled successfully")
                $('#button_canceled').click();
            }else{
                toastr.error("Error: Failed to Cancel Stocktransfer")
            }
        },
        "error": function(){
            toastr.error("Error: Failed to Cancel Stocktransfer")
        }
    })
}

function intransitSTN(stocktransfer_id){

    if(stocktransfer_id >0){

        $.ajax({
            "url": "<?=base_url()?>admin/Stocktransfer/intransitSTN/"+stocktransfer_id,
            "type": "POST",
            "dataType": "json",
            "success": function(data){
                if(data.status == 1){
                    toastr.success("SUCCESS: Stocktransfer Note status changed")
                    $('#button_intransit').click();
                }else{
                    toastr.error("Failed to change status")
                }
            },
            "error": function(){
                toastr.error("Failed to change status")
            }
        })
    }
}

function shipSTN(stocktransfer_id){

    if(stocktransfer_id >0){

        $.ajax({
            "url": "<?=base_url()?>admin/Stocktransfer/shipSTN/"+stocktransfer_id,
            "type": "POST",
            "dataType": "json",
            "success": function(data){
                if(data.status == 1){
                    toastr.success("SUCCESS: Stocktransfer Note status changed")
                    $('#button_shipped').click();
                }else{
                    toastr.error("Failed to change status")
                }
            },
            "error": function(){
                toastr.error("Failed to change status")
            }
        })
    }
}

$(document).ready(function(){

    getStocktransferList('NEW')
    
    $('#button_new').change(function(){
        getStocktransferList('NEW')
    });

    $('#button_approved').change(function(){
        getStocktransferList('FINANCE_APPROVED')
    });

    $('#button_rejected').change(function(){
        getStocktransferList('FINANCE_REJECTED')
    });

    $('#button_invoiced').change(function(){
        getStocktransferList('INVOICED')
    });

    $('#button_dispatched').change(function(){
        getStocktransferList('DISPATCHED')
    });

    $('#button_intransit').change(function(){
        getStocktransferList('IN_TRANSIT')
    });
    
    $('#button_shipped').change(function(){
        getStocktransferList('SHIPPED')
    });

    $('#button_canceled').change(function(){
        getStocktransferList('CANCELED')
    });


    $('#stocktransferList_table tbody').on('click', 'td.details-control', function () {
        var tr = $(this).closest('tr');
        var row = sr_table.row( tr );
        if ( row.child.isShown() ) {
            row.child.hide();
            tr.removeClass('shown');
        }else {
            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
    }) ;
})
    $(document).delegate("#fileupload_modal_close","click", function(){
        
        $("#fileupload_st_id").val('')
        $('#fileupload_file').val('')

        $("#modalFileUpload").modal('hide');
    })

    function openModal(btn){
        $("#fileupload_st_id").val('')
        
        $('#fileupload_file').val('')
        
        var stocktransfer_id = $(btn).closest('tr').find('.stocktransfer_id').text()
        var tracking_name = $(btn).closest('tr').find('.tracking_name').text()
        if(stocktransfer_id>0){

            $("#fileupload_st_id").val(tracking_name)

            $("#modalFileUpload").modal('show');
        }
    }

    function fileupload_submit(){

        var stocktransfer_id = $("#fileupload_st_id").val();
        var file_data = $('#fileupload_st_file').prop('files')[0];   
        var form_data = new FormData();             
        
        form_data.append('file', file_data);
        
        var file_name = file_data.name
        var file_extension = file_name.split('.').pop().toLowerCase();

        if(jQuery.inArray(file_extension,['pdf']) == -1){
            alert("Invalid PDF file");
            return false;
        }

        if(stocktransfer_id == '0' || stocktransfer_id == null || stocktransfer_id == 0 || parseInt(stocktransfer_id) == NaN){
            return false
        }

        $.ajax({
            url: "<?=base_url()?>admin/Stocktransfer/uploadFiles/"+stocktransfer_id, // point to server-side PHP script 
            dataType: 'json',  // what to expect back from the PHP script, if anything
            cache: false,
            contentType: false,
            processData: false,
            data: form_data,                         
            type: 'post',
            success: function(data){

                if(data.status == 1){
                    toastr.success("file uploaded successfully");
                    $("#fileupload_modal_close").click()

                }else{
                    alert("Error: "+data.error);
                }
            }
     });
    }
    
    function getSOFilesList(stocktransfer_id){

        var tableData = '<br><h5 style="text-align:left; font-weight:700;">Files List</h5>';
        tableData += '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';

        $.ajax({
            url:"<?=base_url();?>admin/Stocktransfer/getSOFilesList",
            type: "GET",
            data: { "stocktransfer_id": stocktransfer_id},
            dataType: 'json',
            async:false,
            success: function (data){
                if(data.status==1){

                    tableData+="<thead><th>S.No</th><th>File Name</th><th>Download</th></thead>"

                    $.each(data.result,function(i,v){

                        tableData += "<tr>"
                        tableData += "<td>"+(i+1)+"</td>"
                        tableData += "<td>"+data.result[i].file_name+"</td>"
                        tableData += "<td><a class='btn btn-downlaod' href='<?=base_url()?>"+data.directory+"/"+encodeURIComponent(data.result[i].file_name)+"' download>Download</a></td>"
                        tableData += "</tr>";
                    })
                }
            }
        });
        tableData+='</table>'
        console.log(tableData)
        return tableData;
    }

    function downloadTraceBulkDevice(){

        var array = typeof responseData != 'object' ? JSON.parse(responseData) : responseData;
        var str = '';
        str += 'ID,SKU,GRADE,DEVICE NAME,CATEGORY,FNSKU,QUANTITY \r\n';
        for (var i = 0; i < array.length; i++) {
            var line = '';
            for (var index in array[i]) {
                if (line != '') line += ','

                line += array[i][index];
            }

            str += line + '\r\n';
        }
        var a         = document.createElement('a');
        a.href        = 'data:attachment/csv,' +  encodeURIComponent(str);
        a.target      = '_blank';
        a.download    = 'orderdetails.csv';

        document.body.appendChild(a);
        a.click();
    }

</script>
	 
