<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 #stocktransferInvoiceList_table{ all: unset; } 

     .imei_nos > span {
        display: block;
        font-size: 12px;
     }
     .stn_locns {
        font-size: 12px;
     }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="invoice_button_invoiced">INVOICED
    </label>
    <label class="btn btn-primary" active>
	  <input type="radio" name="options" id="invoice_button_dispatched">DISPATCHED
    </label>
    <label class="btn btn-primary" active>
	  <input type="radio" name="options" id="invoice_button_intransit">IN TRANSIT
    </label>
    <label class="btn btn-primary" active>
	  <input type="radio" name="options" id="invoice_button_shipped">SHIPPED
	</label>
</div>
<p style="line-height:10px;"></p>

<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="stocktransferInvoiceList_table">
	<thead>
		<tr>
            <th>&nbsp;</th>
            <th>&nbsp;</th>
            <th>INVOICE / <br> CHALLAN NO</th>
            <th>WEBSITE</th>
			<th> STOCKTRANSFER <br>TYPE</th>
			<th>FROM <br>WAREHOUSE</th>					
            <th>TO <br>WAREHOUSE</th>
			<th>TRACKING ID</th>
            <th>TRACKING NAME</th>
            <th>QUANTITY</th>
            <th>TOTAL <br>AMOUNT</th>
            <th>TAXABLE<br> AMOUNT</th>
            <th>EXEMPT <br>AMOUNT</th>
            <th>TOTAL TAX</th>
			<th>CREATED BY</th>			
			<th>LAST <br>UPDATED BY</th>			
			<th>LAST UPDATED<br> DATE</th>
            <th>&nbsp;</th>
		</tr>
	</thead>		
</table>
							
<script>
var sr_table;
var department_id = getUserdata('department_id')





function st_invoice_list_rows ( d ) {
	// `d` is the original data object for the row
	var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/Stocktransfer/getStocktransferInvoiceDetails?stocktransfer_id="+d.stocktransfer_id),
		type:"GET",
		dataType: 'json',
		async: false,
		success: function ( data ) {
			if(data.result==null){
				childtable+='<tr><td>No Records Found</td></tr>';
			}else{
				childtable+= '<th>Inwardid</th><th>IMEIs</th><th>ST Notes</th><th>SKU</th><th>Product Name</th><th>CATEGORY</th><th>GRADE</th><th>FNSKU</th>';
                childtable+= '<th>LPN NUMBER</th><th>PRICE</th><th>TAXABLE AMOUNT</th><th>EXEMPT AMOUNT</th><th>Tax Amount</th><th>TAX TYPE</th>';

				$.each(data.result, function (i, d) { // loop through data returned from ajax 
                    var obj = data.result[i];

                    var stns = obj.stn_locns;
                    if (stns == '' || stns == undefined || typeof(stns) == 'undefined') {
                        stns = [];
                    } else {
                        stns = stns.split(',');
                    }
                    stns_arr = ([obj.st_from_loc, obj.st_to_loc]).concat(stns);

                    childtable+='<tr>'+
                            '<td>'+obj.nhdin+'</td>'+
                            '<td class="imei_nos"><span>'+ obj.imei1_no + '</span><span>'+ obj.imei2_no +'</span></td>'+
                            '<td class="stn_locns">'+( stns_arr.join(' - ') )+'</td>'+
                            '<td>'+obj.sku+'</td>'+
                            '<td>'+obj.device_name+'</td>'+
                            '<td>'+obj.stock_type+'</td>'+
                            '<td>'+obj.grade+'</td>'+
                            '<td>'+obj.fnsku+'</td>'+
                            '<td>'+obj.lpn_number+'</td>'+
                            '<td>'+obj.price+'</td>'+
                            '<td>'+obj.taxable_amount+'</td>'+
                            '<td>'+obj.exempt_amount+'</td>'+
                            '<td>'+obj.tax_amount+'</td>'+
                            '<td>'+obj.tax_type+'</td>'+
                        '</tr>';
				});
			}
		}
	} );
		
	childtable+='</table>';
	return childtable
}

function getUserdata(attribute){
    
    var a='';
    $.ajax({
        "url": "<?=base_url()?>Web_api/getUserData/"+attribute,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            a = data.result;
        }
    })
     return a;
}

$(document).ready(function(){

    function getStocktransferInvoiceList(status){
        st_invoice_table = $('#stocktransferInvoiceList_table').DataTable({
                        "paging":true,
                        "destroy":true,
                        "searching":true,
                        "processing": true,
                        "serverSide": false,  
                        "scrollY": 380,
                        "scrollX":"100%",
                        "scrollCollapse": false,
                        "autoWidth": false,
                        "aaSorting": [[9, 'desc'],[1,'desc']],
                        "ajax": {
                            "url": "<?php echo base_url(); ?>admin/Stocktransfer/getStocktransferInvoiceList?status="+status,
                            "type": "GET",
                            "dataSrc": "data",
                            "async": false,
                        },
                        "columns": [
                            {
                                    "className":      "details-control",
                                    "orderable":      false,
                                    "data":           null,
                                    "defaultContent": '&nbsp;'
                            },
                            { "data": function(data){
                                return '<div class="dropdown" style="text-align:left">'
                                            +'<a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">'
                                                +'<img src="<?=base_url()?>assets/img/export_pdf.png" title="Export" alt="Export">'
                                            +'</a>'

                                            +'<div class="btn dropdown-menu">'
                                                +'<a class="btn dropdown-item" href="<?php echo base_url();?>admin/Stocktransfer/invoicePdf?stocktransfer_id='+data.stocktransfer_id+'&type=Original" target="_blank">Original</a><br>'
                                                +'<a class="btn dropdown-item" href="<?php echo base_url();?>admin/Stocktransfer/invoicePdf?stocktransfer_id='+data.stocktransfer_id+'&type=Duplicate" target="_blank">Duplicate</a><br>'
                                                +'<a class="btn dropdown-item" href="<?php echo base_url();?>admin/Stocktransfer/invoicePdf?stocktransfer_id='+data.stocktransfer_id+'&type=Triplicate" target="_blank">Triplicate</a><br>'
                                            +'</div>'
                                        +'</div>'
                                    
                                }
                            },
                            { "data": "invoice_no"},
                            { "data": "website"},
                            { "data": "stocktransfer_type" },									
                            { "data": "from_loc" },
                            { "data": "to_loc" },
                            { "data": "tracking_id" },
                            { "data": "tracking_name" },							
                            { "data": "total_quantity" },							
                            { "data": "total_amount" },							
                            { "data": "total_taxable" },							
                            { "data": "total_exempt" },							
                            { "data": "total_tax" },							
                            { "data": "CREATED_BY" },
                            { "data": "LAST_UPDATED_BY" },
                            { "data": "LAST_UPDATE_DATE" },
                            {
                                "data": function(data){
                                    if(data.status == 'INVOICED' && department_id == 13){
                                        var a = '<a class="btn btn-info" type="button" href="<?=base_url()?>admin/Stocktransfer/createDispatchForm/'+data.stocktransfer_id+'">Dispatch</a>'
                                            return a 
                                    }else{
                                        return null
                                    }
                                    
                                }
                            }
                        ]
        });


    }

    getStocktransferInvoiceList('INVOICED')
    
    $('#invoice_button_invoiced').change(function(){
        getStocktransferInvoiceList('INVOICED')
    });

    $('#invoice_button_dispatched').change(function(){
        getStocktransferInvoiceList('DISPATCHED')
    });

    $('#invoice_button_intransit').change(function(){
        getStocktransferInvoiceList('IN_TRANSIT')
    });

    $('#invoice_button_shipped').change(function(){
        getStocktransferInvoiceList('SHIPPED')
    });

    $('#stocktransferInvoiceList_table tbody').on('click', 'td.details-control', function () {
        var tr = $(this).closest('tr');
        var row = st_invoice_table.row( tr );
        if ( row.child.isShown() ) {
            row.child.hide();
            tr.removeClass('shown');
        }else {
            row.child( st_invoice_list_rows(row.data()) ).show();
            tr.addClass('shown');
        }
    }) ;
})
 
</script>