<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 #getStockInwardList_table{ all: unset; } 

     .imei_nos > span {
        display: block;
        font-size: 12px;
     }
     .stn_locns {
        font-size: 12px;
     }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_inward">INWARD PENDING
    </label>
    <label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_finance">FINANCE PENDING
	</label>
	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_warehouse">WAREHOUSE PENDING
	</label>
	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_received">RECEIVED
	</label>
</div>
<p style="line-height:10px;"></p>

<div>
<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="getStockInwardList_table">
	<thead>
		<tr>
            <th>&nbsp;</th>
            <th>&nbsp;</th>
            <th>&nbsp;</th>
            <th>INVOICE / <br> CHALLAN NO</th>
            <th>MRN NO</th>
			<th>FROM <br>WAREHOUSE</th>					
            <th>TO <br>WAREHOUSE</th>
            <th>QUANTITY</th>
            <th>TOTAL <br>AMOUNT</th>
            <th>TAXABLE<br> AMOUNT</th>
            <th>TOTAL TAX</th>
			<th>LAST UPDATED<br> DATE</th>
            <th>&nbsp;</th>
		</tr>
	</thead>		
</table>
</div>
							
<script>
var sr_table;
var department_id = getUserdata('department_id')

function st_inward_list_rows (d) {
    var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/Stock_inward/getStockinwardDetails?stn_id="+d.stocktransfer_id),
		type:"GET",
		dataType: 'json',
		async: false,
		success: function ( data ) {  
		  
			if(data.result==null){
				childtable+='<tr><td>No Records Found</td></tr>';
			}else{
				childtable += '<th>Category</th><th>TD Id</th><th>Device Name</th><th>SKU</th><th>Grade</th>';

				$.each(data.result, function (i, d) {
                  
				childtable+='<tr>'+
					'<td>'+data.result[i].stock_type+'</td>'+
					'<td>'+data.result[i].nhdin+'</td>'+
					'<td>'+data.result[i].device_name+'</td>'+
					'<td>'+data.result[i].sku+'</td>'+
					'<td>'+data.result[i].grade+'</td>'+
					'</tr>';
				});
			}
		}
	} );
		
	childtable+='</table>';
    childtable += '<button class="btn btn-info" onclick="downloadTraceBulkDevice('+d.stocktransfer_id+')">Download</button>'
            //childtable += getSOFilesList(d.stn_id)
	return childtable
}

function getUserdata(attribute){
    
    var a='';
    $.ajax({
        "url": "<?=base_url()?>Web_api/getUserData/"+attribute,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            a = data.result;
        }
    })
     return a;
}

$(document).ready(function(){

    function getStockInwardList(status){
        if(status == "DISPATCHED"){
            
            var cntr_mtd = "getStockinwardList";
        } else {
            
            var cntr_mtd = "getStockinwardedList";
        }
        st_inward_table = $('#getStockInwardList_table').DataTable({
                        "paging":true,
                        "destroy":true,
                        "searching":true,
                        "processing": true,
                        "serverSide": false,  
                        // "scrollY": 380,
                        //"scrollX":"100%",
                        // "scrollCollapse": false,
                        // "autoWidth": false,
                        "aaSorting": [[9, 'desc'],[1,'desc']],
                        "ajax": {
                            "url": "<?php echo base_url(); ?>admin/Stock_inward/"+cntr_mtd + "?status="+status,
                            "type": "GET",
                            "dataSrc": "data",
                            "async": false,
                        },
                        "columns": [
                            {
                                    "className":      "details-control",
                                    "orderable":      false,
                                    "data":           null,
                                    "defaultContent": '&nbsp;'
                            },
                            {  "data":function(data){
                                    
                                    var pdf_menu = '<div class="dropdown" style="text-align:left">'
        						    pdf_menu += '<a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">'
        					        pdf_menu += '<img src="<?=base_url()?>assets/img/export_pdf.png" title="Export" alt="Export">'
        						    pdf_menu += '</a>'
        
        						    pdf_menu += '<div class="btn dropdown-menu">'
        
        							pdf_menu += '<a class="btn dropdown-item" href="<?php echo base_url();?>admin/Stock_inward/inwardListPdf?stn_id='+data.stocktransfer_id+'" target="_blank">MRN Summary</a><br>'
                                    +'<a class="btn dropdown-item" href="<?php echo base_url();?>admin/Stock_inward/invoiceHeaderPdf?stocktransfer_id='+data.stocktransfer_id+'" target="_blank">MRN Note</a><br>'
                                    +'<a class="btn dropdown-item" href="<?php echo base_url();?>admin/Stock_inward/inwardPdf?stocktransfer_id='+data.stocktransfer_id+'" target="_blank">MRN - Item wise</a><br>'
                                    pdf_menu += '</div>'
        				
        							pdf_menu += '</div>'
                                    return pdf_menu;
                                }
                            },
                            { "data": function(data){
                                var stn_id =  data.stocktransfer_id ;
                                var status = data.status;
                                var department_id = data.department_id;
                                var a = ''
                                if(status == "RECEIVED"){
                                   return a; 
                                }
                                
                                if(department_id == '13' && status == "DISPATCHED"){
                                        a += '<a><input type="checkbox" id = "checkbox_'+department_id+'" class ="stn_approve" onclick="approveStockinward(\'' + stn_id + '\',\'' + status + '\')"'
                                        a += '</a>'
                                        return a;
                                        
                                    } else if(department_id == '6' && status == "FINANCE_PENDING"){
                                        
                                        a += '<a><input type="checkbox" id = "checkbox_'+department_id+'" class ="stn_approve" onclick="approveStockinward(\'' + stn_id + '\',\'' + status + '\')"'
                                        a += '</a>'
                                        return a;
                                        
                                    } else if(department_id == '5' && status == "WAREHOUSE_PENDING"){
                                        a += '<a><input type="checkbox" id = "checkbox_'+department_id+'" class ="stn_approve" onclick="approveStockinward(\'' + stn_id + '\',\'' + status + '\')"'
                                        a += '</a>'
                                        return a;
                                    } else {
                                        return a
                                    }
                                }
                            },
                            { "data": "invoice_no"},
                            { "data": "mrn_no"},
                            { "data": "from_loc" },
                            { "data": "to_loc" },
                            { "data": "total_quantity" },							
                            { "data": "total_amount" },							
                            { "data": "total_taxable" },							
                            { "data": "total_tax" },							
                            { "data": "LAST_UPDATE_DATE" },
                            {
                                "data": function(data){
                                    if(data.status == 'PACKED' && department_id == 13){
                                        var a = '<a class="btn btn-info" type="button" href="<?=base_url()?>admin/Stock_inward/createDispatchForm/'+data.Stockinward_id+'">Dispatch</a>'
                                            return a 
                                    } else if(data.status == 'DISPATCHED' && department_id == 13){
                                         var a = '<a class="btn btn-info" type="button" href="<?=base_url()?>admin/Stock_inward/gatepass_pdf/'+data.Stockinward_id+'">Gatepass</a>'
                                            return a
                                    }
                                    else{
                                        return null
                                    }
                                    
                                }
                            }
                        ]
        });


    }

    getStockInwardList('DISPATCHED')
    
    $('#button_inward').change(function(){
        getStockInwardList('DISPATCHED')
    });

    $('#button_finance').change(function(){
        getStockInwardList('FINANCE_PENDING')
    });
    
    $('#button_warehouse').change(function(){
        getStockInwardList('WAREHOUSE_PENDING')
    });
    $('#button_received').change(function(){
        getStockInwardList('RECEIVED')
    });

    $('#getStockInwardList_table tbody').on('click', 'td.details-control', function () {
        
        var tr = $(this).closest('tr');
        var row = st_inward_table.row( tr );
        if ( row.child.isShown() ) {
            row.child.hide();
            tr.removeClass('shown');
        }else {
            row.child( st_inward_list_rows(row.data()) ).show();
            tr.addClass('shown');
        }
    }) ;
})

function approveStockinward(stn_id, status){
    
    var user_confirm = window.confirm("Do you want to Approve the Stockinward?")
    if(user_confirm != true){
        $('.stn_approve').prop('checked', false);
        return false
    }

    $.ajax({
        "url": "<?=base_url()?>admin/Stock_inward/approveStockInward",
        "type": "GET",
        "dataType": "json",
        "data" : {"stn_id" : stn_id, "status" : status},
        "async": false,
        "success": function(data){
            
            if(data.status==1){
                
                toastr.success("Success: Stock inward approved successfully")
                window.location.replace("<?=base_url()?>admin/Stock_inward/manage_stockinward");
            }else{
                toastr.error("Error: Failed to Approve Stock inward")
            }
        },
        "error": function(){
            toastr.error("Error: Failed to Approve Stock inward")
        }
    })
}
function downloadTraceBulkDevice(stn_id){

    window.location.href = '<?php echo base_url(); ?>admin/Stock_inward/dowloadStockinwardItems?stn_id='+stn_id
    
}
 
</script>