<!-- Form with a file upload option -->

<div class="col-sm-12 col-md-12 col-lg-12">
    <div class="col-md-12  col-sm-12 col-xs-12" style="padding:10px">
        <div class="form-group" style="padding:10px;">
            <label class="col-lg-2 control-label">Upload Price (CSV)</label>
            <div class="col-lg-3">
                <input type="file" name="upload_mrp_devices" id="upload_mrp_devices" class="form-control">
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-primary" id="upload_mrp_devices_btn" onclick="validatePrices()">Upload</button>
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-danger" id="upload_mrp_devices_sample" onclick="downloadPrices()">Download</button>
            </div>
        </div>
    </div>
</div>
<!--include assets/jquery-csv.js -->
<script src="<?php echo base_url(); ?>assets/js/jquery-csv.js"></script>
<script>
    function downloadPrices() {
        window.open("<?= base_url() ?>admin/Sellerflex/downloadPrices", "_blank")
    }

    function validatePrices() {
        var device_id, listing_amount, remittance_amount, document_no;
        var deviceArr = [];
        var orderObject = [];

        var fileUpload = document.getElementById("upload_mrp_devices");
        var regex = /^([a-zA-Z0-9\s_\\.\-:()])+(.csv|.txt)$/;

        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof(FileReader) != "undefined") {
                var reader = new FileReader();
                reader.onload = function(e) {
                    let str = e.target.result;
                    let data = $.csv.toArrays(str);
                    let isValid = true;
                    for (i = 1; i < data.length; i++) {
                        if (data[i][0].length > 0) {
                            device_id = data[i][0];
                            listing_amount = data[i][2];
                            remittance_amount = data[i][3];
                            document_no = data[i][4];

                            if(isNaN(listing_amount) || isNaN(remittance_amount) || parseFloat(listing_amount) <= 0 || parseFloat(remittance_amount) <= 0) {
                                alert("Invalid Price for device id: " + device_id);
                                isValid = false;
                                return false;
                            }

                            let order_obj = {
                                "device_id": device_id,
                                "mrp": listing_amount,
                                "remittance_amount": remittance_amount,
                                "lot_no": document_no
                            }

                            orderObject.push(order_obj);
                        }
                    }

                    if(!isValid){
                        return false;
                    }

                    if (orderObject.length > 0) {
                        uploadDevicePrices(orderObject)
                    } else {
                        toastr.error("Invalid File")
                        return false
                    }

                }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

    function uploadDevicePrices(orderObject) {

        if (orderObject == null) {
            toastr.error("Invalid File")
            return false
        }

        jsonObejct = JSON.stringify(orderObject);
        $.ajax({
            url: "<?= base_url() ?>admin/Fastcheckout/uploadMRP",
            type: "POST",
            data: jsonObejct,
            dataType: 'json',
            success: function(data) {
                if (data.status == 1) {
                    toastr.success("Prices Uploaded Successfully")
                    setTimeout(function() {
                        window.location.reload()
                    }, 2000)
                    return true
                } else {
                    if (data.message != undefined) {
                        toastr.error(data.message)
                    } else {
                        toastr.error("Failed to Upload Prices")
                    }
                    return false
                }
            },
            error: function(data) {
                toastr.error("Failed to Upload Prices")
                return false
            }
        })
    }
</script>