<!-- Form with a file upload option -->

<div class="col-sm-12 col-md-12 col-lg-12">
    <div class="col-md-12  col-sm-12 col-xs-12" style="padding:10px">
        <div class="form-group" style="padding:10px;">
            <label class="col-lg-2 control-label">Upload Invoice (CSV)</label>
            <div class="col-lg-3">
                <input type="file" name="create_vendor_name_file" id="create_vendor_name_file" class="form-control">
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-primary" id="create_upload_vendor_name" onclick="validateVendorName()">Upload</button>
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-danger" id="create_upload_vendor_name" onclick="downloadVendorNameOrders()">Download</button>
            </div>
        </div>
    </div>
</div>

<script>
    function downloadVendorNameOrders() {
        window.open("<?=base_url()?>admin/Sellerflex/getVendorNameFile", "_blank")
    }

    function validateVendorName(){
		var orderObject = [];
		
		var fileUpload = document.getElementById("create_vendor_name_file");
        var regex = /^([a-zA-Z0-9\s_\\.\-:()])+(.csv|.txt)$/;
        
        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof (FileReader) != "undefined") {
                var reader = new FileReader();
                reader.onload = function (e) {
					var rows = e.target.result.split("\n");
					for (var i = 1; i < rows.length; i++) {
                        if(rows[i] == ''){
                            continue
                        }
						var cells = rows[i].split(",");
                        
                        if (cells[1].length > 1) {
                            
                            order_obj = {
                                order_id:cells[0],
                                vendor_name: cells[1].replace('\r', '')
                            }
                            orderObject.push(order_obj)
						}
					}	
					
					if(orderObject.length>0){
                        uploadVendorName(orderObject)
                    }else{
                        toastr.error("Invalid File")
                        return false
                    }
		        }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

    function uploadVendorName(orderObject){

        if(orderObject == null){
            toastr.error("Invalid File")
            return false
        }

        jsonObejct = JSON.stringify(orderObject);
        $.ajax({
            url: "<?=base_url()?>admin/Sellerflex/updateVendorName",
            type: "POST",
            data: jsonObejct,
            dataType: 'json',
            success: function (data) {
                if (data.status == 1) {
                    toastr.success("Vendor Name Updated Successfully")
                    setTimeout(function () {
                        window.location.reload()
                    }, 2000)
                    return true
                } else {
                    if(data.message != undefined){
                        toastr.error(data.message)
                    }else{
                        toastr.error("Failed to Update Vendor Names")
                    }
                    return false
                }
            },
            error: function (data) {
                toastr.error("Failed to Update Vendor Names")
                return false
            }
        })
    }

    
</script>