<!-- Form with a file upload option -->

<div class="col-sm-12 col-md-12 col-lg-12">
    <div class="col-md-12  col-sm-12 col-xs-12" style="padding:10px">
        <div class="form-group" style="padding:10px;">
            <label class="col-lg-2 control-label">Upload Picked Devices (CSV)</label>
            <div class="col-lg-3">
                <input type="file" name="create_picked_devices" id="create_picked_devices" class="form-control">
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-primary" id="create_picked_devices" onclick="validatePickedDevices()">Upload</button>
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-danger" id="create_download_pick_devices" onclick="downloadPickDevices()">Download Sample File</button>
            </div>
        </div>
    </div>
</div>
<!--include assets/jquery-csv.js -->
<script src="<?php echo base_url(); ?>assets/js/jquery-csv.js"></script>
<script>
    function downloadPickDevices() {
        let data = 'Device Id, Listing Amount, Remittance Amount'
        data += '\n'
        //create csv file for donwload
        var csv = data;
        var filename = "picked_devices.csv";
        var blob = new Blob([csv], {
            type: 'text/csv;charset=utf-8;'
        });
        var link = document.createElement("a");
        link.href = window.URL.createObjectURL(blob);
        link.download = filename;
        link.click();
    }

    function validatePickedDevices() {
        var device_id, listing_amount, remittance_amount;
        var orderObject = [];

        var fileUpload = document.getElementById("create_picked_devices");
        var regex = /^([a-zA-Z0-9\s_\\.\-:()])+(.csv|.txt)$/;

        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof(FileReader) != "undefined") {
                var reader = new FileReader();
                reader.onload = function(e) {
                    let str = e.target.result;
                    let data = $.csv.toArrays(str);

                    for (i = 1; i < data.length; i++) {
                        if (data[i][0].length > 0) {
                            device_id = data[i][0];
                            listing_amount = data[i][1];
                            remittance_amount = data[i][2];
                            
                            let order_obj = {
                                "device_id": device_id,
                                "listing_amount": listing_amount,
                                "remittance_amount": remittance_amount,
                            }

                            orderObject.push(order_obj);
                        }
                    }

                    if (orderObject.length > 0) {
                        uploadPickedDevices(orderObject)
                    } else {
                        toastr.error("Invalid File")
                        return false
                    }

                }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

    function uploadPickedDevices(orderObject) {

        if (orderObject == null) {
            toastr.error("Invalid File")
            return false
        }

        jsonObejct = JSON.stringify(orderObject);
        $.ajax({
            url: "<?= base_url() ?>admin/Sellerflex/uploadPickedDevices",
            type: "POST",
            data: jsonObejct,
            dataType: 'json',
            success: function(data) {
                if (data.status == 1) {
                    toastr.success("Devices Uploaded Successfully")
                    setTimeout(function() {
                        window.location.reload()
                    }, 2000)
                    return true
                } else {
                    if (data.message != undefined) {
                        toastr.error(data.message)
                    } else {
                        toastr.error("Failed to Upload Pick List")
                    }
                    return false
                }
            },
            error: function(data) {
                toastr.error("Failed to Upload Pick List")
                return false
            }
        })
    }
</script>