<!-- Form with a file upload option -->

<div class="col-sm-12 col-md-12 col-lg-12">
    <div class="col-md-12  col-sm-12 col-xs-12" style="padding:10px">
        <div class="form-group" style="padding:10px;">
            <label class="col-lg-2 control-label">Upload Salesorder (XML File)</label>
            <div class="col-lg-3">
                <input type="file" name="xml_so_file" id="xml_so_file" class="form-control">
            </div>
        </div>
        <div class="col-md-12 col-sm-12 col-xs-12" style="padding:10px">
            <div class="form-group">
                <label class="col-lg-2 control-label">Upload SO List (CSV)</label>
                <div class="col-lg-3">
                    <input type="file" id="csv_so_file" class="form-control">
                </div>
                <div class="col-lg-2">
                    <button type="button" id="sample_sf_so_csv" class="btn btn-success" onclick="window.open('<?=base_url()?>assets/sample/sf_so.csv', target='_blank')">Download Sample CSV</button>
                </div>
            </div>
        </div>
        <div class="col-md-12 col-sm-12 col-xs-12" style="padding:10px">
            <div class="form-group">
                <div class="col-lg-2">
                    <button type="button" class="btn btn-primary" id="upload_invoice" onclick="getCSVData()">Upload</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>

    function getCSVData(){
        let data = [];
        let fileUpload = document.getElementById("csv_so_file");
        let regex = /^([a-zA-Z0-9\s_\\.\-:()])+(.csv|.txt)$/;

        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof (FileReader) != "undefined") {
                let reader = new FileReader();
                reader.onload = function (e) {
                    let rows = e.target.result.split("\n");
                    for (let i = 1; i < rows.length; i++) {
                        if(rows[i] == ''){
                            continue
                        }
						var cells = rows[i].split(",");
                        let order_id = cells[0].replace("\r", "");
                        data.push(order_id);
                    }
                    validateXML(data);
                }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

    function validateXML(orderIdList = []) {
        var xmlDoc;
        var orders = [];
        var fileUpload = document.getElementById("xml_so_file");
        var regex = /^([a-zA-Z0-9\s_\\.\-:()])+(.xml|.txt)$/;

        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof(FileReader) != "undefined") {
                var reader = new FileReader();
                reader.onload = function(e) {

                    if (window.DOMParser) {
                        parser = new DOMParser();
                        xmlDoc = parser.parseFromString(e.target.result, "text/xml");
                    } else // Internet Explorer
                    {
                        xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
                        xmlDoc.async = false;
                        xmlDoc.loadXML(e.target.result);
                    }
                    var xml_error = xmlDoc.getElementsByTagName("error");
                    
                    if (xml_error.length > 0) {
                        alert(xml_error[0].childNodes[0].nodeValue);
                        return false;
                    }
                    //Loop For Element Message
                    for (let i = 0; i < xmlDoc.getElementsByTagName("Message").length; i++) {
                        let order_items = []
                        let xml_order = xmlDoc.getElementsByTagName("Message")[i];

                        //Get Order Element from xml_order
                        let xml_order_element = xml_order.getElementsByTagName("Order");
                        let xml_order_element_id = xml_order_element[0].getElementsByTagName("AmazonOrderID")[0].childNodes[0].nodeValue;
                        
                        if(orderIdList.length > 0 && orderIdList.indexOf(xml_order_element_id) == -1){
                            continue;
                        }
                        
                        let xml_order_purchase_date = xml_order_element[0].getElementsByTagName("PurchaseDate")[0].childNodes[0].nodeValue;
                        let xml_order_order_status = xml_order_element[0].getElementsByTagName("OrderStatus")[0].childNodes[0].nodeValue;
                        let xml_order_fulfillment_element = xml_order_element[0].getElementsByTagName("FulfillmentData");
                        let xml_order_address_element = xml_order_fulfillment_element[0].getElementsByTagName("Address")
                        let xml_order_city = xml_order_address_element[0].getElementsByTagName("City")[0].childNodes[0].nodeValue;
                        let xml_order_state = xml_order_address_element[0].getElementsByTagName("State")[0].childNodes[0].nodeValue;
                        let xml_order_postalcode = xml_order_address_element[0].getElementsByTagName("PostalCode")[0].childNodes[0].nodeValue;
                        let xml_order_item_element = xml_order_element[0].getElementsByTagName("OrderItem");
                        let is_cancelled_before_ship = false;
                        for (let k = 0; k < xml_order_item_element.length; k++) {
                            let xml_order_item_status = xml_order_item_element[0].getElementsByTagName("ItemStatus")[0].childNodes[0].nodeValue;
                            if (xml_order_item_status == "Cancelled") {
                                is_cancelled_before_ship = true
                                continue
                            }
                            let xml_order_item_sku = xml_order_item_element[0].getElementsByTagName("SKU")[0].childNodes[0].nodeValue;
                            let xml_order_item_product_name = xml_order_item_element[0].getElementsByTagName("ProductName")[0].childNodes[0].nodeValue;
                            let xml_order_item_quantity = xml_order_item_element[0].getElementsByTagName("Quantity")[0].childNodes[0].nodeValue;
                            let xml_order_item_price_element = xml_order_item_element[0].getElementsByTagName("ItemPrice")

                            let xml_order_item_price_component = xml_order_item_price_element[0].getElementsByTagName("Component")
                            let xml_order_item_price_type = ''
                            let xml_order_item_price_amount = 0;

                            for (let m = 0; m < xml_order_item_price_component.length; m++) {
                                xml_order_item_price_type = xml_order_item_price_component[0].getElementsByTagName("Type")[0].childNodes[0].nodeValue;
                                if (xml_order_item_price_type == "Principal") {
                                    xml_order_item_price_amount = xml_order_item_price_component[0].getElementsByTagName("Amount")[0].childNodes[0].nodeValue;
                                }
                            }

                            if (isNaN(xml_order_item_price_amount)) {
                                toastr.error('Invalid Order Price for' + xml_order_element_id);
                                return false
                            }

                            if (xml_order_item_quantity <= 0 || isNaN(xml_order_item_quantity)) {
                                toastr.error('Invalid Order Quantity for' + xml_order_element_id);
                                return false
                            }

                            order_items.push({
                                sku: xml_order_item_sku,
                                quantity: xml_order_item_quantity,
                                price: xml_order_item_price_amount,
                                product_name: xml_order_item_product_name
                            })
                        }
                        if (is_cancelled_before_ship) {
                            continue
                        }
                        if (xml_order_element_id.length <= 0) {
                            toastr.error('Invalid Order ID' + xml_order_element_id);
                            return false
                        }

                        let order_obj = {
                            'order_id': xml_order_element_id,
                            'purchase_date': xml_order_purchase_date,
                            'order_status': xml_order_order_status,
                            'city': xml_order_city,
                            'state': xml_order_state,
                            'postalcode': xml_order_postalcode,
                            'order_items': order_items

                        }
                        orders.push(order_obj)
                    }
                    uploadSalesorder(orders);
                }
            }
            reader.readAsText(fileUpload.files[0]);
        } else {
            alert("Please upload a valid xml/txt file.");
            return false;
        }
    }

    function uploadSalesorder(orders_obj) {
        if (orders_obj) {
            var jsonObject = JSON.stringify(orders_obj);
            $.ajax({
                url: '<?= base_url() ?>admin/Sellerflex/createSalesorder',
                type: 'POST',
                data: jsonObject,
                dataType: 'json',
                processData: false,
                contentType: false,
                success: function(data) {
                    if (data.status == 1) {
                        toastr.success(data.message);
                        setTimeout(function() {
                            window.location.href = '<?= base_url() ?>admin/Sellerflex/manage_sellerflex';
                        }, 2000);
                        return true
                    }
                    toastr.error(data.message);
                    return false
                },
                error: function(data) {
                    toastr.error("Failed to Create Salesorders");
                }
            });
        }
    }
</script>