<!-- Form with a file upload option -->

<div class="col-sm-12 col-md-12 col-lg-12">
    <div class="col-md-12  col-sm-12 col-xs-12" style="padding:10px">
        <div class="form-group" style="padding:10px;">
            <label class="col-lg-2 control-label">Upload Invoice (CSV)</label>
            <div class="col-lg-3">
                <input type="file" name="create_stn_file" id="create_stn_file" class="form-control">
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-primary" id="create_stn_upload" onclick="validateTDIDs()">Upload</button>
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-danger" id="create_stn_sample" onclick="downloadSampleStn()">Download</button>
            </div>
        </div>
    </div>
</div>

<script>
    function downloadSampleStn() {
        window.open("<?= base_url() ?>admin/Sellerflex/downloadSampleStn", "_blank")
    }

    function validateTDIDs() {
        var stnObject = [];

        var fileUpload = document.getElementById("create_stn_file");
        var regex = /^([a-zA-Z0-9\s_\\.\-:()])+(.csv|.txt)$/;

        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof(FileReader) != "undefined") {
                var reader = new FileReader();
                reader.onload = function(e) {
                    var rows = e.target.result.split("\n");
                    for (var i = 1; i < rows.length; i++) {
                        if (rows[i] == '') {
                            continue
                        }
                        var cells = rows[i].split(",");

                        if (cells[0].length > 1) {

                            stn_obj = {
                                device_id: cells[0].replace('\r', '')
                            }
                            stnObject.push(stn_obj)
                        }
                    }

                    if (stnObject.length > 0) {
                        uploadStocktransfer(stnObject)
                    } else {
                        toastr.error("Invalid File")
                        return false
                    }
                }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

    function uploadStocktransfer(stnObject) {

        if (stnObject == null) {
            toastr.error("Invalid File")
            return false
        }

        jsonObejct = JSON.stringify(stnObject);
        $.ajax({
            url: "<?= base_url() ?>admin/Bulk_status/updateSaletypetoSellerflex",
            type: "POST",
            data: jsonObejct,
            dataType: 'json',
            success: function(data) {
                if (data.status == 1) {
                    toastr.success("Stock Moved to Seller Flex Warehouse Successfully")
                    setTimeout(function() {
                        window.location.reload()
                    }, 2000)
                    return true
                } else {
                    if (data.message != undefined) {
                        toastr.error(data.message)
                    } else {
                        toastr.error("Failed to Move Stock to Seller Flex Warehouse")
                    }
                    return false
                }
            },
            error: function(data) {
                toastr.error("Failed to Move Stock to Seller Flex Warehouse")
                return false
            }
        })
    }
</script>