<style>
    td.details-control {
        font-size: 0;
        background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
    }

    tr {
        height: 30px;
    }

    #sellerflexInvoiceTable {
        all: unset;

    }



    .modal-backdrop {
        z-index: 0 !important;
    }

    #sellerflexInvoiceTable td {
        white-space: nowrap
    }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
    <label class="btn btn-primary active">
        <input type="radio" name="options" id="invoice_button_pending">PENDING
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="invoice_button_invoiced">INVOICED
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="invoice_button_part_return">PART RETURN
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="invoice_button_full_return">FULL RETURN
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="invoice_button_cancelled">CANCELLED
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="invoice_button_void">VOID
    </label>

</div>
<p style="line-height:10px;"></p>

<div style="overflow-x: auto;">
    <table class="table table-striped DataTables table-responsive" style="margin-left:15px; width:100%;" id="sellerflexInvoiceTable">
        <thead>
            <tr>
                <th></th>
                <th>Salesorder No</th>
                <th>Invoice No</th>
                <th>Vendor Name</th>
                <th>Saleschannel<br>Order Id</th>
                <th>Order Date</th>
                <th>Invoice Date</th>
                <th>Qty</th>
                <th>Invoice Amount</th>
                <th>Taxable Amount</th>
                <th>Tax Amount</th>
                <th>Sales Channel</th>
                <th>Payment Mode</th>
                <th>Created By</th>
                <th>Creation Date</th>
                <th>Last Updated By</th>
                <th>last Update Date</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<script>
    var department_id = <?= $this->session->userdata('department_id') ?>;
    $(document).ready(function() {

        getPurchaseInvoiceList('PENDING');
        var st_invoice_table;

        function getPurchaseInvoiceList(status) {
            st_invoice_table = $('#sellerflexInvoiceTable').DataTable({
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "aaSorting": [],
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/Sellerflex/getInvoiceList?status=" + status,
                    "type": "GET",
                    "dataSrc": "data",
                    "async": false,
                },
                "dom": 'Bfrtip',
                "buttons": [{
                    "extend": 'csv',
                    "text": '<span class="fa fa-download" style="color:white;"></span>',
                    'className': 'btn btn-green down_btn',

                    exportOptions: {
                        columns: ':not(.details-control)'
                    }
                }],
                "columns": [{
                        "className": 'details-control salesorderid',
                        "data": "salesorder_id"
                    },
                    {
                        "data": "salesorder_no"
                    },
                    {
                        "data": "invoice_no"
                    },
                    {
                        "data": "vendor_name"
                    },
                    {
                        "data": "saleschannel_ref_id"
                    },
                    {
                        "data": "order_date"
                    },
                    {
                        "data": "invoice_date"
                    },
                    {
                        "data": "quantity"
                    },
                    {
                        "data": "total_amount"
                    },
                    {
                        "data": "taxable_amount"
                    },
                    {
                        "data": "tax_amount"
                    },
                    {
                        "data": "sales_channel"
                    },
                    {
                        "data": "payment_mode"
                    },
                    {
                        "data": "created_by"
                    },
                    {
                        "data": "creation_date"
                    },
                    {
                        "data": "last_updated_by"
                    },
                    {
                        "data": "last_update_date"
                    }
                ]
            });
        }

        $('#invoice_button_pending').change(function() {
            getPurchaseInvoiceList('PENDING')
        });

        $('#invoice_button_invoiced').change(function() {
            getPurchaseInvoiceList('INVOICED')
        });

        $('#invoice_button_full_return').change(function() {
            getPurchaseInvoiceList('FULL_RETURN')
        });
        $('#invoice_button_part_return').change(function() {
            getPurchaseInvoiceList('PART_RETURN')
        });
        $('#invoice_button_cancelled').change(function() {
            getPurchaseInvoiceList('CANCELLED')
        });

        $('#sellerflexInvoiceTable tbody').on('click', 'td.details-control', function() {
            var tr = $(this).closest('tr');
            var row = st_invoice_table.row(tr);
            if (row.child.isShown()) {
                row.child.hide();
                tr.removeClass('shown');
            } else {
                row.child(format(row.data())).show();
                tr.addClass('shown');
            }
        });

        function format(d) {
            var str = '';
            // `d` is the original data object for the row
            var childtable = '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
            $.ajax({
                url: encodeURI("<?php echo base_url(); ?>web_api/getsalesorderdetails?salesorder_id=" + d.salesorder_id),
                type: "GET",
                dataType: 'json',
                async: false,
                success: function(data) {
                    if (data.result == null) {
                        responseData = null;
                        childtable += '<tr><td>No Records Found</td></tr>';
                    } else {
                        responseData = data.result

                        str = 'Device ID, Category, SKU, Device Name, Grade, Sales Terms, Price, Quantity, Amount, '
                        str += '\r\n'
                        childtable += '<th>Device Id</th><th>CATEGORY</th><th>SKU</th><th>Product Name</th>';
                        childtable += '<th>GRADE</th><th>SALES TERMS</th><th>Price</th><th>Quantity</th><th>Amount</th>' //<th>Remarks</th>'
                        $.each(data.result, function(i, d) { // loop through data returned from ajax 
                            let device_id = data.result[i].device_id
                            if(device_id == null){
                                device_id = ''
                            }
                            childtable += '<tr>' +
                                '<td>' + device_id + '</td>' +
                                '<td>' + data.result[i].category + '</td>' +
                                '<td>' + data.result[i].sku + '</td>' +
                                '<td>' + data.result[i].product_name + '</td>' +
                                '<td>' + data.result[i].grade + '</td>' +
                                '<td>' + data.result[i].sales_terms + '</td>' +
                                '<td>' + data.result[i].price + '</td>' +
                                '<td>' + data.result[i].quantity + '</td>' +
                                '<td>' + data.result[i].amount + '</td>' +
                                '</tr>';

                            var line = '';

                            line += data.result[i].device_id + ", "
                            line += data.result[i].category + ", "
                            line += data.result[i].sku + ", "
                            line += data.result[i].product_name + ", "
                            line += data.result[i].grade + ", "
                            line += data.result[i].sales_terms + ", "
                            line += data.result[i].price + ", "
                            line += data.result[i].quantity + ", "
                            line += data.result[i].amount + ", "

                            str += line + '\r\n';
                        });
                    }
                }
            });

            childtable += '</table>';
            childtable += '<br>';
            childtable += '<div style="text-align:left; margin-left:5px;"><button class="btn btn-info" onclick=\'downloadSalesOrderDetails(' + JSON.stringify(str) + ')\'>Download</button></div>'
            return childtable
        }


    })

    function downloadSalesOrderDetails(str = '') {

        var a = document.createElement('a');
        a.href = 'data:attachment/csv,' + encodeURIComponent(str);
        a.target = '_blank';
        a.download = 'orderdetails.csv';

        document.body.appendChild(a);
        a.click();
    }
</script>