<div class="btn-group btn-toolbar" data-toggle="buttons" style="margin:5px;">
    <label class="btn btn-primary active">
        <input type="radio" name="options" id="button_to_be_priced">PRICING PENDING
    </label>

    <label class="btn btn-primary">
        <input type="radio" name="options" id="button_wh_pending">WH PENDING
    </label>

    <label class="btn btn-primary">
        <input type="radio" name="options" id="button_available">AVAILABLE
    </label>

    <label class="btn btn-primary">
        <input type="radio" name="options" id="button_sold">SOLD
    </label>
</div>
<br>
<hr>
<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;">
    <!-- Table with columns Device ID, Device Name, SKU, Category, Retail Price -->
    <table id="device_price_list" class=" dataTables table table-striped table-bordered dt-responsive nowrap" cellspacing="0" width="90%">
        <thead>
            <th>Device ID</th>
            <th>Device Name</th>
            <th>SKU</th>
            <th>Category</th>
            <th>Batch No</th>
            <th>Lot No</th>
            <th>Status</th>
            <th>Retail Price</th>
        </thead>
    </table>
</div>

<script>
    $(document).ready(function() {
        //get device price list
        getDevicePriceList('TO_BE_PRICED')

        function getDevicePriceList(action = '') {
            //datatable
            var table = $('#device_price_list').DataTable({
                "processing": true,
                "serverSide": false,
                "destroy": true,
                "ajax": {
                    "url": "getDevicePriceList",
                    "type": "GET",
                    "data": {
                        'action': action
                    },
                    "dataSrc": "data",
                },
                    "columns": [{
                            "data": "device_id"
                        },
                        {
                            "data": "device_name"
                        },
                        {
                            "data": "sku"
                        },
                        {
                            "data": "category"
                        },
                        {
                            "data": "batch_no"
                        },
                        {
                            "data": "lot_no"
                        },
                        {
                            "data": "status"
                        },
                        {
                            "data": "mrp"
                        }
                    ],
                    //Export csv with buttons
                    dom: 'Bfrtip',
                    buttons: [{
                        extend: 'csv',
                        text: '<i class="fa fa-file-excel-o btn btn-success" style="margin:20px;">&nbsp;&nbsp;CSV</i>',
                        filename: 'Device Price List',
                    }]
                

            })
        }

        $('#button_available').change(function() {
            getDevicePriceList('AVAILABLE')
        });

        $('#button_wh_pending').change(function() {
            getDevicePriceList('WH_PENDING')
        });

        $('#button_to_be_priced').change(function() {
            getDevicePriceList('TO_BE_PRICED')
        });

        $('#button_sold').change(function() {
            getDevicePriceList('SOLD')
        });
    })
</script>