<style>
    td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
    }

    tr {
        height: 30px;
    }

    #sellerflexInvoiceTable {
        all: unset;

    }

    .modal-backdrop {
        z-index: 0 !important;
    }

    #sellerflexDeviceTable td {
        white-space: nowrap
    }
    .btn_download{
        margin: 5px !important;
    }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons" style="margin-left:5px;">
    <label class="btn btn-primary active">
        <input type="radio" name="options" id="device_rfs">RFS
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="device_sold">SOLD
    </label>
</div>
<p style="line-height:10px;"></p>

<div style="overflow-x: auto;">
    <table class="table table-striped DataTables table-responsive" style="margin-left:5px; width:100%;" id="sellerflexDeviceTable">
        <thead>
            <tr>
                <th></th>
                <th>DEVICE ID</th>
                <th>PRODUCT</th>
                <th>SKU</th>
                <th>STOCK<br>TYPE</th>
                <th>STOCK<br>SUB TYPE</th>
                <th>SALE TYPE</th>
                <th>BIN<br>NUMBER</th>
                <th>AGE<br>(IN DAYS)</th>
                <th>CERTIFICATION AGE<br>(IN DAYS)</th>
                <th>CERTIFIED<br>GRADE</th>
                <th>BAC</th>
                <th>ISSUED<br>GRADE</th>
                <th>ISSUED<br>DATE</th>
                <th>CERTIFIED<br>DATE</th>
                <th>IMEI</th>
            </tr>
        </thead>
    </table>
</div>

<script>
    var department_id = <?= $this->session->userdata('department_id') ?>;
    $(document).ready(function() {

        getDeviceList('RFS');

        function getDeviceList(status) {
            st_invoice_table = $('#sellerflexDeviceTable').DataTable({
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "aaSorting": [],
                dom: 'Bfrtip',
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/certification/getDeviceDetailsByStatus",
                    "type": "POST",
                    "data": {
                        'status': status,
                        'saletype': "SELLERFLEX"
                    },
                    "dataSrc": "data"
                },
                buttons: [{
					"extend": 'csv',
					"text": '<span class="fa fa-download" style="color:white;"></span>',
					'className': 'btn btn-green down_btn',

					exportOptions: {
						columns: ':not(.details-control)'
					}
				} ],
                "columns": [{
                        "className": 'details-control',
                        "orderable": false,
                        "data": null,
                        "defaultContent": ''
                    },
                    {
                        "data": "nhdin"
                    },
                    {
                        "data": "device_name"
                    },
                    {
                        "data": function(data) {
                            return data.nhmod + '-' + data.ram + '-' + data.rom + '-' + data.color;
                        }
                    },
                    {
                        "data": "stock_type"
                    },
                    {
                        "data": "device_sub_category"
                    },
                    {
                        "data": "saletype"
                    },
                    {
                        "data": "bin_number"
                    },
                    {
                        "data": "age"
                    },
                    {
                        "data": function(data) {
                            const startDate = data.issued_date;
                            const endDate = new Date();

                            if (startDate == null)
                                return ''

                            const diffInMs = new Date(endDate) - new Date(startDate)
                            const diffInDays = Math.floor(diffInMs / (1000 * 60 * 60 * 24));
                            if (diffInDays == NaN) {
                                return ''
                            }
                            return diffInDays
                        }
                    },
                    {
                        "data": "certification_grade"
                    },
                    {
                        "data": "bac"
                    },
                    {
                        "data": "issued_category"
                    },
                    {
                        "data": "issued_date"
                    },
                    {
                        "data": "certified_date"
                    },
                    {
                        "data": "imei1_no"
                    }
                ]
            });
        }

        $('#device_rfs').change(function() {
            getDeviceList('RFS')
        });

        $('#device_sold').change(function() {
            getDeviceList('SOLD')
        });

    })
</script>