<!-- Form with a file upload option -->

<div class="col-sm-12 col-md-12 col-lg-12">
    <div class="col-md-12  col-sm-12 col-xs-12" style="padding:10px">
        <div class="form-group" style="padding:10px;">
            <label class="col-lg-2 control-label">Upload Invoice (CSV)</label>
            <div class="col-lg-3">
                <input type="file" name="create_so_file" id="create_so_file" class="form-control">
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-primary" id="create_upload_invoice" onclick="validateSODevices()">Upload</button>
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-danger" id="create_so_sample" onclick="window.open('<?=base_url()?>assets/sample/sf_so.csv', target='_blank')">Download Sample</button>
            </div>
        </div>
    </div>
</div>
<!--include assets/jquery-csv.js -->
<script src="<?php echo base_url(); ?>assets/js/jquery-csv.js"></script>
<script>
    function downloadOrders() {
        window.open("<?= base_url() ?>admin/Sellerflex/getSOData", "_blank")
    }

    function validateSODevices() {
        var device_name, sku, category, grade, sales_term, saletype, quantity, price, parsedPrice;
        var deviceArr = [];
        var orderObject = [];
        var orderMap = {};

        var fileUpload = document.getElementById("create_so_file");
        var regex = /^([a-zA-Z0-9\s_\\.\-:()])+(.csv|.txt)$/;

        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof(FileReader) != "undefined") {
                var reader = new FileReader();
                reader.onload = function(e) {
                    let str = e.target.result;
                    let data = $.csv.toArrays(str);

                    for (i = 1; i < data.length; i++) {
                        if (data[i][4].length > 0) {
                            order_id = data[i][0].trim();
                            date = data[i][1].trim();
                            date = date.split('-');
                            date = date[2] + '-' + date[1] + '-' + date[0];
                            sku = data[i][2].trim();
                            device_name = data[i][3].trim();
                            quantity = data[i][4];
                            device_id = data[i][5].trim();
                            amount = data[i][6].trim();
                            vendor_name = data[i][7];
                            city = data[i][8];
                            state = data[i][9].trim();
                            pincode = data[i][10];
                            // address truncated to 100 characters
                            address = data[i][11].trim().substring(0, 100).replace('/n', '').replace('/r', '').replace('/n', '');
                            gstin = data[i][12];

                            // check date validity
                            if(date.length != 10){
                                alert('Invalid date format');
                                return false;
                            }

                            if(device_name.length == 0 || device_name === 'undefined'){
                                alert('Device name is empty');
                                return false;
                            }

                            if(sku.length == 0 || sku === 'undefined'){
                                alert('SKU is empty');
                                return false;
                            }

                            if(quantity <= 0 || quantity === 'undefined'){
                                alert('Quantity is empty');
                                return false;
                            }

                            if(amount <= 0 || amount === 'undefined'){
                                alert('Amount is empty');
                                return false;
                            }

                            if(device_id.length == 0 || device_id === 'undefined'){
                                alert('Device id is empty');
                                return false;
                            }

                            let order_items = {
                                'sku': sku,
                                'device_name': device_name,
                                'quantity': quantity,
                                'device_id': device_id,
                                'amount': amount
                            }

                            if(order_id in orderMap){
                                for(let j =0; j < orderObject.length; j++){
                                    if(orderObject[j].order_id == order_id){
                                        orderObject[j].order_items.push(order_items);
                                    }
                                }
                            } else {
                                let order = {
                                    'order_id': order_id,
                                    'date': date,
                                    'vendor_name': vendor_name,
                                    'city': city,
                                    'state': state,
                                    'pincode': pincode,
                                    'address': address,
                                    'gstin': gstin,
                                    'order_items': [order_items]
                                };
                                orderObject.push(order);
                                orderMap[order_id] = true;
                            }
                        }
                    }

                    if (orderObject.length > 0) {
                        createSOwithDevice(orderObject)
                    } else {
                        toastr.error("Invalid File")
                        return false
                    }

                }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

    function createSOwithDevice(orderObject) {

        if (orderObject == null) {
            toastr.error("Invalid File")
            return false
        }

        jsonObejct = JSON.stringify(orderObject);
        $.ajax({
            url: "<?= base_url() ?>admin/Sellerflex/createSOwithDevice",
            type: "POST",
            data: jsonObejct,
            dataType: 'json',
            success: function(data) {
                if (data.status == 1) {
                    toastr.success("Sales Order Uploaded Successfully")
                    setTimeout(function() {
                        window.location.reload()
                    }, 2000)
                    return true
                } else {
                    if (data.message != undefined) {
                        toastr.error(data.message)
                    } else {
                        toastr.error("Failed to Create Sales Order")
                    }
                    return false
                }
            },
            error: function(data) {
                toastr.error("Failed to Create Sales Order")
                return false
            }
        })
    }
</script>