<!-- Form with a file upload option -->

<div class="col-sm-12 col-md-12 col-lg-12">
    <div class="col-md-12  col-sm-12 col-xs-12" style="padding:10px">
        <div class="form-group" style="padding:10px;">
            <label class="col-lg-2 control-label">Upload Invoice (CSV)</label>
            <div class="col-lg-3">
                <input type="file" name="create_invoice_file" id="create_invoice_file" class="form-control">
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-primary" id="create_upload_invoice" onclick="validateDevices()">Upload</button>
            </div>
            <div class="col-lg-2">
                <button type="button" class="btn btn-danger" id="create_upload_invoice" onclick="downloadOrders()">Download <br>Pending Orders</button>
            </div>
        </div>
    </div>
</div>
<!--include assets/jquery-csv.js -->
<script src="<?php echo base_url(); ?>assets/js/jquery-csv.js"></script>
<script>
    function downloadOrders() {
        window.open("<?= base_url() ?>admin/Sellerflex/getSOData", "_blank")
    }

    function validateDevices() {
        var device_name, sku, category, grade, sales_term, saletype, quantity, price, parsedPrice;
        var deviceArr = [];
        var orderObject = [];

        var fileUpload = document.getElementById("create_invoice_file");
        var regex = /^([a-zA-Z0-9\s_\\.\-:()])+(.csv|.txt)$/;

        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof(FileReader) != "undefined") {
                var reader = new FileReader();
                reader.onload = function(e) {
                    let str = e.target.result;
                    let data = $.csv.toArrays(str);

                    for (i = 1; i < data.length; i++) {
                        if (data[i][4].length > 0) {
                            order_id = data[i][1];
                            device_id = data[i][4];
                            vendor_name = data[i][5];
                            gstin = data[i][6];
                            address = data[i][7];
                            let order_obj = {
                                "order_id": order_id,
                                "device_id": device_id,
                                "vendor_name": vendor_name,
                                "gstin": gstin,
                                "address": address
                            }

                            orderObject.push(order_obj);
                        }
                    }

                    if (orderObject.length > 0) {
                        uploadInvoice(orderObject)
                    } else {
                        toastr.error("Invalid File")
                        return false
                    }

                }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

    function uploadInvoice(orderObject) {

        if (orderObject == null) {
            toastr.error("Invalid File")
            return false
        }

        jsonObejct = JSON.stringify(orderObject);
        $.ajax({
            url: "<?= base_url() ?>admin/Sellerflex/uploadInvoiceDevices",
            type: "POST",
            data: jsonObejct,
            dataType: 'json',
            success: function(data) {
                if (data.status == 1) {
                    toastr.success("Invoice Uploaded Successfully")
                    setTimeout(function() {
                        window.location.reload()
                    }, 2000)
                    return true
                } else {
                    if (data.message != undefined) {
                        toastr.error(data.message)
                    } else {
                        toastr.error("Failed to Create Invoice")
                    }
                    return false
                }
            },
            error: function(data) {
                toastr.error("Failed to Create Invoice")
                return false
            }
        })
    }
</script>