<?php echo message_box('success'); ?>
<?php echo message_box('error'); ?>
<?php echo message_box('warning'); ?>
<style>
    #invoice_table_filter.dataTables_filter td{width: 130px;}
		.scrolledTable{ overflow-y: auto; clear:both; white-space:nowrap;
	}
    #invoice_table_filter.dataTables_filter input{width: 130px;}
	td.details-control {
    background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
    cursor: pointer;
	background-position-x: left;
}
tr.shown td.details-control {
    background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
	background-position-x: left;
}
td.invoiceid{
	font-size: 0;
	background-position:center;
}
</style>

<div class="col-md-12">
	<div class="btn-group" style="float: right; margin-top: -15px; margin-bottom: 15px;">
		<a class="btn btn-sm btn-success" style="text-transform:initial;" target="_blank" href="<?php echo base_url();?>admin/security_admin/bulk_package_update">Bulk Package update</a>
	</div>
</div>

    <div class="table-responsive scrolledTable" id="invoice_list">
            <table class="table table-striped DataTables" id="invoice_table" cellspacing="0" style="width:1047px" width="100%">
                <thead>
                <tr>
                    <th>&nbsp;</th>
					<th></th>
                    <th>INVOICE NO</th>
                    <th>VENDOR NAME</th>
                    <th>SALESORDER</th>
                    <th>SLAES<br>EXECUTIVE</th>
                    <th>CREATED BY</th>
                    <th>LAST UPDATE DATE</th>
                    <th>LAST UPDATED BY</th>
					
                </tr>
                </thead>
                <tbody> 
                </tbody>
            </table>
		</div>

		
		<!-- Modal -->
<div class="modal fade" id="Reject_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Reject Invoice</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body table-resposive">
		<table class="table table-responsive">
			<tr><td>Invoice Code: </td><td><input id="invoice_code_modal"><input type="hidden" id="invoice_id_modal"></td></tr>
			<tr><td> Remark: </td><td><textarea maxlength="200" width="250px" height="300px;" id="invoice_remark_modal"></textarea></td></tr>
		</table>
		
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-danger" id="reject_modal_btn" disabled>REJECT</button>
      </div>
    </div>
  </div>
</div>

<script>

$(document).ready(function(){
	$('#Reject_modal').appendTo("body") 

    $.fn.dataTable.pipeline = function ( opts ) {
		// Configuration options
		var conf = $.extend( {
			pages: 5,     // number of pages to cache
			url: '',      // script url
			data: null,   // function or object with parameters to send to the server
						  // matching how `ajax.data` works in DataTables
			method: 'POST' // Ajax HTTP method
		}, opts );
	 
		// Private variables for storing the cache
		var cacheLower = -1;
		var cacheUpper = null;
		var cacheLastRequest = null;
		var cacheLastJson = null;
	 
		return function ( request, drawCallback, settings ) {
			var ajax          = false;
			var requestStart  = request.start;
			var drawStart     = request.start;
			var requestLength = request.length;
			var requestEnd    = requestStart + requestLength;

			var departmentid=<?php echo $this->session->userdata('department_id'); ?>
			 
			if ( settings.clearCache ) {
				// API requested that the cache be cleared
				ajax = true;
				settings.clearCache = false;
			}
			else if ( cacheLower < 0 || requestStart < cacheLower || requestEnd > cacheUpper ) {
				// outside cached data - need to make a request
				ajax = true;
			}
			else if ( JSON.stringify( request.order )   !== JSON.stringify( cacheLastRequest.order ) ||
					  JSON.stringify( request.columns ) !== JSON.stringify( cacheLastRequest.columns ) ||
					  JSON.stringify( request.search )  !== JSON.stringify( cacheLastRequest.search )
			) {
				// properties changed (ordering, columns, searching)
				ajax = true;
			}
			 
			// Store the request for checking next time around
			cacheLastRequest = $.extend( true, {}, request );
	 
			if ( ajax ) {
				// Need data from the server
				if ( requestStart < cacheLower ) {
					requestStart = requestStart - (requestLength*(conf.pages-1));
	 
					if ( requestStart < 0 ) {
						requestStart = 0;
					}
				}
				 
				cacheLower = requestStart;
				cacheUpper = requestStart + (requestLength * conf.pages);
	 
				request.start = requestStart;
				request.length = requestLength*conf.pages;
	 
				// Provide the same `data` options as DataTables.
				if ( typeof conf.data === 'function' ) {
					// As a function it is executed with the data object as an arg
					// for manipulation. If an object is returned, it is used as the
					// data object to submit
					var d = conf.data( request );
					if ( d ) {
						$.extend( request, d );
					}
				}
				else if ( $.isPlainObject( conf.data ) ) {
					// As an object, the data given extends the default
					$.extend( request, conf.data );
				}
	 
				settings.jqXHR = $.ajax( {
					"type":     conf.method,
					"url":      conf.url,
					"data":     request,
					"dataType": "json",
					"cache":    false,
					"beforeSend": function(){ 
						$('.loader').css('display','block'); 					  
					},
					"complete": function(){ 
						$('.loader').css('display','none');				  
					},
					"success":  function ( json ) {
 
						cacheLastJson = $.extend(true, {}, json);
	 
						if ( cacheLower != drawStart ) {
							json.data.splice( 0, drawStart-cacheLower );
						}
						if ( requestLength >= -1 ) {
							json.data.splice( requestLength, json.data.length );
						}
						 
						drawCallback( json );
					}
				} );
			}
			else {
				json = $.extend( true, {}, cacheLastJson );
				json.draw = request.draw; // Update the echo for each response
				json.data.splice( 0, requestStart-cacheLower );
				json.data.splice( requestLength, json.data.length );
	 
				drawCallback(json);
			}
		}
	};

   var invoicetable= $("#invoice_table").DataTable({
        //"dom": 'lBfrtip',
			"nowrap":true,
			//"scrollX": true,
			"bSearchable": true,
			"aaSorting": [[6, 'desc'],[0,'desc']],
			"dom": 'Bfrtip',
			"buttons": [{
				"extend": 'csv',
				"text": '<span class="fa fa-download" style="color:white;"></span>',
				'className': 'btn btn-green down_btn',

				exportOptions: {
					columns: ':not(.no_dwnld)'
				}
			}],
			// "buttons": [
			// 	{
			// 		extend: 'print',
			// 		text: "<i class='fa fa-print'> </i>",
			// 		className: 'btn btn-danger btn-xs mr',
			// 		exportOptions: {
			// 			columns: 'th:not(:first-child),th:not(:last-child)',
			// 		}
			// 	},
			// 	{
			// 		extend: 'excel',
			// 		text: '<i class="fa fa-file-excel-o"> </i>',
			// 		className: 'btn btn-purple mr btn-xs',
			// 		 exportOptions: {
			// 				columns: 'th:not(:first-child),th:not(:last-child)',
			// 			}
			// 	},
			// 	{
			// 		extend: 'csv',
			// 		text: '<i class="fa fa-file-excel-o"> </i>',
			// 		className: 'btn btn-primary mr btn-xs',
			// 		 exportOptions: 
			// 		 {
			// 				columns: 'th:not(:first-child),th:not(:last-child)', 
			// 		 }
			// 	},
			// 	{
			// 		extend: 'pdf',
			// 		text: '<i class="fa fa-file-pdf-o"> </i>',
			// 		className: 'btn btn-info mr btn-xs',
			// 		 exportOptions: {
			// 			columns: 'th:not(:first-child),th:not(:last-child)',
			// 		}
			// 	},
			// ],
			"columns": [
                {"className":'no_dwnld details-control invoiceid', "data": "invoice_id"},
				{'className': 'no_dwnld'},
                { "className":"invoice_code", "data": "invoice_code" },
                { "className":"vendor_name", "data": "vendor_name" },
                { "data": "sales_code" },
                { "data": "salesman" },
                { "data": "CREATED_BY" },
                { "data": "LAST_UPDATE_DATE" },
				{ "data": "LAST_UPDATED_BY" },
				
			],
			"columnDefs": [ {
            "targets": 1,
            "data": null,
			"render":function(a,b,data,d){
					return '<a class="fa fa-file-pdf-o" href="<?php echo base_url();?>/admin/Invoice/packedlist_pdf/'+data.invoice_id+'" target="_blank"></a>'
					+'&nbsp;&nbsp;&nbsp;&nbsp;<a class="fa fa-edit" href="<?php echo base_url();?>/admin/security_admin/manage_securityadmin/'+data.invoice_id+'/4/admin"></a>'

			} 
			}],
			//"lengthMenu": [[10, 25, 50, 10000], [10, 25, 50, 10000]],
			"ajax": $.fn.dataTable.pipeline( {
				url: '<?php echo base_url(); ?>admin/Invoice/getInvoiceApi/INVOICED',
				//pages: 1 // number of pages to cache
			} ),
		} );

		$('#invoice_table tbody').on('click', 'td.details-control', function () {
			var tr = $(this).closest('tr');
			var row = invoicetable.row( tr );
			if ( row.child.isShown() ) {
				row.child.hide();
				tr.removeClass('shown');
			}else {
				row.child( format(row.data()) ).show();
				tr.addClass('shown');
			}
		}) ;

		$(document).on("click",".reject_invoice",function(){
			var invoice_id=$(this).data('invoice_id')
			var invoice_code=$(this).data('code')
			$("#invoice_code_modal").val(invoice_code);
			$("#invoice_id_modal").val(invoice_id);
		})


		function format ( d ) {
			// `d` is the original data object for the row
			var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
				$.ajax( {
				url: encodeURI("<?php echo base_url(); ?>admin/Invoice/getInvoiceSummary/"+d.invoice_id),
				type:"GET",
				dataType: 'json',
				async: false,
				success: function ( data ) {
					if(data.rows==null){
						childtable+='<tr><td>No Records Found</td></tr>';
					}else{
                        childtable+= '<th>SKU</th><th>Category</th><th>Product Name</th><th>Grade</th><th>Quantity</th>';
						$.each(data.rows, function (i, d) { // loop through data returned from ajax 
						childtable+='<tr>'+
							'<td>'+data.rows[i].nhmod+'-'+data.rows[i].ram+'-'+data.rows[i].rom+'-'+data.rows[i].color_code+'</td>'+
							'<td>'+data.rows[i].category+'</td>'+
							'<td>'+data.rows[i].product_name+'</td>'+
                            '<td>'+data.rows[i].grade+'</td>'+
                            '<td>'+data.rows[i].quantity+'</td>'+
							'</tr>';
 						});
					}
				}
			} );
				
			childtable+='</table>';
			return childtable
		}

		$("#reject_modal_btn").on("click",function(){
			return false
			var invoice_id=$("#invoice_id_modal").val();
			var remark=$.trim($("#invoice_remark_modal").val());
			$("#reject_modal_btn").attr("disabled", true);
			if(parseInt(invoice_id)>0){
				var rejectinvoice=$.ajax({
					type: 'POST',
					url: "<?php echo base_url();?>admin/invoice/RejectInvoice",
					data: {"invoice_id":invoice_id, "remark":remark},
					dataType: "json",
					success: function(resultData) { 
						if(resultData.status==1){
							alert("success: Invoice Rejected");
						}else{
							alert("Error: Failed to Reject Invoice");
							$("#reject_modal_btn").attr("disabled", false);
						}
					}
				})
				rejectinvoice.error(function(resultData) { 
                        $("#reject_modal_btn").attr("disabled", false);
                        alert("Error"+resultData.message); 
                    });
			}
		})


	});

	
</script>