<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 th, td { white-space: nowrap; }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_new">NEW
	</label>
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_inprogress">IN PROGRESS
	</label>
</div>
<p style="line-height:10px;"></p>

<table class="table table-striped DataTables" style="margin-left:5px" id="salesReturnList_table">
	<thead>
		<tr>
			<th></th>
			<th>SALES CHANNEL</th>
			<th>SALES CHANNEL Ref. ID</th>
			<th>INVOICE NO.</th>					
			<th>MODE OF RECEIPT</th>
			<th>DELIVERED BY</th>
			<th>DOCKET NO.</th>
			<th>WAREHOUSE</th>			
			<th>STATUS</th>			
			<th>NO OF<br>PACKAGES</th>
			<th>QUANTITY</th>
			<th>CREATED BY</th>
			<th>LAST<br>UPDATED BY</th>
            <th>UPDATED<br>DATE</th>
            <th></th>
		</tr>
	</thead>		
</table>
							
<script>
    var sr_table;
    
    function getSalesReturnList(status){
		sr_table = $('#salesReturnList_table').DataTable({
						"paging":true,
						"destroy":true,
						"searching":true,
						"processing": true,
						"serverSide": false,  
						"scrollY": 380,
						"scrollX":true,
						"scrollCollapse": true,
						"aaSorting": [[13, 'desc'],[3,'desc']],
						"ajax": {
							"url": "<?php echo base_url(); ?>admin/CreditNotes/getSalesReturnList",
							"type": "GET",
							"data":{'status':status},
							"dataSrc": "data"
						},
						"columns": [
						    {
									"className":      "details-control",
									"orderable":      false,
									"data":           null,
									"defaultContent": ''
							},
							{ "data": "saleschannel" },
							{ "data": "saleschannel_refid" },									
							{ "data": "invoice_no" },
                            { "data": "mode_of_receipt" },
							{ "data": "delivered_by" },
							{ "data": "docket_no" },							
							{ "data": "warehouse" },
							{ "data": "status" },
							{ "data": "no_of_pkg" },
							{ "data": "quantity" },
							{ "data": "CREATED_BY" },
							{ "data": "LAST_UPDATED_BY" },
							{ "data": "last_modified" },
                            {
                                "data": function(data){
                                    if(data.status=='NEW'){
                                        <?php if($type=='admin'){ ?>
                                        return '<a class="btn btn-primary" href="<?=base_url()?>admin/security_admin/updateSalesReturnForm/'+data.salesreturn_id+'">UPDATE</a>'
                                    <?php }else{ ?>
                                        return null;
                                    <?php } ?>
                                    }else{
                                        return null;
                                    }
                                    
                                }
                            }
						]
		});

	} 



function format ( d ) {
	// `d` is the original data object for the row
	var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/CreditNotes/getSalesReturnDetails?salesreturn_id="+d.salesreturn_id),
		type:"GET",
		dataType: 'json',
		async: false,
		success: function ( data ) {
			if(data.result==null){
				childtable+='<tr><td>No Records Found</td></tr>';
			}else{
				childtable += '<th>Inwardid</th><th>Product Name</th><th>Received<br>Product</th><th>Product<br>Condition</th>'
				childtable += '<th>Damage Type</th><th>Dent Type</th><th>Remarks</th>';

				$.each(data.result, function (i, d) { // loop through data returned from ajax 
				childtable+='<tr>'+
					'<td>'+data.result[i].deviceid+'</td>'+
					'<td>'+data.result[i].product_name+'</td>'+
					'<td>'+data.result[i].received_product+'</td>'+
					'<td>'+data.result[i].product_condition+'</td>'+
					'<td>'+data.result[i].damage_type+'</td>'+
					'<td>'+data.result[i].dent_type+'</td>'+
					'<td>'+data.result[i].remarks+'</td>'+
					
					'</tr>';
				});
			}
		}
	} );
		
	childtable+='</table>';
	return childtable
}

    $(document).ready(function(){

        getSalesReturnList('NEW')
        
        $('#button_new').change(function(){
            getSalesReturnList('NEW')
        });

        $('#button_inprogress').change(function(){
            getSalesReturnList('IN_PROGRESS')
        });

		$('#salesReturnList_table tbody').on('click', 'td.details-control', function () {
			var tr = $(this).closest('tr');
			var row = sr_table.row( tr );
			if ( row.child.isShown() ) {
				row.child.hide();
				tr.removeClass('shown');
			}else {
				row.child( format(row.data()) ).show();
				tr.addClass('shown');
			}
		}) ;
    })
 
</script>
	 
