<style>
    td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
    }

    tr {
        height: 30px;
    }

    #stocktransferInvoiceList_table {
        all: unset;
    }

    .modal-backdrop {
        z-index: 0 !important;
    }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
    <label class="btn btn-primary active">
        <input type="radio" name="options" id="invoice_button_new">NEW
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="invoice_button_pending">PENDING
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="invoice_button_approved">APPROVED
    </label>
</div>
<p style="line-height:10px;"></p>

<div class="table-responsive" style="overflow-x: auto;">
    <table class="table table-striped DataTables " id="purchaseInvoiceTable" style="width:100%;">
        <thead>
            <tr>
                <th></th>
                <th>Invoice No</th>
                <th>Vendor Name</th>
                <th>Invoice Date</th>
                <th>No of Packages</th>
                <th>Qty</th>
                <th>Invoice Amount<br>(Excl TCS)</th>
                <th>Exempt Amount</th>
                <th>Taxable Amount</th>
                <th>Tax Amount</th>
                <th>TCS Amount</th>
                <th>Net Amount</th>
                <th>Short Devices</th>
                <th>Extra Devices</th>
                <th>Logistic Provider</th>
                <th>Docket Number</th>
                <th>Entrypass No</th>

            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<!-- Create a modal with Invoice NO, Date, Taxable amount, exempt amount, tax amount and tcs in a table -->
<div class="modal fade" id="invoiceDetailsModal" data-backdrop="false" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel">Invoice Details</h4>
            </div>
            <div class="modal-body">
                <table class="table table-striped">
                    <tr>
                        <th>Invoice No</th>
                        <td id="modal_invoice_no"></td>
                    </tr>
                    <tr>
                        <th>Invoice Date</th>
                        <td id="modal_invoice_date"></td>
                    </tr>
                    <tr>
                        <th>Taxable Amount</th>
                        <td id="modal_taxable_amount"></td>
                    </tr>
                    <tr>
                        <th>Exempt Amount</th>
                        <td id="modal_exempt_amount"></td>
                    </tr>
                    <tr>
                        <th>Tax Amount</th>
                        <td id="modal_tax_amount"></td>
                    </tr>
                    <tr>
                        <th>TCS Amount</th>
                        <td id="modal_tcs_amount"></td>
                    </tr>
                    <tr>
                        <th>Net Amount</th>
                        <td id="modal_net_amount"></td>
                    </tr>
                </table>
            </div>
            <div class="modal-footer" style="text-align: center;">
            <input type="hidden" id="modal_admin_id" value="">
                <button type="button" class="btn btn-success" id="modal_approve_btn" onclick="approveInvoice()">Approve</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    var department_id  = <?=$this->session->userdata('department_id')?>;
    $(document).ready(function() {

        getPurchaseInvoiceList('NEW')

        function getPurchaseInvoiceList(status) {
            st_invoice_table = $('#purchaseInvoiceTable').DataTable({
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "scrollY": 380,
                "scrollX": '100%',
                "scrollCollapse": false,
                "autoWidth": false,

                "aaSorting": [],
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/Security_admin/getPurchaseInvoiceList?status=" + status,
                    "type": "GET",
                    "dataSrc": "data",
                    "async": false,
                },
                "columns": [{
                        "render": function(a, b, data, d) {
                            let row = ''
                            row += '<span style="display:inline-flex">'
                            if (data.status == 'NEW' && department_id == '13') {
                                row += '<a href="<?php echo base_url(); ?>admin/Security_admin/manage_securityadmin/' + data.admin_id + '" class="fa fa-edit"></a>'
                            }
                            if (data.status == 'PENDING' && department_id == '6') {
                                row += '<a href="<?php echo base_url(); ?>admin/Security_admin/manage_securityadmin/' + data.admin_id + '" class="fa fa-edit"></a>'
                                row += '&nbsp;&nbsp;<a onclick="openApprovalModal(this)" class="fa fa-check" style="color:green"></a>'
                            }
                            row += '</span>'
                            return row

                        }
                    },
                    {
                        "data": "invoice_no"
                    },
                    {
                        "data": "vendor_name"
                    },
                    {
                        "data": "invoice_date"
                    },
                    {
                        "data": "no_package"
                    },
                    {
                        "data": "invoice_qty"
                    },
                    {
                        "data": "invoice_value"
                    },
                    {
                        "data": "exempt_value"
                    },
                    {
                        "data": "taxable_value"
                    },
                    {
                        "data": "tax_amount"
                    },
                    {
                        "data": "tcs"
                    },
                    {
                        "data": "net_amount"
                    },
                    {
                        "data": "short_devices"
                    },
                    {
                        "data": "extra_devices"
                    },
                    {
                        "data": "logistics_provider"
                    },
                    {
                        "data": "docket_no"
                    }
                    ,
                    {
                        "data": "entrypass_no"
                    }
                ]
            });
        }

        $('#invoice_button_new').change(function() {
            getPurchaseInvoiceList('NEW')
        });

        $('#invoice_button_pending').change(function() {
            getPurchaseInvoiceList('PENDING')
        });

        $('#invoice_button_approved').change(function() {
            getPurchaseInvoiceList('APPROVED')
        });

    })

    function openApprovalModal(d) {
        let data = st_invoice_table.row($(d).parents('tr')).data()

        $("#modal_admin_id").val(data.admin_id)
        $('#modal_invoice_no').text(data.invoice_no)
        $('#modal_invoice_date').text(data.invoice_date)
        $('#modal_taxable_amount').text(data.taxable_value)
        $('#modal_exempt_amount').text(data.exempt_value)
        $('#modal_tax_amount').text(data.tax_amount)
        $('#modal_tcs_amount').text(data.tcs)
        $('#modal_net_amount').text(data.net_amount)
        $('#invoiceDetailsModal').modal('show')
        $("#modal_approve_btn").attr('disabled', false)

    }

    function approveInvoice() {
        let admin_id = $("#modal_admin_id").val()
	$("#modal_approve_btn").attr('disabled', true)
        $.ajax({
            url: "<?php echo base_url(); ?>admin/Security_admin/approveInvoice",
            type: "POST",
            data: {
                admin_id: admin_id
            },
            dataType: "JSON",
            success: function(response) {
                if (response.status == 1) {
                    $('#invoiceDetailsModal').modal('hide')
                    $('#invoice_button_approved').trigger('click')
                    toastr.success(response.msg)
                }else{
                    $('#invoiceDetailsModal').modal('hide')
                    toastr.error(response.msg)
                    $("#modal_approve_btn").attr('disabled', false)
                }
            },
            error: function(response) {
                toastr.error(response)
                $("#modal_approve_btn").attr('disabled', false)
                return false
            }
        })
    }
</script>