<?php echo message_box('success'); ?>
<?php echo message_box('error'); ?>
<?php echo message_box('warning'); ?>

<style>
	table {
		display: block;
		overflow-x: auto;
		white-space: nowrap;
	}

	.items-list-expand {
		background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
		cursor: pointer;
	}

	td.items-list-shown {
		background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center !important;
	}
</style>

<form method="post" data-parsley-validate="" novalidate="" enctype="multipart/form-data" class="form-horizontal">
	<input type="hidden" id="salesreturn_id" name="salesreturn_id" value="<?= $salesreturn_id ?>">
	<input type="hidden" id="invoice_id" name="invoice_id" value="">
	<div class="col-md-12 col-sm-12 col-xs-12" style="padding:0px">
		<div class="col-md-6">

		</div>
		<div class="col-md-6"></div>

		<div class="col-md-6  col-sm-6 col-xs-6" style="padding:0px">
			<div class="form-group">
				<label class="col-lg-3 control-label">SALES CHANNEL<span class="text-danger">*</span></label>
				<div class="col-lg-9">
					<div class=" ">
						<select id="sales_channel_id" class="form-control" onchange="getReturnRows()" style="width:100%" name="sales_channel">
							<option value="">SELECT SALES CHANNEL</option>
						</select>
					</div>
				</div>
			</div>
			<div class="form-group">
				<label class="col-lg-3 control-label">SALES CHANNEL REF.ID<span class="text-danger">*</span>
				</label>
				<div class="col-lg-9">
					<div class=" ">
						<input type="text" name="saleschannel_refno" id="saleschannel_ref_id" onchange="getReturnRows()" value="" class="form-control" placeholder="sales channel ref no." readonly />
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="col-lg-3 control-label">INVOICE NO.<span class="text-danger">*</span>
				</label>
				<div class="col-lg-9">
					<div class=" ">
						<input type="text" name="invoice_no" value="" onchange="getReturnRows()" class="form-control" id="invoice_no" placeholder="invoice no" readonly />
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="col-lg-3 control-label">DOCKET NO.<span class="text-danger">*</span>
				</label>
				<div class="col-lg-9">
					<div class=" ">
						<input type="text" name="docket_no" id="docket_no" value="" class="form-control" placeholder="DOCKET NO." />
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="col-lg-3 control-label">MODE OF RECEIPT<span class="text-danger">*</span>
				</label>
				<div class="col-lg-9">
					<div class=" ">
						<select id="mode_of_receipt_id" class="form-control" style="width:100%" name="mode_of_receipt">
							<option value=""><?= lang('none') ?></option>
						</select>
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="col-lg-3 control-label">DELIVERED BY<span class="text-danger">*</span>
				</label>
				<div class="col-lg-9">
					<div class=" ">
						<input type="text" style="width:100%" name="delivered_by" id="delivered_by" value="" class="form-control" placeholder="DELIVERED BY" />
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="col-lg-3 control-label">WAREHOUSE<span class="text-danger">*</span>
				</label>
				<div class="col-lg-9">
					<div class=" ">
						<select onkeypress="return isNumberKey(event)" type="text" name="quantity" id="warehouse" value="" class="form-control" placeholder="WAREHOUSE">
							<option value=""></option>
						</select>
					</div>
				</div>
			</div>
			<div class="form-group">
				<label class="col-lg-3 control-label">AUTO CLAIMED</label>
				<div class="col-lg-9">
					<input type="text" id="update_auto_claim" class="form-control" readonly>
				</div>
			</div>

			<div class="form-group">
				<label class="col-lg-3 control-label">Claim Required?</label>
				<div class="col-lg-9">
					<div class="radio-inline ">
						<label class="radio-inline">
							<input type="radio" name="claim_required" id="claim_required_yes" value="YES">YES
						</label>
						<label class="radio-inline">
							<input type="radio" name="claim_required" id="claim_required_no" value="NO">NO
						</label>
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="col-lg-3 control-label">RETURN TYPE</label>
				<div class="col-lg-9">
					<div class=" ">
						<select onkeypress="return isNumberKey(event)" type="text" name="return_type" id="return_type" value="" class="form-control" placeholder="WAREHOUSE">
							<option value=""></option>
							<option value="Courier Return">Courier Return</option>
							<option value="Customer Return">Customer Return</option>
						</select>
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="col-lg-3 control-label">Reason For Return</label>
				<div class="col-lg-9">
					<div class=" ">
						<input type="text" id="update_return_reason" class="form-control" style="width: 100%;" readonly>
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="col-lg-3 control-label">Requested Date</label>
				<div class="col-lg-9">
					<div class=" ">
						<input type="date" class="form-control" style="width: 100%;" id="requested_date" value="<?php echo date("Y-m-d");  ?>" max="<?php echo date("Y-m-d");  ?>" readonly>
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="col-lg-3 control-label">Return Date</label>
				<div class="col-lg-9">
					<div class=" ">
						<input type="date" class="form-control" style="width: 100%;" id="returned_date" value="<?php echo date("Y-m-d");  ?>" max="<?php echo date("Y-m-d");  ?>">
					</div>
				</div>
			</div>
			<div class="form-group">
				<label class="col-lg-3 control-label">QUANTITY<span class="text-danger">*</span>
				</label>
				<div class="col-lg-9">
					<div class=" ">
						<input onkeypress="return isNumberKey(event)" type="text" name="quantity" id="quantity" value="" class="form-control" placeholder="QUANTITY" />
					</div>
				</div>
			</div>

			<div class="form-group">
				<label class="col-lg-3 control-label">PKG.NO.<span class="text-danger">*</span>
				</label>
				<div class="col-lg-9">
					<div class=" ">
						<input onkeypress="return isNumberKey(event)" type="text" name="package_no" id="package_no" value="" class="form-control" placeholder="NO OF PACKAGES" />
					</div>
				</div>
			</div>
		</div>

	</div>

	<div >
		<table class="table">
			<tr>
				<td class="items-list-expand" style="margin: 10px;height:30px; min-width:30px" onclick="showDeviceDetails(this)">.</td>
				<td>Device List</td>
			</tr>
		</table>
		<table id="device-list-table" class="table table-bordered" style="display: block;">
		</table>
	</div>
	<hr style="border: 1px solid grey" />
	<div class="col-md-12" style="margin-bottom:30px;">
		<label class="col-lg-3 control-label">Device Id</label>
		<div class="col-md-4"><input type="text" placeholder="device id" id="scan_device_id" style="width:300px" class="form-control" /></div>
		<div class="col-md-3"><button type="button" style="text-align: left;" class="btn btn-green" onclick="addRows()">Add</button>
		</div>
	</div>
	<hr style="border: 1px solid grey" />
	<table id="device_table" class="table table-bordered table-responsive table-stripped" style="width:90%;">
		<thead>
			<tr>
				<th>CATEGORY</th>
				<th>DEVICE ID</th>
				<th>DEVICE NAME</th>
				<th>SKU</th>
				<th>GRADE</th>
				<th>PRODUCT<br>CONDITION</th>
				<th>RECEIVED PRODUCT</th>
				<th>DAMAGE TYPE</th>
				<th>DENT TYPE</th>
				<th>REMARKS</th>
			</tr>
		</thead>
	</table>
	<div class="form-group">
		<label class="col-lg-3 control-label"></label>
		<div class="col-lg-6">
			<button type="button" id="submit" onclick="updateSalesReturn()" class="btn btn-sm btn-primary"></i>UPDATE</button>
			<button type="button" id="danger" class="btn btn-sm btn-primary" onclick=""></i>Cancel</button>
		</div>
	</div>
</form>

<script>
	$("#cancel").on("click", function() {
		window.location.replace("<?= base_url() ?>admin/CreditNotes/manage_salesreturn");
	})

	var salesreturn_id = $("#salesreturn_id").val();
	var condition_str_opt = getType('çondition');
	var damage_str_opt = getType('damage');
	var dent_str_opt = getType('dents');
	var return_items = [];
	var added_devices = [];

	function checkNull(entity, message) {
		if (entity == '0' || entity == '0' || entity == 0 || entity == '' || entity == null) {
			return message;
		}
		return '';
	}

	function getType(type) {
		var opt = '';
		$.ajax({
			type: "GET",
			url: "<?= base_url() ?>admin/DropDownItems/getItems",
			data: {
				'type': type
			},
			dataType: "json",
			async: false,
			success: function(data) {
				$.each(data, function(i, v) {
					opt += '<option value="' + data[i].name + '">' + data[i].name + '</option>'
				})
			},
			error: function(error) {
				alert(error.responseJSON.message);
			}

		});
		return opt;
	}

	function getReturnRows() {
		var invoice_no = $("#invoice_no").val();
		$("#device_table").find("tr:gt(0)").remove();
		$("#invoice_id").val('');
		var url = ''

		if (invoice_no == '0' || invoice_no == '' || invoice_no == 'undefined') {
			getInvoiceCode();
			invoice_no = $("#invoice_no").val();
		}

		url = "<?= base_url() ?>admin/CreditNotes/getDeviceInfoByInvoice?invoice_code=" + invoice_no;

		$.ajax({
			url: url,
			type: "GET",
			dataType: "json",
			success: function(data) {
				if (data.status == 1) {
					$("#invoice_id").val(data.invoice);
					return_items = data.rows;



				} else {
					toastr.error("Failed to get Return item Details")
					return false
				}
			},
			error: function(error) {
				toastr.error("Failed to get Return item Details")
				return false
			}
		})
	}

	function addRows() {

		let device_id = $("#scan_device_id").val()
		let isItemFound = false;

		for(let j = 0; j<added_devices.length; j++){
			if(added_devices[j] === device_id.toUpperCase()){
				toastr.error("Already Added")
				return false
			}
		}

		$.each(return_items, function(i, v) {

			if (v.status != 'SOLD') {
				return true
			}

			if (device_id.toUpperCase() !== return_items[i].deviceid.toUpperCase()) return true

			var row = '<tr class="device_tr">'
			row += '<td>' + return_items[i].stock_type + '</td>'
			row += '<td class="td_deviceid">' + return_items[i].deviceid + '</td>'
			row += '<td>' + return_items[i].device_name + '</td>'
			row += '<td>' + return_items[i].sku + '</td>'
			row += '<td>' + return_items[i].grade + '</td>'

			row += '<td><select class="form-control product_cond" style="width:150px;">'
			row += '<option value="">NONE</option>'
			row += condition_str_opt
			row += '</select></td>'

			row += '<td><input type="text" class="received_product"></td>'

			row += '<td><select class="damage_type form-control" style="width:150px;">'
			row += '<option value="">NONE</option>'
			row += damage_str_opt
			row += '</select></td>'

			row += '<td><select class="dent_type form-control" style="width:150px;">'
			row += '<option value="">NONE</option>'
			row += dent_str_opt
			row += '</select></td>'

			row += '<td><textarea class="remarks"></textarea></td>'
			row += '<td onclick="delete_row(this)" class="bg-secondary delete"><img src="<?php echo base_url(); ?>assets/img/delete.png">'
			row += '<input type="hidden" class="invoice_item_id" value="' + return_items[i].invoice_item_id + '"></td>'

			row += '</tr>'
			$("#device_table").append(row)

			// Add to Added List
			added_devices.push(return_items[i].deviceid.toUpperCase())

			//break the loop
			$("#scan_device_id").val('')
			isItemFound = true;
			return false
		})

		if (!isItemFound) {
			toastr.error("Invalid Device Id / Not belong to this invoice")
			return false
		}
	}

	function getInvoiceCode() {
		var sales_channel = $("#sales_channel_id").val();
		var saleschannel_ref_id = $("#saleschannel_ref_id").val();

		$.ajax({
			url: "<?= base_url() ?>admin/CreditNotes/getInvoiceCode?sales_channel=" + sales_channel + "&saleschannel_ref_id=" + saleschannel_ref_id,
			type: "GET",
			dataType: "json",
			async: false,
			success: function(data) {
				if (data.invoice_code != null || data.invoice_code != '') {
					$("#invoice_no").val(data.invoice_code)
				}
			},
			error: function(error) {
				console.log("failed to get invoice_code")
			}
		})
	}

	function delete_row(btn) {
		var yes = confirm("Do you want to delete the record?")
		if (yes) {
			$(btn).closest("tr").remove();
			let device_id = $(btn).closest("tr").find("td_deviceid").text()
			let index = added_devices.indexOf(device_id.toUpperCase())
			if(index>=0){
				added_devices.splice(index,1)
			}
		}
	}

	function showDeviceDetails(d){
		if($(d).hasClass('items-list-shown')){
			
			$(d).removeClass('items-list-shown')
			$(d).addClass('items-list-expand')
			$("#device-list-table").css("display","none")
		}else{
			$(d).addClass('items-list-shown')
			$(d).removeClass('items-list-expand')
			$("#device-list-table").css("display","block")
		}
		addDeviceItems()
	}

	function addDeviceItems(){
		$("#device-list-table").html('')
		let childtable = ''
		if(return_items.length === 0){
				childtable+='<tr><td>No Records Found</td></tr>';
		}else{
			childtable += '<tr><th>Inwardid</th><th>Product Name</th><th>SKU</th></tr>'
			$.each(return_items, function (i, d) { // loop through data returned from ajax 
				childtable += '<tr>'+
					'<td>' +return_items[i].deviceid+'</td>'+
					'<td>' +return_items[i].device_name+'</td>'+
					'<td>' +return_items[i].sku+ '</td>'+
					
					'</tr>';
			});
			console.log(childtable)

		}
		console.log(childtable)

		$("#device-list-table").append(childtable)
	}

	function updateSalesReturn() {

		var sales_channel = $("#sales_channel_id").val();
		var saleschannel_ref_id = $("#saleschannel_ref_id").val();
		var invoice_no = $("#invoice_no").val();
		var docket_no = $("#docket_no").val();
		var mode_of_receipt = $("#mode_of_receipt_id").val();
		var delivered_by = $("#delivered_by").val();
		var quantity = $("#quantity").val();
		var package_no = $("#package_no").val();
		var warehouse = $("#warehouse").val();
		var invoice_id = $("#invoice_id").val();
		var return_type = $("#return_type").val();
		var returned_date = $("#returned_date").val();
		var auto_claim = $("#update_auto_claim").val();
		var claim_required = $('input[name="claim_required"]:checked').val()
		var return_reason = $("#update_return_reason").val()

		var data = [];
		var devices = [];
		var fields_required = ''

		fields_required += checkNull(warehouse, 'Warehouse ')
		fields_required += checkNull(mode_of_receipt, 'Mode of Receipt, ')
		fields_required += checkNull(return_type, 'Return Type, ')
		fields_required += checkNull(claim_required, 'Claim Required ')

		if (fields_required != '') {
			alert("Fields Required: " + fields_required)
			return false
		}


		$("#submit").attr("disabled", true)

		$("tr.device_tr").each(function() {

			var td_deviceid = $(this).find(".td_deviceid").text();
			var product_cond = $(this).find(".product_cond").val();
			var received_product = $(this).find(".received_product").val();
			var damage_type = $(this).find(".damage_type").val();
			var dent_type = $(this).find(".dent_type").val();
			var remarks = $(this).find(".remarks").val();
			var invoice_item_id = $(this).find(".invoice_item_id").val();

			devices.push({
				"salesreturn_id": salesreturn_id,
				"device_id": td_deviceid,
				"product_condition": product_cond,
				"received_product": received_product,
				"damage_type": damage_type,
				"dent_type": dent_type,
				"remarks": remarks,
				"invoice_item_id": invoice_item_id
			})
		})

		data.push({
			"salesreturn_id": salesreturn_id,
			"sales_channel": sales_channel,
			"saleschannel_ref_id": saleschannel_ref_id,
			"invoice_no": invoice_no,
			"docket_no": docket_no,
			"mode_of_receipt": mode_of_receipt,
			"delivered_by": delivered_by,
			"quantity": quantity,
			"returned_date": returned_date,
			"package_no": package_no,
			"warehouse": warehouse,
			"rows": devices,
			"invoice_id": invoice_id,
			"claim_required": claim_required,
			"return_type": return_type,
			"auto_claim": auto_claim,
			"reason_for_return": return_reason
		})
		var jsonObject = JSON.stringify(data)

		$.ajax({
			url: "<?= base_url() ?>admin/CreditNotes/updateSalesReturn",
			data: jsonObject,
			dataType: "json",
			type: "POST",
			success: function(data) {
				if (data.status == 1) {
					window.location.replace("<?= base_url() ?>admin/CreditNotes/manage_salesreturn");

				} else {
					alert("Error: Failed to UPDATE Sales Return");
					$("#submit").attr("disabled", false)
				}
			},
			error: function() {
				alert("Error: Failed to Create Sales Order");
				$("#submit").attr("disabled", false)
			}
		});
	}


	$(document).ready(function() {

		dropdown('sales_channel', 'sales_channel_id');
		dropdown('mode_of_receipt', 'mode_of_receipt_id');

		function dropdown(type, select_id) {
			$.ajax({
				type: "GET",
				url: "<?= base_url() ?>admin/DropDownItems/getItems?type=" + type,
				data: {},
				dataType: "json",
				async: false,
				success: function(data) {

					$.each(data, function(i, v) {
						$("#" + select_id).append('<option value="' + data[i].name + '">' + data[i].name + '</option>')
					})

				},
				error: function(error) {
					alert(error.responseJSON.message);
				}
			});
		}

		$.ajax({
			url: "<?php echo base_url(); ?>web_api/getWareHouse",
			type: "GET",
			dataType: 'json',
			async: false,
			success: function(data) {

				$.each(data.result, function(index, value) {
					var a = "<option value=\"" + data.result[index].short_code + "\">" + data.result[index].warehouse + '-' + data.result[index].short_code + "</option>"
					$("#warehouse").append(a);
				})
			},
			error: function(errorThrown, textStatus, jqXHR) {
				alert("Error: " + jqXHR + " " + data.message);
			}
		});

		$.ajax({
			url: "<?= base_url() ?>admin/CreditNotes/getSalesReturnHeader/" + salesreturn_id,
			type: "GET",
			dataType: "json",
			success: function(data) {
				if (data.return_status == 'PENDING' || data.return_status == 'IN_TRANSIT') {

					$("#submit").attr("disabled", false)

					$("#sales_channel_id").val(data.saleschannel);
					$("#saleschannel_ref_id").val(data.saleschannel_refid);
					$("#invoice_no").val(data.invoice_no);
					$("#docket_no").val(data.docket_no);
					$("#mode_of_receipt_id").val(data.mode_of_receipt);
					$("#delivered_by").val(data.delivered_by);
					$("#quantity").val(data.quantity);
					$("#package_no").val(data.no_of_pkg);
					$("#warehouse").val(data.warehouse);
					$("#return_type").val(data.return_type);
					$("#update_auto_claim").val(data.auto_claim);
					$("#requested_date").val(data.request_date);
					$("#update_return_reason").val(data.reason_for_return);

					if (data.claim_required == 'YES') {
						$("#claim_required_yes").prop("checked", true)
					}

					if (data.claim_required == 'NO') {
						$("#claim_required_no").prop("checked", true)
					}

					getReturnRows();
				} else {
					$("#submit").attr("disabled", true)
				}
			},
			error: function() {

			}
		})

	});
</script>