<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 th, td { white-space: nowrap; }
	 
	 .salesreturn_id{
		 font-size:0 ;
	 }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_intransit">IN TRANSIT
	</label>

	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_pending">PENDING
	</label>
	
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_whpending">WH PENDING
	</label>

	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_financepending">FINANCE PENDING
	</label>

	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_cncreate">CN CREATED
	</label>
	
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_cancel">CANCEL
	</label>

	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_void">VOID
	</label>

	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_lost_in_transit">LOST IN TRANSIT
	</label>
	<label class="btn"></label>
	
	<label class="btn btn-info">
	  <input type="radio" name="options" id="button_claim_required">CLAIM REQUIRED
	</label>
</div>
<p style="line-height:10px;"></p>

<table class="table table-striped DataTables" style="margin-left:5px" id="salesReturnList_table">
	<thead>
		<tr>
			<th></th>
			<th></th>
			<th></th>
			<th>SALESRETURN NO</th>
			<th>CREDITNOTE NO</th>
			<th>SALES CHANNEL</th>
			<th>SALES CHANNEL<br> Ref. ID</th>
			<th>VENDOR NAME.</th>	
			<th>INVOICE NO.</th>	
			<th>RETURN TYPE</th>	
			<th>CLAIM<br>REQUIRED</th>
			<th>CLAIM NO</th>
			<th>AUTO<br>CLAIM</th>
			<th>MODE OF RECEIPT</th>
			<th>DELIVERED BY</th>
			<th>DOCKET NO.</th>
			<th>WAREHOUSE</th>			
			<th>NO OF<br>PACKAGES</th>
			<th>RETURN<br>QUANTITY</th>
			<th>INVOICE<br>QUANTITY</th>
			<th>REASON FOR RETURN</th>
			<th>RETURN DATE</th>
			<th>REQUEST DATE</th>
			<th>CREATED BY</th>
			<th>LAST<br>UPDATED BY</th>
            <th>UPDATED<br>DATE</th>
		</tr>
	</thead>		
</table>

<div class="modal fade" id="claimrequired_modalReject" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
  aria-hidden="true" data-backdrop="false">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header text-center">
        <button type="button" class="close" onclick="closeModal()" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
	  </div>
	  <input type="hidden" id="claimrequired_sr_id_modal">
      <div class="modal-body mx-3">
	  <div class="form-group">
            <label class="col-lg-3 control-label">SALESORDER ID</label>
            <div class="col-lg-9">
                <span class="form-control" id="claimrequired_sr_no_modal"></span>
            </div> 
		</div><br>
		<div class="form-group">
            <label class="col-lg-3 control-label">Claim Required</label>
            <div class="col-lg-9">
                <select class="form-control" id="claimrequired_select_modal">
					 <option value="">SELECT</option>
					 <option value="YES">YES</option>
					 <option value="NO">NO</option>
				</select>
            </div> 
        </div>
	  <br>
	  <div class="form-group">
            <label class="col-lg-3 control-label">REMARKS</label>
            <div class="col-lg-9">
                <textarea class="form-control" id="claimrequired_remarks_modal"></textarea>
            </div> 
        </div>
      </div><br>
      <div class="modal-footer d-flex justify-content-center">
        <button class="btn btn-success" id="claimrequired_submit_modal" onclick="claimrequiredSubmit()" CausesValidation="False">Submit</button>
        <button class="btn btn-danger" id="claimrequired_close_modal" onclick="closeModal()" CausesValidation="False">Close</button>
      </div>
    </div>
  </div>
</div>


<!-- Cancel Modal -->

<div class="modal fade" id="modalCancelSR" tabindex="-1" role="dialog" aria-labelledby="myModalCancelSRLabel"
  aria-hidden="true" data-backdrop="false">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header text-center">
        <button type="button" class="close" onclick="closeCancelSRModal()" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
	  </div>
	  <input type="hidden" id="cancel_sr_id_modal">
	  <br>
      <!--<div class="modal-body mx-3">-->
	  <div class="form-group">
            <label class="col-lg-3 control-label">SALES RETURN NO</label>
            <div class="col-lg-9">
                <span class="form-control" id="cancel_sr_no_modal"></span>
            </div> 
		</div>
	  <!--</div>-->
	  <br>
	  <div class="form-group">
            <label class="col-lg-3 control-label">SELECT FILE</label>
            <div class="col-lg-9 file-upload-wrapper">
                <input type="file" class="form-control file-upload" id="cancel_sr_fileupload_modal" >
            </div> 
		</div><br>
		<div class="form-group">
            <label class="col-lg-3 control-label">REMARKS</label>
            <div class="col-lg-9">
                <textarea class="form-control" id="cancel_sr_remarks_modal"></textarea>
            </div> 
        </div>
      <div class="modal-footer d-flex justify-content-center">
		<br>
        <button class="btn btn-primary" id="fileupload_submit" onclick="cancelSR_submit()" CausesValidation="False">CANCEL</button>
        <button class="btn btn-danger" id="fileupload_modal_close" onclick="closeCancelSRModal()" CausesValidation="False">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Void Modal -->

<div class="modal fade" id="modalVoidSR" tabindex="-1" role="dialog" aria-labelledby="myModalVoidSRLabel"
  aria-hidden="true" data-backdrop="false">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header text-center">
        <button type="button" class="close" onclick="closeVoidSRModal()" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
	  </div>
	  <input type="hidden" id="void_sr_id_modal">
      <div class="modal-body mx-3">
	  <div class="form-group">
            <label class="col-lg-3 control-label">SALS RETURN ID</label>
            <div class="col-lg-9">
                <span class="form-control" id="void_sr_no_modal"></span>
            </div> 
		</div>
	  </div><br>
		<div class="form-group">
            <label class="col-lg-3 control-label">REMARKS</label>
            <div class="col-lg-9">
                <textarea class="form-control" id="void_sr_remarks_modal"></textarea>
            </div> 
		</div><br>
		<div class="form-group">
            <div id="void_sr_file_list">
            </div> 
        </div>
      <div class="modal-footer d-flex justify-content-center">
        <button class="btn btn-primary" id="void_submit" onclick="voidSR_submit()" CausesValidation="False">VOID</button>
        <button class="btn btn-danger" id="void_modal_close" onclick="closeVoidSRModal()" CausesValidation="False">Close</button>
      </div>
    </div>
  </div>
</div>
							
<script>
    var sr_table;

	var department_id = getUserdata('department_id')
	var designations_id = getUserdata('designations_id')

	function getUserdata(attribute){
		
		var a='';
		$.ajax({
			"url": "<?=base_url()?>Web_api/getUserData/"+attribute,
			"type": "GET",
			"dataType": "json",
			"async": false,
			"success": function(data){
				a = data.result;
			}
		})
		return a;
	}
    
    function getSalesReturnList(status){
		sr_table = $('#salesReturnList_table').DataTable({
						"paging":true,
						"destroy":true,
						"searching":true,
						"processing": true,
						"serverSide": false,  
						"scrollY": 380,
						"scrollX":true,
						"scrollCollapse": true,
						"aaSorting": [0,'desc'],
						"ajax": {
							"url": "<?php echo base_url(); ?>admin/CreditNotes/getSalesReturnList",
							"type": "GET",
							"data":{'status':status},
							"dataSrc": "data"
						},
						"columns": [
						    {
									"className":      "details-control salesreturn_id",
									"orderable":      false,
									"data":           "salesreturn_id",
									"defaultContent": ''
							},
							{},
							{
								"data": function(data){
									if(data.status == 'CN_CREATED'){
										return '<a class="fa fa-file-pdf-o" href="<?php echo base_url();?>admin/CreditNotes/open_CNpdf?salesreturn_id='+data.salesreturn_id+'" target="_blank"></a><br>'
									}else{
										return null
									}
								}
							},
							{ "data": "salesreturn_code", "className": "salesreturn_no"},
							{ "data": "creditnote_code"},
							{ "data": "saleschannel" },
							{ "data": "saleschannel_refid" },									
							{ "data": "vendor_name" },									
							{ "data": "invoice_no" },
							{ "data": "return_type" },
							{ "data": "claim_required", "className": "claim_required"},
							{ "data": "claim_no" },
							{ "data": "auto_claim" },
                            { "data": "mode_of_receipt" },
							{ "data": "delivered_by" },
							{ "data": "docket_no" },				
							{ "data": "warehouse" },
							{ "data": "no_of_pkg" },
							{ "data": "quantity" },
							{ "data": "invoice_qty" },
							{ "data": "reason_for_return"},
							{ "data": "returned_date"},
							{ "data": "request_date"},
							{ "data": "CREATED_BY" },
							{ "data": "LAST_UPDATED_BY"},
							{ "data": "last_modified" },
						],

						"columnDefs": [ {
							"targets": 1,
							"data": null,
							"render": function (data){
									
									if(data.status=='PENDING' || data.status == 'IN_TRANSIT'){
                                       
										if(designations_id=='46'){ 
										
											var a = '<a href="<?=base_url()?>admin/CreditNotes/updateSalesReturnForm/'+data.salesreturn_id+'">'
                                            	a += '<img src="<?=base_url()?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'
												a += '</a>'
											
											return a
										}else if(department_id == '8'){

											var cancel = '<img onclick="openCancelSRModal(this)" src="<?=base_url()?>assets/img/cancel.png" alt="Cancel" title="Cancel">'
											return cancel;
										}else{ 
										
											return null;
										
										}

                                    }else if(data.status=='WH_PENDING'){

										if(department_id =='5'){
                                        	
											var a = '<a href="<?=base_url()?>admin/CreditNotes/updateWHSalesReturnForm/'+data.salesreturn_id+'">'
                                            	a += '<img src="<?=base_url()?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'
												a += '</a>'
											return a
										
										}else{
											
											return null
										}

                                    }else if(data.status=='FINANCE_PENDING'){

										if(department_id == '6'){ 
                                        	
											var a = '<a href="<?=base_url()?>admin/CreditNotes/createCreditNotesForm/'+data.salesreturn_id+'">'
												a += '<img src="<?=base_url()?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'
												a += '</a>'

											return a

										}else{
											
											return null
										
										}

									}else if(data.status == 'CN_CREATED' || data.status == 'LOST_IN_TRANSIT'){
										
										 if($.inArray(parseInt(department_id), [8, 25]) != -1) {

											if(data.claim_required == 'YES'){
												
												var a= '<a href="<?=base_url()?>admin/Claims/newClaimForm/'+data.salesreturn_id+'">'
													a += '<img src="<?=base_url()?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'
													a += '</a>'

											return a
											
											}else{

												return null


											}
										}else if(department_id == '10'){

											if(data.claim_required == 'NO'){

												var	a = '<img onclick ="openModal(this)" src="<?=base_url()?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'

												return a

											}else{
												return null
											}
											

										}else{
											return null

										}
									}else if(data.status == 'LOST_PENDING'){
										if(department_id == '6'){
											var a = '<a href="<?=base_url()?>admin/CreditNotes/updateLostSalesReturnForm/'+data.salesreturn_id+'">'
												a += '<img src="<?=base_url()?>assets/img/update.png" alt="update" title="Update" width="16px" height="16px">'
												a += '</a>'

											return a
										}
									}else if(data.status == 'CANCEL'){

										if(department_id == '8'){
											var cancel = '<img onclick="openVoidSRModal(this)" src="<?=base_url()?>assets/img/cancel.png" alt="Cancel" title="Cancel">'
											return cancel;
										}else{ 
										
											return null;
										
										}

									}else{
										return null;
									}
                                    
                                }
                            }
						]
		});

	} 



function format ( d ) {
	// `d` is the original data object for the row
	var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/CreditNotes/getSalesReturnDetails?salesreturn_id="+d.salesreturn_id),
		type:"GET",
		dataType: 'json',
		async: false,
		success: function ( data ) {
			if(data.result==null){
				childtable+='<tr><td>No Records Found</td></tr>';
			}else{
				childtable += '<th>Inwardid</th><th>Product Name</th><th>Received<br>Product</th><th>Product<br>Condition</th>'
				childtable += '<th>Damage Type</th><th>Dent Type</th><th>Remarks</th>';

				$.each(data.result, function (i, d) { // loop through data returned from ajax 
				childtable+='<tr>'+
					'<td>'+data.result[i].deviceid+'</td>'+
					'<td>'+data.result[i].product_name+'</td>'+
					'<td>'+data.result[i].received_product+'</td>'+
					'<td>'+data.result[i].product_condition+'</td>'+
					'<td>'+data.result[i].damage_type+'</td>'+
					'<td>'+data.result[i].dent_type+'</td>'+
					'<td>'+data.result[i].remarks+'</td>'+
					
					'</tr>';
				});
			}
		}
	} );
		
	childtable += '</table>';
	childtable += sr_remarks_table(d.salesreturn_id)
	return childtable
}

    $(document).ready(function(){

        getSalesReturnList('IN_TRANSIT')

		
		$('#button_intransit').change(function(){
            getSalesReturnList('IN_TRANSIT')
		});
        
        $('#button_pending').change(function(){
            getSalesReturnList('PENDING')
        });

        $('#button_whpending').change(function(){
            getSalesReturnList('WH_PENDING')
		});

		$('#button_financepending').change(function(){
            getSalesReturnList('FINANCE_PENDING')
        });

		$('#button_cncreate').change(function(){
            getSalesReturnList('CN_CREATED')
		});

		$('#button_cancel').change(function(){
            getSalesReturnList('CANCEL')
		});

		$('#button_void').change(function(){
            getSalesReturnList('VOID')
		});

		$('#button_lost_in_transit').change(function(){
            getSalesReturnList('LOST_IN_TRANSIT')
		});

	
		
		$('#button_claim_required').change(function(){
            
			getSalesReturnList('CLAIM_REQUIRED')
			
			sr_table.columns( 10 ).search('YES').draw();
        });



		$('#salesReturnList_table tbody').on('click', 'td.details-control', function () {
			var tr = $(this).closest('tr');
			var row = sr_table.row( tr );
			if ( row.child.isShown() ) {
				row.child.hide();
				tr.removeClass('shown');
			}else {
				row.child( format(row.data()) ).show();
				tr.addClass('shown');
			}
		}) ;

    })

	function closeModal() {
		$("#claimrequired_sr_id_modal").val('')
		$("#claimrequired_sr_no_modal").text('')
		$("#claimrequired_remarks_modal").val('')
		$("#claimrequired_modalReject").modal('hide');
	}

	function openModal(btn){

		var salesreturn_id = $(btn).closest("tr").find(".salesreturn_id").text();
		var salesreturn_no = $(btn).closest("tr").find(".salesreturn_no").text();
		var claim_required = $(btn).closest("tr").find(".claim_required").text();
		
		if(salesreturn_id > 0){
		
			$("#claimrequired_sr_id_modal").val(salesreturn_id)
			$("#claimrequired_sr_no_modal").text(salesreturn_no)
			$("#claimrequired_select_modal").val(claim_required)
			$("#claimrequired_modalReject").modal('show');
		}
	}


	function claimrequiredSubmit() {

		var salesreturn_id = $("#claimrequired_sr_id_modal").val();
		var remarks = $("#claimrequired_remarks_modal").val()
		var claim_required = $("#claimrequired_select_modal").val()

		var data= [];

		if( claim_required == null || claim_required =="" || claim_required == '0' || claim_required == undefined){

			toastr.error("Please Select Claim Required")
			return false
		}

		data = {
					"salesreturn_id": salesreturn_id,
					"claim_required": claim_required,
					"remarks": remarks
				}
		
		jsonObject = JSON.stringify(data)
		
		$.ajax({
			url:"<?=base_url()?>admin/CreditNotes/claimrequiredStatusChange",
			type:"POST",
			dataType:"json",
			data: jsonObject,
			success:function (data){
				if(data.status==1){
					
					toastr.success('Claim required Value changed Successfully');
					
					$("#claimrequired_sr_id_modal").val('')
					$("#claimrequired_sr_no_modal").text('')
					$("#claimrequired_select_modal").val("")
					$("#claimrequired_remarks_modal").val('')
					$("#claimrequired_modalReject").modal('hide');
					getSalesReturnList('CN_CREATED')
				
				}else{
					alert('Failed to change Claim required value');
				}
			},
			error: function(data){
				alert('Failed to change Claim required value');
			}
		})
	}

	function sr_remarks_table(salesreturn_id){
	
		var tableData = '<br><p></p>';
		tableData += '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		
		$.ajax({
			url:"<?php echo base_url();?>web_api/getRemarks/?id="+salesreturn_id+"&type=credit_note",
			type: "GET",
			dataType: 'json',
			async:false,
			success: function (data){
				if(data.status==1){
					tableData+="<thead><th>Date</th><th>By</th><th>Remark</th></thead>"
					$.each(data.remarks,function(i,v){
						tableData+="<tr><td>"+data.remarks[i].date+"</td><td>"+data.remarks[i].username+"</td><td>"+data.remarks[i].remark+"</td></tr>";
					})
				}
			}
		});
		tableData+='</table>'
		return tableData;
	}


	//File Upload

	function closeCancelSRModal(){
		
		$("#cancel_sr_id_modal").val('')
		$("#cancel_sr_no_modal").text('')
		$("#cancel_sr_remarks_modal").val('')
		$('#cancel_sr_fileupload_modal').val('')


		$("#modalCancelSR").modal('hide');
	}

	function openCancelSRModal(btn){

		$("#cancel_sr_id_modal").val('')
		$("#cancel_sr_no_modal").text('')
		$("#cancel_sr_remarks_modal").val('')
		$('#cancel_sr_fileupload_modal').val('')
		
		var salesreturn_id = $(btn).closest("tr").find(".salesreturn_id").text();
		var salesreturn_no = $(btn).closest("tr").find(".salesreturn_no").text();
		
		if(salesreturn_id>0){

			$("#cancel_sr_id_modal").val(salesreturn_id)
			$("#cancel_sr_no_modal").text(salesreturn_no)
			$("#modalCancelSR").modal('show');
		}
	}


	function cancelSR_submit(){

		var salesreturn_id = $("#cancel_sr_id_modal").val();
		var remarks = $("#cancel_sr_remarks_modal").val();
		var file_data = $('#cancel_sr_fileupload_modal').prop('files')[0];   
		var form_data = new FormData();             
		
		form_data.append('file', file_data);
		form_data.append('remarks_header', remarks);

		if(file_data != '' && file_data != undefined && file_data != null){
			var file_name = file_data.name
			var file_extension = file_name.split('.').pop().toLowerCase();

			if(jQuery.inArray(file_extension,['jpeg', 'jpg', 'png']) == -1){
				alert("Invalid Image File file | only JPG and PNG files are allowed");
				return false;
			}

			if(salesreturn_id == '0' || salesreturn_id == null || salesreturn_id == 0 || parseInt(salesreturn_id) == NaN){
				return false
			}
		}

		$.ajax({
			url: "<?=base_url()?>admin/CreditNotes/cancelSR_awaiting/"+salesreturn_id, // point to server-side PHP script 
			dataType: 'json',  // what to expect back from the PHP script, if anything
			cache: false,
			contentType: false,
			processData: false,
			data: form_data,                         
			type: 'post',
			success: function(data){

				if(data.status == 1){
					toastr.success("Sales Return Canceled Successfully");
					$("#fileupload_modal_close").click()

				}else{
					toastr.error("Failed to Cancel Sales Return");
				}
			},
			error: function(data){
				toastr.error('Failed to cancel Return');
			}
     });
	}

		//Void Salesreturn

	function closeVoidSRModal(){
		
		$("#void_sr_id_modal").val('')
		$("#void_sr_no_modal").text('')
		$("#void_sr_remarks_modal").val('')
		$("#void_sr_file_list").text('')


		$("#modalVoidSR").modal('hide');
	}

	function openVoidSRModal(btn){

		$("#void_sr_id_modal").val('')
		$("#void_sr_no_modal").text('')
		$("#void_sr_remarks_modal").val('')
		$("#void_sr_file_list").text('')

		
		var salesreturn_id = $(btn).closest("tr").find(".salesreturn_id").text();
		var salesreturn_no = $(btn).closest("tr").find(".salesreturn_no").text();
		
		if(salesreturn_id>0){

			$("#void_sr_id_modal").val(salesreturn_id)
			$("#void_sr_no_modal").text(salesreturn_no)
			
			getSRFilesList(salesreturn_id)
			
			$("#modalVoidSR").modal('show');
		}
	}

	function getSRFilesList(salesreturn_id){

		var tableData = '<br><h5 style="text-align:left; margin-left:10px; font-weight:700;">Files List</h5>';
		tableData += '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style=" margin-left:10px;">';

		$.ajax({
			url:"<?=base_url();?>admin/CreditNotes/getSRFilesList",
			type: "GET",
			data: { "salesreturn_id": salesreturn_id},
			dataType: 'json',
			async:false,
			success: function (data){
				if(data.status==1){

					tableData+="<thead><th>S.No</th><th>File Name</th><th>Download</th></thead>"

					$.each(data.result,function(i,v){

						tableData += "<tr>"
						tableData += "<td>"+(i+1)+"</td>"
						tableData += "<td style='overflow-wrap: break-word;'>"+data.result[i].file_name+"</td>"
						tableData += "<td><a class='btn btn-downlaod' href='<?=base_url()?>"+data.directory+"/"+encodeURIComponent(data.result[i].file_name)+"' download>Download</a></td>"
						tableData += "</tr>";
					})
				}
			}
		});
		tableData+='</table>'
		$("#void_sr_file_list").append(tableData);
	}

	function voidSR_submit(){

		var salesreturn_id = $("#void_sr_id_modal").val();
		var remarks = $("#void_sr_remarks_modal").val()
		var data= [];

		if(salesreturn_id == '' || salesreturn_id == '0' || salesreturn_id == undefined || salesreturn_id == null){
			toastr.error('No Salesreturn Found')
		}

		data = {
					"salesreturn_id": salesreturn_id,
					"remarks_header": remarks
				}
		jsonObject = JSON.stringify(data)
		
		$.ajax({
			url:"<?=base_url()?>admin/CreditNotes/voidSR",
			type:"POST",
			dataType:"json",
			data: jsonObject,
			success:function (data){
				if(data.status==1){
					toastr.success('Return Canceled Successfully');
					$("#void_sr_id_modal").val('')
					$("#void_sr_no_modal").text('')
					$("#void_sr_remarks_modal").val('')
					$("#modalVoidSR").modal('hide');
					closeVoidSRModal()
				}else{
					toastr.error('Failed to cancel Return');
				}
			},
			error: function(data){
				toastr.error('Failed to cancel Return');
			}
		})

	}


 
</script>
	 
