<!DOCTYPE html>
<html>
<meta charset="utf-8">
    <title><?= lang('Creditnotes') ?></title>
    <head>
    <style type="text/css">
        font-face {
            font-family: "Source Sans Pro", sans-serif;
        }
     
        .clearfix:after {
            content: "";
            display: table;
            clear: both;
        }

        a {
            color: #0087C3;
            text-decoration: none;
        }

        body {
            color: #555555;
            background: #FFFFFF;
            font-size: 9px;
            font-family: "Source Sans Pro", sans-serif; 
            width: 100%;
            margin:0;
        }

        #header_logo{
            float:left;
        }
        #header_title{
            float:right;
        }
       
        #client_address p{
            margin:0;
        }
        #ship_to p{
            margin:0;
        }
      
                   
        #client_detail_table td {
            width:110px;
            border-bottom: 0.5px solid grey;
            text-align: left;
            padding-top: 0;
            padding-bottom: 0;
        }
         .left {text-align:left;}
         .right {text-align:right !important;}
         .center {text-align:center;}

        #invoice_table{ 
            width:100%;
            margin-left: 2px;
            margin-right: 2px;
        }
       
        #invoice_table th, td, tr {
            border-bottom: 0.5px solid grey;
            padding-top: 4px;
            padding-bottom: 2px;
            margin: 0;
            }
        #invoice_table .footer_table{
                font-weight:bold;
        }
        #invoice_table th{
            border-top: 0.5px solid grey;
        }

        header {
                position: fixed;
                top: -20px;
                left: 0px;
                right: 0px;
                height: 20px; 
                width: 100%;

            }

            footer {
                position: fixed; 
                bottom: 0; 
                left: 0px; 
                right: 0px;
                height: 20px; 
                border-top: 1px solid #AAAAAA;
                color: #777777;
                width: 100%;
                padding: 8px 0;
                text-align: center;
            }

        .rupee::before{
            padding-left:5px;
            white-space:nowrap;
        }

        
        .footer_margin{
            margin-bottom: 0;
            margin-left : 1px;
            position: absolute;
            bottom: 0;
            float:right;
            font-size:12px;
        }
        .signature{
            margin-bottom: 40px;
            margin-left : 1px;
            position: absolute;
            bottom: 0;
            float:right;
            font-size:12px;
        }
        .container td{
            border-bottom:none;
        }

    </style>
    </head>
    <body>
    <header>
           
        </header>

    <footer id="footer"><span style="font-weight:bold;">SLOYD VENTURES (P) LTD,</span> 1-11-251/19A. 4th Floor, Jayalakshmi Towers, 
    Motilal Nehru Nagar, Begumpet, Hyderabad, Telangana, 500016, IN.<p style="margin:0;">|| CIN: U52390TG2012PTC083950 | PAN: AASCS2801C | Tel: +91-40-27900059 | Email: accounts@sloyd.in | web: www.ynew.in ||</p>
</footer>
<div class="footmargin"></div>
        <table id="heading" style="text-align:center;width:100%;border-bottom:none;margin-top:-30px;">
            <!-- <div id="header_logo"> -->
                <tr style="border-bottom:none;"><td style="align-content:left;text-align:left;border-bottom:none;"><img src="<?php base_url();?>assets/img/logo_invoice.png" height="50px" width="140px"></td>
            <!-- </div>
            <div style="display:inline;font-size:20px;font-weight:700;padding-top:100px"> -->
            <td  class="left"style="padding-left:50px;padding-right:60px;text-align:left;border-bottom:none;"><h1>CREDIT NOTE</h1></td>
            <!-- </div>
            <div id="header_title" style="font-size:20px;font-weight:700;"> -->
            <td style="border-bottom:none;"><div style="font-size:14px;font-weight:700;text-align:right;"><?=$type?></div></td></tr>
            <!-- </div> -->
    </table>
        <table class="container" style="width:100%;">
        <tr><td  style="width:30%;vertical-align:top;">
            <div id="client_address">
                <p>
                    <span style="font-weight:bold;">Customer Details</span><br>
                    <p><?=$company?></p>
                    <p><?=$address ?></p>
                    <p><?=$city?></p>
                    <p><?=$state?></p>
                    <p>INDIA <?= $pincode?></p>
                    <?php if($gst_no!='' || $gst_no!=null){?>
                        <p> GSTIN: <?=$gst_no;?>
                    <?php }?>
                    <?php if($pan_no!='' || $pan_no!=null){?>
                        <p> PAN: <?=$pan_no;?>
                    <?php }?>
                </p>
            </div></td><td style="width:37%;text-align:left;padding-left:1px;vertical-align:top;">
            <div id="ship_to" >
              

            </div></td><td  style="width:33%;vertical-align:top;">
            <div id="client_details">
            <table id="client_detail_table">
                <tr>
                        <td class="left" style="text-align: left;">GSTIN</td>
                        <td class="left">36AASCS2801C1ZI</td>
                    </tr> 
                    <tr>
                        <td class="left">Creditnote No</td>
                        <td class="left"><?=$creditnote_code?></td>
                    </tr>
                    <tr>
                        <td class="left">Creditnote Date</td>
                        <td class="left"><?=$creditnote_date?></td>
                    </tr>   
                  <!-- <tr>
                        <td class="left" style="text-align: left;">Customer Name</td>
                        <td class="left"><?=$company?></td>
                    </tr>   -->
                    <tr>
                        <td class="left">Invoice No</td>
                        <td class="left"><?=$invoice_no?></td>
                    </tr>
                    <tr>
                        <td class="left">Place of Supply</td>
                        <?php if(!empty($place_supply)){?>
                            <td class="left"><?=substr($gst_no,0,2).' - '.$place_supply?></td>
                        <?php }else{ ?>
                            <td class="left"><?=$state_id.'-'.$state?></td>
                        <?php } ?>
                    </tr>
                    <tr>
                        <td class="left">HSN Code</td>
                        <td class="left">851712 - Mobile Phone</td>
                    </tr>
                    <tr>
                        <td class="left">Currency</td>
                        <td class="left">INR</td>
                    </tr>
                </table>
                </div>
                </td></tr>
            </table>
            
        <p style="clear:both;"></p><br>
        <div id="invoice_div">
            <table id="invoice_table" style="width:100%;" cellspacing="0">
                <thead style="text-align: center;font-size:9px;">
                <tr><th style="white-space:nowrap;text-align:left">SKU</th><th style="width:170px;text-align:left;">Product Name</th><th style="width:5px;">Qty</th><th class="right">Price</th><th class="right">Taxable<p style="margin:0;"> Amount</p></th><th class="right">Exempt<p style="margin:0;"> Amount</p></th><th class="right" style="width:50px;padding-left:10px;padding-right:0px;text-align:right;">Tax <p style="margin:0;">Rate</p></th><th style="overflow-wrap: break-word;text-align:right;"  class="right">Tax <p style="margin:0;">Amount</p></th></tr>
                </thead>
                <tbody>
                   <?php if(!empty($credinotes_rows)){
                       $total_units=0;
                       $total_taxable=0;
                       $total_exempt=0;
                       $total_price = 0;
                       $taxable_cat = TAXABLE_CATEGORY;
                        foreach($credinotes_rows as $rowValue){

                            $tax_type=$rowValue['tax_type'];
                            $sku=$rowValue['sku'];
                            $exempt = $rowValue['exempt_amount'];
                            $taxable_amount = $rowValue['taxable_amount'];
                            $amount = $rowValue['price'];
                            $tax_amount = $rowValue['tax_amount'];
                            
                                if(in_array($rowValue['category'] , $taxable_cat)){
                                    $category = ucwords(strtolower($rowValue['category']));
                                    $taxable=$rowValue['price']/1.18;
                                    $exempt="0.00";
                                }else{
                                    $category='Pre-owned';
                                    $taxable=($rowValue['price']-($rowValue['exempt_amount']))/1.18;
                                    $exempt= $rowValue['exempt_amount'];
                                    
                                    if($exempt > $rowValue['price']){
                                        $exempt = $rowValue['price'];
                                        $taxable_amount =0;
                                    }
                                }
                             $total_exempt += $exempt;
                            $total_taxable+=$taxable_amount;
                            $total_tax_amount+=$tax_amount;
                            $total_price +=$amount; 
                            $device_name=ucwords(strtolower($rowValue['device_name']));
                            $total_units++;?>
                            <tr>
                            <td style="white-space:nowrap;border-bottom:none;"><?=$sku?></td>

                            <?php if($no_grade == 'yes'){ ?>
                                
                                <td style="padding-left:1px;border-bottom:none;"><?=$device_name?></td>
                            
                            <?php } else {?>
                            
                                <td style="padding-left:1px;border-bottom:none;"><?=$device_name.' - '.(($rowValue['grade']=='UNCERTIFIED')?'UC':$rowValue['grade'])?></td>
                                
                            <?php } ?>
                            
                            <td style="border-bottom:none;text-align:center;width:5px;">1</td>
                            <td style="border-bottom:none;text-align:right;"><span class="right rupee"><?=IND_money_format($rowValue['price'])?></span></td>
                            <td style="border-bottom:none;text-align:right;"><span class="right rupee"><?=IND_money_format($rowValue['taxable_amount'])?></span></td>
                            <td style="border-bottom:none;text-align:right;"><span class="right rupee"><?=IND_money_format($rowValue['exempt_amount'])?></span></td>
                            <td style="border-bottom:none;text-align:right;">18%</td>
                            <td style="border-bottom:none;text-align:right;"><span class="right rupee"><?=IND_money_format($rowValue['tax_amount'])?></span></td>
                            </tr>
                            <tr class="bottom-border">
                                <td><span style="font-weight:bold;">IMEI&nbsp;&nbsp;&nbsp;</span><?=$rowValue['imei']?></td>
                                <td style="padding-left:1px;"><?=$category.' | '.$rowValue['nhdin']?></td>
                                <td colspan="6"></td>
                            </tr>
                    <?php  }
                    } ?>
                   
                </tbody>
                <tfoot class="footer_table">
                
                    
                <?php if($net_amount != $total_price){ ?>
                    <tr style="line-height:15px;">
                        <td colspan="2" >Gross Value</td>
                        <td style="text-align:center;padding-bottom:2px;padding-top:2px;"><?=$total_units?></td>

                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($total_price,2))?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($total_taxable,2))?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($total_exempt,2))?></td>
                        <td colspan="2" class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?=IND_money_format($gross_tax)?></td>
                    </tr>
                <?php } ?>
                <?php if($discount_amount > 0){ ?>
                    <tr style="line-height:15px;">
                        <td colspan="2">Less: Discount</td>
                        <td style="text-align:center;padding-bottom:2px;padding-top:2px;"></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($discount_amount,2))?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($discount_amount/1.18,2))?></td>
                        <td class="right" colspan="2">18%</td>
                        <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?=IND_money_format(round($discount_amount - $discount_amount/1.18,2))?></td>
                    </tr>
                <?php } ?>
                <?php if($freight_amount > 0){ ?>
                    <tr style="line-height:15px;">
                        <td colspan="2">Add: Freight</td>
                        <td style="text-align:center;padding-bottom:2px;padding-top:2px;"></td>

                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($freight_amount,2))?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($freight_amount/1.18,2))?></td>
                        <td class="right" colspan="2">18%</td>
                        <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?=IND_money_format(round($freight_amount - $freight_amount/1.18,2))?></td>
                    </tr>
                <?php } ?>
                <?php if($insurance_amount > 0){ ?>

                    <tr style="line-height:15px;">
                        <td colspan="2">Add: Insurance</td>
                        <td style="text-align:center;padding-bottom:2px;padding-top:2px;"></td>

                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($insurance_amount,2))?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($insurance_amount/1.18,2))?></td>
                        <td class="right" colspan="2">18%</td>
                        <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?=IND_money_format(round($insurance_amount - $insurance_amount/1.18 ,2))?></td>
                    </tr>
                <?php } ?>
                <?php if($tcs_total > 0){ ?>
                    <tr style="line-height:15px;">
                        <td colspan="2">Add: TCS</td>
                        <td style="text-align:center;padding-bottom:2px;padding-top:2px;"></td>

                        <td style="text-align:center;padding-bottom:2px;padding-top:2px;"></td>

                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($tcs_amount,2))?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round(0,2))?></td>
                        <td class="right" colspan="2">-</td>
                        <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?=IND_money_format(0)?></td>
                    </tr>
                <?php } ?>

                <?php 
                    $net_tax = $gross_tax - ($discount_amount -$discount_amount/1.18) + ($freight_amount -$freight_amount/1.18) + ($insurance_amount -$insurance_amount/1.18);
                    $net_taxabale = $gross_taxable - ($discount_amount/1.18) + ($freight_amount/1.18) + ($insurance_amount/1.18);
                ?>
                    <tr style="line-height:15px;">
                        <td colspan="2">Net Value</td>
                        <td style="text-align:center;padding-bottom:2px;padding-top:2px;"><?=$total_units?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($net_amount,2))?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($net_taxabale,2))?></td>
                        <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?=IND_money_format(round($total_exempt,2))?></td>
                        <td colspan="2" class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?=IND_money_format($net_tax)?></td>
                    </tr>
                    
                    <tr style="line-height:15px;">
                    <td colspan="4"><?=$amount_words?></td>
                        <?php if($tax_type=='IGST18'){ ?>
                            <td colspan="2" class="right">Tax Break-Up</td><td colspan="2" class="right" style="padding-bottom:2px;padding-top:1px;">IGST <span class="rupee"><?=IND_money_format($net_tax)?></td>
                       <?php }else{ ?>
                        <td colspan="2" class="right">Tax Break-up</td><td colspan="2" class="right" style="padding-bottom:2px;padding-top:1px;">
                            CGST <span class="rupee"><?=IND_money_format(round($net_tax/2,2))?>
                            &nbsp;| SGST <span class="rupee"><?=IND_money_format(round($net_tax/2,2))?> </td>
                       <?php } ?>
                    </tr>
               
                </tfoot>
            </table>
        </div>
        <p></p><br>
        <p></p>
        <div style="font-size:10px;">
            <p>
            <div style="page-break-inside:avoid;">
            <div style="float:left;page-break-inside:avoid;width:60%;height:40px;">
                <p style="font-weight: bold;">Notes</p>
                <p> <?php if($salesman){?>  Sales Code: <?=$salesman?> | <?php }?>
               <?php if($sales_channel){ ?> Sales Channel: <?=$sales_channel?><?php }?></p>
                <?php if($saleschannel_ref_id){ ?> <p> Sales Channel Ref. ID: <?=$saleschannel_ref_id?></p><?php }?>
                <?php if($received_date){ ?> <p> Received Date: <?=$received_date?></p><?php }?>                
            </div>
                <div style="float:right;page-break-inside:avoid;">
                        <br>
                    <span style="font-weight:700;">For Sloyd Ventures (P) Ltd.,</span>
                    <p style="width:50px;height:50px;"></p>
                    <p>Authorised Signature</p>
                </div>
            </div>
       
        
        <div class="signature">
        </div>
        </body>
</html>

<?php
    function IND_money_format($number){    	
        $decimal = (string)($number - floor($number));
        $money = floor($number);
        $length = strlen($money);
        $delimiter = '';
        $money = strrev($money);
 
        for($i=0;$i<$length;$i++){
            if(( $i==3 || ($i>3 && ($i-1)%2==0) )&& $i!=$length){
                $delimiter .=',';
            }
            $delimiter .=$money[$i];
        }
 
        $result = strrev($delimiter);
        $decimal = preg_replace("/0\./i", ".", $decimal);
        $decimal = substr($decimal, 0, 3);
 
        if( $decimal != '0'){
            $result = $result.$decimal;
        }
        if($decimal=="0"){
            $result = $result.'.00';
        }
 
        return $result;
    }
?>