<?php
$Countries_list = file_get_contents(base_url() . 'assets/json/countries.json');
$Countries_list = json_decode($Countries_list);

$CustomerList = $this->db->query("select vendor_id,company, vendor_code from tbl_vendor where user_type IN ('EXPORT') order by company asc")->result();
	
?>

<style>
	.form-control {
		text-transform: initial;
	}
	table tr.no_device_cond td {
		background-color: #fcb0b0;
	}
	table tr.diff_device_cond td {
		background-color: #ead669;
	}

	.disp_messages {
		margin-bottom: 30px;
	}
	.disp_messages .inner_disp {
		margin-bottom: 20px;
	}
	.disp_messages .inner_disp h5 {
		margin-bottom: 5px;
		font-size: 16px;
		text-align: center;
		background-color: #cecece;
		color: #fff;
		padding: 5px;
	}
</style>

<div style="text-transform: initial;">   
	<div class="form-group table-responsive">

		<table class="table table-bordered table-stripped" style="margin-left:15px">
			<tbody>
				<tr>
					<td>Customer</td>
					<td style="width:300px">
						<select class="form-control select_box" id="customerList" name="customerList" style="width:300px" onchange="getCustomerTCSValue()">
							<option value="">Select Customer</option>
						
							<?php  foreach($CustomerList as $obj) { ?>
								<option value="<?php echo strtoupper($obj->vendor_id); ?>"><?php echo strtoupper($obj->company.' / '.$obj->vendor_code); ?></option>
							<?php } ?>
						</select>
					</td>
					<td>Shipping To</td>
					<td style="width:300px">
						<input type="button" class="btn btn-success" id="upload" value="Shipping To" data-toggle="modal" onclick="shippingModel()" />
					</td>		
				</tr>
				<tr>
					<td>Warehouse</td>
					<td style="width:300px">
						<select class="form-control select_box"  id="warehouseList" name="warehousList" style="width:300px;" disabled>							
						</select>
					</td>
					<td>Shipping From</td>
					<td>
						<select class="form-control select_box"  id="shippingFrom" style="width:300px;text-transform:uppercase;">
							<option value="">Select Shipping From</option>
						</select>
					</td>
				</tr>
				<tr class="">
					<td>Sales Channel</td>
					<td>
						<select class="form-control select_box"  id="saleschannelList" name="saleschannelList" style="width:300px;" disabled>
							<option value="EXPORT">EXPORT</option>
						</select>
					</td>
					<td>Sub Category</td>
					<td>
						<select class="form-control select_box"  id="deviceSubCategory" name="deviceSubCategory" style="width:300px;" disabled>
							<option value="STANDARD">STANDARD</option>
						</select>
					</td>
				</tr>
				<tr>
					<td>Sales Representative</td>
					<td style="width:300px">
						<select class="form-control select_box"  id="sellerList" style="width:300px;border:none;">
							<option value="">Select Sales Executive</option>
						</select>
					</td>	
					<td>Payment Mode</td>
					<td style="width:300px">
						<select class="form-control select_box"  id="paymentList" name="paymentList" style="width:300px;">
							<option value="">Select Payment Mode</option>
							<option value="cod">COD</option>
							<option value="prepaid">PREPAID</option>
							<option value="credit">CREDIT</option>								
						</select>
					</td>	
				</tr>
				<tr>
					<!-- <td>SALES CHANNEL REFERNCE ID</td> -->
					<td>Buyer Order No.</td>
					<td>
						<input type="text" class="form-control" name="saleschannel_id_input" id="saleschannel_id_input"  oninput="this.value = this.value.toUpperCase()">
					</td>
				
					<!-- <td>Order Received Date</td> -->
					<td>Buyer Order Date</td>
					<td>
						<input type="date" class="form-control" id="bulk_input_order_date" value="<?=date('Y-m-d')?>">
					</td>
					
				</tr>
				<tr>
					<td>Terms of Delivery</td>
					<td colspan="3">
						<textarea class="form-control" id="terms_of_delivery" ></textarea>
					</td>
				</tr>
				<tr>
					<td>REMARKS</td>
					<td colspan="3">
						<textarea class="form-control" id="remark_textarea" ></textarea>
					</td>
				</tr>
				
			</tbody>
		</table>
		
	<hr style="border: 3px solid #e4eaec">

	<table class="form-group table-responsive table" style="margin-left:10px;">
		<tr>
			<td>Upload</td>
			<td><input type="file" class="form-control-file custom-file-input" id="fileUpload"></td>
			<td colspan="3"><select class="form-control select_box"  class="form-control" id="sales_terms" style="width: 180px;">
					<option value="">Sales Terms</option>
					<option value="ASIS">ASIS</option>
					<option value="FULL QC">FULL QC</option>
				</select>
			</td>
			<td colspan="2">
				<input type="button" class="btn btn-green" id="upload" value="Upload Device" onclick="uploadAndGetDeviceInfo()" />
			</td>
			<input type="hidden" id = "tcs_value" >
			<input type="hidden" id = "tcs_percentage" >
		</tr>
	</table>

	<hr style="border: 3px solid #e4eaec">

	<div class="form-group table-responsive">
		<form action="<?php echo base_url();?>admin/SalesOrder/createsalesorder" method="POST" id="createorderform" enctype="multipart/form-data">
			<input type="hidden" id="customer" name="customer"> 
			<input type="hidden" id="seller" name="seller"> 
			<input type="hidden" id="payment_mode" name="payment_mode">
			<input type="hidden" name="sales_channel" id="sales_channel">
			<input type="hidden" name="sales_channel_id" id="sales_channel_id">
			<input type="hidden" name="remarks_header" id="remarks_header">
			<input type="hidden" id="warehouse" name="warehouse"> 

			<table id="tbl_product" class="table table-bordered table-stripped" style="margin-left:15px; width:90%;">
				<thead>
					<th>BRAND/TDID</th>
					<th>PRODUCT NAME</th>
					<th>SKU</th>
					<th>CATEGORY</th>
					<th>GRADE</th>								
					<th>QTY</th>
					<th>PRICE</th>
					<th>AMOUNT</th>
					<th>Device Actv Condition</th>
					<th>Updating Actv Condition</th>
				</thead>			 
			</table>		
					
			<hr style="border: 3px solid #e4eaec">
		</form>	

		<div class="disp_messages">
			<div class="inner_disp no_actv_status" style="display: none;">
				<h5>No Activation Status Found:</h5>
				<p class="no_actv_status_given" style="color: red;"></p>
				<div>
					<input type="checkbox" id="discard_no_actv_status" name="discard_no_actv_status" value="1">
					<label for="discard_no_actv_status"> Discard</label>
				</div>
			</div>
			<div class="inner_disp diff_actv_status" style="display: none;">
				<h5>Different Activation Status Found:</h5>
				<p class="diff_actv_status_given" style="color: #ff9900;"></p>
			</div>
		</div>

		<table style="margin-left:15px; width:90%;">
			<tr>
				<td colspan="3"></td>
				<td>Total Quantity :</td>
				<td> <span id="total_qty"></span></td>				
				<td>Total Amount : </td>
				<td><span id="total_amount"></span></td>
			</tr>
			<tr></tr>

			<tr>
				<td colspan="3"></td>
				<td>Discount :</td>
				<td class="row">
					<input type ="number" class="create_discount" id="create_discount_value" onchange="getDiscount()" placeholder = "IN (%)" style="width: 100px; height:32px;" value="0">
					<select id="create_discount_type" style="width: 100px; height:32px;" onchange="getDiscount()">
						<option value="percentage">In (%)</option>
						<option value="amount">In Amount</option>
					</select>
				</td>
				<td>
					<span id="create_discount_span"></span>
					<input type="hidden" id="create_discount_amount" value="0">
				</td>
			</tr>
			<tr>
				<td colspan="3"></td>
				<td>Freight :</td>
				<td class="row">
					<input type ="number" class="create_freight" id="create_freight_value" onchange="getTCSAmount()" placeholder = "FREIGHT" style="width: 100px; height:32px;" value="0">
				</td>
				<td>
					<span id="create_freight_span"></span>
				</td>
			</tr>

			<tr>
				<td colspan="3"></td>
				<td>Insurance :</td>
				<td class="row">
					<input type ="number" class="create_insurance" id="create_insurance_value" onchange="getInsurance()" placeholder = "IN (%)" style="width: 100px; height:32px;" value="0">
					<select id="create_insurance_type" style="width: 100px; height:32px;" onchange="getInsurance()">
						<option value="percentage">In (%)</option>
						<option value="amount">In Amount</option>
					</select>
				</td>
				<td>
					<span id="create_insurance_span"></span>
					<input type="hidden" id="create_insurance_amount" value="0">
				</td>
			</tr>
			<tr>
				<td colspan="3"></td>
				<td id = "create_td_tcs_text"></td>
				<td class="row">
					<span id="create_td_tcs_value" ></span>
				</td>
				<td>
					<span id="create_td_tcs_span"></span>
				</td>
			</tr>

			<tr>
				<td colspan="3"></td>
				<td>Total Invoice Value (in Rupees) :</td>
				<td class="row">
					<input type="text" class="form-control" id="total_invoice_in_rupee" placeholder="Total Amout (in Rupees)" disabled>
				</td>
			</tr>
			<tr></tr>

			<tr>
				<td>Export Currency Type :</td>
				<td class="row">
					<select class="form-control export_currency_type" id="export_currency_type" >
						<option value="us_dollar">US Dollar</option>
					</select>
				</td>
				<td colspan="2"></td>

				<td>Currency Exchange Rate (in Rupee) :</td>
				<td class="row">
					<input type="number" class="form-control" id="currencyExchangeRate_inRupee" placeholder="Currency in Rupee">
				</td>
			</tr>
			<tr></tr>

			<tr>
				<td colspan="3"></td>
				<td>Total Invoice Value (in Dollar) :</td>
				<td class="row">
					<input type="text" class="form-control" id="total_invoice_inExportCurrency" placeholder="Total Amount (Dollar)" disabled>
				</td>
			</tr>
			<tr></tr>

			<tr>
				<td colspan="3"></td>
			    <td>
					<button class="btn btn-primary" id="submit" onclick="submitBulkSO()">Submit</button>
					<!-- <button type="button" class="btn btn-green" onclick="submitBulkSO('draft')">Draft</button> -->
				</td>
			</tr>
		</table>

    </div>        
</div>


<!-- Shipping to address model start -->
<div class="modal fade" id="shippingModal" role="dialog" aria-labelledby="shippingModalLabel" data-backdrop="false">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
        
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Shipping To Address</h5>
        </div>
    
      <div class="modal-body">
		<div style="margin-bottom: 15px;">
			<input type="checkbox" class="shipping_to_checkbox" id="shippingToAddress" style="height:14px;width:14px;cursor:pointer; margin-right: 10px;">
			<label for="shippingToAddress" style="cursor: pointer;">Is "SHIPPING TO" same as "BILLING TO" Address</label>
		</div>

        <form>
          <div class="form-group" id="customerCheck" style="display:none">
            <label for="city-text" class="col-form-label">Customer:</label>
            <select class="form-control select_box" id="select_customer" style="width: 100%; height:32px;" >
                <option value="">SELECT CUSTOMER</option>
				<?php  foreach($CustomerList as $obj) { ?>
					<option value="<?php echo strtoupper($obj->vendor_id); ?>"><?php echo strtoupper($obj->company.' / '.$obj->vendor_code); ?></option>
				<?php } ?>
			</select>
          </div>

		  <div class="shipping_to_address_fields">
			<div class="form-group">
				<label for="address-name" class="col-form-label">Address: <span style="color:red; font-size:15px">*</span></label>
				<textarea type="text" class="form-control" id="shipping_to_address" required></textarea>
			</div>
			<div class="form-group">
				<label for="city-text" class="col-form-label">City: </label>
				<input type="text" class="form-control" id="shipping_to_city" placeholder="City" >
			</div>
			<div class="form-group">
				<label for="sate-text" class="col-form-label">State: </label>
				<input type="text" class="form-control" name="state" id="shipping_to_state" placeholder="State" />
			</div>
			<div class="form-group">
				<label for="sate-text" class="col-form-label">Country: <span style="color:red; font-size:15px">*</span></label>
				<select class="form-control select_country" name="country" id="shipping_to_country" required>
					<option value="">Select Country</option>
					<?php foreach($Countries_list as $v) { ?>
						<option value="<?php echo $v; ?>" ><?php echo $v; ?></option>
					<?php } ?>
				</select>
			</div>
			<div class="form-group">
				<label for="pincode-text" class="col-form-label">Pincode: </label>
				<input type="number" class="form-control" id="shipping_to_pincode" placeholder="Pin Code" >
			</div>
		  </div>

        </form>
      </div>
      
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-success" id="shipping_submit" value= "submit" onclick = "shippingData()">ADD</button>
      </div>
    </div>
  </div>
</div>
<!-- End -->


</div>

<script src="<?php echo base_url(); ?>assets/js/bootbox/bootbox.js"></script>

<script type="text/javascript">

	var device_actv_cond_data = <?php echo json_encode($device_actv_cond_data); ?>;
	// console.log(JSON.stringify(device_actv_cond_data));
	var no_actvStatus_devices = [];
	var diff_actvStatus_devices = [];
	
    var devices = [];
	var shipping_address = [];

    $(document).ready(function(){
		$("#submit").attr("disabled", true);

        $.ajax({
            url: "<?php echo base_url(); ?>admin/SalesOrder/shippingFromAddress",
            method: "GET",
            data: {},
            dataType: 'json',
            success: function(data) {
                $.each(data, function(i, v) {
                    $("#shippingFrom").append("<option value=" + v.shipping_from_id + ">" + v.state + ' / ' + v.city + ' - ' + v.pincode + "</option>");
                })
            },
        });
		
		$.ajax({
			url: "<?php echo base_url(); ?>web_api/getsalesreps",
			type: "GET",
			dataType: 'json',
			success: function (data){
				$.each(data.result, function(i, v){
					if ($.inArray('EXP', v.sales_area) != -1) {
						let a = '<option value="'+ v.user_id +'">'+ v.name + '-' + v.sales_code +'</option>';
						$("#sellerList").append(a);
					}
				});
			},
			error: function (errorThrown, textStatus, jqXHR){
				alert("Error: "+jqXHR+" "+data.message); 
			}
		});

		$.ajax({
			url: "<?php echo base_url(); ?>web_api/getWareHouse",
			type: "GET",
			dataType: 'json',
			success: function (data){
				$("#warehouseList").append("<option value='0' >SELECT WAREHOUSE</option>")
				let selected = ''

				$.each(data.result,function(i, v){
					if (v.short_code == 'HYD') {
						selected = (v.short_code == 'HYD')? 'selected' : '';
						
						var a = "<option value='"+v.short_code+"' "+ selected + ">"+v.warehouse+'-'+v.short_code+"</option>"
						$("#warehouseList").append(a);
					}
				});
				$("#warehouseList").change()
				$("#warehouseList").select2()
			},
			error: function (errorThrown, textStatus, jqXHR){
				alert("Error: "+jqXHR+" "+data.message); 
			}
		});
    });

    function shippingModel() {
		$('#shippingModal').modal('show');
	}
	
	$('#shippingToAddress').click(function() {
        if ($('input.shipping_to_checkbox').is(':checked')) {
            $("#customerCheck").show();
			$('#select_customer').val($('#customerList').val()).trigger('change');
            
        } else{
			$('#select_customer').val('').trigger('change');
            $("#customerCheck").hide();
        }
    });

	$('#select_customer').on('change', function() {
		let val = $(this).val();
		if (val == '') {
			$('.shipping_to_address_fields').find('input,select,textarea').val('');
		} else {
			getCustomerDetails(val);
		}
	});
	
	function getCustomerDetails(customer_id){
		$.ajax({
			"url":"<?=base_url()?>admin/SalesOrder/getCustomerDetails",
			"method": "GET",
			"data": { "customer_id": customer_id},
			"dataType": "json",
			"success": function(data) {
				if(data.status == 0){
					return false
				}
				
				$("#shipping_to_address").val(data.address);
				$("#shipping_to_city").val(data.city);
				$("#shipping_to_state").val(data.state);
				$("#shipping_to_country").val(data.country);
				$("#shipping_to_pincode").val(data.pincode);
			}
		});
	}
        
    function shippingData(){
        
		var to_vendor_id = $("#select_customer").val().trim();
        var to_address = $("#shipping_to_address").val().trim();
        var to_city = $("#shipping_to_city").val().trim();
        var to_state = $("#shipping_to_state").val().trim();
        var to_country = $("#shipping_to_country").val().trim();
        var to_pincode = $("#shipping_to_pincode").val().trim();
        
        var fields_required = '';

		fields_required += checkNull(to_address, 'Shipping to Address ');
		// fields_required += checkNull(to_city, 'Shipping to City ');
		// fields_required += checkNull(to_state, 'Shipping to State ');
		fields_required += checkNull(to_country, 'Shipping to Country ');
		// fields_required += checkNull(to_pincode, 'Shipping to Pincode ');
		if (fields_required != '') {
            toastr.error("Fields Required: " + fields_required)
            return false
        }
		shipping_address.push({
							'to_vendor_id':to_vendor_id,
						    'to_address':to_address,
							'to_city':to_city,
							'to_state':to_state,
							'to_country':to_country,
							'to_pincode': (to_pincode == '')? null: to_pincode
						});
		if(shipping_address.length != 0){
		    toastr.success("Shipping To Addesss added successfully");
		} else{
		    toastr.error("Failed to add shipping To Address");
		}
		$('#shippingModal').modal('toggle');
		
    }

		
	function uploadAndGetDeviceInfo() {
		var device_name, sku, category, grade,sales_term, quantity, price, parsedPrice;
		devices = [];
		var DeviceIds = [];
		var fetchPriceArr = [];
		var total_quantity=0;
		var total_amount = 0.0;
		var device_sub_category = $("#deviceSubCategory").val()
		// payment_method = $("#devicePaymentMethod").val()
		var select_sales_terms = $("#sales_terms").val();
		if(select_sales_terms == '' || select_sales_terms == undefined){
			alert("Please Select Sales Terms");
			return false;
		}

		var exempt_cat = <?=json_encode(EXEMPT_CATEGORY)?>;

        var fileUpload = document.getElementById("fileUpload");
        var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.csv|.txt)$/;

        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof (FileReader) != "undefined") {
				$("#tbl_product").find("tr:gt(0)").remove();
                var reader = new FileReader();
                reader.onload = function (e) {
                    //var table = document.createElement("table");
                    var table = document.getElementById("tbl_product");
					var rows = e.target.result.split("\n");

					for (var i = 0; i < rows.length; i++) {
						var cells = rows[i].split(",");

                        if (cells.length > 1) {
							if (cells.length > 3) {
								alert("Max 3 columns are allowed in uploaded file");
								isValid = false;
								return false;
							}

							DeviceIds.push(cells[0]);

							fetchPriceArr.push({
								deviceid:cells[0].toUpperCase(),
								price:cells[1],
								device_condition:cells[2],
							});
						}
					}	
					
					$.ajax({
						url: "<?php echo base_url(); ?>admin/device/getGroupBySKU",
						dataType: 'json',
						data: JSON.stringify(DeviceIds),
						type: 'POST', 			
						success: function(res){
						    var response = res.data;

							no_actvStatus_devices = [];
							diff_actvStatus_devices = [];
							show_ActvStatus_Messages();
							
							for(x = 0;x<response.length;x++){
								var data = response[x];
								device_id = data.nhdin;
								grnreport_id = data.grnreport_id;
								device_name = data.device_name;
								sku = data.SKU;
								category = data.stock_type;
								grade = data.certification_grade;
								quantity = 1;
								status = data.status;
								price = 0.0;
								amount = 0.0;
								device_condition = data.device_condition;
								updating_device_cond = '';
								
								for(y=0;y<fetchPriceArr.length;y++){
									 if(new String(device_id).valueOf().toLowerCase() == new String(fetchPriceArr[y].deviceid).valueOf().toLowerCase()){
										price = parseFloat(fetchPriceArr[y].price);
										amount = price * quantity;
										
										updating_device_cond = $.trim(fetchPriceArr[y].device_condition);
										if ($.inArray(updating_device_cond, ['NA', '', device_condition]) != -1) {
											updating_device_cond = '';
										}

										break;
									 }
								}
								
								if(isNaN(price) || price <= 0){
									toastr.error("Invalid Price for "+device_id)
									return false
								}
																								
								if(exempt_cat.indexOf(category)>=0){
									sales_term = select_sales_terms;
								}else{
									// sales_term = '';
									sales_term = select_sales_terms;
								}
								
								if(device_sub_category != data.device_sub_category){
									toastr.error("Error: "+device_id+" is not a "+device_sub_category+" device")
									return false
								}
								
								var row = table.insertRow(-1);
								row.insertCell(-1).innerHTML = device_id;
								//row.insertCell(-1).innerHTML = status;								
								row.insertCell(-1).innerHTML = device_name;
								row.insertCell(-1).innerHTML = sku;
								row.insertCell(-1).innerHTML = category;
								row.insertCell(-1).innerHTML = grade;
								//row.insertCell(-1).innerHTML = sales_term;
								row.insertCell(-1).innerHTML = quantity;
								row.insertCell(-1).innerHTML = price;
								row.insertCell(-1).innerHTML = parseFloat(amount).toFixed(2);
								row.insertCell(-1).innerHTML = gvv(device_actv_cond_data[device_condition]);
								row.insertCell(-1).innerHTML = gvv(device_actv_cond_data[updating_device_cond]);
								// row.insertCell(-1).innerHTML = !isValidString(device_condition)? device_condition: device_condition;
								// row.insertCell(-1).innerHTML = !isValidString(updating_device_cond)? 'Empty': updating_device_cond;
								
								if (!isValidString(device_condition) && !isValidString(updating_device_cond)) {
									row.className = 'no_device_cond';
									no_actvStatus_devices.push(device_id);
								} else if (isValidString(device_condition) && isValidString(updating_device_cond) && updating_device_cond != device_condition) {
									row.className = 'diff_device_cond';
									diff_actvStatus_devices.push(device_id);
								}
								
								devices.push({'device_name':device_name, 
												'nhdin_id':device_id,
												"grnreport_id": grnreport_id,
												'sku':sku,
												'category':category,
												'grade':grade,
												'sales_term':sales_term,
												'quantity':quantity,
												'price':price,
												'updating_device_cond': updating_device_cond
											});	
												
								total_quantity = parseInt(total_quantity) + parseInt(quantity);
								total_amount = Number(total_amount) + Number(amount);
								
							}	
							
							var totalQtyElement = document.getElementById('total_qty');
							totalQtyElement.innerHTML = total_quantity;
				
							var totalAmountElement = document.getElementById('total_amount');
							totalAmountElement.innerHTML = parseFloat(total_amount).toFixed(2);
							$("#submit").attr("disabled", false);
							getInvoiceGrossAmount()
							getCustomerTCSValue()
							getTCSAmount()

							show_ActvStatus_Messages();
							
						},
						error: function(data){
						   console.log('device not found '+ deviceid);
						}
					});
		        }
                reader.readAsText(fileUpload.files[0]);
            } else {
                alert("This browser does not support HTML5.");
            }
        } else {
            alert("Please upload a valid CSV file.");
        }
    }

	function show_ActvStatus_Messages() {
		$('.disp_messages .inner_disp').hide();

		if (no_actvStatus_devices.length > 0) {
			$('.disp_messages .no_actv_status .no_actv_status_given').text(no_actvStatus_devices.join(', '));
			$('.disp_messages .no_actv_status').show();
		}
		if (diff_actvStatus_devices.length > 0) {
			$('.disp_messages .diff_actv_status .diff_actv_status_given').text(diff_actvStatus_devices.join(', '));
			$('.disp_messages .diff_actv_status').show();
		}
	}
	
	
	function checkNull(entity, message){
		if(entity=='0' || entity=='0' || entity==0 || entity=='' || entity==null){ 
			return message;
		}		
		return '';
	}
	

	function submitBulkSO(submit_type = ''){
		if(submit_type == 'draft'){
			var status = 'DRAFT'
		} else {
			var status = 'FINANCE_PENDING'
		}

		if (no_actvStatus_devices.length > 0) {
			if (!$('#discard_no_actv_status').is(':checked')) {
				toastr.error('Some Devices are not having ActivationStatus');
				return false;
			}
		}
		if (diff_actvStatus_devices.length > 0) {
            let status = window.confirm('Are you sure to override the ActivationStatus of some devices ?');
			if (!status) {
				return false;
			}
		}
		
		if(shipping_address.length == 0){
            toastr.error('Add "Shipping TO" address');
            return false;
        }
		var seller = $("#sellerList").val();
		var customer = $("#customerList").val();
		var warehouse = $("#warehouseList").val();
		var payment_mode = $("#paymentList").val();
		var sales_channel = $("#saleschannelList").val();
		var terms_of_delivery = $("#terms_of_delivery").val();
		var remarks_header = $("#remark_textarea").val();
		var saleschannel_id = $("#saleschannel_id_input").val();
		var order_date = $("#bulk_input_order_date").val()
		var total_amount =  parseFloat($("#total_amount").text())
		var discount_value = parseFloat($("#create_discount_value").val())
		var discount_type = $("#create_discount_type").val()
		var insurance_value = parseFloat($("#create_insurance_value").val())
		var insurance_type = $("#create_insurance_type").val()
		var freight_amount = parseFloat($("#create_freight_value").val())
		var tcs_amount = parseFloat($("#create_td_tcs_value").text())
		var tcs_percentage = parseFloat($("#tcs_percentage").val())
		var device_sub_category = $("#deviceSubCategory").val()
		var shipping_from_id = $("#shippingFrom").val()
		var export_currency_type = $("#export_currency_type").val()
		var currencyExchangeRate_inRupee = $("#currencyExchangeRate_inRupee").val()
		//var payment_method = $("#devicePaymentMethod").val()
		var fields_required = '';

		fields_required += checkNull(customer, 'Customer ');
		fields_required += checkNull(warehouse, 'Warehouse ');
		fields_required += checkNull(shipping_from_id, 'Shipping From ');
		fields_required += checkNull(sales_channel, 'Sales Channel ');
		fields_required += checkNull(device_sub_category, 'Sub Category ');
		fields_required += checkNull(seller, 'Sales Executive ');
		fields_required += checkNull(payment_mode, 'Payment Mode ');
		// fields_required += checkNull(saleschannel_id, 'Buyer Order No ');
		fields_required += checkNull(currencyExchangeRate_inRupee, 'Currency Exchange Rate');
		//fields_required += checkNull(payment_method, 'Payment Method ')

		if (customer == '') {
			alert("Please select customer");
			return false;
		}
		
		if(sales_channel != 'OFFLINE'){
			
		}
		
		if(fields_required!=''){
			bootbox.alert("Fields required: " + fields_required);
			//e.preventDefault();
			return false;
		}

		if(discount_type == 'amount'){
			if(isNaN(discount_value)){
				discount_value = 0
			}
			if(discount_value > total_amount){
				alert("Discount Shouldn't Exceed Total Amount");
				return false
			}
		}

		if(discount_type == 'percentage'){
			if(isNaN(discount_value)){
				discount_value = 0
			}

			if(discount_value > 100){
				alert("Discount Shouldn't Exceed 100%");
				return false
			}
		}
					
		var salesorder_header=[];
		salesorder_header.push({	'seller':seller, 
						'customer':customer,
						'payment_mode':payment_mode,
						'warehouse':warehouse,
						'sales_channel':sales_channel,
						'sales_channel_id':saleschannel_id,
						'terms_of_delivery':terms_of_delivery,
						'remarks_header':remarks_header,
						'order_date': order_date,
						'status': status,
						'discount': discount_value,
						'discount_type': discount_type,
						'insurance_value': insurance_value,
						'insurance_type': insurance_type,
						'freight_amount': freight_amount,
						'tcs_percentage': tcs_percentage,
						'tcs_amount': tcs_amount,
						'device_sub_category': device_sub_category,
						//'payment_method': payment_method,
						'module_type': 2,
						'export_currency_type': export_currency_type,
						'currencyExchangeRate_inRupee': currencyExchangeRate_inRupee,
						'rows':devices,
						'billing_from_id': 1,
						'shipping_from_id':shipping_from_id,
						'shipping_data':shipping_address
					});
					
		var jsonObject = JSON.stringify(salesorder_header)
		$("#submit").attr("disabled", true);
		
		$.ajax({
			url: "<?php echo base_url(); ?>admin/SalesOrder/CreateBulkSalesOrderExport",
			dataType: 'json',
			data: jsonObject,
			type: 'POST', 
			success: function(data){
			    console.log(data)
				if(data.status==1){
					alert('Sales Order Created Successfully');
					window.location.replace("<?=base_url()?>admin/Rfs_exp/manage_rfs");
				}else{
					$("#submit").attr("disabled", false);
					toastr.error(data.message); 
				}				
			},
			error: function(error){ 
			    console.log(error)
				$("#submit").attr("disabled", false);
				toastr.error('Failed to create Sales Order'); 				  
			}
		});
	}
	
	function getDiscount(){
		var discount = parseFloat($("#create_discount_value").val())
		var discount_type = $("#create_discount_type").val()
		var total_amount = parseFloat($("#total_amount").text());
		$("#create_discount_span").text('')
		$("#create_discount_amount").val(0)
		
		if(isNaN(discount)){
			$("#create_discount_value").val(0)
			return false
		}
		if(isNaN(total_amount)){
			total_amount = 0;
		}
		if(total_amount <= 0){
			$("#create_discount_value").val(0)
			return false
		}
		if(discount_type == 'amount'){
			var disc_perc = discount*100/total_amount;
			$("#create_discount_span").text(disc_perc+" %")
			$("#create_discount_amount").val(discount)
		}
		if(discount_type == 'percentage'){
			var disc_amount = discount*total_amount/100
			$("#create_discount_span").text(disc_amount+" Rs.")
			$("#create_discount_amount").val(disc_amount)
		}
		getTCSAmount()
		getInvoiceGrossAmount()
	}

	function getCustomerTCSValue(){

		var customer_id = $("#customerList").val();
		if (customer_id == '') {
			return false;
		}
		$("#tcs_value").val(0)
		$("#tcs_percentage").val(0)
		
		// $.ajax({
		// 	"url":"<?php //echo base_url()?>admin/SalesOrder/getCustomerTCSValue",
		// 	"method": "GET",
		// 	"data": { "customer_id": customer_id},
		// 	"dataType": "json",
		// 	"success": function(data){
		// 				if(data.status != 1){
		// 					return false
		// 				}

		// 				$("#tcs_value").val(data.tcs_value)
		// 				$("#tcs_percentage").val(data.tcs_percentage)
		// 				getTCSAmount()
		// 			}
		// })

		getTCSAmount();
	}
	
	function getTCSAmount(){

		// var total_amount = parseFloat($("#total_amount").text());
		// var tcs_value = parseFloat($("#tcs_value").val())
		// var tcs_percentage = parseFloat($("#tcs_percentage").val())
		// var freight_amount = parseFloat($("#create_freight_value").val())
		// var discount_amount = parseFloat($("#create_discount_amount").val())
		// var insurance_amount = parseFloat($("#create_insurance_amount").val())
		// var net_amount = 0;

		// if(isNaN(discount_amount)){
		// 	discount_amount = 0;
		// }
		// if(isNaN(freight_amount)){
		// 	freight_amount = 0;
		// }
		// if(isNaN(insurance_amount)){
		// 	insurance_amount = 0;
		// }
		// net_amount = total_amount - discount_amount + freight_amount + insurance_amount;

		// if(tcs_value > 5000000){
		//   $("#create_td_tcs_text").text("TCS @ " + tcs_percentage + "%")
		//   tcs_amount = 0

		//   tcs_amount = Math.round(net_amount*tcs_percentage/100)
		//   $("#create_td_tcs_value").text(tcs_amount.toFixed(2))
		//   $("#create_td_tcs_span").text(tcs_amount.toFixed(2))  
		// } else{
			
		// 	if(net_amount + tcs_value > 5000000){
		// 		var diff_amount = (net_amount + tcs_value) - 5000000;
		// 		$("#create_td_tcs_text").text("TCS @ " + tcs_percentage + "%")
		// 		tcs_amount = 0;
		// 		tcs_amount = Math.round(diff_amount*tcs_percentage/100);
		// 		$("#create_td_tcs_value").text(tcs_amount.toFixed(2))
		// 		$("#create_td_tcs_span").text(tcs_amount.toFixed(2))
		// 	} else{
		// 		$("#create_td_tcs_text").text('')
		// 		$("#create_td_tcs_value").text('')
		// 		$("#create_td_tcs_span").text('')
		// 	}
		// }

		$("#create_td_tcs_text").text('')
		$("#create_td_tcs_value").text('')
		$("#create_td_tcs_span").text('')
		getInvoiceGrossAmount()
	}

	function getInsurance(){
		var insurance = parseFloat($("#create_insurance_value").val())
		var insurance_type = $("#create_insurance_type").val()
		var total_amount = parseFloat($("#total_amount").text());
		$("#create_insurance_amount").val(0)
		$("#create_insurance_span").text('')
		
		if(isNaN(insurance)){
			$("#create_insurance_value").val(0)
			return false
		}
		if(isNaN(total_amount)){
			total_amount = 0;
		}
		if(total_amount <= 0){
			$("#create_insurance_value").val(0)
			return false
		}
		if(insurance_type == 'amount'){
			var insurance_perc = insurance*100/total_amount;
			$("#create_insurance_span").text(insurance_perc+" %")
			$("#create_insurance_amount").val(insurance)
		}
		if(insurance_type == 'percentage'){
			var insurance_amount = insurance*total_amount/100
			$("#create_insurance_span").text(insurance_amount+" Rs.")
			$("#create_insurance_amount").val(insurance_amount)
		}
		getTCSAmount()
		getInvoiceGrossAmount()
	}

	function getInvoiceGrossAmount(){
		var total_amount = parseFloat($("#total_amount").text());
		var freight_amount = parseFloat($("#create_freight_value").val())
		var discount_amount = parseFloat($("#create_discount_amount").val())
		var insurance_amount = parseFloat($("#create_insurance_amount").val())
		var tcs_amount = parseFloat($("#create_td_tcs_value").text())
		var currencyExchangeRate_inRupee = parseFloat($("#currencyExchangeRate_inRupee").val())
		$("#total_invoice_in_rupee").val(0);
		$("#total_invoice_inExportCurrency").val(0);

		if(isNaN(freight_amount)){
			discount_amount = 0;
		}
		if(isNaN(discount_amount)){
			discount_amount = 0;
		}
		if(isNaN(freight_amount)){
			freight_amount = 0;
		}
		if(isNaN(insurance_amount)){
			insurance_amount = 0;
		}
		if(isNaN(tcs_amount)){
			tcs_amount = 0;
		}

		var total_invoice_gross_amount = total_amount - discount_amount + freight_amount + insurance_amount + tcs_amount
		$("#total_invoice_in_rupee").val(total_invoice_gross_amount.toFixed(2));

		if (!isNaN(currencyExchangeRate_inRupee) && currencyExchangeRate_inRupee != '') {
			let amount = total_invoice_gross_amount / currencyExchangeRate_inRupee;
			amount = Math.round(amount);
			$("#total_invoice_inExportCurrency").val(amount.toFixed(2));
		}
		
	}
	
	$("#currencyExchangeRate_inRupee").on('change', function() {
		let currencyExchangeRate_inRupee = $(this).val();
		
		if (!isNaN(currencyExchangeRate_inRupee) && currencyExchangeRate_inRupee != '') {
			let total_invoice_gross_amount = $("#total_invoice_in_rupee").val();

			if (!isNaN(total_invoice_gross_amount) && total_invoice_gross_amount != '') {
				let amount = total_invoice_gross_amount / currencyExchangeRate_inRupee;
				amount = Math.round(amount);
				$("#total_invoice_inExportCurrency").val(amount.toFixed(2));
			}
		}
	});

</script>


