<style>
    #product_det_filter.dataTables_filter input {
        width: 130px;
    }

    input.scrolledTable {
        overflow-y: auto;
        clear: both;
    }

    .currency {
        text-align: right;
    }
</style>
<div>
    <div class="table-responsive scrolledTable">
        <hr style="border: 3px solid #e4eaec">
        <input type="hidden" name="salesorderid" id="salesorderid" value="<?php echo $salesorderid; ?>">
        <input type="hidden" id="fin_update_sales_channel_so" value="">
        <input type="hidden" id="update_vendor_id" value="">
        <input type="hidden" id="update_so_amount" value="">
        <input type="hidden" id="update_so_net_amount" value="">
        <h4>Order Details</h4>
        <table class="table table-striped DataTables" id="salesorder_det" cellspacing="0" align="left" style="width:90%;white-space:nowrap;">
            <thead>
                <th>SALESORDER ID</th>
                <th>SALES ORDER NUMBER</th>
                <th>VENDOR</th>
                <th>SALES REPRESENTATIVE</th>
                <th>STOCK TYPE</th>
                <th>STATUS</th>
                <th>PAYMENT MODE</th>
                <th>WAREHOUSE</th>
                <th>SALES CHANNEL</th>
                <th>CREATION DATE</th>
                <th>UPDATE DATE</th>
                <th>CREATED BY</th>
                <th>UPDATED BY</th>
                </tr>
            </thead>
        </table>
        <hr style="border: 3px solid #e4eaec">
        <h4>Remarks</h4>
        <table class="table table-stripped DataTables" id="remarks_table">
        </table>

        <tr>
            <td>REMARKS</td>
            <td><textarea id="remarks_header" class="form-control" name="remarks_header" maxlength="200"></textarea></td>
        </tr>
    </div>
    <hr style="border: 3px solid #e4eaec">
    <div class="table-responsive scrolledTable">
        <h4>Product Details</h4>
        <table class="table table-bordered table-stripped DataTables " id="product_det" style="margin-left:15px; width:90%;">
            <thead>
                <th>Device ID</th>
                <th>PRODUCT Name</th>
                <th>SKU</th>
                <th>CATEGORY</th>
                <th>GRADE</th>
                <th>SALES TERMS</th>
                <th>PRICE</th>
                <th>QTY</th>
                <th>AMOUNT</th>
            </thead>
            <tbody class="tbody2">
            </tbody>

        </table>
    </div>
    <button class="btn btn-purple" style="margin-left: 15px;" onclick="getYield()">Get Yield</button>
    <hr style="border: 3px solid #e4eaec">
    <div id="yield_data"></div>
    <hr style="border: 3px solid #e4eaec">
    <h4>Receipt Details</h4>

    <div class="table-responsive scrolledTable">
        <table class="table">
            <tr>
                <td>
                    <select id="update_select_receipt" class="form-control select_box" style="width: 300px;">
                        <option value="">SELECT RECEIPT</option>
                    </select>
                </td>
                <td style="text-align: left;">
                    <button class="btn btn-dark" onclick="addReceipt()">Add</button>
                </td>
            </tr>
        </table>

    </div>

    <table id="t_receipt_details" class="table" style="margin-left:15px;width:50%;">
        <thead>
            <th>Receipt No</th>
            <th>Receipt Type</th>
            <th>Account No</th>
            <th>Reference No</th>
            <th>Received Amount</th>
            <th>Available Amount</th>
            <th>Received Date</th>
            <th>Adjusted Amount</th>
            <th>balance Amount</th>
        </thead>
        <tbody id="receipt_table_tbody">
        </tbody>
    </table>

    <table>
        <tr>
            <td colspan="13"><button class="btn btn-primary" id="submit" name="action" onclick="submitForm('approve')" value="approve">Approve</button>
                &nbsp;&nbsp;&nbsp;&nbsp;<button class="btn btn-danger" id="submit" name="action" onclick="submitForm('reject')" value="reject">Reject</button>
                &nbsp;&nbsp;&nbsp;&nbsp;<button class="btn btn-red" id="cancel" type="button" onclick="window.location.replace('<?= base_url() ?>admin/Rfs/manage_rfs/null/2')">BACK</button></td>
        </tr>
    </table>
    </form>
</div>

<script>
    getVendorId();
    getReceiptDataforSOCreate();
    var applied_receipts = [];

    $(document).ready(function() {
        $('form').keydown(function(e) {
            if (e.keyCode == 13) {
                e.preventDefault();
                return false;
            }
        });
    });

    function addRowToPaymentTable() {
        var data = $('#tr_payment_details').html();
        $('#t_payment_details').find('tbody').append("<tr id='tr_payment_details' class='tr_payment_details'>" + data + "</tr>");
    }


    function IndianCurrency(rupees) {

        rupees = parseFloat(rupees)
        return rupees.toLocaleString('en-IN', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }

    function submitForm(action) {

        var remarks = $("#remarks_header").val();
        var salesorder_id = $("#salesorderid").val();
        var vendor_id = $("#update_vendor_id").val();
        var total_amount = $("#update_so_amount").val();
        var net_amount = $("#update_so_net_amount").val()
        var sales_channel = $("#fin_update_sales_channel_so").val()
        var total_adjusted_amount = 0;
        var check = 0;
        var receipt_details = [];
        var receiptDuplicates = [];

        $.each($(".tr_receipt_details"), function() {

            var receipt_id = $(this).find("input.receipt_input_receipt_id").val();
            var receipt_no = $(this).find(".td_receipt_no").text();
            var received_amount = $(this).find("input.receipt_input_received_amount").val();
            var adjusted_amount = $(this).find("input.receipt_input_adjusted_amount").val();
            var available_amount = $(this).find(".td_receipt_available_amount").text()

            if (parseFloat(adjusted_amount) > parseFloat(available_amount)) {
                toastr.error("Adjusted Amount exceeds Available Amount for " + receipt_no)
                check = 1;
                return false;
            }

            if (receiptDuplicates[receipt_id] == true) {
                toastr.error("Duplicate Record Added for " + receipt_no)
                check = 1;
                return false;
            } else {
                receiptDuplicates[receipt_id] = true;
            }

            total_adjusted_amount += parseFloat(adjusted_amount)

            if (parseFloat(adjusted_amount) > 0) {
                receipt_details.push({
                    "receipt_id": receipt_id,
                    "vendor_id": vendor_id,
                    "salesorder_id": salesorder_id,
                    "salesorder_amount": net_amount,
                    "receipt_amount": received_amount,
                    "adjusted_amount": adjusted_amount
                })
            }
            
        });
        
        if (check == 1) {
            return false
        }

        if (sales_channel == 'OFFLINE'){

            if (parseFloat(total_adjusted_amount) < (parseFloat(net_amount) - 5)) {

                toastr.error("Adjusted Amount Less than Sales Order Amount")
                return false
            }
            if (parseFloat(total_adjusted_amount) > (parseFloat(net_amount) + 5)) {

                toastr.error("Adjusted Amount exceeds Sales Order Amount")
                return false
            }

            if (sales_channel == 'OFFLINE' && total_adjusted_amount <= 0) {
                toastr.error("Please Add Receipts")
                return false
            }
        }

        var data = {
            "salesorder_id": salesorder_id,
            "action": action,
            "remarks_header": remarks,
            "receipt_details": receipt_details
        }
        var jsonObject = JSON.stringify(data)

        $("#submit").attr('disabled', true)
        $.ajax({
            url: "<?php echo base_url(); ?>admin/SalesOrder/update_salesorder",
            dataType: 'json',
            data: jsonObject,
            type: 'POST',
            success: function(data) {
                if (data.status == 1) {

                    if (data.message == 'approved') {
                        //alert('Sales Order Approved Successfully');
                    }
                    if (data.message == 'rejected') {
                        // alert('Sales Order Rejected Successfully');
                    }

                    window.location.replace("<?= base_url() ?>admin/Rfs/manage_rfs/null/2");

                } else {
                    $("#submit").attr("disabled", false);
                    toastr.error('Failed to Approve/Reject Sales Order');
                }
            },
            error: function() {
                $("#submit").attr("disabled", false);
                toastr.error('Failed to Approve/Reject Sales Order');
            }
        });
    }

    function getVendorId() {

        var salesorder_id = $("#salesorderid").val()
        $.ajax({
            type: "GET",
            url: "<?= base_url() ?>admin/Receipt/getSalesorderVendorId",
            data: {
                "salesorder_id": salesorder_id
            },
            dataType: "json",
            async: false,
            success: function(data) {

                if (data.status != '1') {
                    return false
                }
                $("#update_vendor_id").val(data.vendor_id)

            },
            error: function(error) {
                alert(error.responseJSON.message);
            }
        });
    }

    function getReceiptDataforSOCreate() {

        var vendor_id = $("#update_vendor_id").val()

        if (vendor_id == '' || vendor_id == null || vendor_id == '0') {
            return false
        }

        $.ajax({
            type: "GET",
            url: "<?= base_url() ?>admin/Receipt/getReceiptDataByVendor",
            data: {
                "vendor_id": vendor_id
            },
            dataType: "json",
            success: function(data) {

                if (data.status != '1') {
                    return false
                }

                $.each(data.result, function(i, v) {
                    var opt = '<option value="' + data.result[i].receipt_id + '">'
                    opt += data.result[i].receipt_no + '/' + data.result[i].received_date + '/' + data.result[i].received_amount
                    opt += '</option>'
                    $("#update_select_receipt").append(opt)
                })

            },
            error: function(error) {
                alert(error.responseJSON.message);
            }
        });
    }

    var ad_amount = 0;
    var a = false;
    function addReceipt() {

        var receipt_id = $("#update_select_receipt").val()
        var total_amount = $("#update_so_net_amount").val()

        if (receipt_id == '0' || receipt_id == '' || receipt_id == null || receipt_id == undefined) {
            toastr.error("Please select a Receipt")
            return false
        }


        $.ajax({
            "url": '<?= base_url() ?>admin/Receipt/getReceiptHeader',
            "data": {
                "receipt_id": receipt_id
            },
            "type": "GET",
            "dataType": "json",
            "success": function(data) {

                if (data.status != '1') {
                    toastr.error("Error: Failed to fetch Receipt Data")
                    return false
                }
        		
        		if(a == true){
        		    toastr.error("Error: Adjusted amount is already exceeds net invoice amount ")
                    return false
        	
        		}
                var result = data.data

                var adjusted_amount_float = parseFloat(result.adjusted_amount)

                if (isNaN(adjusted_amount_float)) {
                    adjusted_amount_float = 0
                }
                var available_amount = parseFloat(result.received_amount) - parseFloat(adjusted_amount_float)
                
                if (parseFloat(total_amount) <= available_amount) {
                    adjusted_amount = total_amount;
                    ad_amount += parseFloat(adjusted_amount);
                } else {
                    adjusted_amount = available_amount;
                    ad_amount += parseFloat(adjusted_amount);
                }
                var balance_amount = 0;
                if (ad_amount >= parseFloat(total_amount)) {
                    
                    balance_amount = ad_amount - total_amount;
                    adjusted_amount = adjusted_amount - balance_amount;
                    toastr.success("Added amount is enough for the net invoice amount")
                    a = true;
                }
                var receiptRow = '<tr class="tr_receipt_details">'
                receiptRow += '<td class="td_receipt_no">' + result.receipt_no + '</td>'
                receiptRow += '<td>' + result.receipt_type + '</td>'
                receiptRow += '<td>' + result.account_no + '</td>'
                receiptRow += '<td>' + result.reference_no + '</td>'
                receiptRow += '<td>' + result.received_amount + '</td>'
                receiptRow += '<td class="td_receipt_available_amount">' + available_amount + '</td>'
                receiptRow += '<td>' + result.received_date + '</td>'
                receiptRow += '<td><input class="receipt_input_adjusted_amount" value="' + adjusted_amount.toFixed(2) + '"></td>'
                receiptRow += '<td>' + balance_amount.toFixed(2) + '</td>'
                receiptRow += '<td onclick="delete_receipt_row(this)" class="bg-secondary delete">'
                receiptRow += '<img src="<?php echo base_url(); ?>assets/img/delete.png">'
                receiptRow += '</td>';

                receiptRow += '<input type="hidden" class="receipt_input_received_amount" value="' + result.received_amount + '">'
                receiptRow += '<input type="hidden" class="receipt_input_receipt_id" value="' + result.receipt_id + '">'
        
                receiptRow += '</tr>'
                
                $("#receipt_table_tbody").append(receiptRow)
                
                applied_receipts[result.receipt_id] = $('#update_select_receipt option:selected')[0].outerHTML
                // var optionselected =  $("#update_select_receipt").val($("#name option[selected]").val());
                $('#update_select_receipt option:selected').remove();
                $('#update_select_receipt').val('');
                $('#update_select_receipt').change();

            }
        })

    }

    $(document).ready(function() {
        var salesorderid = $("#salesorderid").val();

        var salestable = $('#salesorder_det').DataTable({
            "ajax": "<?php echo base_url(); ?>admin/SalesOrder/getSalesorderdets/?salesorderid=" + salesorderid,
            "aoColumnDefs": [{
                    "aTargets": 0,
                    "visible": false
                },
                {
                    "aTargets": 8,
                    "visible": false
                }
            ]
        })

        product_det();

        function product_det() {
            var total_amount = 0.0;
            var total_quantity = 0;
            var childtable = '';

            $.ajax({
                url: encodeURI("<?php echo base_url(); ?>web_api/getsalesorderdetails?salesorder_id=" + salesorderid),
                type: "GET",
                dataType: 'json',
                async: false,
                success: function(data) {
                    if (data.result == null) {
                        childtable += '<tr><td>No Records Found</td></tr>';
                    } else {
                        $.each(data.result, function(i, d) { // loop through data returned from ajax 
                            var variant = data.result[i].sku; //+"-"+data.result[i].ram+"-"+data.result[i].rom
                            if (variant == '---') {
                                variant = "";
                            }

                            var price = data.result[i].price;
                            var amount = data.result[i].amount;
                            total_amount = total_amount + parseFloat(amount);
                            total_quantity = total_quantity + parseInt(data.result[i].quantity);

                            childtable += '<tr>' +
                                '<td>' + data.result[i].device_id + '</td>' +
                                '<td>' + data.result[i].product_name + '</td>' +
                                '<td>' + data.result[i].sku + '</td>' +
                                '<td>' + data.result[i].category + '</td>' +
                                '<td>' + data.result[i].grade + '</td>' +
                                '<td>' + data.result[i].sales_terms + '</td>' +
                                '<td class="currency">' + IndianCurrency(parseFloat(price)) + '</td>' +
                                '<td>' + data.result[i].quantity + '</td>' +
                                '<td class="currency">' + IndianCurrency(parseFloat(amount)) + '</td>' +
                                '<input type="hidden" name="salesorder_item_id[]" value="' + data.result[i].salesorder_item_id + '">' +
                                '</tr>';
                        });
                    }
                }
            });
            childtable += '<tr><td>Total Quantity<td><td>' + parseInt(total_quantity) + '</td></tr>';
            childtable += '<tr><td>Total Amount<td><td class="currency">' + IndianCurrency(parseFloat(total_amount)) + '</td></tr>';
            childtable += getSalesorderChargesUpdate(total_amount)
            $("#update_so_amount").val(total_amount)

            $(".tbody2").append(childtable);
        }

        function getSalesorderChargesUpdate(total_amount) {
            var salesorder_charges = ''
            $.ajax({
                "url": "<?= base_url() ?>admin/SalesOrder/getSalesorderCharges",
                "method": "GET",
                "data": {
                    "salesorder_id": salesorderid
                },
                "dataType": "json",
                "async": false,
                "success": function(data) {
                    if (data.status != 1) {
                        return false
                    }
                    if (isNaN(parseFloat(data.tcs_amount))) {
                        data.tcs_amount = 0;
                    }
                    if (isNaN(parseFloat(data.discount_amount))) {
                        data.discount_amount = 0;
                    }
                    if (isNaN(parseFloat(data.freight_amount))) {
                        data.freight_amount = 0;
                    }
                    if (isNaN(parseFloat(data.insurance_amount))) {
                        data.insurance_amount = 0;
                    }
                    salesorder_charges += '<tr><td>Discount Amount<td><td class="currency">' + IndianCurrency(parseFloat(data.discount_amount)) + '</td></tr>';
                    salesorder_charges += '<tr><td>Freight Amount<td><td class="currency">' + IndianCurrency(parseFloat(data.freight_amount)) + '</td></tr>';
                    salesorder_charges += '<tr><td>Insurance Amount<td><td class="currency">' + IndianCurrency(parseFloat(data.insurance_amount)) + '</td></tr>';
                    if (data.tcs_amount > 0) {
                        salesorder_charges += '<tr><td>TCS ' + data.tcs_percent + '%<td><td class="currency">' + IndianCurrency(parseFloat(data.tcs_amount)) + '</td></tr>';
                    }

                    var gross_invoice_amount = parseFloat(total_amount) - parseFloat(data.discount_amount) + parseFloat(data.freight_amount) + parseFloat(data.insurance_amount) + parseFloat(data.tcs_amount)
                    salesorder_charges += '<tr><td>Gross Invoice Amount<td><td class="currency">' + IndianCurrency(parseFloat(gross_invoice_amount)) + '</td></tr>';
                    $("#update_so_net_amount").val(gross_invoice_amount)
                    $("#fin_update_sales_channel_so").val(data.sales_channel)
                }
            })
            return salesorder_charges
        }


        $.ajax({
            url: encodeURI("<?php echo base_url(); ?>web_api/getRemarks?id=" + salesorderid) + "&type=salesorder",
            type: "GET",
            dataType: 'json',
            success: function(data) {
                if (data.status == 1) {
                    var tableData = "<thead><th>Date</th><th>By</th><th>Remark</th></thead>"
                    $.each(data.remarks, function(i, v) {
                        tableData += "<tr><td>" + data.remarks[i].date + "</td><td>" + data.remarks[i].username + "</td><td>" + data.remarks[i].remark + "</td></tr>";
                    })
                    $("#remarks_table").append(tableData)
                }
            }
        })

    })

    function delete_receipt_row(btn) {

        var yes = confirm("Do you want to delete the record?")

        if (yes) {
            var receipt_id = $(btn).closest("tr").find('.receipt_input_receipt_id').val()
            var available_amount = $(btn).closest("tr").find('.td_receipt_available_amount').text()
            ad_amount = ad_amount - parseFloat(available_amount);
            a = false;
            var option = applied_receipts[receipt_id]
            $('#update_select_receipt').append(option)
            $(btn).closest("tr").remove();
        }

    }

    function getYield() {
        var salesorder_id = $("#salesorderid").val();
        var yield_data = ''
        $("#yield_data").text('')

        $.ajax({
            "url": "<?php echo base_url(); ?>admin/Yieldreports/getYieldOfflineSalesorder",
            "data": {
                "salesorder_id": salesorder_id
            },
            "type": "GET",
            "dataType": "json",
            "success": function(data) {
                var result = data.data[0]
                if (result.status != 1) {
                    return false
                }

                yield_data += '<table class="table table-striped">'
                yield_data += '<th>Total Amount</th><th>Sale Price<br>(Excl. GST)</th>'
                yield_data += '<th>Discount</th><th>Sale Price <br> (After Discount)'
                yield_data += '<th>GST</th><th>Cost Price</th><th>Yield Amount</th><th>Yield (%)</th>'
                yield_data += '<tr>'
                yield_data += '<td>' + result.total_amount + '</td>'
                yield_data += '<td>' + result.sale_price + '</td>'
                yield_data += '<td>' + result.discount + '</td>'
                yield_data += '<td>' + result.sale_price_discount + '</td>'
                yield_data += '<td>' + result.tax_amount + '</td>'
                yield_data += '<td>' + result.cost_price + '</td>'
                yield_data += '<td>' + result.yield_amount + '</td>'
                yield_data += '<td>' + result.yield_perc + '</td>'
                yield_data += '</tr>'
                yield_data += '</table>'

                $("#yield_data").append(yield_data)
            }
        })
    }
</script>