<head>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
</head>
<style>
td.details-control {
    background: url('<?php echo base_url() ?>assets/img/details_open.png') no-repeat center center;
    cursor: pointer;
}

tr.shown td.details-control {
    background: url('<?php echo base_url() ?>assets/img/details_close.png') no-repeat center center;
}

tr {
    height: 30px;
}

th,
td {
    white-space: nowrap;
}

td.spare_order_id {
    font-size: 0;
}


.sub_button {
    height: 30px;
    font-size: 12px;
    display: flex;
    align-items: center;
    font-size: larger !important;
}

label.sub_button.active {
    background-color: #4b91ea;
}

.approve {

    height: 30px;
    color: white;
    margin-top: 20px;
    background-color: green;

}

.report {

    height: 30px;
    color: white;
    margin-top: 20px;
    background-color: #C70039;

}

</style>

<!-- Shipping to address model start -->
<div class="modal fade" id="addLogisticModal" role="dialog" aria-labelledby="addLogisticModalLabel" data-backdrop="false">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
        
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel"> Update Payment</h5>
        </div>
    
      <div class="modal-body">
        <form>
         <div class="form-group">
            <label for="city-text" class="col-form-label">Sales Order No: </label>
            <input type="text" class="form-control" id="so_no" readonly>
          </div>
	<div class="form-group">
            <label for="city-text" class="col-form-label">Reference No:</label>
            <input type="text" class="form-control" id="reference_no" readonly>
          </div>
          <div class="form-group">
            <label for="sate-text" class="col-form-label">Amount: <span style="color:red; font-size:15px">*</span></label>
           <input type="text" class="form-control" id="update_payment" required>
          </div>
          
        </form>
      </div>
      
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-success" id="logistic_submit" value= "submit" onclick = "updateLogisticData()">ADD</button>
      </div>
    </div>
  </div>
</div>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	
	<label class="btn btn-primary" >
	<input type="radio" name="options" id="button_lp_pending">PENDING
	</label>
	<label class="btn btn-primary">
	<input type="radio" name="options" id="button_lp_approved">APPROVED
	</label>
</div>
<p style="line-height:10px;"></p>
<div class="table-responsive scrolledTable">
    <table class="table table-striped DataTables" style="margin-left:5px; width:100% !important" id="lpList_table">
        <thead>
            <tr>
                <th></th>
                <th></th>
                <th>Reference No</th>
                <th>Salesorder Code</th>
		<th>Invoice Code</th>
                <th>Logistic Name</th>
		<th>Approx Amount</th>
                <th>LP Invoice</th>
		<th>Invoice Amount</th>
		<th>Last Updated</th>
            </tr>
        </thead>
    </table>
</div>

<script type="text/javascript">

$(document).ready(function() {
    
   var status = "PENDING";
   lpApproxPayments(status)
   function lpApproxPayments(status){
	
   lpList_table = $('#lpList_table').DataTable({
	
        "paging": true,
        "destroy": true,
        "searching": true,
        "processing": true,
        "serverSide": false,
        //"scrollY": 390,
        //"scrollX": true,
        "scrollCollapse": true,
        //"autoWidth": false,
        "aaSorting": [],
        "ajax": {
            "url": "<?php echo base_url(); ?>admin/SalesOrder/getLPSloydPayments",
            "data": {status : status},
            "type": "GET",
            "dataSrc": "data"
        },
        "columns": [
	    {
                 "className": 'details-control',
                  "orderable": false,
                  "data": null,
                  "defaultContent": ''
            },
            {},
            {
                "data": "reference_no"
            },
            {
                "data": "salesorder_code"
            },
	    {
                "data": "invoice_code"
            },
	    {
                "data": "logistic_name"
            },
            {
                "data": "paid_amount"
            },
	    {
                "data": "invoice_no"
            },
	    {
                "data": "invoice_amount"
            },
	    
            {
                "data": "updated_date"
            }
        ],
        "order": [
            [1, 'asc']
        ],
        "columnDefs": [{
            "targets": 1,
            "data": null,
            "render": function(a, b, data, d) {
                
                var a = ''

                a += '<a onclick="openModel(this)">'
                a += '<span><i class="fa fa-edit"  alt="update" title="update" style="font-size:18px; color:#008000; cursor:pointer"></i></span>'
                a += '</a>'

                return a
            }
        }]
    });
   }

    $('#lpList_table tbody').on('click', 'td.details-control', function() {

            var tr = $(this).closest('tr');
            var row = lpList_table.row(tr);

            if (row.child.isShown()) {
                row.child.hide();
                tr.removeClass('shown');
            } else {
                // Open this row
                row.child(image_data(row.data())).show();
                tr.addClass('shown');
            }
        });
	$('#button_lp_pending').change(function() {
		lpApproxPayments('PENDING')

    	});
	$('#button_lp_approved').change(function() {
     		lpApproxPayments('APPROVED')

  	});
});



function image_data(d) {

        var base_url = "<?php echo base_url() ?>"
        var item = ''
        item += '<div>'
        item += '<table style="padding-left:50px;">'
        item += '<thead><tr>'
        item += '<th>Tampered<br>Photo</th>'
        item += '</tr></thead>'
        item += '<tbody><tr>'

        item += '<td><img src="' + base_url + d.invoice_image + '" style="height:50px; width:50px;" alt ="invoice Image"></td>'
        item += '</tr></tbody>'
        item += '</table></div>';
        return item
    }

function openModel(btn){

	var tr = $(btn).closest('tr');
        var row_data = lpList_table.row(tr).data();
	var so_no = row_data.salesorder_code
	var reference_no = row_data.reference_no;
	$('#so_no').val(so_no);
	$('#reference_no').val(reference_no);
	$('#update_payment').val(row_data.paid_amount);
	$('#addLogisticModal').modal('show');
}

function updateLogisticData() {

        var reference_no = $('#reference_no').val();
	var updated_amount = $('#update_payment').val();
	$.ajax({
                            type: "GET",
                            url: "<?php echo base_url(); ?>admin/SalesOrder/updatePayment",
                            data: {
                                reference_no: reference_no,
                                updated_amount: updated_amount
                            },
                            dataType: "json",
                            async: false,
                            success: function(data) {
    
                                if (data.status != 1) {
    
                                    toastr.error(data.msg)
                                    return false
                                }
                                toastr.success("Updated Successfully ")
                                location.reload();
                            },
                            "error": function(data) {
    
                                toastr.error("Failed to Update Active Status")
                                return false;
                            }
                        });       
    }


</script>