<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 td.block-control {
        background: url('<?php echo base_url();?>assets/img/cancel.png') no-repeat center center;
        cursor: pointer;
     }
	 tr { height: 30px; }
	 th, td { white-space: nowrap; }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	<label class="btn btn-primary" active>
	  <input type="radio" name="options" id="button_rfs2_online">RFS
	</label>
	<label class="btn btn-primary">
	  <input type="radio" name="options" id="button_blocked_online">BLOCKED
	</label>
</div>
<p style="line-height:10px;"></p>
<table class="table table-striped DataTables" style="margin-left:5px" id="deviceListTable">
	<thead>
		<tr>
			<th></th>
			<th></th>
			<th>DEVICE ID</th>
			<th>STATUS</th>
			<th>STOCK<br>TYPE</th>
			<th>PRODUCT</th>
			<th>SKU</th>
			<th>GRADE</th>
            <th>IMEI1</th>
            <th>IMEI2</th>						
		</tr>
	</thead>		
</table>
							
<script>
    var table;
    function format ( d ) {    
	   return '<table cellpadding="0" cellspacing="0" border="1" style="padding-left:50px;">'+
					'<tr><td>IMEI1/IMEI2</td><td>'+d.imei1_no+'/'+d.imei2_no+'</td></tr>'+
					'<tr><td>WH REMARKS</td><td>'+d.remark+'</td></tr>'+
					'<tr><td>Cert. REMARKS</td><td>'+d.checked_by+'</td></tr>'+
			'</table>';
	 }

    function getDevices(status){
		table = $('#deviceListTable').DataTable({
						"paging":true,
						"destroy":true,
						"searching":true,
						"processing": true,
						"serverSide": false,  
						"scrollY": 380,
						"scrollX":true,
						"scrollCollapse": true,
						"ajax": {
							"url": "<?php echo base_url(); ?>admin/certification/getDeviceDetailsByStatus",
							"type": "POST",
							"data":{'status':status,'saletype':'ONLINE'},
							"dataSrc": "data"
						},
						"columns": [
						    {
									"className":      'details-control',
									"orderable":      false,
									"data":           null,
									"defaultContent": ''
							},
							{
									"className":      'block-control',
									"orderable":      false,
									"data":           null,
									"defaultContent": ''
							},
							{ "data": "nhdin" },
							{ "data": "status"},		
							{ "data": "stock_type" },
							{ "data": "device_name" },
							{ "data": "SKU"},		
							{ "data": "certification_grade" },							
							{ "data": "imei1_no" },
							{ "data": "imei2_no" }
						]
		});
		
		
	} 

	 $(document).ready(function(){
		getDevices('RFS');
		
		$('#button_rfs2_online').change(function(){
			getDevices('RFS');
		});
		
		$('#button_blocked_online').change(function(){
			getDevices('BLOCKED');
		});
		
		$('#deviceListTable tbody').on('click', 'td.details-control', function () {
				var tr = $(this).closest('tr');
				var row = table.row( tr );
		 
				if ( row.child.isShown() ) {
					// This row is already open - close it
					row.child.hide();
					tr.removeClass('shown');
				}
				else {
					// Open this row
					row.child( format(row.data()) ).show();
					tr.addClass('shown');
				}
		});		
		
		
		$('#deviceListTable tbody').on('click', 'td.block-control', function () {
				var tr = $(this).closest('tr');
				var row = table.row( tr );
				var data = row.data();
				
				if(data.status == 'RFS'){
					status = 'BLOCKED';
				}else{
					status = 'RFS';
				}
				
				$.ajax({
					  type: "POST",
					  url: "<?php echo base_url(); ?>admin/certification/blockDevice",
					  data: JSON.stringify({deviceid: data.nhdin, status:status}),
					  success: function(data) {
						  table.clear();
						  table.ajax.reload();
						  table.draw();
					  },	  
					  error: function(error) {
						 alert(error);
					  }
				});
		});		
	
	 });
	 

 
</script>
	 
