<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 th, td { white-space: nowrap; }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
	
    <div class="btn-group btn-toolbar" data-toggle="buttons">

        <label class="btn btn-primary">
            <input type="radio" name="options" id="button_offline">OFFLINE
        </label>
        <label class="btn btn-primary active">
            <input type="radio" name="options" id="button_online" >ONLINE
        </label>

        <label class="btn"></label>

       
        <label class="btn btn-info active">
            <input type="radio" name="options" id="status_button_approved">APPROVED
        </label>
        
        <label class="btn btn-info">
            <input type="radio" name="options" id="status_button_invoiced" >INVOICED
        </label>
        <label class="btn btn-info">
            <input type="radio" name="options" id="status_button_fullreturn" >FULL RETURN
        </label>
        <label class="btn btn-info">
            <input type="radio" name="options" id="status_button_partreturn" >PART RETURN
        </label>
        
        
    </div>
</div>
<p style="line-height:10px;"></p>

<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="salesorderList_table">
	<thead>
		<tr>
            <th></th>
            <th>SALESORDER NO</th>
            <th>CUSTOMER NAME</th>
            <th>SALES CHANNEL</th>
            <th>SALES CHANNEL Ref Id.</th>
            <th>STATUS</th>
            <th>PAYMENT MODE</th>
            <th>SALESORDER AMOUNT</th>
			<th>CREATION DATE</th>					
		</tr>
	</thead>		
</table>
							
<script>
var payments_table;
var department_id = getUserdata('department_id')

function payments_childtable ( d ) {
	// `d` is the original data object for the row
	var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/Receipt/getReceiptDetailsBySalesorder?salesorder_id="+d.salesorder_id),
		type:"GET",
		dataType: 'json',
		async: false,
		success: function ( data ) {
			if(data.result==null){
				childtable+='<tr><td>No Records Found</td></tr>';
			}else{
				childtable += '<th>RECEIPT NO</th><th>RECEIPT TYPE</th><th>ACCOUNT NO</th><th>REF. NUMBER</th>'
                childtable += '<th>Received Amount</th><th>Adjusted Amount</th><th>Received DATE</th><th>Received/<br>Verified By</th>'

				$.each(data.result, function (i, d) { // loop through data returned from ajax 
				childtable+='<tr>'+
					'<td>'+data.result[i].receipt_no+'</td>'+
					'<td>'+data.result[i].receipt_type+'</td>'+
					'<td>'+data.result[i].account_no+'</td>'+
					'<td>'+data.result[i].reference_no+'</td>'+
					'<td>'+data.result[i].received_amount+'</td>'+					
					'<td>'+data.result[i].adjusted_amount+'</td>'+					
					'<td>'+data.result[i].received_date+'</td>'+					
					'<td>'+data.result[i].received_by+'</td>'+					
					'</tr>';
				});
			}
		}
	} );
		
	childtable+='</table>';
	return childtable
}

function getUserdata(attribute){
    
    var a='';
    $.ajax({
        "url": "<?=base_url()?>Web_api/getUserData/"+attribute,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            a = data.result;
        }
    })
     return a;
}


$(document).ready(function(){

    var saletype = 'ONLINE';
    var status = 'FINANCE_APPROVED';

    getPaymentList()

    function getPaymentList(){

        payments_table = $('#salesorderList_table').DataTable({
                        "paging":true,
                        "destroy":true,
                        "searching":true,
                        "processing": true,
                        "serverSide": false,  
                        "scrollY": 390,
                        "scrollX": true,
                        "scrollCollapse": true,
                        //"autoWidth": false,
                        "aaSorting": [1, 'asc'],
                        "ajax": {
                            "url": "<?php echo base_url(); ?>admin/Receipt/getSalesorderList",
							"data": {'saletype': saletype, "status": status},
							"type": "GET",
                            "dataSrc": "data"
                        },
                        "columns": [
                            {
                                    "className":      "details-control",
                                    "orderable":      false,
                                    "data":           null,
                                    "defaultContent": ''
                            },
                            { "data": "salesorder_code", "type":"any-number"},
                            { "data": "vendor_name" },	
                            { "data": "sales_channel" },	
                            { "data": "saleschannel_ref_id" },
                            { "data": "status" },
                            { "data": "payment_mode" },								
                            { "data": "total_amount" },									
                            { "data": "creation_date" },
                        ]
        });

    } 

    $('#salesorderList_table tbody').on('click', 'td.details-control', function () {
        
        var tr = $(this).closest('tr');
        var row = payments_table.row( tr );

        if ( row.child.isShown() ) {

            row.child.hide();
            tr.removeClass('shown');

        }else {
            row.child( payments_childtable(row.data()) ).show();
            tr.addClass('shown');
        }
    }) ;


    $('#button_offline').change(function(){
        saletype = 'OFFLINE'
        getPaymentList()
    });
    
    $('#button_online').change(function(){
        saletype = 'ONLINE'
        getPaymentList()
    });


    $('#status_button_pending').change(function(){
        status = 'FINANCE_PENDING';
        getPaymentList()
    });
    
    $('#status_button_approved').change(function(){
        status = 'FINANCE_APPROVED';
        getPaymentList()
    });
    
    $('#status_button_rejected').change(function(){
        status = 'FINANCE_REJECTED';
        getPaymentList()
    });
    
    $('#status_button_invoiced').change(function(){
        status = 'INVOICED';
        getPaymentList()
    });

    $('#status_button_fullreturn').change(function(){
        status = 'FULL_RETURN';
        getPaymentList()
    });

    $('#status_button_partreturn').change(function(){
        status = 'PART_RETURN';
        getPaymentList()
    });
    
    $('#status_button_canceled').change(function(){
        status = 'CANCELED';
        getPaymentList()
    });

    $('#status_button_wh_rejected').change(function(){
        status = 'WAREHOUSE_REJECTED';
        getPaymentList()
    });

    $('#status_button_void').change(function(){
        status = 'VOID';
        getPaymentList()
    });

})

</script>
	 
