<style>
     td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
     }
     tr.shown td.details-control {
        background: url('<?php echo base_url();?>assets/img/details_close.png') no-repeat center center;
     }
	 tr { height: 30px; }
	 th, td { white-space: nowrap; }
</style>

<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;"> 
    <div class="col-md-8  col-sm-8" style="padding:0px">
    
        <div class="form-group">
            <label class="col-lg-2 control-label">FROM DATE</label>
            <div class="col-lg-3">
               <input type="date" class="form-control" id="input_from_date">
            </div> 
            
            <label class="col-lg-2 control-label">TO DATE</label>
            <div class="col-lg-3">
               <input type="date" class="form-control" id="input_to_date">
            </div> 

            <button type="button" class="btn btn-success" id="download_receiptList_excel_report" onclick="getReceiptListCsv()" >
                <span class="fa fa-file-excel-o" ></span>&nbsp;&nbsp;Download
            </button>
        </div>
    </div>

    
</div>

<p style="line-height:10px;"></p>

<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="receiptList_table">
	<thead>
		<tr>
            <th></th>
            <th></th>
            <th>RECEIPT<br> NUMBER</th>
            <th>SALES ORDER<br> NO</th>
            <th>INVOICE<br> NO</th>
            <th>CUSTOMER<br> NAME</th>
            <th>RECEIPT<br> TYPE</th>
            <th>REFERENCE<br> NUMBER</th>
            <th>VOUCHER NO</th>
            <th>VOUCHER<br>VALIDITY</th>
            <th>RECEIVED<br> AMOUNT</th>
            <th>ADJUSTED<br> AMOUNT</th>
            <th>ACCOUNT<br> NUMBER</th>
            <th>RECEIVED/ <br> VERIFIED BY</th>
			<th>RECEIVED<br> DATE</th>			
			<th>CREATED<br> BY</th>			
			<th>CREATION<br> DATE</th>			
		</tr>
	</thead>		
</table>
							
<script>
var receipt_table;
var department_id = getUserdata('department_id')

function getReceiptListCsv(){

        var from_date = $("#input_from_date").val()
        var to_date = $("#input_to_date").val()

        if(from_date == '' || from_date == null || from_date == '0' || from_date == 'null'){
            alert("Please select From Date")
            return false
        }

        if(to_date == '' || to_date == null || to_date == '0' || to_date == 'null'){
            alert("Please select To Date")
            return false
        }

        window.open("<?=base_url()?>admin/Receipt/downloadCsvgetReceiptList?from_date="+from_date+"&to_date="+to_date, '_blank')

}

function getUserdata(attribute){
    
    var a='';
    $.ajax({
        "url": "<?=base_url()?>Web_api/getUserData/"+attribute,
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            a = data.result;
        }
    })
     return a;
}


$(document).ready(function(){

    getReceiptList()

    function getReceiptList(){

        receiptList_table = $('#receiptList_table').DataTable({
                        "paging":true,
                        "destroy":true,
                        "searching":true,
                        "processing": true,
                        "serverSide": false,  
                        "scrollY": 390,
                        "scrollX": true,
                        "scrollCollapse": true,
                        //"autoWidth": false,
                        "aaSorting": [1, 'asc'],
                        
                        "ajax": {
                            "url": "<?php echo base_url(); ?>admin/Receipt/getReceiptList",
							"data": {},
							"type": "GET",
                            "dataSrc": "data"
                        },
                        "columns": [
                            {       "className":      "details-control",
                                    "orderable":      false,
                                    "data":           null,
                                    "defaultContent": ''
                            },
                            {
                                "data": function(data){
                                    if(data.adjusted_count == 0 && department_id == 6){
                                    return '<a href="<?=base_url()?>admin/Receipt/editReceiptForm/'+data.receipt_id+'" class="fa fa-edit"></a>'
                                }else{
                                    return ''
                                }
                                }
                            },
                            { "data": "receipt_no", "type":"any-number"},
                            { "data": "salesorder_code" },	
                            { "data": "invoice_code" },	
                            { "data": "vendor_name" },	
                            { "data": "receipt_type" },	
                            { "data": "reference_no" },
                            { "data": "voucher_no" },	
                            { "data": "voucher_valid" },	
                            { "data": "received_amount" },								
                            { "data": "adjusted_amount" },	
                            { "data": "account_no" },
                            { "data": "received_by" },							
                            { "data": "received_date" },									
                            { "data": "CREATED_BY" },
                            { "data": "CREATION_DATE" },
                        ]
        });

    } 

    $('#receiptList_table tbody').on('click', 'td.details-control', function () {
        
        var tr = $(this).closest('tr');
        var row = receiptList_table.row( tr );

        if ( row.child.isShown() ) {

            row.child.hide();
            tr.removeClass('shown');

        }else {
            row.child( receipts_childtable(row.data()) ).show();
            tr.addClass('shown');
        }
    }) ;

})

function receipts_childtable ( d ) {

	// `d` is the original data object for the row
	var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';
		$.ajax( {
		url: encodeURI("<?php echo base_url(); ?>admin/Receipt/getSalesordersByReceipt"),
		type:"GET",
        data: { "receipt_id": d.receipt_id},
		dataType: 'json',
		async: false,
		success: function ( data ) {
			if(data.result==null){
				childtable+='<tr><td>No Records Found</td></tr>';
			}else{
				childtable += '<th>Sales Order NO</th><th>Customer Name</th><th>Status</th><th>Adjusted Amount</th>'
                childtable += '<th>Sales Order Amount</th><th>Creation Date</th>'

				$.each(data.result, function (i, d) { // loop through data returned from ajax 
				childtable+='<tr>'+
					'<td>'+data.result[i].salesorder_code+'</td>'+
					'<td>'+data.result[i].vendor_name+'</td>'+
					'<td>'+data.result[i].status+'</td>'+
					'<td>'+data.result[i].adjusted_amount+'</td>'+
					'<td>'+data.result[i].total_amount+'</td>'+
					'<td>'+data.result[i].creation_date+'</td>'+									
					'</tr>';
				});
			}
		}
	} );
		
	childtable += '</table>';
    childtable += getEcomBreakdown(d.receipt_id)
	return childtable
}

function getEcomBreakdown(receipt_id){debugger

    receipt_id = parseInt(receipt_id)
    var breakdown_rows = ''
    if(isNaN(receipt_id) || receipt_id <= 0){
        return breakdown_rows
    }

    $.ajax({
        "url": "<?=base_url()?>admin/Receipt/getEcomBreakdown",
        "type": "get",
        "data": {"receipt_id": receipt_id},
        "dataType": "json",
        "async": false,
        "success": function(data){

            if(data.status != 1){
                return breakdown_rows
            }
            breakdown_rows += '<h4>Breakdown Details</h4>'
            breakdown_rows += '<table class="table" style="margin-left:15px;">'
            breakdown_rows += '<tr><th>CHARGES</th><th>FEE</th><th>TAX AMOUNT</th><th>TOTAL AMOUNT</th></tr>'

            breakdown_rows += '<tr>'
            breakdown_rows += '<td>COMMISSION CHARGES</td>'
            breakdown_rows += '<td>'+data.result.commission_fee+'</td>'
            breakdown_rows += '<td>'+data.result.commission_fee_tax+'</td>'
            breakdown_rows += '<td>'+data.result.commission_fee_total+'</td>'
            breakdown_rows += '</tr>'
            
            breakdown_rows += '<tr>'
            breakdown_rows += '<td>FIXED CLOSING FEE</td>'
            breakdown_rows += '<td>'+data.result.fixed_closing_fee+'</td>'
            breakdown_rows += '<td>'+data.result.fixed_closing_fee_tax+'</td>'
            breakdown_rows += '<td>'+data.result.fixed_closing_fee_total+'</td>'
            breakdown_rows += '</tr>'
            
            breakdown_rows += '<tr>'
            breakdown_rows += '<td>COLLECTION FEE</td>'
            breakdown_rows += '<td>'+data.result.collection_fee+'</td>'
            breakdown_rows += '<td>'+data.result.collection_fee_tax+'</td>'
            breakdown_rows += '<td>'+data.result.collection_fee_total+'</td>'
            breakdown_rows += '</tr>'
            
            breakdown_rows += '<tr>'
            breakdown_rows += '<td>PICK & PACK FEE</td>'
            breakdown_rows += '<td>'+data.result.pick_pack_fee+'</td>'
            breakdown_rows += '<td>'+data.result.pick_pack_fee_tax+'</td>'
            breakdown_rows += '<td>'+data.result.pick_pack_fee_total+'</td>'
            breakdown_rows += '</tr>'
            
            breakdown_rows += '<tr>'
            breakdown_rows += '<td>WEIGHT HANDLING FEE</td>'
            breakdown_rows += '<td>'+data.result.weight_handling_fee+'</td>'
            breakdown_rows += '<td>'+data.result.weight_handling_fee_tax+'</td>'
            breakdown_rows += '<td>'+data.result.weight_handling_fee_total+'</td>'
            breakdown_rows += '</tr>'
            
            breakdown_rows += '<tr>'
            breakdown_rows += '<td>F1 SERVICES FEE</td>'
            breakdown_rows += '<td>'+data.result.f1_services_fee+'</td>'
            breakdown_rows += '<td>'+data.result.f1_services_fee_tax+'</td>'
            breakdown_rows += '<td>'+data.result.f1_services_fee_total+'</td>'
            breakdown_rows += '</tr>'
            
            breakdown_rows += '<tr>'
            breakdown_rows += '<td>TCS</td>'
            breakdown_rows += '<td>'+data.result.tcs_fee+'</td>'
            breakdown_rows += '<td>'+data.result.tcs_fee_tax+'</td>'
            breakdown_rows += '<td>'+data.result.tcs_fee_total+'</td>'
            breakdown_rows += '</tr>'
            
            breakdown_rows += '<tr>'
            breakdown_rows += '<td style="text-align:left">COURIER FEE</td>'
            breakdown_rows += '<td id="courier_local_fee">'+data.result.courier_fee+'</td>'
            breakdown_rows += '<td id="courier_local_fee_tax">'+data.result.courier_fee_tax+'</td>'
            breakdown_rows += '<td id="courier_local_fee_total">'+data.result.courier_fee_total+'</td>'
            breakdown_rows += '</tr>'
            
            breakdown_rows += '<tr style="font-weight:700">'
            breakdown_rows += '<td>TOTAL AMOUNT</td>'
            breakdown_rows += '<td></td>'
            breakdown_rows += '<td></td>'
            breakdown_rows += '<td>'+data.result.remittance_amount+'</td>'
            breakdown_rows += '</tr>'
            breakdown_rows += '</table>'

            
        }
    })

    return breakdown_rows
}



</script>
	 
