<input id="edit_receipt_id" type="hidden" value="<?= $edit_receipt_id ?>">

<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;">
    <div class="col-md-6 col-sm-6 col-xs-6" style="padding:0px">
        <div class="form-group">
            <label class="control-label col-md-4 col-sm-4 col-xs-4">Receipt No:</label>
            <div class="col-md-8 col-sm-8 col-xs-8">
                <input id="edit_receipt_no" type="text" class="form-control" readonly>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-md-4 col-sm-4 col-xs-4">Select Vendor</label>
            <div class="col-md-8 col-sm-8 col-xs-8">
                <select id="edit_vendor_id" class="form-control select_box" style="width:100%" >
                    <option value="">Select Vendor</option>
                </select>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-md-4 col-sm-4 col-xs-4">Receipt Date:</label>
            <div class="col-md-8 col-sm-8 col-xs-8">
                <input id="edit_receipt_date" type="date" class="form-control">
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-md-4 col-sm-4 col-xs-4">Receipt Type:</label>
            <div class="col-md-8 col-sm-8 col-xs-8">
                <select id="edit_select_receipt_type" class="form-control select_box" style="width:100%" onchange="receiptEditTypeChange()">
                    <option value="">SELECT RECEIPT TYPE</option>
                </select>
            </div>
        </div>
        <div
        <div class="form-group">
            <label class="control-label col-md-4 col-sm-4 col-xs-4">Bank Account:</label>
            <div class="col-md-8 col-sm-8 col-xs-8">
                <select id="edit_bank_account_id" class="form-control select_box" style="width: 100%;">
                    <option value="">Select Bank Account</option>
                </select>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-md-4 col-sm-4 col-xs-4">Reference No</label>
            <div class="col-md-8 col-sm-8 col-xs-8">
                <input id="edit_reference_no" type="text" class="form-control">
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-md-4 col-sm-4 col-xs-4">Receipt Amount:</label>
            <div class="col-md-8 col-sm-8 col-xs-8">
                <input id="edit_receipt_amount" type="text" class="form-control">
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-md-4 col-sm-4 col-xs-4">Received Or Verified By:</label>
            <div class="col-md-8 col-sm-8 col-xs-8">
                <input id="edit_received_verified_by" type="text" class="form-control">
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-md-4 col-sm-4 col-xs-4">Generate Voucher</label>
            <div class="col-md-8 col-sm-8 col-xs-8">
                <!-- radio Button yes/no -->
                <div class="radio">
                    <label>
                        <input type="radio" name="edit_generate_voucher" id="edit_generate_voucher_yes" value="yes">
                        Yes
                    </label>
                    <label>
                        <input type="radio" name="edit_generate_voucher" id="edit_generate_voucher_no" value="no">
                        No
                    </label>
                </div>
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-md-4 col-sm-4 col-xs-4"></label>
            <div class="col-md-2 col-sm-2 col-xs-2">
                <button id="edit_receipt_btn" class="btn btn-primary" style="width:100%;" onclick="editReceipt()">Submit</button>
            </div>
            <div class="col-md-2 col-sm-2 col-xs-2">
                <button id="back_receipt_btn" class="btn btn-grey" style="width:100%;">Back</button>
            </div>
        </div>
    </div>
</div>

<script>
    getEditReceiptDetails()

    function checkNull(entity, msg) {
        if (entity == null || entity == "" || entity == undefined || entity == "undefined") {
            return msg;
        }
        return '';
    }

    function receiptEditTypeChange(){
        var receipt_type = $("#edit_select_receipt_type").val();
        if(receipt_type == 'CASH'){
            $("#edit_bank_account_id").val('');
            $("#edit_bank_account_id").prop('disabled', true);
        }else{
            $("#edit_bank_account_id").prop('disabled', false);
        }
    }

    function getEditReceiptDetails() {
        var receipt_id = $('#edit_receipt_id').val();
        var requiredfield = "";

        if (requiredfield != "") {
            toastr.error("Required Field Missing", requiredfield);
            return;
        }

        $.ajax({
            url: "<?= site_url('admin/Receipt/getEditReceiptData') ?>",
            type: "get",
            data: {
                receipt_id: receipt_id
            },
            dataType: "json",
            success: function(data) {
                if (data.status == 1) {
                    getEditVendorList();

                    dropdownEdit('RECEIPT_TYPE', 'edit_select_receipt_type');
                    dropdownEdit('BANK_ACCOUNTS', 'edit_bank_account_id');
                    dropdown('RECEIPT_TYPE', 'edit_select_receipt_type');
                    
                    $('#edit_receipt_no').val(data.result.receipt_no);
                    $('#edit_vendor_id').val(data.result.vendor_id);
                    $("#edit_bank_account_id").val(data.result.account_no);
                    $('#edit_receipt_date').val(data.result.received_date);
                    $('#edit_select_receipt_type').val(data.result.receipt_type);
                    $('#edit_reference_no').val(data.result.reference_no);
                    $('#edit_receipt_amount').val(data.result.received_amount);
                    $('#edit_received_verified_by').val(data.result.received_or_verified_by);

                    if(data.result.voucher_no == null){
                        data.result.voucher_no = '';
                    }
                    if(data.result.voucher_no.length>0){
                        $('#edit_generate_voucher_yes').prop('checked', true);
                    }else{
                        $('#edit_generate_voucher_no').prop('checked', true);
                    }

                    $('#edit_vendor_id').change()
                    $('#edit_bank_account_id').change()
                    $('#edit_select_receipt_type').change()
                } else {
                    toastr.error("Error: Failed to Get Receipt Data");
                }
            }
        })
    }

    function dropdownEdit(type, select_id) {
        $.ajax({
            type: "GET",
            url: "<?= base_url() ?>admin/DropDownItems/getItems?type=" + type,
            data: {},
            dataType: "json",
            async: false,
            success: function(data) {
                $.each(data, function(i, v) {
                    $("#" + select_id).append('<option value="' + data[i].name + '">' + data[i].name + '</option>')
                })
            },
            error: function(error) {
                alert(error.responseJSON.message);
            }
        });
    }

    function getEditVendorList() {
        $.ajax({
            url: "<?= site_url('Web_api/getVendorList') ?>",
            type: "get",
            dataType: "json",
            async: false,
            success: function(data) {
                var html = '';
                for (var i = 0; i < data.result.length; i++) {
                    html += '<option value="' + data.result[i].vendor_id + '">' + data.result[i].vendor_id + '/' + data.result[i].vendor_name + '</option>';
                }
                $('#edit_vendor_id').append(html);
            },
            error: function(data) {
                toastr.error("Error: Failed to Get Vendor List");
            }
        })
    }

    function getReceiptTypeList() {
        $.ajax({
            url: "<?= site_url('Receipt/getReceiptTypeList') ?>",
            type: "get",
            dataType: "json",
            success: function(data) {
                if (data.status == 1) {
                    var html = '';
                    html += '<option value="">SELECT RECEIPT TYPE</option>';
                    
                    for (var i = 0; i < data.receipt_type_list.length; i++) {
                        html += '<option value="' + data.receipt_type_list[i].receipt_type_id + '">' + data.receipt_type_list[i].receipt_type_name + '</option>';
                    }
                    
                    $('#edit_select_receipt_type').html(html);
                } else {
                    toastr.error("Error: Failed to Get Receipt Type List");
                }
            }
        })
    }

    function editReceipt() {
        var receipt_id = $('#edit_receipt_id').val();
        var vendor_id = $('#edit_vendor_id').val();
        var bank_account_id = $('#edit_bank_account_id').val();
        var receipt_date = $('#edit_receipt_date').val();
        var receipt_type = $('#edit_select_receipt_type').val();
        var reference_no = $('#edit_reference_no').val();
        var receipt_amount = $('#edit_receipt_amount').val();
        var received_or_verified_by = $('#edit_received_verified_by').val();
        var generate_voucher = $('#edit_generate_voucher_yes').is(':checked')?'yes':'no';
        var requiredfield = "";

        requiredfield += checkNull(vendor_id, "Vendor, ");
        requiredfield += checkNull(receipt_date, "Receipt Date,");
        requiredfield += checkNull(receipt_type, "Receipt Type,");
        requiredfield += checkNull(receipt_amount, "Receipt Amount,");
        requiredfield += checkNull(received_or_verified_by, "Received/Verified By,");
        
        if(receipt_type != 'CASH'){
            requiredfield += checkNull(bank_account_id, "Bank Account,");
            requiredfield += checkNull(reference_no, "Reference No,");
        }

        if (requiredfield != "") {
            toastr.error("Required Field Missing", requiredfield);
            return;
        }

        if (receipt_amount <= 0) {
            toastr.error("Receipt Amount Should be Greater than Zero");
            return;
        }

        if (receipt_type == 'CASH') {
            bank_account_id = '';
        }

        var JsonObject = {
            receipt_id: receipt_id,
            vendor_id: vendor_id,
            bank_account_id: bank_account_id,
            receipt_date: receipt_date,
            receipt_type: receipt_type,
            reference_no: reference_no,
            receipt_amount: receipt_amount,
            received_or_verified_by : received_or_verified_by,
            generate_voucher : generate_voucher
        }

        $.ajax({
            url: "<?= site_url('admin/Receipt/editReceipt') ?>",
            type: "post",
            data: JSON.stringify(JsonObject),
            dataType: "json",
            success: function(data) {
                if (data.status == 1) {
                    toastr.success("Receipt Updated Successfully");
                    window.location.href = "<?= site_url('admin/Receipt/manage_receipt') ?>";
                } else {
                    toastr.error("Error: Failed to Update Receipt");
                }
            }
        })
    }


</script>