<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;"> 
    <div class="col-md-4  col-sm-4" style="padding:0px">
    
        <div class="form-group">
            <label class="col-lg-4 control-label">VENDOR</label>
            <div class="col-lg-8">
                <select id="select_vendor" class="form-control select_box"  style="width:100%" onchange="getSalesordersByVendor()">
                        <option value="">SELECT CUSTOMER</option>
                </select>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">SALESORDER NO</label>
            <div class="col-lg-8">
                <select id="select_salesorder" class="form-control select_box" onchange="multiReceiptforSO()"  style="width:100%">
                        <option value="">SELECT SALESORDER</option>
                </select>
            </div> 
        </div>
    </div>

    <div class="col-md-4 col-sm-2 col-xs-2" style="padding:0px">
    
        <div class="form-group">
            <label class="col-lg-4 control-label">AMOUNT</label>
            <div class="col-lg-8 control-label" style="text-align:left;">
                <span id="salesorder_amount"></span>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">DATE</label>
            <div class="col-lg-8 control-label" style="text-align:left;">
            <span id="salesorder_date"></span>
            </div> 
        </div>
    </div>

    <div class="col-md-3 col-sm-3 col-xs-3" style="padding:0px">
    
        <div class="form-group">
            <label class="col-lg-4 control-label">Invoice No</label>
            <div class="col-lg-8 control-label" style="text-align:left;">
                <span id="salesorder_invoice_no"></span>
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">Status</label>
            <div class="col-lg-8 control-label" style="text-align:left;">
            <span id="salesorder_status"></span>
            </div> 
        </div>
    </div>
</div>


<hr style="border: 3px solid #e4eaec">
<h4 style="margin-left: 15px;">Previous Receipt Details</h4>
<div id="receipt_details_div" class="table-responsive">

</div>

<hr style="border: 3px solid #e4eaec;">

<div class="table-responsive scrolledTable">
    <table class="table">
        <tr>
            <td>
                <select id="multiple_select_receipt" class="form-control select_box" style="width: 300px;" >
                    <option value="">SELECT RECEIPT</option>
                </select>
            </td>
            <td style="text-align: left;">
                <button type="button" class="btn btn-dark" onclick="addReceipttoTable()">Add</button>
            </td>
        </tr>
    </table>
</div>

<table id="t_receipt_details" class="table" style="margin-left:15px;">
        <thead>
            <th>Receipt No</th>
            <th>Receipt Type</th>
            <th>Account No</th>
            <th>Reference No</th>
            <th>Received Amount</th>
            <th>Available Amount</th>
            <th>Received Date</th>
            <th>Adjusted Amount</th>
        </thead>
        <tbody id="receipt_table_tbody">
		</tbody>		
    </table>

<table style="float: center; width:100%;">
	<tr>
        <td colspan="13">
            <button class="btn btn-red" id="cancel" type="button" onclick="window.location.replace('<?=base_url()?>admin/Receipt/manage_receipt')">BACK</button>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <button class="btn btn-primary" id="submit_multiple_receipt" name="action" onclick="addMultipleReceipt()"  >SUBMIT</button>
        </td>
    </tr>
            
	</table>
<script>
    var amounts = [];
    var dates = [];
    var statuses = [];
    var invoice_nos = [];
    var adjusted_amount_prev = 0;
    //getVendorList()

    function IndianCurrency(rupees){
		rupees=parseFloat (rupees)
		var rupee_str = rupees.toLocaleString ('en-IN',
										{minimumFractionDigits : 2,
										maximumFractionDigits : 2}
									);
        if(rupee_str == NaN || rupee_str =='NaN'){
            rupee_str = '0.00'
        }
        return rupee_str
	}

    function getVendorList(){
    
        $.ajax({
            "url": "<?=base_url()?>Web_api/getVendorList/",
            "type": "GET",
            "dataType": "json",
            "async": false,
            "success": function(data){
                
                $.each(data.result, function (i, d) { // loop through data returned from ajax
                    var a = '<option value="'+data.result[i].vendor_id+'">'+data.result[i].vendor_name+'</option>';
                    $("#select_vendor").append(a)
                })
            },
            "error": function (){
                toastr.error("Failed to get Customer List")
            }
        })
    }

    function getSalesordersByVendor(){
       
       var vendor_id = $("#select_vendor").val();
       dates = [];
       amounts = [];
       statuses = [];
       invoice_nos = [];
       $("#select_salesorder").empty();
       $("#select_salesorder").append("<option value=''>SELECT SALES ORDER</option>")
       $("#select_salesorder").change();

       if(vendor_id == "" || vendor_id == null){
           return false;
       }

        $.ajax({
            "url": "<?=base_url()?>admin/Receipt/getSalesordersByVendor/"+vendor_id,
            "type": "GET",
            "dataType": "json",
            "async": false,
            "success": function(data){
                
                $.each(data.result, function (i, d) { // loop through data returned from ajax
                    var a = '<option value="'+data.result[i].salesorder_id+'">'+data.result[i].salesorder_code+'</option>';
                    $("#select_salesorder").append(a)
                    
                    dates[data.result[i].salesorder_id] = data.result[i].salesorder_date
                    amounts[data.result[i].salesorder_id] = data.result[i].total_amount
                    statuses[data.result[i].salesorder_id] = data.result[i].status
                    invoice_nos[data.result[i].salesorder_id] = data.result[i].invoice_no
                })

                getReceiptDataforSOCreate()
            },
            "error": function (){
                toastr.error("Failed to get Salesorders List")
            }
        })
    }


    function addMultipleReceipt(){

        var salesorder_id = $("#select_salesorder").val();
        var vendor_id = $("#select_vendor").val();
        var total_amount = amounts[salesorder_id]
        var total_adjusted_amount = 0;
        var check = 0
        var receipt_details = [];
        var receiptDuplicates = [];

        if(salesorder_id == '' || salesorder_id == null || salesorder_id == 0){
            alert("Select Salesorder")
            return false
        }

        $.each($(".tr_receipt_details"), function() {

            var receipt_id = $(this).find("input.receipt_input_receipt_id").val();
            var receipt_no = $(this).find("td.td_receipt_no").text()
            var received_amount = $(this).find("input.receipt_input_received_amount").val();
            var adjusted_amount = $(this).find("input.receipt_input_adjusted_amount").val();
            var available_amount = $(this).find("td.td_receipt_available_amount").text()

            if(parseFloat(adjusted_amount) > parseFloat(available_amount)){
                toastr.error("Adjusted Amount exceeds Available Amount for "+receipt_no)
                check = 1;
                return false;
            }

            if(receiptDuplicates[receipt_id] == true){
                toastr.error("Duplicate Record Added for "+receipt_no)
                check = 1;
                return false;
            }else{
                receiptDuplicates[receipt_id] = true;
            }

            total_adjusted_amount += parseFloat(adjusted_amount)

            if(parseFloat(adjusted_amount)>0){
                receipt_details.push({
                            "receipt_id" : receipt_id,
                            "vendor_id" : vendor_id,
                            "salesorder_id" : salesorder_id,
                            "salesorder_amount" : total_amount,
                            "receipt_amount" : received_amount,
                            "adjusted_amount" : adjusted_amount

                        })
            }
        });

        if(check == 1){
            return false
        }

        if(receipt_details.length == 0){
            toastr.error('Please Add Receipt Details'); 	
            return false;
        }

        if(parseFloat(adjusted_amount_prev) > 0){
            total_adjusted_amount += parseFloat(adjusted_amount_prev)
        }

        if(parseFloat(total_adjusted_amount) > parseFloat(total_amount)){

            toastr.error("Adjusted Amount exceeds Sales Order Amount")
            return false
        }

        var data = {
                "salesorder_id" : salesorder_id,
                "receipt_details":receipt_details
            }

        var jsonObject = JSON.stringify(data)

        $("#submit_multiple_receipt").attr('disabled',true)

        $.ajax({
            url: "<?php echo base_url(); ?>admin/Receipt/addMultipleReceipt",
            dataType: 'json',
            data: jsonObject,
            type: 'POST', 
            success: function(data){
                if(data.status==1){

                    window.location.replace("<?=base_url()?>admin/Receipt/manage_receipt");
                
                }else{
                    $("#submit_multiple_receipt").attr("disabled", false);
                    toastr.error('Failed to Add Receipt'); 
                }				
            },
            error: function(){ 
                $("#submit_multiple_receipt").attr("disabled", false);
                toastr.error('Failed to Add Receipt'); 				  
            }
		});
    }


    function multiReceiptforSO ( ) {

        $("#receipt_details_div").text('')
        $("#salesorder_amount").text('')
        $("#salesorder_date").text('')
        $("#salesorder_status").text('')
        $("#salesorder_invoice_no").text('')


        var salesorder_id = $("#select_salesorder").val();

        $("#salesorder_amount").text(IndianCurrency(amounts[salesorder_id]))
        $("#salesorder_date").text(dates[salesorder_id])
        $("#salesorder_status").text(statuses[salesorder_id])
        $("#salesorder_invoice_no").text(invoice_nos[salesorder_id])


	    var childtable= '<table cellpadding="5" cellspacing="0" border="0" class="table table-bordered " style="padding-left:50px;">';
		$.ajax( {
            url: encodeURI("<?php echo base_url(); ?>admin/Receipt/getReceiptDetailsBySalesorder?salesorder_id="+salesorder_id),
            type:"GET",
            dataType: 'json',
            async: false,
            success: function ( data ) {
                
                if(data.result==null){
                    childtable+='<tr><td>No Records Found</td></tr>';
                }else{
                
                    childtable += '<th>RECEIPT NO</th><th>RECEIPT TYPE</th><th>ACCOUNT NO</th><th>REF. NUMBER</th>'
                    childtable += '<th>Received Amount</th><th>Adjusted Amount</th><th>Received DATE</th><th>Received/<br>Verified By</th>'

                    $.each(data.result, function (i, d) { // loop through data returned from ajax 
                        
                        adjusted_amount_prev += parseFloat(data.result[i].adjusted_amount)
                        
                        childtable+='<tr>'+
                                    '<td>'+data.result[i].receipt_no+'</td>'+
                                    '<td>'+data.result[i].receipt_type+'</td>'+
                                    '<td>'+data.result[i].account_no+'</td>'+
                                    '<td>'+data.result[i].reference_no+'</td>'+
                                    '<td>'+data.result[i].received_amount+'</td>'+					
                                    '<td>'+data.result[i].adjusted_amount+'</td>'+					
                                    '<td>'+data.result[i].received_date+'</td>'+					
                                    '<td>'+data.result[i].received_by+'</td>'+					
                                    '</tr>';
                    });
                }
            }
        } );
            
        childtable+='</table>';
        $("#receipt_details_div").append(childtable)
    }

    function getReceiptDataforSOCreate(){

        var vendor_id = $("#select_vendor").val();

        if(vendor_id == '' || vendor_id == null || vendor_id == '0'){
            return false
        }

        $("#multiple_select_receipt").empty();
        $("#multiple_select_receipt").append("<option value=''>SELECT RECEIPT</option>")
        $("#multiple_select_receipt").change();

        $.ajax({
			type: "GET",
			url: "<?=base_url()?>admin/Receipt/getReceiptDataByVendor",
			data: { "vendor_id": vendor_id},
			dataType:"json",
			success: function(data){

                if(data.status != '1'){
                    return false
                }

				$.each(data.result ,function(i,v){

                    var adjusted_amount_float = parseFloat(data.result[i].adjusted_amount)

                    if(isNaN(adjusted_amount_float)){
                        adjusted_amount_float = 0
                    }
                    var available_amount = parseFloat(data.result[i].received_amount)-parseFloat(adjusted_amount_float)

                    if(parseFloat(available_amount)>0){
                        
                        var opt = '<option value="'+data.result[i].receipt_id+'">'
                            opt += data.result[i].receipt_no+'/'+data.result[i].received_date+'/'+data.result[i].received_amount
                            opt += '</option>'
                        $("#multiple_select_receipt").append(opt)
                    }
				})
				
			},
			error: function(error) {
				alert(error.responseJSON.message);
			}
		});
    }

    function addReceipttoTable(){

        var receipt_id = $("#multiple_select_receipt").val()
        var salesorder_id = $("#select_salesorder").val();
        var total_amount = amounts[salesorder_id]

        if(receipt_id == '0' || receipt_id == '' || receipt_id == null || receipt_id == undefined){
            toastr.error("Please select a Receipt")
            return false
        }

        $.ajax({
            "url": '<?=base_url()?>admin/Receipt/getReceiptHeader',
            "data": { "receipt_id": receipt_id},
            "type": "GET",
            "dataType": "json",
            "success": function(data){

                if(data.status != '1'){
                    toastr.error("Error: Failed to fetch Receipt Data")
                    return false
                }

                var result = data.data

                var adjusted_amount_float = parseFloat(result.adjusted_amount)

                if(isNaN(adjusted_amount_float)){
                    adjusted_amount_float = 0
                }
                var available_amount = parseFloat(result.received_amount)-parseFloat(adjusted_amount_float)
               // var available_amount = parseFloat(result.received_amount)-parseFloat(result.adjusted_amount)

                if(parseFloat(total_amount) <= available_amount){
                    adjusted_amount = total_amount
                }else{
                    adjusted_amount = available_amount
                }

                var receiptRow = '<tr class="tr_receipt_details">'
                    receiptRow += '<td class="td_receipt_no">'+result.receipt_no+'</td>'
                    receiptRow += '<td>'+result.receipt_type+'</td>'
                    receiptRow += '<td>'+result.account_no+'</td>'
                    receiptRow += '<td>'+result.reference_no+'</td>'
                    receiptRow += '<td>'+result.received_amount+'</td>'
                    receiptRow += '<td class="td_receipt_available_amount">'+available_amount+'</td>'
                    receiptRow += '<td>'+result.received_date+'</td>'
                    receiptRow += '<td><input class="receipt_input_adjusted_amount" value="'+adjusted_amount+'"></td>'
                    receiptRow += '<td onclick="delete_receipt_row(this)" class="bg-secondary delete">'
                    receiptRow += '<img src="<?php echo base_url(); ?>assets/img/delete.png">'
                    receiptRow += '</td>';

                    
                    receiptRow += '<input type="hidden" class="receipt_input_received_amount" value="'+result.received_amount+'">'
                    receiptRow += '<input type="hidden" class="receipt_input_receipt_id" value="'+result.receipt_id+'">'
                    
                    receiptRow += '</tr>'
                
                $("#receipt_table_tbody").append(receiptRow)
                $("#multiple_select_receipt").prop('selectedIndex', 0);
                $("#multiple_select_receipt").change()
            }
        })

    }

    function delete_receipt_row(btn){

        var yes= confirm("Do you want to delete the record?")
        
        if(yes){
            $(btn).closest("tr").remove();
        }
    }
</script>
