<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;"> 
    <div class="col-md-5  col-sm-5" style="padding:0px">

        <div class="form-group">
            <label class="col-lg-4 control-label">SALESCHANNEL REF. NO</label>
            <div class="col-lg-7">
                <input type="text" id="ecom_input_saleschannel_ref_id" class="form-control"  style="width:100%">
            </div> 
            <div class="col-lg-1" style="text-align:right;">
                <button class="btn btn-grey" onclick="getSalesorder_ecom()">GET</button>
            </div>
        </div>
    </div>
    
</div>

<hr style="border: 3px solid #e4eaec;">
<h4>SALESORDER DETAILS</h4>
<div class="table-responsive">
    <table class="table table-striped" id="table_ecom_so">
        <tr>
            <th>CUSTOMER NAME</th>
            <th>SALES ORDER NO</th>
            <th>INVOICE NO</th>
            <th>SALES CHANNEL</th>
            <th>SALES CHANNEL Ref. No</th>
            <th>SALESORDER AMOUNT</th>
        </tr>
        <tbody id="tbody_so_ecom">

        </tbody>
    </table>
</div>
<hr style="border: 3px solid #e4eaec;">

<h4>BREAKDOWN DETAILS</h4>
<div class="table-responsive">
    <table class="table table-striped" id="table_breakdown_ecom" style="margin-left: 20px;">
        <tr>
            <th>CHARGES</th>
            <th>AMOUNT</th>
            <th>TAX</th>
            <th>AMOUNT(incl. TAX)</th>
        </tr>
        <tbody id="tbody_breakdown_ecom"></tbody>
        <tfoot>
            <tr>
                <td>Remittance Amount</td>
                <td id = "td_remittance_amount" colspan="3"></td>
            </tr>
        </tfoot>
    </table>
</div>
<hr style="border: 3px solid #e4eaec;">
<h4>RECEIPT DETAILS</h4>
<div style="overflow-x: auto;width:100%;">
    <div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;"> 

        <div class="col-lg-2">
            <input id="ecom_receipt_type" class="form-control" style="width:100%" value="ONLINE" readonly>          
        </div>
        <div class="col-lg-2">
            <select id="ecom_select_bank_account" class="form-control select_box" style="width:100%">
                    <option value="">SELECT ACCOUNT</option>
            </select>
        </div>
        <div class="col-lg-2">
            <input type="text" id="ecom_received_by" class="form-control" style="width:100%" placeholder="RECEIVED BY">
        </div>
        <div class="col-lg-2">
            
            <input type="text" id="ecom_reference_no" class="form-control" style="width:100%" placeholder="REFERENCE NO">    
        </div>
        <div class="col-lg-2">
            <input type="text" id="ecom_received_amount" class="form-control" style="width:100%" placeholder="RECEIVED AMOUNT">
        </div>
        <div class="col-lg-2">
            <input type="date" id="ecom_received_date" class="form-control" style="width:100%" placeholder="RECEIVED DATE">
        </div>
    </div>
</div>
<div style="text-align: center;">
    <button type="button" id="submit_ecom_receipt" class="btn btn-grey">BACK</button> &nbsp;&nbsp;
    <button type="button" id="submit_ecom_receipt" class="btn btn-primary" onclick="submitEcomReceipt()">SUBMIT</button>
</div>

<script>
    var salesorder_id = 0;
    var fee_amount_excl_courier = 0;
    var total_tax_excl_courier = 0;
    var total_amount_excl_courier  = 0;
    var total_fee_excl_tax = 0;
    var total_fee_tax = 0;
    var total_amount_incl_tax = 0;
    var result_obj = {};
    var courier_fee = 0
    var courier_fee_tax = 0
    var courier_fee_total = 0

    dropdown_ecom('BANK_ACCOUNTS','ecom_select_bank_account');

    function checkNull(entity, message){

        if(entity == 0 || entity == '' || entity == null || entity == undefined){
            return message
        }
        return ''
    }

    function dropdown_ecom(type,select_id){

        $.ajax({
            type: "GET",
            url: "<?=base_url()?>admin/DropDownItems/getItems?type="+type,
            data: {},
            dataType:"json",
            success: function(data){

                $.each(data,function(i,v){
                    $("#"+select_id).append('<option value="'+data[i].name+'">'+data[i].name+'</option>')
                })
                
            },
            error: function(error) {
                alert(error.responseJSON.message);
            }
        });
    }

    function getSalesorder_ecom(){
        salesorder_id = 0;
        $("#table_ecom_so").find("tr:gt(0)").remove();
        $("#tbody_breakdown_ecom").empty();
        var saleschannel_ref_id = $("#ecom_input_saleschannel_ref_id").val()
        fee_amount_excl_courier = 0;
        total_tax_excl_courier = 0;
        total_amount_excl_courier  = 0;
        total_fee_excl_tax = 0;
        total_fee_tax = 0;
        total_amount_incl_tax = 0;
        result_obj = {};
        courier_fee = 0
        courier_fee_tax = 0
        courier_fee_total = 0
        $("#td_remittance_amount").text('')
        fields_required = '';

        fields_required += checkNull(saleschannel_ref_id, 'Saleschannel Ref Id')

        if(fields_required != ''){
            toastr.error("Fields Required: "+fields_required)
            return false
        }

        $.ajax({
            "url": "<?=base_url()?>admin/Receipt/getSalesorderDetails_ecom",
            "type": "GET",
            "data": { "saleschannel_ref_id": saleschannel_ref_id}, 
            "dataType": "json",
            "success": function(data){
                
                if(data.status != 1){

                    if(data.message != null){
                        toastr.error(data.message)
                        return false    
                    }else{
                        toastr.error("Failed to fetch Salesorder Details")
                        return false
                    }
                }
                var tr = '<tr>'
                    tr += '<td>'+data.result.vendor_name+'</td>'
                    tr += '<td>'+data.result.salesorder_code+'</td>'
                    tr += '<td>'+data.result.invoice_code+'</td>'
                    tr += '<td>'+data.result.sales_channel+'</td>'
                    tr += '<td>'+data.result.saleschannel_ref_id+'</td>'
                    tr += '<td>'+data.result.total_amount+'</td>'
                    tr += '<input type="hidden" id="ecom_vendor_id" value="'+data.result.vendor_id+'">'
                    tr += '<input type="hidden" id="ecom_salesorder_amount" value="'+data.result.total_amount+'">'
                    tr += '</tr>'
                
                $("#tbody_so_ecom").append(tr)
                salesorder_id = data.result.salesorder_id

                getBreakdownEcomCharges(data.result.salesorder_id)

            }
        })

    }

    function getBreakdownEcomCharges(order_id){
        var fields_required = checkNull(order_id, 'Salesorder')

        if(fields_required != ''){
            return false
        }

        $.ajax({
            "url": "<?=base_url()?>admin/Marketplace_charges/getEcomBreakdown",
            "type": "GET",
            "data": { "salesorder_id": order_id},
            "dataType": "json",
            "success": function(data){
                        
                    if(data.status != 1){
                        toastr.error("Failed to fetch breakdown details")
                        return false
                    }
                    result_obj = data.result
                    var breakdown_rows = ''
                    breakdown_rows += '<tr>'
                    breakdown_rows += '<td>COMMISSION CHARGES</td>'
                    breakdown_rows += '<td>'+data.result.commission_fee+'</td>'
                    breakdown_rows += '<td>'+data.result.commission_fee_tax+'</td>'
                    breakdown_rows += '<td id="">'+data.result.commission_fee_total+'</td>'
                    breakdown_rows += '</tr>'
                    fee_amount_excl_courier += parseFloat(data.result.commission_fee)
                    total_tax_excl_courier += parseFloat(data.result.commission_fee_tax)
                    total_amount_excl_courier += parseFloat(data.result.commission_fee_total)

                    breakdown_rows += '<tr>'
                    breakdown_rows += '<td>FIXED CLOSING FEE</td>'
                    breakdown_rows += '<td>'+data.result.fixed_closing_fee+'</td>'
                    breakdown_rows += '<td>'+data.result.fixed_closing_fee_tax+'</td>'
                    breakdown_rows += '<td>'+data.result.fixed_closing_fee_total+'</td>'
                    breakdown_rows += '</tr>'
                    fee_amount_excl_courier += parseFloat(data.result.fixed_closing_fee)
                    total_tax_excl_courier += parseFloat(data.result.fixed_closing_fee_tax)
                    total_amount_excl_courier += parseFloat(data.result.fixed_closing_fee_total)

                    breakdown_rows += '<tr>'
                    breakdown_rows += '<td>COLLECTION FEE</td>'
                    breakdown_rows += '<td>'+data.result.collection_fee+'</td>'
                    breakdown_rows += '<td>'+data.result.collection_fee_tax+'</td>'
                    breakdown_rows += '<td>'+data.result.collection_fee_total+'</td>'
                    breakdown_rows += '</tr>'
                    fee_amount_excl_courier += parseFloat(data.result.collection_fee)
                    total_tax_excl_courier += parseFloat(data.result.collection_fee_tax)
                    total_amount_excl_courier += parseFloat(data.result.collection_fee_total)

                    breakdown_rows += '<tr>'
                    breakdown_rows += '<td>PICK & PACK FEE</td>'
                    breakdown_rows += '<td>'+data.result.pick_pack_fee+'</td>'
                    breakdown_rows += '<td>'+data.result.pick_pack_fee_tax+'</td>'
                    breakdown_rows += '<td>'+data.result.pick_pack_fee_total+'</td>'
                    breakdown_rows += '</tr>'
                    fee_amount_excl_courier += parseFloat(data.result.pick_pack_fee)
                    total_tax_excl_courier += parseFloat(data.result.pick_pack_fee_tax)
                    total_amount_excl_courier += parseFloat(data.result.pick_pack_fee_total)

                    breakdown_rows += '<tr>'
                    breakdown_rows += '<td>WEIGHT HANDLING FEE</td>'
                    breakdown_rows += '<td>'+data.result.weight_handling_fee+'</td>'
                    breakdown_rows += '<td>'+data.result.weight_handling_fee_tax+'</td>'
                    breakdown_rows += '<td>'+data.result.weight_handling_fee_total+'</td>'
                    breakdown_rows += '</tr>'
                    fee_amount_excl_courier += parseFloat(data.result.weight_handling_fee)
                    total_tax_excl_courier += parseFloat(data.result.weight_handling_fee_tax)
                    total_amount_excl_courier += parseFloat(data.result.weight_handling_fee_total)

                    breakdown_rows += '<tr>'
                    breakdown_rows += '<td>F1 SERVICES FEE</td>'
                    breakdown_rows += '<td>'+data.result.f1_services_fee+'</td>'
                    breakdown_rows += '<td>'+data.result.f1_services_fee_tax+'</td>'
                    breakdown_rows += '<td>'+data.result.f1_services_fee_total+'</td>'
                    breakdown_rows += '</tr>'
                    fee_amount_excl_courier += parseFloat(data.result.f1_services_fee)
                    total_tax_excl_courier += parseFloat(data.result.f1_services_fee_tax)
                    total_amount_excl_courier += parseFloat(data.result.f1_services_fee_total)

                    breakdown_rows += '<tr>'
                    breakdown_rows += '<td>TCS</td>'
                    breakdown_rows += '<td>'+data.result.tcs_fee+'</td>'
                    breakdown_rows += '<td>'+data.result.tcs_fee_tax+'</td>'
                    breakdown_rows += '<td>'+data.result.tcs_fee_total+'</td>'
                    breakdown_rows += '</tr>'
                    fee_amount_excl_courier += parseFloat(data.result.tcs_fee)
                    total_tax_excl_courier += parseFloat(data.result.tcs_fee_tax)
                    total_amount_excl_courier += parseFloat(data.result.tcs_fee_total)

                    breakdown_rows += '<tr>'
                    breakdown_rows += '<td style="text-align:left"><input type="radio" name="courier_fee" id="local" onclick="courierSelect(\'local\')" checked> &nbsp;COURIER LOCAL FEE</td>'
                    breakdown_rows += '<td id="courier_local_fee">'+data.result.courier_local_fee+'</td>'
                    breakdown_rows += '<td id="courier_local_fee_tax">'+data.result.courier_local_fee_tax+'</td>'
                    breakdown_rows += '<td id="courier_local_fee_total">'+data.result.courier_local_fee_total+'</td>'
                    breakdown_rows += '</tr>'
                    courier_fee = data.result.courier_local_fee
                    courier_fee_tax = data.result.courier_local_fee_tax
                    courier_fee_total = data.result.courier_local_fee_total
                    
                    breakdown_rows += '<tr>'
                    breakdown_rows += '<td style="text-align:left"><input type="radio" name="courier_fee" id="regional"  onclick="courierSelect(\'regional\')"> &nbsp;COURIER REGIONAL FEE</td>'
                    breakdown_rows += '<td id="courier_regional_fee">0.00</td>'
                    breakdown_rows += '<td id="courier_regional_fee_tax">0.00</td>'
                    breakdown_rows += '<td id="courier_regional_fee_total">0.00</td>'
                    breakdown_rows += '</tr>'
                    
                    breakdown_rows += '<tr>'
                    breakdown_rows += '<td style="text-align:left"><input type="radio" name="courier_fee" id="national" onclick="courierSelect(\'national\')"> &nbsp;COURIER NATIONAL FEE</td>'
                    breakdown_rows += '<td id="courier_national_fee">0.00</td>'
                    breakdown_rows += '<td id="courier_national_fee_tax">0.00</td>'
                    breakdown_rows += '<td id="courier_national_fee_total">0.00</td>'
                    breakdown_rows += '</tr>'
                    
                    var total_fee = fee_amount_excl_courier+parseFloat(data.result.courier_local_fee)
                    var total_tax = total_tax_excl_courier+parseFloat(data.result.courier_local_fee_tax)
                    var total_amount = total_amount_excl_courier+parseFloat(data.result.courier_local_fee_total)
                    
                    breakdown_rows += '<tr style="font-weight:700">'
                    breakdown_rows += '<td>TOTAL AMOUNT</td>'
                    breakdown_rows += '<td id="td_total_fee_excl_tax">'+total_fee.toFixed(2)+'</td>'
                    breakdown_rows += '<td id="td_total_fee_tax">'+total_tax.toFixed(2)+'</td>'
                    breakdown_rows += '<td id="td_total_fee_incl_tax">'+total_amount.toFixed(2)+'</td>'
                    breakdown_rows += '</tr>'

                    $("#tbody_breakdown_ecom").append(breakdown_rows)

                    var salaesorder_amount = parseFloat($("#ecom_salesorder_amount").val())
                    if(isNaN(salaesorder_amount)){
                        salaesorder_amount = 0;
                    }
                    $("#td_remittance_amount").text((salaesorder_amount - total_amount).toFixed(2))

            }
        })
    
    }

    function courierSelect(type){

        $("#courier_local_fee").text('0.00')
        $("#courier_local_fee_tax").text('0.00')
        $("#courier_local_fee_total").text('0.00')
        $("#courier_regional_fee").text('0.00')
        $("#courier_regional_fee_tax").text('0.00')
        $("#courier_regional_fee_total").text('0.00')
        $("#courier_national_fee").text('0.00')
        $("#courier_national_fee_tax").text('0.00')
        $("#courier_national_fee_total").text('0.00')
        
        if(type == 'local'){
            $("#courier_local_fee").text(result_obj.courier_local_fee)
            $("#courier_local_fee_tax").text(result_obj.courier_local_fee_tax)
            $("#courier_local_fee_total").text(result_obj.courier_local_fee_total)
            
            courier_fee = parseFloat(result_obj.courier_local_fee)
            courier_fee_tax = parseFloat(result_obj.courier_local_fee_tax)
            courier_fee_total = parseFloat(result_obj.courier_local_fee_total)
        }else if(type == 'regional'){
            $("#courier_regional_fee").text(result_obj.courier_regional_fee)
            $("#courier_regional_fee_tax").text(result_obj.courier_regional_fee_tax)
            $("#courier_regional_fee_total").text(result_obj.courier_regional_fee_total)
            
            courier_fee = parseFloat(result_obj.courier_regional_fee)
            courier_fee_tax = parseFloat(result_obj.courier_regional_fee_tax)
            courier_fee_total = parseFloat(result_obj.courier_regional_fee_total)
        }else if(type == 'national'){
            $("#courier_national_fee").text(result_obj.courier_national_fee)
            $("#courier_national_fee_tax").text(result_obj.courier_national_fee_tax)
            $("#courier_national_fee_total").text(result_obj.courier_national_fee_total)
            
            courier_fee = parseFloat(result_obj.courier_national_fee)
            courier_fee_tax = parseFloat(result_obj.courier_national_fee_tax)
            courier_fee_total = parseFloat(result_obj.courier_national_fee_total)
        }else{
            courier_fee = 0
            courier_fee_tax = 0
            courier_fee_total = 0
        }

        if(isNaN(courier_fee)){
            courier_fee = 0;
        }
        if(isNaN(courier_fee_tax)){
            courier_fee_tax = 0;
        }
        if(isNaN(courier_fee_total)){
            courier_fee_total = 0;
        }

        total_fee_excl_tax = fee_amount_excl_courier + parseFloat(courier_fee)
        total_fee_tax = total_tax_excl_courier + parseFloat(courier_fee_tax)
        total_amount_incl_tax = total_amount_excl_courier + parseFloat(courier_fee_total)
        
        var salaesorder_amount = parseFloat($("#ecom_salesorder_amount").val())
        if(isNaN(salaesorder_amount)){
            salaesorder_amount = 0;
        }

        $("#td_total_fee_excl_tax").text((total_fee_excl_tax).toFixed(2))
        $("#td_total_fee_tax").text((total_fee_tax).toFixed(2))
        $("#td_total_fee_incl_tax").text((total_amount_incl_tax).toFixed(2))
        $("#td_remittance_amount").text((salaesorder_amount - total_amount_incl_tax).toFixed(2))
    }

    function submitEcomReceipt(){

       var vendor_id = $("#ecom_vendor_id").val()
       var receipt_type = $("#ecom_receipt_type").val()
       var bank_account = $("#ecom_select_bank_account").val()
       var received_by = $("#ecom_received_by").val()
       var reference_no = $("#ecom_reference_no").val()
       var received_amount = $("#ecom_received_amount").val()
       var received_date = $("#ecom_received_date").val()
       var remittance_amount = parseFloat($("#td_remittance_amount").text().trim())
       var salaesorder_amount = parseFloat($("#ecom_salesorder_amount").val())
       var fields_required = ''
       
       if(isNaN(salaesorder_amount) || salaesorder_amount <= 0){
           toastr.error("Invalid Salesorder Amount");
           return false
       }
       if(isNaN(remittance_amount) || remittance_amount <= 0){
           toastr.error("Invalid Remittance Amount");
           return false
       }

       fields_required += checkNull(vendor_id, 'Vendor Name, ')
       fields_required += checkNull(salesorder_id, 'Salesorder No, ')
       fields_required += checkNull(receipt_type, 'Receipt Type, ')
       fields_required += checkNull(reference_no, 'Reference No, ')
       fields_required += checkNull(received_amount, 'Received Amount, ')
       fields_required += checkNull(received_date, 'Received Date, ')
       fields_required += checkNull(received_by, 'Received/Verified By, ')
    
       if(fields_required != ''){
           alert("Fields Required: "+fields_required)
           return false
       }

        var data = {
                "vendor_id" : vendor_id,
                "salesorder_id" : salesorder_id,
                "salesorder_amount" : salaesorder_amount,
                "receipt_type": receipt_type,
                "account_no": bank_account,
                "received_by": received_by,
                "reference_no": reference_no,
                "received_amount": received_amount,
                "received_date": received_date,
                "commission_fee": result_obj.commission_fee,
                "commission_fee_tax": result_obj.commission_fee_tax,
                "commission_fee_total_amount": result_obj.commission_fee_total,
                "fixed_closing_fee": result_obj.fixed_closing_fee,
                "fixed_closing_fee_tax": result_obj.fixed_closing_fee_tax,
                "fixed_closing_fee_total_amount": result_obj.fixed_closing_fee_total,
                "collection_fee": result_obj.collection_fee,
                "collection_fee_tax": result_obj.collection_fee_tax,
                "collection_fee_total_amount": result_obj.collection_fee_total,
                "pick_pack_fee": result_obj.pick_pack_fee,
                "pick_pack_fee_tax": result_obj.pick_pack_fee_tax,
                "pick_pack_fee_total_amount": result_obj.pick_pack_fee_total,
                "weight_handling_fee": result_obj.weight_handling_fee,
                "weight_handling_fee_tax": result_obj.weight_handling_fee_tax,
                "weight_handling_fee_total_amount": result_obj.weight_handling_fee_total,
                "courier_fee": courier_fee,
                "courier_fee_tax": courier_fee_tax,
                "courier_fee_total_amount": courier_fee_total,
                "f1_services_fee": result_obj.f1_services_fee,
                "f1_services_fee_tax": result_obj.f1_services_fee_tax,
                "f1_services_fee_total_amount": result_obj.f1_services_fee_total,
                "tcs_fee": result_obj.tcs_fee_total,
                "remittance_amount": remittance_amount

            }

        var jsonObject = JSON.stringify(data)

        $.ajax({
            "url": "<?=base_url()?>admin/Receipt/addReceiptEcom",
            "type": "POST",
            "data": jsonObject,
            "dataType": "json",
            "success": function(data){

                if(data.status != 1){
                    toastr.error("Failed to Add Receipt Details")
                    return false
                }

                toastr.success("Receipt Data Added Successfully")
                window.location.replace("<?=base_url()?>admin/Receipt/manage_receipt")
            },
            error: function(data){
                toastr.error("Failed to Add Receipt Details")
                return false
            }
        })
    }
</script>