<style>
    #product_det_filter.dataTables_filter input {
        width: 130px;
    }

    input.scrolledTable {
        overflow-y: auto;
        clear: both;
    }

    .currency {
        text-align: right;
    }
</style>
<div>
    <div class="table-responsive scrolledTable">
        <hr style="border: 3px solid #e4eaec">
        <input type="hidden" id="purchase_return_id_fin" value="<?php echo $purchase_return_id_fin; ?>" readonly>
        <h4>Order Details</h4>
        <table class="table table-striped DataTables" id="purchase_return_update_fin" cellspacing="0" align="left" style="width:90%;white-space:nowrap;">
            <thead>
                <th>Purchase Return No</th>
                <th>Vendor Name</th>
                <th>Invoice No</th>
                <th>Credit Note Number</th>
                <th>Credin Note Date</th>
                <th>STATUS</th>
                </tr>
            </thead>
        </table>
        <hr style="border: 3px solid #e4eaec">
        <h4 style="margin-left:15px;">Remarks</h4>
        <table class="table table-stripped" id="remarks_table" style="width: 40%;">
        </table>
        <tr>
            <td><textarea id="remarks_header" class="form-control" name="remarks_header" maxlength="200" style="margin-left:15px;width:40%;"></textarea></td>
        </tr>
    </div>
    <hr style="border: 3px solid #e4eaec">

    <table class="form-group table-responsive table" style="margin-left:10px;">
        <tr>
            <td>UPLOAD</td>
            <td><input type="file" class="form-control-file custom-file-input" id="fileUploadPrices"></td>

            <td colspan="9"><input type="button" class="btn btn-primary" id="upload" value="Upload Prices" onclick="uploadFinanceDevicePrices()" /></td>
            <td>
                <button type="button" class="btn btn-green" onclick="downloadDevices()">
                    <span class="fa fa-file-excel-o"></span>&nbsp;&nbsp;&nbsp; Download</button>
            </td>
        </tr>
    </table>


    <div class="table-responsive scrolledTable">
        <h4>Product Details</h4>
        <table class="table table-bordered table-stripped DataTables " id="product_det" style="margin-left:15px; width:90%;">
            <thead>
                <th>Device ID</th>
                <th>Device Name</th>
                <th>SKU/Variant</th>
                <th>Quantity</th>
                <th>Taxable Amount</th>
                <th>Exempt Amount</th>
                <th>Tax Amount</th>
                <th>Total Amount</th>
                <th>Remarks</th>
            </thead>
            <tbody class="tbody2">
            </tbody>

        </table>
    </div>

    <table>
        <tr>
            <td colspan="13"><button class="btn btn-primary" type="button" id="submit" name="action" onclick="submitForm('approve')" value="approve">Approve</button>
                &nbsp;&nbsp;&nbsp;&nbsp;<button class="btn btn-danger" id="submit" name="action" onclick="submitForm('reject')" value="reject">Reject</button>
                &nbsp;&nbsp;&nbsp;&nbsp;<button class="btn btn-red" id="cancel" type="button" onclick="window.location.replace('<?= base_url() ?>admin/Purchase_return/manage_purchase_return')">BACK</button></td>
        </tr>
    </table>
    </form>
</div>
<!-- jquery-csv -->
<script src="<?= base_url() ?>assets/js/jquery-csv.js"></script>
<script>
    function IndianCurrency(rupees) {

        rupees = parseFloat(rupees)
        return rupees.toLocaleString('en-IN', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }
    var devicesFin = [];


    function submitForm(type = '') {

        var remarks = $("#remarks_header").val();
        var purchase_return_id_fin = $("#purchase_return_id_fin").val();

        if(devicesFin.length == 0){
            alert("Please select atleast one device");
            return false;
        }

        var data = {
            "purchase_return_id": purchase_return_id_fin,
            "action": type,
            "remarks_header": remarks,
            "devices": devicesFin
        }

        var jsonObject = JSON.stringify(data)

        $("#submit").attr('disabled', true)
        $.ajax({
            url: "<?php echo base_url(); ?>admin/Purchase_return/updatePurchaseReturnFinance",
            dataType: 'json',
            data: jsonObject,
            type: 'POST',
            success: function(data) {
                if (data.status == 1) {

                    toastr.success(data.message);

                    window.location.replace("<?= base_url() ?>admin/Purchase_return/manage_purchase_return");

                } else {
                    $("#submit").attr("disabled", false);
                    toastr.error(data.message);
                }
            },
            error: function() {
		
                $("#submit").attr("disabled", false);
                toastr.error('Failed to Approve/Reject Purchase Return');
            }
        });

    }

    $(document).ready(function() {
        var update_fin_purchase_return_id = $("#purchase_return_id_fin").val();
        let total_devices = {}
        var purchase_fin_table = $('#purchase_return_update_fin').DataTable({
            "processing": true,
            "serverSide": false,
            "bDestroy": true,
            "ajax": {
                "url": "<?php echo base_url(); ?>admin/Purchase_return/getPurchaseReturnList",
                "data": {
                    "purchase_return_id": update_fin_purchase_return_id,
                    "status": "FINANCE_PENDING"
                }
            },
            "columns": [{
                    "data": "purchase_return_no"
                },
                {
                    "data": "vendor_name"
                },
                {
                    "data": "invoice_no"
                },
                {
                    "data": "creditnote_no"
                },
                {
                    "data": "creditnote_date"
                },
                {
                    "data": "status"
                }
            ]
        })

        uploadFinanceDevicePrices = () => {

            //get csv data from fileUploadPrices
            var csv_data = $("#fileUploadPrices").prop('files')[0];
            var reader = new FileReader();
            reader.readAsText(csv_data);
            reader.onload = function(event) {
                var csv = event.target.result;
                let data = $.csv.toArrays(csv).map((row) => {
                    return row.map((cell) => {
                        return cell.trim();
                    });
                });

                //remove first row
                data.shift();
                let check_failed = false
                data.forEach(function(row) {
                    let item_id = row[0]
                    let device_id = row[1]
                    let device_name = row[2]
                    let sku_variant = row[3]
                    let quantity = +row[4]
                    let taxable_amount = +row[5]
                    let exempt_amount = +row[6]
                    let tax_amount = +row[7]
                    let total_amount = +row[8]

                    if (isNaN(total_amount) || total_amount <= 0) {
                        toastr.error('Invalid Total Amount For ' + device_id);
                        check_failed = true;
                        return false;
                    }

                    if (isNaN(taxable_amount) || taxable_amount <= 0) {
                        toastr.error('Invalid Taxable Amount For ' + device_id);
                        check_failed = true;
                        return false;
                    }

                    if (isNaN(exempt_amount) || exempt_amount < 0) {
                        toastr.error('Invalid Exempt Amount For ' + device_id);
                        check_failed = true;
                        return false;
                    }

                    if (isNaN(tax_amount) || tax_amount <= 0) {
                        toastr.error('Invalid Tax Amount For ' + device_id);
                        check_failed = true;
                        return false;
                    }
                    let calculated_price = taxable_amount + exempt_amount + tax_amount;
                    console.log(calculated_price, total_amount)
                    if (!(calculated_price >= (total_amount - 5)) && !(calculated_price <= (total_amount + 5))) {
                        toastr.error('Total Price Not Matching with Taxable Amount + Exempt Amount + Tax Amount for ' + device_id);
                        check_failed = true;
                        return false;
                    }

                    let item = {
                        "item_id": item_id,
                        "device_id": device_id,
                        "device_name": device_name,
                        "sku_variant": sku_variant,
                        "quantity": quantity,
                        "taxable_amount": taxable_amount,
                        "exempt_amount": exempt_amount,
                        "tax_amount": tax_amount,
                        "total_amount": total_amount
                    }
                    devicesFin.push(item);
                    delete total_devices[item_id];
                });

                if (check_failed) {
                    return false;
                }
                //check if any device is missing
                for (var key in total_devices) {
                    toastr.error('Device ' + key + ' is missing in the CSV');
                    return false;
                }

                var tableData = '';
                let total_amount = 0
                $.each(devicesFin, function(i, v) {

                    tableData += "<tr>"
                    tableData += "<td>" + v.device_id + "</td>"
                    tableData += "<td>" + v.device_name + "</td>"
                    tableData += "<td>" + v.sku_variant + "</td>"
                    tableData += "<td>" + v.quantity + "</td>"
                    tableData += "<td>" + v.taxable_amount + "</td>"
                    tableData += "<td>" + v.exempt_amount + "</td>"
                    tableData += "<td>" + v.tax_amount + "</td>"
                    tableData += "<td>" + v.total_amount + "</td>"
                    tableData += "</tr>"
                    total_amount += +v.total_amount;
                })
                tableData += '<tr><td colspan="7" style="text-align:right;"><b>Total Amount:</b></td><td>' + IndianCurrency(total_amount) + '</td><td></td></tr>'


                $("#product_det").append(tableData);
            }
        }

        downloadDevices = () => {
            console.log('downloading')
            let csv = 'Item Id,Device Id,Device Name,SKU/Varaint,Quantity,Taxable Amount,Exempt Amount,Tax Amount,Price\n'
            $.ajax({
                "url": "<?php echo base_url(); ?>admin/Purchase_return/getPurchaseReturnItems?purchase_return_id=" + update_fin_purchase_return_id,
                "type": "GET",
                "dataType": 'json',
                "async": false,
                "success": function(data) {

                    if (data.status != 1) {
                        toastr.error('No Records Found');
                        return false
                    }
                    
                    $.each(data.data, function(i, v) {
                        let price = 0;
                        let taxable = 0;
                        let exempt = 0;
                        let tax_amount = 0;
                        if(data.data[i].sku == 'XIA1514-6GB-128GB-BLU'){
                            price = 14999
                            taxable = 12711.02
                            tax_amount = 2287.98
                        }

                        if(data.data[i].sku == 'XIA1551-6GB-128GB-PRP'){
                            price = 14100
                            taxable = 11949.15
                            tax_amount = 2150.85
                        }

                        if(data.data[i].sku == 'XIA1551-6GB-128GB-WHT'){
                            price = 14100
                            taxable = 11949.15
                            tax_amount = 2150.85
                        }

                        if(data.data[i].sku == 'XIA1576-6GB-128GB-GRN'){
                            price = 10800
                            taxable = 9152.54
                            tax_amount = 1647.46
                        }

                        if(data.data[i].sku == 'XIA1576-6GB-128GB-PRP'){
                            price = 10800
                            taxable = 9152.54
                            tax_amount = 1647.46
                        }

                        csv += data.data[i].purchase_return_item_id+ ','+data.data[i].nhdin + ',' + data.data[i].device_name + ',' + data.data[i].sku + ',' + data.data[i].quantity + ',' + taxable + ',' + exempt + ',' + tax_amount + ',' + price + '\n'
                        total_devices[data.data[i].purchase_return_item_id] = true
                    })

                    //download csv file
                    var blob = new Blob([csv], {
                        type: 'text/csv'
                    });
                    var url = window.URL.createObjectURL(blob);
                    var link = document.createElement('a');
                    link.href = url;
                    link.download = 'devices.csv';
                    link.click();
                    window.URL.revokeObjectURL(url);
                    return true
                },
                error: function() {
                    toastr.error('Failed to get data');
                    return false
                }
            });
        }

        $.ajax({
            url: encodeURI("<?php echo base_url(); ?>web_api/getRemarks?id=" + update_fin_purchase_return_id) + "&type=purchase_return",
            type: "GET",
            dataType: 'json',
            success: function(data) {
                if (data.status == 1) {
                    var tableData = "<thead><th>Date</th><th>By</th><th>Remark</th></thead>"
                    $.each(data.remarks, function(i, v) {
                        tableData += "<tr><td>" + data.remarks[i].date + "</td><td>" + data.remarks[i].username + "</td><td>" + data.remarks[i].remark + "</td></tr>";
                    })
                    $("#remarks_table").append(tableData)
                }
            }
        })
    })
</script>