<style>
    #product_det_filter.dataTables_filter input {
        width: 130px;
    }

    input.scrolledTable {
        overflow-y: auto;
        clear: both;
    }

    .currency {
        text-align: right;
    }
</style>
<div>
    <div class="table-responsive scrolledTable">
        <hr style="border: 3px solid #e4eaec">
        <input type="hidden" id="purchase_return_id_admin" value="<?php echo $purchase_return_id_admin; ?>" readonly>
        <h4>Order Details</h4>
        <table class="table table-striped DataTables" id="purchase_return_update_admin" cellspacing="0" align="left" style="width:90%;white-space:nowrap;">
            <thead>
                <th>Purchase Return No</th>
                <th>Vendor Name</th>
                <th>Invoice No</th>
                <th>Credit Note Number</th>
                <th>Credin Note Date</th>
                <th>STATUS</th>
                </tr>
            </thead>
        </table>
        <hr style="border: 3px solid #e4eaec">
        <h4>Remarks</h4>
        <table class="table table-stripped DataTables" id="remarks_table">
        </table>

        <tr>
            <td>REMARKS</td>
            <td><textarea id="remarks_header" class="form-control" name="remarks_header" maxlength="200"></textarea></td>
        </tr>
    </div>
    <hr style="border: 3px solid #e4eaec">
    <div style="display: flex;width:50%;">
        <h5 style="width: 25%; margin-left:15px;font-weight: 700;">Scan Device</h5>
        <input type="text" id="scan_device" class="form-control" name="scan_device" style="width:250px; margin-left:15px;" placeholder="Device ID" onchange="scanDevice(this)" />
        <button type="button" value="ADD" class="btn btn-primary" id="add_device" style="width: 60px;height:30px;padding:5px; margin-left:15px;">ADD</button>
    </div>
    <div class="table-responsive scrolledTable">
        <h4>Product Details</h4>
        <table class="table table-bordered table-stripped DataTables " id="product_det_admin" style="margin-left:15px; width:90%;">
            <thead>
                <th>Device ID</th>
                <th>Device Name</th>
                <th>SKU/Variant</th>
                <th>Taxable Amount</th>
                <th>Exempt Amount</th>
                <th>Tax Amount</th>
                <th>Total Amount</th>
                <th>Remarks</th>
            </thead>
            <tbody class="tbody2">
            </tbody>

        </table>
    </div>

    <table>
        <tr>
            <td colspan="13"><button class="btn btn-primary" type="button" id="submit" name="action" onclick="submitForm('approve')" value="approve">Approve</button>
                &nbsp;&nbsp;&nbsp;&nbsp;<button class="btn btn-red" id="cancel" type="button" onclick="window.location.replace('<?= base_url() ?>admin/Purchase_return/manage_purchase_return')">BACK</button></td>
        </tr>
    </table>
    </form>
</div>

<script>
    let scanDevice;
    let admin_table_products = {}
    function IndianCurrency(rupees) {

        rupees = parseFloat(rupees)
        return rupees.toLocaleString('en-IN', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }

    function submitForm(action) {

        var remarks = $("#remarks_header").val();
        var salesorder_id = $("#salesorderid").val();

        var data = {
            "salesorder_id": salesorder_id,
            "action": action,
            "remarks_header": remarks
        }
        var jsonObject = JSON.stringify(data)

        $("#submit").attr('disabled', true)
        $.ajax({
            url: "<?php echo base_url(); ?>admin/Purchase_return/updatePurchaseReturnAdmin",
            dataType: 'json',
            data: jsonObject,
            type: 'POST',
            success: function(data) {
                if (data.status == 1) {

                    toastr.success(data.message);

                    window.location.replace("<?= base_url() ?>admin/Rfs/manage_rfs/null/2");

                } else {
                    $("#submit").attr("disabled", false);
                    toastr.error('Failed to Approve/Reject Purchase Return');
                }
            },
            error: function() {
                $("#submit").attr("disabled", false);
                toastr.error('Failed to Approve/Reject Purchase Return');
            }
        });
    }


    function submitForm(type = '') {

        if (type == '') {
            return false
        }

        if(Object.keys(admin_table_products).length>0){
            toastr.error('Not All Devices are Scanned');
            return false;
        }
        
        var remarks = $("#remarks_header").val();
        var purchase_return_id_admin = $("#purchase_return_id_admin").val();

        var data = {
            "purchase_return_id": purchase_return_id_admin,
            "action": type,
            "remarks_header": remarks
        }

        var jsonObject = JSON.stringify(data)

        $("#submit").attr('disabled', true)
        $.ajax({
            url: "<?php echo base_url(); ?>admin/Purchase_return/updatePurchaseReturnAdmin",
            dataType: 'json',
            data: jsonObject,
            type: 'POST',
            success: function(data) {
                if (data.status == 1) {

                    toastr.success(data.message);

                    window.location.replace("<?= base_url() ?>admin/Purchase_return/manage_purchase_return");

                } else {
                    $("#submit").attr("disabled", false);
                    toastr.error('Failed to Approve/Reject Purchase Return');
                }
            },
            error: function() {
                $("#submit").attr("disabled", false);
                toastr.error('Failed to Approve/Reject Purchase Return');
            }
        });

    }




    $(document).ready(function() {
        var update_admin_purchase_return_id = $("#purchase_return_id_admin").val();

        var purchase_admin_table = $('#purchase_return_update_admin').DataTable({
            "processing": true,
            "serverSide": false,
            "bDestroy": true,
            "ajax": {
                "url": "<?php echo base_url(); ?>admin/Purchase_return/getPurchaseReturnList",
                "data": {
                    "purchase_return_id": update_admin_purchase_return_id,
                    "status": "ADMIN_PENDING"
                }
            },
            "columns": [{
                    "data": "purchase_return_no"
                },
                {
                    "data": "vendor_name"
                },
                {
                    "data": "invoice_no"
                },
                {
                    "data": "creditnote_no"
                },
                {
                    "data": "creditnote_date"
                },
                {
                    "data": "status"
                }
            ]
        })


        product_det_admin();

        function product_det_admin() {

            $.ajax({
                "url": "<?php echo base_url(); ?>admin/Purchase_return/getPurchaseReturnItems?purchase_return_id=" + update_admin_purchase_return_id,
                "type": "GET",
                "dataType": 'json',
                "async": false,
                "success": function(data) {

                    $.each(data.data, function(i, v) {
                        let row = ''
                        row += "<tr>"
                        row += "<td>" + data.data[i].nhdin + "</td>"
                        row += "<td>" + data.data[i].device_name + "</td>"
                        row += "<td>" + data.data[i].sku + "</td>"
                        row += "<td>" + data.data[i].taxable_amount + "</td>"
                        row += "<td>" + data.data[i].exempt_amount + "</td>"
                        row += "<td>" + data.data[i].tax_amount + "</td>"
                        row += "<td>" + data.data[i].price + "</td>"
                        row += "<td>" + data.data[i].remarks + "</td>"
                        row += "</tr>";
                        admin_table_products[data.data[i].nhdin.toUpperCase()] = row
                    })
                }
            });
        }

        scanDevice = (d) =>  {
            if (d.value == '' || d.value == null || d.value.length <= 0) {
                return false
            }
            
            if(d.value.length !=13){
                toastr.error('Invalid Device ID');
                return false;
            }

            if(admin_table_products[d.value.toUpperCase()] != undefined){
                $("#product_det_admin").append(admin_table_products[d.value]);
                delete admin_table_products[d.value];
                d.value = '';
            }else{
                toastr.error('Device ID Not Found in this Purchase Return');
                return false;
            }
        }

        $.ajax({
            url: encodeURI("<?php echo base_url(); ?>web_api/getRemarks?id=" + update_admin_purchase_return_id) + "&type=purchase_return",
            type: "GET",
            dataType: 'json',
            success: function(data) {
                if (data.status == 1) {
                    var tableData = "<thead><th>Date</th><th>By</th><th>Remark</th></thead>"
                    $.each(data.remarks, function(i, v) {
                        tableData += "<tr><td>" + data.remarks[i].date + "</td><td>" + data.remarks[i].username + "</td><td>" + data.remarks[i].remark + "</td></tr>";
                    })
                    $("#remarks_table").append(tableData)
                }
            }
        })

    })
</script>