<!DOCTYPE html>
<html>
<meta charset="utf-8">
<title><?= lang('invoice') ?></title>

<head>
    <style type="text/css">
        font-face {
            font-family: "Source Sans Pro", sans-serif;
        }

        .clearfix:after {
            content: "";
            display: table;
            clear: both;
        }

        a {
            color: #0087C3;
            text-decoration: none;
        }

        body {
            color: #222222;
            background: #FFFFFF;
            font-size: 9px;
            font-family: "Source Sans Pro", sans-serif;
            width: 100%;
            margin: 0;
        }

        #header_logo {
            float: left;
        }

        #header_title {
            float: right;
        }

        #client_address p {
            margin: 0;
        }

        #ship_to p {
            margin: 0;
        }


        #client_detail_table td {
            width: 110px;
            border-bottom: 0.5px solid grey;
            text-align: left;
            padding-top: 0;
            padding-bottom: 0;
        }

        .left {
            text-align: left;
        }

        .right {
            text-align: right !important;
        }

        .center {
            text-align: center;
        }

        #invoice_table {
            width: 100%;
            margin-left: 2px;
            margin-right: 2px;
        }

        #invoice_table th,
        td,
        tr {
            border-bottom: 0.5px solid grey;
            padding-top: 4px;
            padding-bottom: 2px;
            margin: 0;
        }

        #invoice_table .footer_table {
            font-weight: bold;
        }

        #invoice_table th {
            border-top: 0.5px solid grey;
        }

        header {
            position: fixed;
            top: -20px;
            left: 0px;
            right: 0px;
            height: 20px;
            width: 100%;

        }

        footer {
            position: fixed;
            bottom: 0;
            left: 0px;
            right: 0px;
            height: 20px;
            border-top: 1px solid #AAAAAA;
            color: #777777;
            width: 100%;
            padding: 8px 0;
            text-align: center;
        }

        .rupee::before {
            padding-left: 5px;
            white-space: nowrap;
        }


        .footer_margin {
            margin-bottom: 0;
            margin-left: 1px;
            position: absolute;
            bottom: 0;
            float: right;
            font-size: 12px;
        }

        .signature {
            margin-bottom: 40px;
            margin-left: 1px;
            position: absolute;
            bottom: 0;
            float: right;
            font-size: 12px;
        }

        .container td {
            border-bottom: none;
        }
	.uppercase {
		text-transform: uppercase;
	}
    </style>
</head>

<body>
    <header>

    </header>

    <footer id="footer"><span style="font-weight:bold;">SLOYD VENTURES (P) LTD,</span> 1-11-251/19A. 4th Floor, Jayalakshmi Towers,
        Motilal Nehru Nagar, Begumpet, Hyderabad, Telangana, 500016, IN.<p style="margin:0;">|| CIN: U52390TG2012PTC083950 | PAN: AASCS2801C | Tel: +91-40-27900059 | Email: accounts@sloyd.in | web: www.sloyd.in ||</p>
    </footer>
    <div class="footmargin"></div>
    <table id="heading" style="text-align:center;width:100%;border-bottom:none;margin-top:-30px;">
        <!-- <div id="header_logo"> -->
        <tr style="border-bottom:none;">
            <td style="align-content:left;text-align:left;border-bottom:none;"><img src="<?php base_url(); ?>assets/img/logo_invoice.png" height="50px" width="140px"></td>
            <!-- </div>
            <div style="display:inline;font-size:20px;font-weight:700;padding-top:100px"> -->
            <td style="text-align:center;border-bottom:none;">
                <h1>Debit Note</h1>
            </td>
            <!-- </div>
            <div id="header_title" style="font-size:20px;font-weight:700;"> -->
            <td style="border-bottom:none;">
                <div style="font-size:14px;font-weight:700;text-align:right;"><?= $type ?></div>
            </td>
        </tr>
        <!-- </div> -->
    </table>
    <table class="container" style="width:100%;">
        <tr>
            <td style="width:30%;vertical-align:top;">
                <div id="client_address">
                    <p>
                        <span style="font-weight:bold;">Bill To</span><br>
                    <p class="uppercase"><?= $company ?></p>
                    <p class="uppercase"><?= $vendor_code ?></p>
                    <p class="uppercase"><?= $address ?></p>
                    <p class="uppercase"><?= $city ?></p>
                    <p class="uppercase"><?= $state ?></p>
                    <p >INDIA <?= $pincode ?></p>
                    <?php if (!empty($gst_no)) { ?>
                        <p> GSTIN: <?= $gst_no; ?>
                        <?php } ?>
                        <?php if ($pan_no != '' || $pan_no != null) { ?>
                        <p> PAN: <?= $pan_no; ?>
                        <?php } ?>
                        </p>
                </div>
            </td>
            <td style="width:37%;text-align:left;padding-left:1px;vertical-align:top;">
                <div id="ship_to">
                    <span class="uppercase" style="font-weight:bold;">Ship To</span><br>
                    <p class="uppercase"><?= $company ?></p>
                    <p class="uppercase"><?= $address ?></p>
                    <p class="uppercase"><?= $city ?></p>
                    <p class="uppercase"><?= $state ?></p>
                    <p>INDIA <?= $pincode ?></p>

                </div>
            </td>
            <td style="width:33%;vertical-align:top;">
                <div id="client_details">
                    <table id="client_detail_table">
                        <tr>
                            <td class="left" style="text-align: left;">GSTIN</td>
                            <td class="left">36AASCS2801C1ZI</td>
                        </tr>
                        <tr>
                            <td class="left uppercase">Debit Note Number</td>
                            <td class="left uppercase"><?= $purchase_return_no ?></td>
                        </tr>
                        <tr>
                            <td class="left uppercase">Invoice Number</td>
                            <td class="left uppercase"><?= $invoice_no ?></td>
                        </tr>
                        <tr>
                            <td class="left uppercase">Invoice Date</td>
                            <td class="left uppercase"><?= $invoice_date ?></td>
                        </tr>
                        <tr>
                            <td class="left uppercase">Vendor Creditnote No</td>
                            <td class="left uppercase"><?= $creditnote_no ?></td>
                        </tr>
                        <tr>
                            <td class="left uppercase">Debitnote Date</td>
                            <td class="left uppercase"><?= $creditnote_date ?></td>
                        </tr>
                        <tr>
                            <td class="left uppercase">Place of Supply</td>

                            <td class="left uppercase"><?= $placeofsupply ?></td>
                        </tr>
                        <tr>
                            <td class="left uppercase">HSN Code</td>
                            <td class="left uppercase">851712 - Mobile Phone</td>
                        </tr>
                        <tr>
                            <td class="left uppercase">Currency</td>
                            <td class="left uppercase">INR</td>
                        </tr>
                    </table>
                </div>
            </td>
        </tr>
    </table>

    <p style="clear:both;"></p><br>


    <div id="invoice_div">
        <table id="invoice_table" style="width:100%;" cellspacing="0">
            <thead style="text-align: center;font-size:9px;">
                <tr>
                    <th class = "uppercase" style="text-align:left;white-space:nowrap;">Product Name</th>
                    <th class = "uppercase" style="width: 10px;">Qty</th>
                    <th class="right uppercase">Price</th>
                    <th class="right uppercase">Taxable<p style="margin:0px;">Amount</p>
                    </th>
                    <th class="right uppercase">Exempt<p style="margin:0px;">Amount</p>
                    </th>
                    <th class="right uppercase">Tax<p style="margin:0px;">Rate</p>
                    </th>
                    <th class="right uppercase">Tax<p style="margin:0px;">Amount</p>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($devices)) {
                    $total_units = 0;
                    $total_taxable = 0;
                    $total_exempt = 0;
                    $total_tax = 0;
                    $total_amount = 0;
                    $taxable_cat = TAXABLE_CATEGORY;
                    foreach ($devices as $rowValue) {
                        $total_exempt += $rowValue['exempt_amount'];
                        $total_taxable += $rowValue['taxable_amount'];
                        $total_tax += $rowValue['tax_amount'];
                        $total_amount += $rowValue['price'];
                        $total_units += $rowValue['quantity'];
                ?>
                        <tr style="line-height:15px;">
                            <td class="uppercase" style="text-align:left;padding-bottom:2px;padding-top:2px;"><?= $rowValue['device_name'] ?></td>
                            <td class="uppercase" style="text-align:center;padding-bottom:2px;padding-top:2px;"><?= $rowValue['quantity'] ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($rowValue['price'], 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($rowValue['taxable_amount'], 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($rowValue['exempt_amount'], 2)) ?></td>
                            <td class="right rupee" style="padding-bottom:2px;padding-top:2px;">18%</td>
                            <td class="right" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format($rowValue['tax_amount']) ?></td>
                        </tr>
                <?php
                    }
                }

                if (strtoupper($state) == 'TELANGANA') {
                    $igst = 0;
                    $sgst = $cgst = round($total_tax / 2, 2);
                } else {
                    $igst = round($total_tax, 2);
                    $sgst = $cgst = 0;
                }

                ?>


            <tfoot class="footer_table">



                <tr style="line-height:15px;">
                    <td class = "uppercase">Net Value</td>
                    <td class = "uppercase" style="text-align:center;padding-bottom:2px;padding-top:2px;"><?= $total_units ?></td>
                    <td class="uppercase right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_amount, 2)) ?></td>
                    <td class="uppercase right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_taxable, 2)) ?></td>
                    <td class="uppercase right rupee" style="padding-bottom:2px;padding-top:2px;"><?= IND_money_format(round($total_exempt, 2)) ?></td>
                    <td colspan="2" class="right uppercase" style="padding-bottom:2px;padding-top:2px;"><span class="rupee"><?= IND_money_format($total_tax) ?></td>
                </tr>

                <tr style="line-height:15px;">
                    <td class="uppercase" colspan="3"><?= amounttowords($total_amount) ?></td>
                    <?php if ($igst > 0) { ?>
                        <td colspan="2" class="right uppercase">Tax Break-Up</td>
                        <td colspan="2" class="right uppercase" style="padding-bottom:2px;padding-top:1px;">IGST <span class="rupee"><?= IND_money_format($igst) ?></td>
                    <?php } else { ?>
                        <td colspan="2" class="right uppercase">Tax Break-up</td>
                        <td colspan="2" class="right uppercase" style="padding-bottom:2px;padding-top:1px;">
                            CGST <span class="rupee uppercase"><?= IND_money_format(round($cgst / 2, 2)) ?>
                                &nbsp;| SGST <span class="rupee uppercase"><?= IND_money_format(round($sgst / 2, 2)) ?> </td>
                    <?php } ?>
                </tr>


            </tfoot>
        </table>

    </div>
    <p></p><br>
    <p></p>

    <div style="font-size:10px;">
        <p>
        <div style="page-break-inside:avoid;">
            <div style="float:left;page-break-inside:avoid;width:60%;height:40px;">
                <p class = "uppercase" style="font-weight: bold;">Notes</p>
                <p class = "uppercase"> 
                Return Type : <?= $return_type ?>
                <p class = "uppercase" style="position:relative;font-weight:bold;text-align:right;">Thank you for your Business.</p>
            </div>
            <div style="float:right;page-break-inside:avoid;">
                <br>
                <span class = "uppercase" style="font-weight:700;">For Sloyd Ventures (P) Ltd.,</span>
                <p style="width:50px;height:50px;"></p>
                <p class = "uppercase">Authorised Signature</p>
            </div>
        </div>
        
    </div>

    <?php if (!empty($qr_code) && !empty($irn)) { ?>
        <table id="heading" style="text-align:center;width:100%;border-bottom:none;margin-top:-30px;">

            <tr style="border-bottom:none;">
                <td class = "uppercase" style="align-content:left;text-align:left;border-bottom:none;">
                    IRN: <?= $irn ?>
                </td>
                <td class = "uppercase" style="border-bottom:none;">
                    <image src="<?php base_url() ?><?= $filename ?>" style="width:150px;height:150px;">
                </td>
            </tr>
        </table>
    <?php } ?>



    <div class="signature">
    </div>
</body>

</html>

<?php
function IND_money_format($number)
{
    $decimal = (string)($number - floor($number));
    $money = floor($number);
    $length = strlen($money);
    $delimiter = '';
    $money = strrev($money);

    for ($i = 0; $i < $length; $i++) {
        if (($i == 3 || ($i > 3 && ($i - 1) % 2 == 0)) && $i != $length) {
            $delimiter .= ',';
        }
        $delimiter .= $money[$i];
    }

    $result = strrev($delimiter);
    $decimal = preg_replace("/0\./i", ".", $decimal);
    $decimal = substr($decimal, 0, 3);

    if ($decimal != '0') {
        $result = $result . $decimal;
    }
    if ($decimal == "0") {
        $result = $result . '.00';
    }

    return $result;
}

function amounttowords($number)
{
    $no = $number;
    $point = round($number - $no, 2) * 100;
    $hundred = null;
    $digits_1 = strlen($no);
    $i = 0;
    $str = array();
    $words = array(
        '0' => '', '1' => 'One', '2' => 'Two',
        '3' => 'Three', '4' => 'Four', '5' => 'Five', '6' => 'Six',
        '7' => 'Seven', '8' => 'Eight', '9' => 'Nine',
        '10' => 'Ten', '11' => 'Eleven', '12' => 'Twelve',
        '13' => 'Thirteen', '14' => 'Fourteen',
        '15' => 'Fifteen', '16' => 'Sixteen', '17' => 'Seventeen',
        '18' => 'Eighteen', '19' => 'Nineteen', '20' => 'Twenty',
        '30' => 'Thirty', '40' => 'Forty', '50' => 'Fifty',
        '60' => 'Sixty', '70' => 'Seventy',
        '80' => 'Eighty', '90' => 'Ninety'
    );
    $digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
    while ($i < $digits_1) {
        $divider = ($i == 2) ? 10 : 100;
        $number = floor($no % $divider);
        $no = floor($no / $divider);
        $i += ($divider == 10) ? 1 : 2;
        if ($number) {
            $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
            $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
            $str[] = ($number < 21) ? $words[$number] .
                " " . $digits[$counter] . $plural . " " . $hundred
                :
                $words[floor($number / 10) * 10]
                . " " . $words[$number % 10] . " "
                . $digits[$counter] . $plural . " " . $hundred;
        } else $str[] = null;
    }
    $str = array_reverse($str);
    $result = implode('', $str);
    $points = ($point) ?
        "." . $words[$point / 10] . " " .
        $words[$point = $point % 10] : '';
    return "RUPEES ".$result . " ONLY";
}
?>