<style>
    tr {
        height: 30px;
    }

    th,
    td {
        white-space: nowrap;
    }


    td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
        background-position-x: left;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
        background-position-x: left;
    }

    td.purchase_return_id {
        font-size: 0;
    }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
    <label class="btn btn-primary active">
        <input type="radio" name="options" id="button_finance_pending">FINANCE PENDING
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="button_admin_pending">ADMIN PENDING
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="button_cn_created">DB CREATED
    </label>
    <label class="btn btn-primary" active>
        <input type="radio" name="options" id="button_finance_rejected">FINANCE REJECTED
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="button_cancelled">CANCELLED
    </label>

</div>

<p style="line-height:10px;"></p>
<div class="table-responsive scrolledTable">
    <table class="table table-striped DataTables" style="margin-left:5px;" id="purchaseReturnList_table">
        <thead>
            <tr>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>PURCHASE <br> RETURN NO</th>
                <th>Vendor Name</th>
                <th>Invoice No</th>
                <th>Credit Note No</th>
                <th>Invoice Date</th>
                <th>Credit Note Date</th>
                <th>Total Amount</th>
                <th>Taxable Amount</th>
                <th>Exempt Amount</th>
                <th>Tax Amount</th>
                <th>Quantity</th>
                <th>Status</th>
                <th>CREATED BY</th>
                <th>LAST<br>UPDATED BY</th>
                <th>CREATION<br> DATE</th>
                <th>LAST UPDATE<br> DATE</th>
            </tr>
        </thead>
    </table>
</div>

<!-- <div class="modal fade" id="modalReject" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header text-center">
                <button type="button" class="close" onclick="closeModal()" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <input type="hidden" id="finance_reject_claims_id_modal">
            <div class="modal-body mx-3">
                <div class="form-group">
                    <label class="col-lg-3 control-label">PR
                        NO</label>
                    <div class="col-lg-9">
                        <span class="form-control" id="finance_reject_claim_no_modal"></span>
                    </div>
                </div><br>
                <div class="form-group">
                    <label class="col-lg-3 control-label">REMARKS</label>
                    <div class="col-lg-9">
                        <textarea class="form-control" id="finance_reject_remarks_modal"></textarea>
                    </div>
                </div>
            </div><br>
            <div class="modal-footer d-flex justify-content-center">
                <button class="btn btn-success" id="finance_reject_submit_modal" CausesValidation="False">Reject</button>
                <button class="btn btn-danger" id="finance_reject_close_modal" CausesValidation="False">Close</button>
            </div>
        </div>
    </div>
</div> -->

<!-- Cancel Modal -->
<div class="modal fade" id="modalCancel" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header text-center">
                <button type="button" class="close" onclick="closeModal()" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <input type="hidden" id="cancel_purchase_return_id_modal">
            <div class="modal-body mx-3">
                <div class="form-group">
                    <label class="col-lg-3 control-label">PR
                        NO</label>
                    <div class="col-lg-9">
                        <span class="form-control" id="cancel_purchase_return_no_modal"></span>
                    </div>
                </div><br>
                <div class="form-group">
                    <label class="col-lg-3 control-label">REMARKS</label>
                    <div class="col-lg-9">
                        <textarea class="form-control" id="cancel_remarks_modal"></textarea>
                    </div>
                </div>
            </div><br>
            <div class="modal-footer d-flex justify-content-center">
                <button class="btn btn-success" id="cancel_submit_modal" CausesValidation="False" onclick="cancelPurchaseReturn()">Cancel</button>
                <button class="btn btn-danger" id="cancel_close_modal" CausesValidation="False" onclick="closeModal()">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    var service_center_list;
    var department_id = getUserdata('department_id')

    function getUserdata(attribute) {

        var a = '';
        $.ajax({
            "url": "<?= base_url() ?>Web_api/getUserData/" + attribute,
            "type": "GET",
            "dataType": "json",
            "async": false,
            "success": function(data) {
                a = data.result;
            }
        })
        return a;
    }

    $(document).ready(function() {

        purchaseReturnList('FINANCE_PENDING')

        function purchaseReturnList(status) {

            purchaseReturnList_table = $('#purchaseReturnList_table').DataTable({
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "scrollY": 390,
                "scrollX": true,
                "scrollCollapse": true,
                //"autoWidth": false,
                "aaSorting": [2, 'asc'],
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/Purchase_return/getPurchaseReturnList",
                    "data": {
                        "status": status
                    },
                    "type": "GET",
                    "dataSrc": "data"
                },
                "columns": [{
                        "className": 'details-control purchase_return_id',
                        "data": "purchase_return_id"
                    },
                    {},
                    {
                        "data": "purchase_return_no"
                    },
                    {
                        "data": "vendor_name"
                    },
                    {
                        "data": "invoice_no"
                    },
                    {
                        "data": "creditnote_no"
                    },
                    {
                        "data": "invoice_date"
                    },
                    {
                        "data": "creditnote_date"
                    },
                    {
                        "data": "total_amount"
                    },
                    {
                        "data": "taxable_amount"
                    },
                    {
                        "data": "exempt_amount"
                    },
                    {
                        "data": "tax_amount"
                    },
                    {
                        "data": "quantity"
                    },
                    {
                        "data": "status"
                    },
                    {
                        "data": "created_by"
                    },
                    {
                        "data": "last_updated_by"
                    },
                    {
                        "data": "creation_date"
                    },
                    {
                        "data": "last_update_date"
                    },
                ],

                "columnDefs": [{
                    "targets": 1,
                    "data": null,
                    "render": function(a, b, data, d) {
                        let icn = ''
                        if (data.status == 'FINANCE_PENDING' && department_id == '6') {

                            icn += '<a class="fa fa-edit" href="<?= base_url() ?>admin/Purchase_return/updatePurchaseReturnFinanceForm/' + data.purchase_return_id + '">'
                            icn += '</a>'


                        } else if (data.status == 'ADMIN_PENDING' && department_id == '13') {

                            icn += '&nbsp;&nbsp;&nbsp;&nbsp;<a class="fa fa-edit" href="<?= base_url() ?>admin/Purchase_return/updatePurchaseReturnAdminForm/' + data.purchase_return_id + '">'
                            icn += '</a>'

                        }
                        if (data.status != 'CANCELLED') {
                            icn += '&nbsp;&nbsp;&nbsp;<a class="fa fa-file-pdf-o" href="<?= base_url() ?>admin/Purchase_return/purchaseReturnPDF/' + data.purchase_return_id + '" target="_blank">'
                            icn += '</a>'
                        }

                        if (data.status != 'CANCELLED' && data.status != 'FINANCE_REJECTED' && data.status != 'CN_CREATED') {
                            icn += '&nbsp;&nbsp;&nbsp;<a class="fa fa-trash" href="javascript:void(0);" onclick="cancelModal(this)">'
                            icn += '</a>'
                        }
                        return icn
                    }
                }]
            });

        }

        $('#purchaseReturnList_table tbody').on('click', 'td.details-control', function() {

            var tr = $(this).closest('tr');
            var row = purchaseReturnList_table.row(tr);

            if (row.child.isShown()) {
                row.child.hide();
                tr.removeClass('shown');

            } else {

                row.child(format(row.data())).show();
                tr.addClass('shown');
            }
        });

        $('#button_finance_pending').change(function() {
            purchaseReturnList('FINANCE_PENDING')
        });

        $('#button_admin_pending').change(function() {
            purchaseReturnList('ADMIN_PENDING')
        });

        $('#button_cn_created').change(function() {
            purchaseReturnList('CN_CREATED')
        });

        $('#button_finance_rejected').change(function() {
            purchaseReturnList('FINANCE_REJECTED')
        });

        $('#button_cancelled').change(function() {
            purchaseReturnList('CANCELLED')
        });


        function format(d) {

            // `d` is the original data object for the row
            var tableData = '<br><p></p>';

            tableData += '<p style="text-align: left; margin-left: 15px; font-weight:700;">Devices</p>';
            tableData += '<table cellpadding="5" cellspacing="0" border="0" class="table-bordered " style="padding-left:50px;">';

            $.ajax({
                "url": "<?php echo base_url(); ?>admin/Purchase_return/getPurchaseReturnItems?purchase_return_id=" + d.purchase_return_id,
                "type": "GET",
                "dataType": 'json',
                "async": false,
                "success": function(data) {

                    if (data.status != 1) {
                        tableData += "<tr>"
                        tableData += "<td>NO RECORDS FOUND</td>"
                        tableData += "</tr>";
                        return false
                    }

                    tableData += "<thead><th>DEVICE ID</th><th>Device Name</th><th>SKU/Variant</th><th>Color</th><th>Ref No</th><th>Quantity</th>" +
                        "<th>Taxable Amount</th><th>Exempt Amount</th><th>Tax Amount</th><th>Price</th><th>Remarks</th></thead>"

                    $.each(data.data, function(i, v) {

                        tableData += "<tr>"
                        if (data.data[i].nhdin != null) {
                            tableData += "<td>" + data.data[i].nhdin + "</td>"
                        } else {
                            tableData += "<td></td>"
                        }
                        tableData += "<td>" + data.data[i].device_name + "</td>"
                        tableData += "<td>" + data.data[i].sku + "</td>"
                        tableData += "<td>" + data.data[i].color + "</td>"
                        tableData += "<td>" + data.data[i].ref_no + "</td>"
                        tableData += "<td>" + data.data[i].quantity + "</td>"
                        tableData += "<td>" + data.data[i].taxable_amount + "</td>"
                        tableData += "<td>" + data.data[i].exempt_amount + "</td>"
                        tableData += "<td>" + data.data[i].tax_amount + "</td>"
                        tableData += "<td>" + data.data[i].price + "</td>"
                        tableData += "<td>" + data.data[i].remarks + "</td>"
                        tableData += "</tr>";
                    })
                }
            });
            tableData += '</table>'
            return tableData;
        }
    })

    function cancelModal(d) {
        var tr = $(d).closest('tr');
        var row = purchaseReturnList_table.row(tr);
        var data = row.data();
        $("#cancel_purchase_return_no_modal").text(data.purchase_return_no)
        $("#cancel_purchase_return_id_modal").val(data.purchase_return_id)
        $('#modalCancel').modal('show')
    }

    function closeModal() {
        $("#cancel_purchase_return_no_modal").text('')
        $("#cancel_purchase_return_id_modal").val('')
        $('#modalCancel').modal('hide')
    }

    function cancelPurchaseReturn() {

        var remarks = $("#cancel_remarks_modal").val();
        var purchase_return_id_cancel = $("#cancel_purchase_return_id_modal").val();

        if (remarks == '') {
            toastr.error("Please enter remarks");
            return false;
        }

        if(purchase_return_id_cancel == '' || purchase_return_id_cancel == null || purchase_return_id_cancel == undefined){
            toastr.error("Please select purchase return");
            return false;
        }

        var data = {
            "purchase_return_id": purchase_return_id_cancel,
            "remarks_header": remarks
        }

        var jsonObject = JSON.stringify(data)

        $("#submit").attr('disabled', true)
        $.ajax({
            url: "<?php echo base_url(); ?>admin/Purchase_return/cancelPurchaseReturn",
            dataType: 'json',
            data: jsonObject,
            type: 'POST',
            success: function(data) {
                if (data.status == 1) {

                    toastr.success(data.message);

                    window.location.replace("<?= base_url() ?>admin/Purchase_return/manage_purchase_return");

                } else {
                    $("#submit").attr("disabled", false);
                    toastr.error('Failed to Cancel Purchase Return');
                }
            },
            error: function() {
                $("#submit").attr("disabled", false);
                toastr.error('Failed to Cancel Purchase Return');
            }
        });

    }
</script>