<style>
	#purchaseReturnTable th {
		text-align: center;
	}

	#purchaseReturnTableShortfall th {
		text-align: center;
	}
</style>
<div class="form-group table-responsive">

	<div class="col-sm-12 form-horizontal">
		<div class="col-sm-6 col-md-6">
			<div class="form-group">
				<label class="col-sm-4 control-label">Procurement Channel</label>
				<div class="col-sm-6">
					<select style="width: 100%;" class="form-control select_box" id="procurement_channel" name="procurement_channel">
						<option value="">Procurement Channel</option>
						<option value="AMAZON">AMAZON</option>
						<option value="FLIPKART">FLIPKART</option>
						<option value="XIAOMI">XIAOMI</option>
						<option value="YAANTRA">YAANTRA</option>
						<option value="OFFLINE">OFFLINE</option>
						<option value="OTHERS">OTHERS</option>
					</select>
				</div>
			</div>
			<div class="form-group">
				<label class="col-sm-4 control-label">Select Vendor</label>
				<div class="col-sm-6">
					<select class="form-control select_box" style="width: 100%;" id="select_new_vendor" name="select_new_vendor" onchange="getInvoices()">
						<option value="">Select Vendor</option>
					</select>
				</div>
			</div>
			<div class="form-group">
				<label class="col-sm-4 control-label">Select Invoice</label>
				<div class="col-sm-6">
					<select class="form-control select_box" id="select_new_invoice" name="select_new_invoice" style="width: 100%;">
						<option value="">Select Invoice</option>
					</select>
				</div>
			</div>
			<div class="form-group">
				<label class="col-sm-4 control-label">Select Category</label>
				<div class="col-sm-6">
					<select class="form-control select_box" id="select_new_category" name="select_new_invoice" style="width: 100%;">
						<option value="">Select Category</option>
					</select>
				</div>
			</div>
			<div class="form-group">
				<label class="col-sm-4 control-label">Vendor Creditnote No</label>
				<div class="col-sm-6">
					<input type="text" class="form-control" id="creditnote_no" name="creditnote_no" placeholder="Creditnote No">
				</div>
			</div>
			<div class="form-group">
				<label class="col-sm-4 control-label">Debitnote Date</label>
				<div class="col-sm-6">
					<input type="date" class="form-control" id="creditnote_date" name="creditnote_date" placeholder="Creditnote Date">
				</div>
			</div>
			<div class="form-group">
				<label class="col-sm-4 control-label">Type</label>
				<div class="col-sm-6">
					<!-- Radio Buttons -->
					<div class="radio">
						<label>
							<input type="radio" name="return_type" id="return_type" value="rejected" checked>
							Rejected
						</label>
						&nbsp;&nbsp;&nbsp;&nbsp;
						<label>
							<input type="radio" name="return_type" id="return_type" value="shortfall">
							Shortfall
						</label>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div style="width: 100%;overflow-x: auto;">
	<table style="margin-left:5px; width:100%;" id="purchaseReturnTable">
		<thead>
			<tr>
				<th>DEVICE ID</th>
				<th>PRODUCT</th>
				<th>SKU</th>
				<!--<th>Taxable<br>Amount</th>
				<th>Exempt<br>Amount</th>
				<th>Tax<br>Amount</th>
				<th>Total<br>Amount</th>
				-->
				<th>REMARKS</th>
			</tr>
		</thead>
		<tbody>
			<tr id="purchaseReturnTableRow" class="purchaseReturnTableRow">
				<td>
					<input name="nhdin_rej" onchange="getDeviceDetails(this)" value="" style="width:120px" type="text">
					<input name="grnreport_id" value="" style="width:120px" type="hidden">
				</td>
				<td><input name="product" value="" type="text" style="width:140px" disabled></td>
				<td><input name="sku" value="" type="text" style="width:140px" disabled></td>
				<!--<td><input name="taxable_row_rej" value="" type="NUMBER" onkeypress="return event.keyCode !=32" style="width:100px"></td>
				<td><input name="exempt_row_rej" value="" type="NUMBER" onkeypress="return event.keyCode !=32" style="width:100px"></td>
				<td><input name="tax_row_rej" value="" type="NUMBER" onkeypress="return event.keyCode !=32" style="width:100px"></td>
				<td><input name="total_row_rej" value="" type="NUMBER" onkeypress="return event.keyCode !=32" style="width:100px"></td>
				-->
				<td><textarea name="remarks_rej" value="" type="text" style="border: 1"></textarea></td>
			</tr>
		</tbody>
	</table>
</div>
<div style="width: 100%; overflow-x:auto;">

	<table style="margin-left:5px; width:100%; display:none;overflow-x:auto;" id="purchaseReturnTableShortfall">
		<thead>
			<tr>
				<th>Device Model</th>
				<th>RAM</th>
				<th>ROM</th>
				<th>COLOR</th>
				<th>Quantity</th>
				<th>Ref. No</th>
				<th>REMARKS</th>
			</tr>
		</thead>
		<tbody>
			<tr id="purchaseReturnTableRowShortfall" class="purchaseReturnTableRowShortfall">
				<td style="width:300px;text-align:center;">
					<select class="form-control model_row select_box" id="model_row" style="width: 100%;" onchange="addNewShortfallRow(this)" placeholder="Model Name">
						<option value="">Model Name</option>
					</select>
				</td>
				<td style="width: 140px;padding-left: 10px;">
					<select name="ram_row_sf" class="ram_row_sf form-control" id = "ram_row_sf" value="" type="text" style="width:100%">
					<option value="">Select RAM</option>
			</select>
			</td>
			<td style="width: 140px;padding-left: 10px;">
					<select class="rom_row_sf form-control" id="rom_row_sf" value="" type="text" style="width:100%">
						<option value="">Select ROM</option>
					</select>
				</td>
				<td><input class="color_row_sf" value="" type="text" style="width:80px"></td>
				<td><input class="quantity_row_sf" value="" type="number" onkeypress="return event.keyCode !=32" style="width:80px"></td>
				<td><input class="ref_row_sf" value="" type="text" style="width:80px"></td>
				<!-- <td><input class="taxable_row_sf" value="" type="NUMBER" onkeypress="return event.keyCode !=32" style="width:100px"></td>
				<td><input class="exempt_row_sf" value="" type="NUMBER" onkeypress="return event.keyCode !=32" style="width:100px"></td>
				<td><input class="tax_row_sf" value="" type="NUMBER" onkeypress="return event.keyCode !=32" style="width:100px"></td>
				<td><input class="total_row_sf" value="" type="NUMBER" onkeypress="return event.keyCode !=32" style="width:100px"></td> -->
				<td><textarea name="remarks_row_sf" class="remarks_row_sf" value="" type="text" style="border: 1"></textarea></td>
			</tr>
		</tbody>
	</table>
</div>
<br>
<!-- <p style="margin-left:5px">Total Entries: <span id="purchaseReturnTotalEntries"></span></p> -->

<hr style="border: 3px solid #e4eaec">
<div class="form-group">
	<label class="col-lg-3 control-label"></label>
	<div class="col-lg-6">
		<button type="submit" onclick="createPurchaseReturn(event)" class="btn btn-sm btn-primary">SUBMIT</button>
	</div>
</div>



<script>
	var i = '<?php echo $totalCount; ?>';
	var rowCount = 0;
	var rowCountShortfall = 0;
	let model_list = ''
	let ram_list = ''
	let rom_list = ''
	let scanned_devices = []
	getVendorDetails()
	getModelList()
	dropdown('CATEGORY', 'select_new_category');
	getDeviceMemory('ROM', 'rom_row_sf')
	getDeviceMemory('RAM', 'ram_row_sf')

	$(document).ready(function() {
		$('form').keydown(function(e) {
			if (e.keyCode == 13) {
				e.preventDefault();
				return false;
			}
		});
	});

	function getVendorDetails() {
		$.ajax({
			url: "<?php echo base_url(); ?>admin/Vendor/getVendorList",
			method: "GET",
			dataType: "JSON",
			data: {
				"type": "supplier"
			},
			success: function(data) {
				var options = ''
				$.each(data.data, function(i, v) {
					options += '<option value="' + v.vendor_id + '">' + v.company + '-' + v.vendor_code + '-' + v.city + '</option>';
				})
				$('#select_new_vendor').append(options);
			}

		})
	}

	function getDeviceMemory(type, select_id) {
		$.ajax({
			type: "GET",
			url: "<?= base_url() ?>admin/DropDownItems/getDeviceMemory?type=" + type,
			data: {},
			dataType: "json",
			success: function(data) {
				let memory_options = '<option value="">Select ' + type + '</option>'
				$.each(data, function(i, v) {
					memory_options += '<option value="' + data[i].value + '">' + data[i].value + '</option>'
				})
				$("#" + select_id).append(memory_options)
				if(type == 'RAM') {
					ram_list = memory_options
				}else if(type == 'ROM') {
					rom_list = memory_options
				}
				return true
			},
			error: function(error) {
				alert(error.responseJSON.message);
			}
		});
	}

	function dropdown(type, select_id) {
		$.ajax({
			type: "GET",
			url: "<?= base_url() ?>admin/DropDownItems/getItems?type=" + type,
			data: {},
			dataType: "json",
			success: function(data) {

				$.each(data, function(i, v) {
					$("#" + select_id).append('<option value="' + data[i].name + '">' + data[i].name + '</option>')
				})

			},
			error: function(error) {
				alert(error.responseJSON.message);
			}
		});
	}

	function getInvoices() {

		var vendor_id = $('#select_new_vendor').val();
		$("#select_new_invoice").html('');
		$("#select_new_invoice").change()
		if (vendor_id == '') {
			return true;
		}

		$.ajax({
			url: "<?php echo base_url(); ?>admin/Purchase_return/getVendorInvoices",
			method: "GET",
			dataType: "JSON",
			data: {
				"supplier_id": vendor_id
			},
			success: function(data) {

				if (data.status != 1) {
					toastr.error(data.message);
					return false;
				}
				var options = ''
				options = '<option value="">Select Invoice</option>';
				$.each(data.result, function(i, v) {
					options += '<option value="' + v.invoice_id + '">' + v.invoice_no + '</option>';
				})
				$('#select_new_invoice').append(options);
				$("#select_new_invoice").change()
			},
			error: function(data) {
				toastr.error("Failed to get Invoices List");
			}
		})
	}

	function getModelList() {
		$.ajax({
			url: "<?php echo base_url(); ?>admin/Purchase_return/getProductDetails",
			method: "GET",
			dataType: "JSON",
			data: {},
			success: function(data) {
				$.each(data.data, function(i, v) {
					model_list += '<option value="' + v.product_name + '">' + v.product_name + '</option>';
				})
				$('#model_row').append(model_list);
			}
		})
	}


	function addRowPurchaseReturnTable() {
		var data = $('#purchaseReturnTableRow').html();
		$('#purchaseReturnTable').find('tbody').append("<tr>" + data + "</tr>");
	}

	function addNewShortfallRow(d) {
		if (d.value == '') {
			return;
		}
		console.log(ram_list)
		let sf_row = '<tr class="purchaseReturnTableRowShortfall">' +
			'<td style="width:200px;text-align:center">' +
			'<select class="form-control model_row" style="width:100%" onchange="addNewShortfallRow(this)" placeholder="Model Name">' +
			'<option value="">Model Name</option>' +
			model_list +
			'</select>' +
			'</td>' +
			'<td style="width:140px; padding-left:10px"><select name="ram_row_sf" class="form-control ram_row_sf" value="" onkeypress="return event.keyCode !=32" type="text" style="width:100%" >'+
			ram_list+
			'</td>' +
			'<td style="width:140px; padding-left:10px"><select class="form-control rom_row_sf" value="" type="text" onkeypress="return event.keyCode !=32" style="width:100%" >'+
			rom_list+
			'</td>'+
			'<td><input class="color_row_sf" value="" type="text" onkeypress="return event.keyCode !=32" style="width:80px" ></td>' +
			'<td><input class="quantity_row_sf" value="" type="number" onkeypress="return event.keyCode !=32" style="width:80px" ></td>' +
			'<td><input class="ref_row_sf" value="" type="text" onkeypress="return event.keyCode !=32" style="width:80px" ></td>' +
			//'<td><input class="taxable_row_sf" value="" type="text" onkeypress="return event.keyCode !=32" style="width:100px" ></td>' +
			//'<td><input class="exempt_row_sf" value="" type="text" onkeypress="return event.keyCode !=32" style="width:100px" ></td>' +
			//'<td><input class="tax_row_sf" value="" type="text" onkeypress="return event.keyCode !=32" style="width:100px" ></td>' +
			//'<td><input class="total_row_sf" value="" type="text" onkeypress="return event.keyCode !=32" style="width:100px" ></td>' +
			'<td><textarea name="remarks_row_sf" class="remarks_row_sf" value="" type="text" style="border: 1"></textarea></td>' +
			'</tr>'
		$('#purchaseReturnTableShortfall').find('tbody').append("<tr>" + sf_row + "</tr>");
		$(".model_row").select2()
		rowCountShortfall = rowCountShortfall + 1;
	}

	function getDeviceDetails(x) {
		var deviceid = x.value;
		var row_id = $(x).closest('tr').index();
		var invoice_no = $("#select_new_invoice option:selected").text();
		if (scanned_devices.includes(deviceid)) {
			toastr.error("Device Already Scanned");
			return false;
		}

		$('input[name$="bin"]:eq(' + row_id + ')').val('');
		$('input[name$="imei"]:eq(' + row_id + ')').val('');
		$('input[name$="product"]:eq(' + row_id + ')').val('');
		$('input[name$="stocktype"]:eq(' + row_id + ')').val('');
		$('input[name$="remarks_rej"]:eq(' + row_id + ')').val('');
		$('input[name$="sku"]:eq(' + row_id + ')').val('');
		$('input[name$="status"]:eq(' + row_id + ')').val('');
		$('input[name$="certification_grade"]:eq(' + row_id + ')').val('');
		$('input[name$="grnreport_id"]:eq(' + row_id + ')').val('');

		$.ajax({
			url: "<?php echo base_url(); ?>admin/certification/getDeviceDetails",
			dataType: 'json',
			data: {
				deviceid: deviceid
			},
			type: 'POST',
			error: function() {
				totalPurchaseReturnEntries()
				$('.nhdinInvoiceLoader').css('display', 'none');
				toastr.error('Device not found !');
			},
			success: function(data) {
				if (data.status == 'SOLD') {
					$('.nhdinInvoiceLoader').css('display', 'none');
					toastr.error('This is a Sold Device.');
					totalPurchaseReturnEntries()
					return;
				}

				if (data.status == 'RTV') {
					$('.nhdinInvoiceLoader').css('display', 'none');
					toastr.error('This is a RTV Device.');
					totalPurchaseReturnEntries()
					return;
				}

				if (invoice_no.toUpperCase() != data.invoice_no.toUpperCase()) {
					$('.nhdinInvoiceLoader').css('display', 'none');
					toastr.error('The Device Doesnt belong to selected Invoice');
					totalPurchaseReturnEntries()
					return;
				}


				$('input[name$="product"]:eq(' + row_id + ')').val(data.device_name);
				$('input[name$="grnreport_id"]:eq(' + row_id + ')').val(data.grnreport_id);

				$('input[name$="sku"]:eq(' + row_id + ')').val(data.SKU);
				addRowPurchaseReturnTable();
				rowCount = row_id + 1;
				scanned_devices.push(deviceid);
				$('input[name$="nhdin"]:eq(' + (row_id + 1) + ')').focus();
				totalPurchaseReturnEntries()
			}
		});
	}

	function createPurchaseReturn(event) {
		event.preventDefault();
		var procurement_channel = $('#procurement_channel').val();
		var vendor_id = $('#select_new_vendor').val();
		var invoice_no = $("#select_new_invoice").val();
		var creditnote_no = $("#creditnote_no").val();
		var creditnote_date = $("#creditnote_date").val();
		var return_type = $("input[name='return_type']:checked").val();
		var category = $("#select_new_category").val();

		if (procurement_channel == '') {
			toastr.error('Please select Procurement Channel');
			return;
		}

		if (vendor_id == '') {
			toastr.error('Please select Vendor');
			return;
		}

		if (category == '') {
			toastr.error('Please select Category');
			return;
		}

		if (invoice_no == '') {
			toastr.error('Please select Invoice');
			return;
		}

		if (creditnote_no.length <= 0) {
			toastr.error('Please enter Credit Note No');
			return;
		}

		if (creditnote_date == '') {
			toastr.error('Please select Credit Note Date');
			return;
		}

		var devices = [];
		var index;
		var check_failed = false;
		if (return_type == 'rejected') {
			for (index = 0; index < rowCount; index++) {

				var nhdin = $('input[name$="nhdin"]:eq(' + index + ')').val();
				var device_id = $('input[name$="grnreport_id"]:eq(' + index + ')').val();
				var remarks = $('textarea[name$="remarks_rej"]:eq(' + index + ')').val();
				//var price = parseInt($('input[name$="total_row_rej"]:eq(' + index + ')').val());
				//var taxable = parseInt($('input[name$="taxable_row_rej"]:eq(' + index + ')').val());
				//var tax = parseInt($('input[name$="tax_row_rej"]:eq(' + index + ')').val());
				//var exempt = parseInt($('input[name$="exempt_row_rej"]:eq(' + index + ')').val());

				if (device_id.length > 0) {

					if (remarks.length == 0 || remarks == null || remarks == undefined) {
						toastr.error('Please Enter Remarks for Device ' + nhdin);
						check_failed = true;
						return false;
					}
					/*
					if (isNaN(price) || price <= 0) {
						toastr.error('Invalid Total Price');
						check_failed = true;
						return false;
					}

					if (isNaN(taxable) || taxable <= 0) {
						toastr.error('Invalid Taxable Amount');
						check_failed = true;
						return false;
					}

					if (isNaN(exempt) || exempt < 0) {
						toastr.error('Invalid Exempt Amount');
						check_failed = true;
						return false;
					}

					if (isNaN(tax) || tax <= 0) {
						toastr.error('Invalid Tax Amount');
						check_failed = true;
						return false;
					}
					let calculated_price = taxable + exempt + tax;
					if (calculated_price != price) {
						toastr.error('Total Price Not Matching with Taxable Amount + Exempt Amount + Tax Amount for ' + nhdin);
						check_failed = true;
						return false;
					}
					*/
					devices.push({
						'device_id': device_id,
						'remarks': remarks
					});
				}


			}
		} else {
			$("tr.purchaseReturnTableRowShortfall").each(function() {
				var model_name = $(this).find('.model_row').val();
				var ram = $(this).find('.ram_row_sf').val();
				var rom = $(this).find('.rom_row_sf').val();
				var quantity = parseInt($(this).find('.quantity_row_sf').val());
				var color = $(this).find('.color_row_sf').val();
				var ref_no = $(this).find('.ref_row_sf').val();
				/*var taxable = parseInt($(this).find('.taxable_row_sf').val());
				var exempt = parseInt($(this).find('.exempt_row_sf').val());
				var tax = parseInt($(this).find('.tax_row_sf').val());
				var price = parseInt($(this).find('.total_row_sf').val()); */
				var remarks = $(this).find('.remarks_row_sf').val();

				if (model_name.length > 0) {
					if (isNaN(quantity) || quantity <= 0) {
						toastr.error('Invalid Quantity for ' + model_name);
						check_failed = true;
						return false;
					}
					/*
					if (isNaN(price) || price <= 0) {
						toastr.error('Invalid Total Price');
						check_failed = true;
						return false;
					}

					if (isNaN(taxable) || taxable <= 0) {
						toastr.error('Invalid Taxable Amount');
						check_failed = true;
						return false;
					}

					if (isNaN(exempt) || exempt < 0) {
						toastr.error('Invalid Exempt Amount');
						check_failed = true;
						return false;
					}

					if (isNaN(tax) || tax <= 0) {
						toastr.error('Invalid Tax Amount');
						check_failed = true;
						return false;
					}
					let calculated_price = taxable + exempt + tax;
					if (calculated_price != price) {
						toastr.error('Total Price Not Matching with Taxable Amount + Exempt Amount + Tax Amount for ' + model_name);
						check_failed = true;
						return false;
					}
					*/
					devices.push({
						'model_name': model_name,
						'ram': ram,
						'rom': rom,
						'quantity': quantity,
						'color': color,
						'ref_no': ref_no,
						'remarks': remarks
					});
				}
			})
		}

		if (check_failed) {
			return false;
		}

		if (devices.length == 0) {
			toastr.error('Please add atleast one device.');
			return;
		}

		var data = {
			'procurement_channel': procurement_channel,
			'vendor_id': vendor_id,
			'invoice_id': invoice_no,
			'creditnote_no': creditnote_no,
			'creditnote_date': creditnote_date,
			'return_type': return_type,
			'category': category,
			'devices': devices
		}

		var jsonObject = JSON.stringify(data)

		$.ajax({
			url: "<?php echo base_url(); ?>admin/Purchase_return/createPurchaseReturn",
			dataType: 'json',
			data: jsonObject,
			type: 'POST',
			error: function() {
				$('.nhdinInvoiceLoader').css('display', 'none');
				toastr.error('Device not found!');
			},
			success: function(data) {
				if (data.status != 1) {
					toastr.error("Failed to Create Purchase Return")
					return false
				}
				$('.nhdinInvoiceLoader').css('display', 'none');
				toastr.info('Purchase Return Created Successfully');
				window.location.replace("<?= base_url() ?>admin/Purchase_return/manage_purchase_return");
			}
		});
	}

	function totalPurchaseReturnEntries() {
		var count = 0;
		for (index = 0; index < rowCount; index++) {
			var product = $('input[name$="product"]:eq(' + index + ')').val();
			if (product.length > 0) {
				count = count + 1
			}
		}

		$("#purchaseReturnTotalEntries").text(count)
	}
	$("input[name=return_type]").change(function() {
		var return_type = $(this).val();
		if (return_type == 'shortfall') {
			$("#purchaseReturnTableShortfall").show()
			$("#purchaseReturnTable").hide()
		} else {
			$("#purchaseReturnTableShortfall").hide()
			$("#purchaseReturnTable").show()
		}
	})
</script>