<input type="hidden" id="update_dispatch_procurement_id" value="<?= $update_dispatch_procurement_id ?>">
<div>
	<div class="form-group table-responsive">

		<hr style="border: 3px solid #e4eaec">

		<table class="form-group table-responsive table" style="margin-left:10px;">
			<tr>
				<td>Procurement No</td>
				<td><?= $update_dispatch_procurement_no ?></td>
			</tr>
			<tr>
				<td>UPLOAD</td>
				<td><input type="file" class="form-control-file custom-file-input" id="uploadInvoiceNo"></td>
				<td colspan="9"><input type="button" id="submitInvoiceNo" class="btn btn-primary" value="Upload" onclick="uploadInvoiceNo()" /></td>
				<td colspan="9" style="text-align:right">
					<button type="button" id="file-save-button" onclick="downloadPendingInvoiceCsv()" class="btn btn-success"><i class="fa fa-file-excel-o"></i>&nbsp;Download</button>
				</td>
			</tr>
		</table>
		<hr style="border: 3px solid #e4eaec">
	</div>

	<script type="text/javascript">

		function uploadInvoiceNo() {
			$("#submitInvoiceNo").prop("disabled", true);
			let items = []
			let procurement_id = parseInt($("#update_dispatch_procurement_id").val())

			if (isNaN(procurement_id) || procurement_id <= 0) {
				return false
			}

			let fileUpload = document.getElementById("uploadInvoiceNo");
			let regex = /^([a-zA-Z0-9\s_\\.\-:])+(.csv|.txt)$/;

			if (regex.test(fileUpload.value.toLowerCase())) {
				if (typeof(FileReader) != "undefined") {
					var reader = new FileReader();

					reader.onload = function(e) {
						var rows = e.target.result.split("\n");
						var validity_fail = false;
						var k = 0;

						for (var i = 1; i < rows.length; i++) {
							var cells = rows[i].split(",");

							if (cells[0] != '') {
								let taxable_amount = +cells[3];
								let exempt_amount = +cells[4];
								let tax_amount = +cells[5];
								let tcs_amount = +cells[6];
								let total_amount = +cells[7];
								let calcuclated_tax_amount = taxable_amount*0.18;
								let calculated_total_amount = taxable_amount + tax_amount + exempt_amount + tcs_amount;

								if(isNaN(taxable_amount) || taxable_amount <= 0){
									toastr.error("Please Enter Valid Taxable Amount For "+cells[0]);
									validity_fail = true;
									break;
								}

								if(isNaN(exempt_amount)){
									toastr.error("Please Enter Valid Exempt Amount For "+cells[0]);
									validity_fail = true;
									break;
								}

								if(isNaN(tax_amount)){
									toastr.error("Please Enter Valid Exempt Amount For "+cells[0]);
									validity_fail = true;
									break;
								}

								if( tax_amount > (calcuclated_tax_amount + 5) || tax_amount < (calcuclated_tax_amount - 5) ){
									toastr.error("Calculated Tax Amount and Entered Tax Amount Didn't matched for "+cells[0]);
									validity_fail = true;
									break;
								}

								if(isNaN(total_amount) || total_amount <= 0){
									toastr.error("Please Enter Valid Total Amount For "+cells[0]);
									validity_fail = true;
									break;
								}

								if(total_amount > (calculated_total_amount+100) && total_amount < (calculated_total_amount - 100)){
									toastr.error("Calculated Total Amount and Entered Total Amount Didn't matched for "+cells[0]);
									validity_fail = true;
									break;
								}
								
								items[k] = {
									"invoice_no": cells[0],
									"taxable_amount": taxable_amount,
									"exempt_value": exempt_amount,
									"tax_amount": tax_amount,
									"tcs_amount": tcs_amount,
									"total_amount": total_amount,
									"eway_bill": cells[8].replace("\r", "")
								}
							}
							k++
						}

						if(validity_fail == true){
							$("#submitInvoiceNo").prop("disabled", false);
							return false
						}

						var data = {
							"procurement_id": procurement_id,
							"items": items
						}

						var jsonObject = JSON.stringify(data)
						
						$.ajax({
							"url": "<?= base_url(); ?>admin/Procurement/updateProcurementOthDispatch",
							"data": jsonObject,
							"dataType": "json",
							"method": "POST",
							"success": function(data) {
								if (data.status != 1) {
									$("#submitInvoiceNo").prop('disabled', false)
									toastr.error("Failed Update Invoice No")
									return false
								}
								window.location.replace("<?= base_url() ?>admin/Procurement/manage_procurement_oth")
							}
						})
					}
					reader.readAsText(fileUpload.files[0]);
				} else {
					toastr.error(fileUpload.value + " is not a valid CSV File")
				}
			} else {
				toastr.error(fileUpload.value + " is not a valid CSV File")
				$("#submit_new_procurement").prop('disabled', false)
				return false
			}
		}

		function downloadPendingInvoiceCsv(){
			let procurement_id = parseInt($("#update_dispatch_procurement_id").val())
			window.open("<?=base_url()?>admin/Procurement/exportPendingInvoiceCsv?procurement_id="+procurement_id, target="_blank")
		}
	</script>