<style>
    td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
    }

    tr {
        height: 30px;
    }

    td.procurement_id_cls {
        font-size: 0;
    }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
    <label class="btn btn-primary active">
        <input type="radio" name="options" id="procurement_button_pending">PENDING
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="procurement_button_dispatched">DISPATCHED
    </label>
    <label class="btn btn-primary">
        <input type="radio" name="options" id="procurement_button_received">RECEIVED
    </label>
    <label>
        <a class="btn btn-danger dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">REPORT</a>
        <div class="btn dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuLink">
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadProcurementData('ALL')">ALL</a>
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadProcurementData('PENDING')">PENDING</a>
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadProcurementData('DISPATCHED')">DISPATCHED</a>
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadProcurementData('RECEIVED')">RECEIVED</a>
        </div>
    </label>
</div>

<p style="line-height:10px;"></p>

<div class="col-sm-12 col-lg-12">
    <div class="table-responsive" style="width: 100%; overflow-x:auto">
        <table class="table table-bordered table-striped table-responsive" id="procurement_oth_table" style="width:100%">
            <thead>
                <tr>
                    <th></th>
                    <th></th>
                    <th>Procurement No</th>
                    <th>Accepted Date</th>
                    <th>Source</th>
                    <th>Category</th>
                    <th>Sub Category</th>
                    <th>Batch No</th>
                    <th>No of Invoices</th>
                    <th>Lot Quantity</th>
                    <th>Invoice Quantity</th>
                    <th>Total Amount</th>
                    <th>Payment Ref No</th>
                    <th>Payment Date</th>
                    <th>Payment Amount</th>
                    <th>Status</th>
                    <th>Creation Date</th>
                    <th>Created By</th>
                </tr>
            </thead>
        </table>
    </div>
</div>

<script>
    $(document).ready(function() {

        function getProcurementList(status = '') {
            if (status == '') {
                status = 'PENDING';
            }

            prc_oth_tbl = $("#procurement_oth_table").DataTable({
                "processing": false,
                "serverSide": false,
                "destroy": true,
                "order": [],

                "ajax": {
                    "url": "<?php echo site_url('admin/Procurement/getProcurementOthList') ?>",
                    "type": "POST",
                    "data": {
                        status: status
                    }
                },
                "dom": 'Bfrtip',
                "buttons": [{
                    "extend": 'csv',
                    "text": '<span class="fa fa-download" style="color:white;"></span>',
                    'className': 'btn btn-green down_btn',

                    "exportOptions": {
                        "columns": ':not(.details-control)'
                    }
                }],
                "columns": [{
                        "data": "procurement_id",
                        "className": "details-control procurement_id_cls",
                    },
                    {
                        "data": function(data) {
                            let action = '<div style="display:flex">';

                            if (data.status == 'PENDING') {
                                action += '<a href="<?php echo site_url('admin/Procurement/updateProcurementOthDispatchForm/') ?>' + data.procurement_id + '" class="fa fa-edit"></a>'
                                //action += '&nbsp;&nbsp;&nbsp;&nbsp;<a href="#" class="fa fa-trash" onclick="cancelProcDispatch(this)" style="color:red;"></a>'
                            }

                            action += '&nbsp;&nbsp;&nbsp;&nbsp;<a href="<?php echo site_url('admin/Procurement/getProcurementOthData/') ?>' + data.procurement_id + '" class="fa fa-download"></a>'
                            action += '</div>';
                            return action
                        }
                    },
                    {
                        "data": "procurement_no"
                    },
                    {
                        "data": "lot_accepted_date"
                    },
                    {
                        "data": "source"
                    },
                    {
                        "data": "category"
                    },
                    {
                        "data": "sub_category"
                    },
                    {
                        "data": "batch_no"
                    },
                    {
                        "data": "invoice_count"
                    },
                    {
                        "data": "accepted_qty"
                    },
                    {
                        "data": "invoice_qty"
                    },
                    {
                        "data": "total_amount"
                    },
                    {
                        "data": "payment_ref_no"
                    },
                    {
                        "data": "payment_date"
                    },
                    {
                        "data": "payment_amount"
                    },
                    {
                        "data": "status"
                    },
                    {
                        "data": "creation_date"
                    },
                    {
                        "data": "created_by"
                    },
                ]
            });
        }

        getProcurementList('PENDING')

        $('#procurement_button_pending').change(function() {
            getProcurementList('PENDING')
        })

        $('#procurement_button_dispatched').change(function() {
            getProcurementList('DISPATCHED')
        })

        $('#procurement_button_received').change(function() {
            getProcurementList('RECEIVED')
        })

        // Expand/Collapse
        $('#procurement_oth_table tbody').on('click', 'td.details-control', function() {
            var tr = $(this).closest('tr');
            var row = prc_oth_tbl.row(tr);

            if (row.child.isShown()) {
                // This row is already open - close it
                row.child.hide();
                tr.removeClass('shown');
            } else {
                // Open this row
                console.log(format(row.data()))
                row.child(format(row.data())).show();
                tr.addClass('shown');
            }
        });

        function format(d) {
            // `d` is the original data object for the row
            let procurement_id = d.procurement_id;
            var invoice_html = '';
            invoice_html = '<table class="table table-bordered table-striped table-responsive" style="width:100%">';
            invoice_html += '<thead>';
            invoice_html += '<tr>';
            invoice_html += '<th>S.No</th>';
            invoice_html += '<th>Invoice NO</th>';
            invoice_html += '<th>Seller</th>';
            invoice_html += '<th>Taxable Amount</th>';
            invoice_html += '<th>Exempt Amount</th>';
            invoice_html += '<th>Tax Amount</th>';
            invoice_html += '<th>TCS Amount</th>';
            invoice_html += '<th>Eway Bill No</th>';
            invoice_html += '</tr>';
            invoice_html += '</thead>';
            invoice_html += '<tbody>';

            $.ajax({
                "url": "<?= base_url() ?>admin/Procurement/getInvoiceDataProcOth/" + procurement_id,
                "type": "POST",
                "dataType": "JSON",
                "async": false,
                "success": function(response) {
                    // Invoice No, seller, invoice_no, taxable_amount, exempt_amount, tax_amount, tcs_amount, eway_bill_no
                    let invoice_data = response.result;
                    for (let i = 0; i < invoice_data.length; i++) {
                        invoice_html += '<tr>';
                        invoice_html += '<td>' + (i + 1) + '</td>';
                        invoice_html += '<td>' + invoice_data[i].invoice_no + '</td>';
                        invoice_html += '<td>' + invoice_data[i].seller + '</td>';
                        invoice_html += '<td>' + invoice_data[i].taxable_amount + '</td>';
                        invoice_html += '<td>' + invoice_data[i].exempt_amount + '</td>';
                        invoice_html += '<td>' + invoice_data[i].tax_amount + '</td>';
                        invoice_html += '<td>' + invoice_data[i].tcs_amount + '</td>';
                        invoice_html += '<td>' + invoice_data[i].eway_bill_no + '</td>';
                        invoice_html += '</tr>';
                    }

                    invoice_html += '</tbody>';
                    invoice_html += '</table>';
                }
            })
            return invoice_html;
        }
    })

    function downloadProcurementData(status = ''){
        if(status == '') return false;

        var win = window.open('<?= base_url() ?>admin/Procurement/getProcurementOthReport?status=' + status, '_blank');
    }
</script>