<style>
    /*form styles*/
    #msform {
        width: 100%;
        margin: 20px auto;
        text-align: center;
        position: relative;
    }

    #msform fieldset {
        background: white;
        border: 0 none;
        border-radius: 3px;
        box-shadow: 0 0 15px 1px rgba(0, 0, 0, 0.4);
        padding: 20px 30px;
        box-sizing: border-box;
        width: 90%;
        margin: 0 5%;

        /*stacking fieldsets above each other*/
        position: relative;
    }

    /*Hide all except first fieldset*/
    #msform fieldset:not(:first-of-type) {
        display: none;
    }

    /*inputs*/
    #msform input,
    #msform textarea {
        padding: 15px;
        border: 1px solid #ccc;
        border-radius: 3px;
        margin-bottom: 10px;
        width: 100%;
        box-sizing: border-box;
        font-family: montserrat;
        color: #2C3E50;
        font-size: 13px;
    }

    /*buttons*/
    #msform .action-button {
        width: 100px;
        background: #27AE60;
        font-weight: bold;
        color: white;
        border: 0 none;
        border-radius: 1px;
        cursor: pointer;
        padding: 10px 5px;
        margin: 10px 5px;
    }

    #msform .action-button:hover,
    #msform .action-button:focus {
        box-shadow: 0 0 0 2px white, 0 0 0 3px #27AE60;
    }

    #msform .add-button {
        width: 110px;
        background: #9784b5;
        font-weight: bold;
        color: white;
        border: 0 none;
        border-radius: 1px;
        cursor: pointer;
        padding: 10px 5px;
        margin: 10px 5px;
    }

    /*headings*/
    .fs-title {
        font-size: 15px;
        text-transform: uppercase;
        color: #2C3E50;
        margin-bottom: 10px;
    }

    .fs-subtitle {
        font-weight: normal;
        font-size: 13px;
        color: #666;
        margin-bottom: 20px;
    }

    /*progressbar*/
    #progressbar {
        margin-bottom: 30px;
        overflow: hidden;
        /*CSS counters to number the steps*/
        counter-reset: step;
    }

    #progressbar li {
        list-style-type: none;
        color: black;
        text-transform: uppercase;
        font-size: 9px;
        width: 23%;
        float: left;
        position: relative;
    }

    #progressbar li:before {
        content: counter(step);
        counter-increment: step;
        width: 20px;
        line-height: 20px;
        display: block;
        font-size: 10px;
        color: #333;
        background: white;
        border-radius: 3px;
        margin: 0 auto 5px auto;
    }

    /*progressbar connectors*/
    #progressbar li:after {
        content: '';
        width: 100%;
        height: 2px;
        background: green;
        position: absolute;
        left: -50%;
        top: 9px;
        z-index: -1;
        /*put it behind the numbers*/
    }

    #progressbar li:first-child:after {
        /*connector not needed before the first step*/
        content: none;
    }

    /*marking active/completed steps green*/
    /*The number of the step and the connector before it = green*/
    #progressbar li.active:before,
    #progressbar li.active:after {
        background: #27AE60;
        color: green;
    }
</style>

<div id="msform">
    <!-- progressbar -->
    <ul id="progressbar">
        <li class="active">Enter Batch Details</li>
        <li>Enter Payment Details</li>
        <li>Upload Device Details</li>
        <li>Review Details</li>
    </ul>
    <!-- Customer Information -->
    <fieldset>
        <h2 class="fs-title">Enter Batch Details</h2>
        <h3 class="fs-subtitle">Step 1 of 4</h3>

        <div class="col-sm-12 col-md-12 form-horizontal">
            <div class="form-group" style="margin-bottom: 10px;">
                <label class="col-sm-3 control-label">SOURCE</label>
                <div class="col-sm-5">
                    <select class="form-control select_box" name="pr_oth_source" id="pr_oth_source" style="width: 100%;">
                        <option value="">Select Source</option>
                    </select>
                </div>
            </div>

            <div class="form-group" style="margin-bottom: 10px;">
                <label class="col-sm-3 control-label">CATEGORY</label>
                <div class="col-sm-5">
                    <select class="form-control select_box" name="pr_oth_procurement_type" id="pr_oth_procurement_type" style="width: 100%;">
                        <option value="">Select Category</option>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label">Sub Category</label>
                <div class="col-sm-5">
                    <input type="text" class="form-control" name="pr_oth_sub_category" id="pr_oth_sub_category">
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label">Quantity</label>
                <div class="col-sm-5">
                    <input type="number" class="form-control" name="pr_oth_qty" id="pr_oth_qty">
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label">Batch No</label>
                <div class="col-sm-5">
                    <input type="text" class="form-control" name="pr_oth_batch_no" id="pr_oth_batch_no">
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label">Warehouse</label>
                <div class="col-sm-5">
                    <input type="text" class="form-control" name="pr_oth_warehouse" id="pr_oth_warehouse">
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label">ACCEPTED DATE</label>
                <div class="col-sm-5">
                    <input type="date" class="form-control" max="<?= date('Y-m-d') ?>" name="pr_oth_accepted_date" id="pr_oth_accepted_date">
                </div>
            </div>
        </div>
        <input type="button" name="next" class="next action-button" value="Next" id="batch_next_btn" onclick="onBatchNxt(this)" />
    </fieldset>

    <fieldset>
        <h2 class="fs-title">Enter Payment Details</h2>
        <h3 class="fs-subtitle">Step 2 of 4</h3>
        <div class="col-sm-12 col-md-12 form-horizontal">
            <div class="form-group">
                <label class="col-sm-3 control-label">PAYMENT REF No.</label>
                <div class="col-sm-5">
                    <input type="text" class="form-control" name="pr_oth_payment_ref_no" id="pr_oth_payment_ref_no">
                </div>
            </div>

            <div class="form-group">
                <label class="col-sm-3 control-label">PAYMENT DATE</label>
                <div class="col-sm-5">
                    <input type="date" max="<?= date('Y-m-d') ?>" class="form-control" name="pr_oth_payment_date" id="pr_oth_payment_date">
                </div>
            </div>

            <div class="form-group">
                <label class="col-sm-3 control-label">PAYMENT AMOUNT</label>
                <div class="col-sm-5">
                    <input type="number" class="form-control" name="pr_oth_payment_amount" id="pr_oth_payment_amount">
                </div>
            </div>
        </div>
        <input type="button" name="previous" class="previous action-button" value="Previous" onclick="previousScreen(this)" />
        <input type="button" name="next" class="next action-button" id="items_next_btn" value="Next" onclick="onPaymentNxt(this)" />
    </fieldset>

    <fieldset>
        <h2 class="fs-title">Upload Device Details</h2>
        <h3 class="fs-subtitle">Step 3 of 4</h3>
        <div class="col-sm-12 col-md-12 form-horizontal">
            <div class="form-group">
                <div class="col-sm-5">
                    <input type="file" class="form-control" name="pr_oth_attachment" id="pr_oth_attachment" style="height: 50px;">
                </div>
                <div class="col-sm-5">
                    <button type="button" class="btn btn-primary" id="sample_attachment" onclick="window.open('<?= base_url() ?>assets/sample/procurement_other.csv')">SAMPLE</button>
                </div>
            </div>
        </div>
        <input type="button" name="previous" class="previous action-button" value="Previous" onclick="previousScreen(this)" />
        <input type="button" name="next" class="next action-button" id="items_next_btn" value="Next" onclick="onItemsNxt(this)" />
    </fieldset>

    <fieldset>
        <h2 class="fs-title">Review Details</h2>
        <h3 class="fs-subtitle">Step 4 of 4</h3>
        <!-- Excel icon fontawesome Span -->
        <span class="fa fa-file-excel-o" id="csv_item_download_btn" style="font-size: 15px; color: #00a65a; float:left">CSV</span>
        <div class="table-responsive">
            <table class="table table-bordered" id="item_table">
                <thead>
                    <tr>
                        <th>S.No</th>
                        <th>Invoice No</th>
                        <th>Invoice Date</th>
                        <th>Quantity</th>
                        <th>Invoice Value</th>
                        <th>Taxable Amount</th>
                        <th>Exempt Amount</th>
                        <th>Tax Amount</th>
                        <th>TCS Amount</th>
                        <th>Total Amount</th>
                    </tr>
                </thead>
                <tbody id="item_table_body">
                </tbody>
            </table>
        </div>
            <input type="button" name="previous" class="previous action-button" value="Previous" onclick="previousScreen(this)" />
            <input type="button" name="next" class="submit action-button" style="background-color: #960;" id="submit_review" value="Submit" onclick="submitNewDispatch()" />
    </fieldset>
</div>

<script src="<?= base_url() ?>assets/js/jquery.easing.min.js"></script>
<script src="<?= base_url() ?>assets/js/jquery-csv.js"></script>
<script>
    //jQuery time
    var current_fs, next_fs, previous_fs; //fieldsets
    var left, opacity, scale; //fieldset properties which we will animate
    var animating; //flag to prevent quick multi-click glitches
    let total_items = [];
    let invoice_data = {};
    getNewDropdown('PRC_CHANNEL', 'pr_oth_source');
    getNewDropdown('CATEGORY', 'pr_oth_procurement_type');
    //next Function
    function nextScreen(d) {
        if (animating) return false;
        animating = true;

        current_fs = $(d).parent();
        next_fs = $(d).parent().next();

        //activate next step on progressbar using the index of next_fs
        $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");

        //show the next fieldset
        next_fs.show();
        //hide the current fieldset with style
        current_fs.animate({
            opacity: 0
        }, {
            step: function(now, mx) {
                //as the opacity of current_fs reduces to 0 - stored in "now"
                //1. scale current_fs down to 80%
                scale = 1 - (1 - now) * 0.2;
                //2. bring next_fs from the right(50%)
                left = (now * 50) + "%";
                //3. increase opacity of next_fs to 1 as it moves in
                opacity = 1 - now;
                current_fs.css({
                    'transform': 'scale(' + scale + ')',
                    'position': 'absolute'
                });
                next_fs.css({
                    'left': left,
                    'opacity': opacity
                });
            },
            duration: 800,
            complete: function() {
                current_fs.hide();
                animating = false;
            },
            //this comes from the custom easing plugin
            easing: 'easeInOutBack'
        });
    }

    function previousScreen(d) {
        if (animating) return false;
        animating = true;

        current_fs = $(d).parent();
        previous_fs = $(d).parent().prev();

        //de-activate current step on progressbar
        $("#progressbar li").eq($("fieldset").index(current_fs)).removeClass("active");

        //show the previous fieldset
        previous_fs.show();
        //hide the current fieldset with style
        current_fs.animate({
            opacity: 0
        }, {
            step: function(now, mx) {
                //as the opacity of current_fs reduces to 0 - stored in "now"
                //1. scale previous_fs from 80% to 100%
                scale = 0.8 + (1 - now) * 0.2;
                //2. take current_fs to the right(50%) - from 0%
                left = ((1 - now) * 50) + "%";
                //3. increase opacity of previous_fs to 1 as it moves in
                opacity = 1 - now;
                current_fs.css({
                    'left': left
                });
                previous_fs.css({
                    'transform': 'scale(' + scale + ')',
                    'opacity': opacity,
                    'position': 'relative'
                });
            },
            duration: 800,
            complete: function() {
                current_fs.hide();
                animating = false;
            },
            //this comes from the custom easing plugin
            easing: 'easeInOutBack'
        });
    }

    function getNewDropdown(type, select_id) {
        $.ajax({
            type: "GET",
            url: "<?= base_url() ?>admin/DropDownItems/getItems?type=" + type,
            data: {},
            dataType: "json",
            success: function(data) {

                $.each(data, function(i, v) {
                    $("#" + select_id).append('<option value="' + data[i].name + '">' + data[i].name + '</option>')
                })
            },
            error: function(error) {
                alert(error.responseJSON.message);
            }
        });
    }

    function checkNull(entity, msg) {
        if (entity === '' || entity == null || entity == undefined) {
            console.log(entity);
            return msg;
        }
        return '';
    }

    function onBatchNxt(d) {
        let source = $("#pr_oth_source").val();
        let procurement_type = $("#pr_oth_procurement_type").val();
        let sub_category = $("#pr_oth_sub_category").val();
        let batch_no = $("#pr_oth_batch_no").val();
        let warehouse = $("#pr_oth_warehouse").val();
        let accepted_qty = $("#pr_oth_qty").val();
        let accepted_date = $("#pr_oth_accepted_date").val();
        let fields_required = ''

        fields_required += checkNull(source, 'Source, ');
        fields_required += checkNull(procurement_type, 'Category, ');
        fields_required += checkNull(batch_no, 'Batch No, ');
        fields_required += checkNull(accepted_qty, 'Quantity, ');
        fields_required += checkNull(accepted_date, 'Accepted Date, ');
        fields_required += checkNull(warehouse, 'Warehouse');

        if (fields_required != '') {
            toastr.error('Please fill the following fields: ' + fields_required);
            return false;
        }
        nextScreen(d);
    }

    function onPaymentNxt(d) {
        let payment_ref_no = $("#pr_oth_payment_ref_no").val();
        let payment_date = $("#pr_oth_payment_date").val();
        let payment_amount = +$("#pr_oth_payment_amount").val();
        let fields_required = ''

        fields_required += checkNull(payment_ref_no, 'Payment Ref No, ');
        fields_required += checkNull(payment_date, 'Payment Date, ');
        fields_required += checkNull(payment_amount, 'Payment Amount, ');
        //console.log

        if (fields_required != '') {
            toastr.error('Please fill the following fields: ' + fields_required);
            return false;
        }
        if (payment_amount <= 0) {
            toastr.error('Payment Amount should be greater than 0');
            return false
        }
        nextScreen(d);
    }

    function onItemsNxt(d) {
	invoice_data = {};
        var fileUpload = document.getElementById("pr_oth_attachment");
        var regex = /^([a-zA-Z0-9\s_\\.\-:()])+(.csv|.txt)$/;

        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof(FileReader) != "undefined") {
                var reader = new FileReader();

                reader.onload = function(e) {
                    var csvval = e.target.result;
                    let data = $.csv.toArrays(csvval);
                    let not_valid = false

                    $.each(data, function(i, v) {
                        if (i == 0) {
                            return true;
                        }

                        let brand = v[0];
                        let model = v[1];
                        let ram = v[2];
                        let rom = v[3];
                        let color = v[4];
                        let imei_no = v[5];
                        let vendor_unique_id = v[6];
                        let model_sku = v[7];
                        let variant_sku = v[8];
                        let color_sku = v[9];
                        let order_id = v[10];
                        let invoice_no = v[11];
                        let invoice_date = v[12];
                        let seller = v[13];
                        let vrp_no = v[14];
                        let procurement_grade = v[15];
                        let product_description = v[16];
                        let quantity = +v[17];
                        let price = +v[18];
                        let taxable_amount = +v[19];
                        let exempt_amount = +v[20];
                        let tax_amount = +v[21];
                        let tcs_amount = +v[22];
                        let invoice_value = +v[23];
                        let box_no = v[24];

                        let fields_required = ''
                        fields_required += checkNull(brand, 'Brand, ');
                        fields_required += checkNull(model, 'Model, ');
                        fields_required += checkNull(ram, 'RAM, ');
                        fields_required += checkNull(rom, 'ROM, ');
                        fields_required += checkNull(color, 'Color, ');
                        fields_required += checkNull(imei_no, 'IMEI, ');
                        fields_required += checkNull(vendor_unique_id, 'Vendor Unique ID, ');
                        fields_required += checkNull(model_sku, 'Model SKU, ');
                        fields_required += checkNull(variant_sku, 'Variant SKU, ');
                        fields_required += checkNull(color_sku, 'Color SKU, ');
                        fields_required += checkNull(order_id, 'Order ID, ');
                        fields_required += checkNull(invoice_no, 'Invoice No, ');
                        fields_required += checkNull(invoice_date, 'Invoice Date, ');
                        fields_required += checkNull(seller, 'Seller, ');
                        fields_required += checkNull(vrp_no, 'VRP No, ');
                        fields_required += checkNull(procurement_grade, 'Procurement Grade, ');
                        fields_required += checkNull(product_description, 'Product Description, ');
                        fields_required += checkNull(quantity, 'Quantity, ');
                        fields_required += checkNull(price, 'Price, ');
                        fields_required += checkNull(taxable_amount, 'Taxable Amount, ');
                        fields_required += checkNull(exempt_amount, 'Exempt Amount, ');
                        fields_required += checkNull(tax_amount, 'Tax Amount, ');
                        fields_required += checkNull(tcs_amount, 'TCS Amount, ');
                        fields_required += checkNull(invoice_value, 'Invoice Value, ');
                        fields_required += checkNull(box_no, 'Box No, ');

                        if (fields_required != '') {
                            not_valid = true;
                            alert('Please fill the following fields: ' + fields_required + ' in row ' + (i + 1));
                            return false;
                        }

                        if (price <= 0 || quantity <= 0 || tax_amount <= 0 || taxable_amount <= 0 || exempt_amount < 0 || tcs_amount < 0 || invoice_value <= 0) {
                            not_valid = true;
                            alert('Price, Quantity, Tax Amount, Taxable Amount, Exempt Amount, TCS Amount, Invoice Value should be greater than 0 for row ' + (i + 1));
                            return false;
                        }

                        let item = {
                            brand: brand,
                            model: model,
                            ram: ram,
                            rom: rom,
                            color: color,
                            vendor_unique_id: vendor_unique_id,
                            model_sku: model_sku,
                            variant_sku: variant_sku,
                            color_sku: color_sku,
                            order_id: order_id,
                            invoice_no: invoice_no,
                            invoice_date: invoice_date,
                            seller: seller,
                            vrp_no: vrp_no,
                            procurement_grade: procurement_grade,
                            product_description: product_description,
                            quantity: quantity,
                            price: price,
                            taxable_amount: taxable_amount,
                            exempt_amount: exempt_amount,
                            tax_amount: tax_amount,
                            tcs_amount: tcs_amount,
                            invoice_value: invoice_value,
                            box_no: box_no,
                            imei_no: imei_no
                        }

                        let total_amount = taxable_amount + exempt_amount + tax_amount + tcs_amount;

                        if (invoice_data[invoice_no] == undefined) {
                            invoice_data[invoice_no] = {
                                invoice_no: invoice_no,
                                invoice_date: invoice_date,
                                seller: seller,
                                quantity: quantity,
                                price: price,
                                taxable_amount: taxable_amount,
                                exempt_amount: exempt_amount,
                                tax_amount: tax_amount,
                                tcs_amount: tcs_amount,
                                invoice_value: invoice_value,
                                box_no: box_no,
                                total_amount: total_amount
                            }
                        } else {
                            invoice_data[invoice_no].quantity += quantity;
                            invoice_data[invoice_no].price += price;
                            invoice_data[invoice_no].taxable_amount += taxable_amount;
                            invoice_data[invoice_no].exempt_amount += exempt_amount;
                            invoice_data[invoice_no].tax_amount += tax_amount;
                            invoice_data[invoice_no].tcs_amount += tcs_amount;
			    invoice_data[invoice_no].invoice_value += invoice_value; // This Line added by Nagireddy
                            invoice_data[invoice_no].total_amount += total_amount;
                        }
                        total_items.push(item);
                    })

                    if (not_valid) {
                        return false;
                    }

                    if (total_items.length == 0) {
                        alert('No data found in the file.');
                        return false;
                    }

                    if (invoice_data.length == 0) {
                        alert('No data found in the file.');
                        return false;
                    }

                    reviewTable()
                    nextScreen(d);
                }
            }
            reader.readAsText(fileUpload.files[0]);
        } else {
            alert("This browser does not support HTML5.");
        }
    }

    function reviewTable() {
        $("#item_table_body").empty();
        let tr = ''
        let total_amount = 0;
        let total_quantity = 0;
        let total_price = 0;
        let total_taxable_amount = 0;
        let total_exempt_amount = 0;
        let total_tax_amount = 0;
        let total_tcs_amount = 0;
        let total_invoice_value = 0;
        let sno = 1;
        let csv_data = 'Sno, invoice_no, invoice_date, quantity, price, taxable_amount, exempt_amount, tax_amount, tcs_amount, invoice_value\n';

        for (let i in invoice_data) {
            let invoice_no = invoice_data[i].invoice_no;
            let invoice_date = invoice_data[i].invoice_date;
            let quantity = invoice_data[i].quantity;
            let price = invoice_data[i].price;
            let taxable_amount = invoice_data[i].taxable_amount;
            let exempt_amount = invoice_data[i].exempt_amount;
            let tax_amount = invoice_data[i].tax_amount;
            let tcs_amount = invoice_data[i].tcs_amount;
            let invoice_value = invoice_data[i].invoice_value;

            total_quantity += quantity;
            total_price += price;
            total_taxable_amount += taxable_amount;
            total_exempt_amount += exempt_amount;
            total_tax_amount += tax_amount;
            total_tcs_amount += tcs_amount;
            total_invoice_value += invoice_value;
            total_amount += +price + +tcs_amount

            tr += '<tr>';
            tr += '<td>' + sno + '</td>';
            tr += '<td>' + invoice_no + '</td>';
            tr += '<td>' + invoice_date + '</td>';
            tr += '<td>' + quantity + '</td>';
            tr += '<td>' + price.toFixed(2) + '</td>';
            tr += '<td>' + taxable_amount.toFixed(2) + '</td>';
            tr += '<td>' + exempt_amount.toFixed(2) + '</td>';
            tr += '<td>' + tax_amount.toFixed(2) + '</td>';
            tr += '<td>' + tcs_amount.toFixed(2) + '</td>';
            tr += '<td>' + invoice_value.toFixed(2) + '</td>';
            tr += '</tr>';
            sno++;
            csv_data += sno + ',' + invoice_no + ',' + invoice_date + ',' + quantity + ',' + price + ',' + taxable_amount + ',' + exempt_amount + ',' + tax_amount + ',' + tcs_amount + ',' + invoice_value + '\n';
        }
        $("#item_table_body").append(tr);

        let foot = '<tr>';
        foot += '<td>Total</td>';
        foot += '<td></td>';
        foot += '<td></td>';
        foot += '<td>' + total_quantity.toFixed(2) + '</td>';
        foot += '<td>' + total_price.toFixed(2) + '</td>';
        foot += '<td>' + total_taxable_amount.toFixed(2) + '</td>';
        foot += '<td>' + total_exempt_amount.toFixed(2) + '</td>';
        foot += '<td>' + total_tax_amount.toFixed(2) + '</td>';
        foot += '<td>' + total_tcs_amount.toFixed(2) + '</td>';
        foot += '<td>' + total_amount.toFixed(2) + '</td>';
        foot += '</tr>';
        $("#item_table_body").append(foot);

        // csv_item_download_btn 
        $("#csv_item_download_btn").attr('href', 'data:application/csv;charset=utf-8,' + encodeURIComponent(csv_data));
        $("#csv_item_download_btn").attr('download', 'invoice_data.csv');
    }

    function submitNewDispatch() {
        let source = $("#pr_oth_source").val();
        let procurement_type = $("#pr_oth_procurement_type").val();
        let sub_category = $("#pr_oth_sub_category").val();
        let batch_no = $("#pr_oth_batch_no").val();
        let warehouse = $("#pr_oth_warehouse").val();
        let accepted_qty = $("#pr_oth_qty").val();
        let accepted_date = $("#pr_oth_accepted_date").val();
        let payment_ref_no = $("#pr_oth_payment_ref_no").val();
        let payment_date = $("#pr_oth_payment_date").val();
        let payment_amount = +$("#pr_oth_payment_amount").val();

        let dispatch_data = {
            source: source,
            category: procurement_type,
            sub_category: sub_category,
            warehouse: warehouse,
            batch_no: batch_no,
            accepted_qty: accepted_qty,
            accepted_date: accepted_date,
            payment_ref_no: payment_ref_no,
            payment_date: payment_date,
            payment_amount: payment_amount,
            items: total_items,
            invoice_data: invoice_data
        }
        let jsonObject = JSON.stringify(dispatch_data);

        $.ajax({
            url: '<?= base_url() ?>admin/Procurement/newDispatchOth',
            type: 'POST',
            data: jsonObject,
            dataType: 'json',
            success: function(data) {

                if (data.status == 1) {
                    toastr.success(data.message);
                    setTimeout(function() {
                        window.location.href = '<?= base_url() ?>admin/Procurement/manage_procurement_oth';
                    }, 1000);
                    return true;
                } else {
                    toastr.error(data.message);
                    return false;
                }
            }
        })
    }
</script>