<input type="hidden" id="raised_procurement_id" value="<?= $raised_procurement_id ?>">
<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;">
    <div class="col-md-6  col-sm-6 col-xs-6" style="padding:0px">

        <div class="form-group">
            <label class="col-lg-4 control-label">Procurement Number</label>
            <div class="col-lg-6">
                <input type="text" class="form-control" id="raised_procurement_no" readonly>
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">Batch NO</label>
            <div class="col-lg-6">
                <input type="text" class="form-control" id="raised_batch_no" readonly>
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">Accepted Quantity</label>
            <div class="col-lg-6">
                <input type="number" class="form-control" id="raised_accepted_qty" readonly>
            </div>
        </div>


        <div class="form-group">
            <label class="col-lg-4 control-label">Lot Raised Date</label>
            <div class="col-lg-6">
                <input type="date" class="form-control" id="input_raised_date">
            </div>
        </div>


        <div class="form-group">
            <label class="col-lg-4 control-label">Upload File</label>
            <div class="col-lg-5">
                <input type="file" class="form-control" id="raised_input_upload_file" multiple="multiple" onchange="uploadList()">
            </div>
            <div class="col-lg-2">
                <input type="button" id="download_report" class="btn btn-green" onclick="uploadFiles()" value="UPLOAD" readonly>
            </div>
            <div class="col-lg-1">
                <a href="<?php echo base_url('assets/sample/procurement/RFQPrexo_Mobile-264099-_sample.csv'); ?>"><button type="button" id="file-save-button" value="Sample file" class="btn btn-success"></i> <i class="fa fa-file-excel-o"></i>&nbsp;Sample file</button></a>
            </div><br>
        </div>
        <div class="form-group">
            <label class="col-lg-4 control-label">SELECT FILES</label>
            <div class="col-lg-6">
                <div id="raised_fileList"></div>
            </div>
        </div>
        <div class="form-group">
            <div class="col-lg-12" style="text-align: center;">
                <input type="button" id="download_report" class="btn btn-grey" value="BACK" readonly>
                &nbsp;&nbsp;&nbsp;&nbsp;
                <input type="button" id="raised_procurement_submit" class="btn btn-primary" onclick="updateRaisedLot()" value="SUBMIT" readonly disabled>

            </div>
        </div>
    </div>
</div>

<script>
    var procurement_id = parseInt($("#raised_procurement_id").val())
    var items = []

    getProcurementHeader()

    function getProcurementHeader() {

        if (procurement_id <= 0 || isNaN(procurement_id)) {
            return false
        }

        $.ajax({
            "url": "<?= base_url() ?>admin/Procurement/getProcurementHeader",
            "data": {
                "procurement_id": procurement_id
            },
            "dataType": "json",
            "async": false,
            "success": function(data) {

                if (data.status != 1) {
                    toastr.error("Error: Failed to get Procurement Details")
                    return false
                }

                let result = data.result
                $("#raised_procurement_no").val(result.procurement_no)
                $("#raised_batch_no").val(result.batch_no)
                $("#raised_accepted_qty").val(result.accepted_qty)
            }


        })

    }

    function uploadList() {
        $("#raised_fileList").text('')

        var input = document.getElementById('raised_input_upload_file');
        var output = document.getElementById('raised_fileList');
        var children = "";
        for (var i = 0; i < input.files.length; ++i) {
            children += '<li>' + input.files.item(i).name + '</li>';
        }
        output.innerHTML = '<ul>' + children + '</ul>';
    }

    function uploadFiles() {

        var files = document.getElementById("raised_input_upload_file").files;
        var k = 0;
        readMultipleRaisedFiles()

        function readMultipleRaisedFiles(n = 0) {

            var file = files[n];
            var regex = /^([a-zA-Z0-9\s_\\.\()-:#!@$%^*&])+(.csv|.txt)$/;
            if (regex.test(file.name.toLowerCase())) {
                if (typeof(FileReader) != "undefined") {
                    var reader = new FileReader();
                    let filename = file.name
                    let filename_arr = filename.split('-')
                    reader.onload = function(e) {

                        var csvdata = e.target.result;
                        var rows = CSVToArray(csvdata)

                        for (var i = 1; i < rows.length; i++) {
                            var cells = rows[i]
                            if (cells[0] != '') {
                                items[k] = {
                                    "fsn": cells[0],
                                    "hsn": cells[1],
                                    "wid": cells[2],
                                    "sku": cells[3],
                                    "warehouse": cells[4],
                                    "storage_location": cells[5],
                                    "seller_id": cells[6],
                                    "seller_name": cells[7],
                                    "super_category": cells[8],
                                    "cms_vertical": cells[9],
                                    "listing_id": cells[10],
                                    "quantity": cells[11],
                                    "fsp": cells[13],
                                    "node_id": cells[15],
                                    "supply_chain": cells[16],
                                    "grade": cells[17],
                                    "rate": cells[19],
                                    "tentative_value": cells[22],
                                    "tcs": cells[23],
                                    "final_tentative_value": cells[24],
                                    "lot_subject": cells[25],
                                    "lot_id": filename_arr[1],
                                }
                                k++
                            }

                        }
                        if (k > 0) {
                            $("#raised_procurement_submit").prop('disabled', false)
                        }

                        n++;
                        if (n < files.length) {
                            readMultipleRaisedFiles(n)
                        }
                    }
                    reader.readAsText(file);
                }
            } else {

                toastr.error(file.name + " Not a valid CSV File")
                return false
            }
        }
    }

    function CSVToArray(strData, strDelimiter) {

        strDelimiter = (strDelimiter || ",");

        var objPattern = new RegExp(
            (
                "(\\" + strDelimiter + "|\\r?\\n|\\r|^)" +

                "(?:\"([^\"]*(?:\"\"[^\"]*)*)\"|" +

                "([^\"\\" + strDelimiter + "\\r\\n]*))"
            ),
            "gi"
        );

        var arrData = [
            []
        ];

        var arrMatches = null;

        while (arrMatches = objPattern.exec(strData)) {

            var strMatchedDelimiter = arrMatches[1];

            if (
                strMatchedDelimiter.length &&
                strMatchedDelimiter !== strDelimiter
            ) {

                arrData.push([]);

            }

            var strMatchedValue;

            if (arrMatches[2]) {

                strMatchedValue = arrMatches[2].replace(
                    new RegExp("\"\"", "g"),
                    "\""
                );

            } else {
                strMatchedValue = arrMatches[3];

            }

            arrData[arrData.length - 1].push(strMatchedValue);
        }
        return (arrData);
    }


    function updateRaisedLot() {
        if (items.length <= 0) {
            return false
        }

        if (procurement_id <= 0 || isNaN(procurement_id)) {
            return false
        }
        let raised_date = $("#input_raised_date").val()

        if (raised_date == '' || raised_date == null || raised_date == undefined) {
            toastr.error("Error: Please Enter Date")
            return false
        }
        let data = {
            "procurement_id": procurement_id,
            "raised_date": raised_date,
            "items": items
        }

        var jsonObject = JSON.stringify(data)
        $("#raised_procurement_submit").prop('disabled', true)
        $.ajax({
            "url": "<?= base_url(); ?>admin/Procurement/updateRaisedLot",
            "data": jsonObject,
            "dataType": "json",
            "method": "POST",
            "success": function(data) {

                if (data.status != 1) {
                    $("#raised_procurement_submit").prop('disabled', false)
                    toastr.error("Failed Add Procurement")
                    return false
                }

                window.location.replace("<?= base_url() ?>admin/Procurement/manage_procurement")
            }
        })
    }
</script>