<style>
    td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_open.png') no-repeat center center;
        cursor: pointer;
    }

    tr.shown td.details-control {
        background: url('<?php echo base_url(); ?>assets/img/details_close.png') no-repeat center center;
    }

    tr {
        height: 30px;
    }

    td.procurement_id_cls {
        font-size: 0;
    }

    #stocktransferInvoiceList_table {
        all: unset;
    }
</style>

<div class="btn-group btn-toolbar" data-toggle="buttons">
    <label class="btn btn-primary" active>
        <input type="radio" name="options" id="procurement_button_accepted">ACCEPTED
    </label>
    <label class="btn btn-primary" active>
        <input type="radio" name="options" id="procurement_button_raised">RAISED
    </label>
    <label class="btn btn-primary" active>
        <input type="radio" name="options" id="procurement_button_pending">VALIDATION PENDING
    </label>
    <label class="btn btn-primary" active>
        <input type="radio" name="options" id="procurement_button_invoice_pending">INVOICE PENDING
    </label>
    <label class="btn btn-primary" active>
        <input type="radio" name="options" id="procurement_button_invoiced">INVOICED
    </label>
    <label class="btn btn-primary" active>
        <input type="radio" name="options" id="procurement_button_dispatched">DISPATCHED
    </label>
    <label class="btn btn-primary" active>
        <input type="radio" name="options" id="procurement_button_intransit">IN TRANSIT
    </label>
    <label class="btn btn-primary" active>
        <input type="radio" name="options" id="procurement_button_received">RECEIVED
    </label>
    <!-- <label>
        <a class="btn btn-danger dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">REPORT</a>
        <div class="btn dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuLink">
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadProcurementData('ALL')">ALL</a>
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadProcurementData('INVOICED')">INVOICED</a>
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadProcurementData('DISPATCHED')">DISPATCHED</a>
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadProcurementData('IN_TRANSIT')">IN TRANSIT</a>
            <a class="dropdown-item btn btn-info" name="OPEN BOX" onclick="downloadProcurementData('RECEIVED')">RECEIVED</a>
        </div>
    </label> -->
</div>
<p style="line-height:10px;"></p>

<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="procurementList_table">
    <thead>
        <tr>
            <th>&nbsp;</th>
            <th>&nbsp;</th>
            <th>PROCUREMENT NO</th>
            <th>BATCH NO</th>
            <th>SOURCE</th>
            <th>CATEGORY</th>
            <th>WAREHOUSE</th>
            <th>PAID<br>AMOUNT</th>
            <th>ACCEPTED DATE</th>
            <th>ACCEPTED<br>QUANTITY</th>
            <th>RAISED<br>QUANTITY</th>
            <th>INVOICED<br>QUANTITY</th>
            <th>CREATED BY</th>
            <th>LAST <br>UPDATED BY</th>
            <th>LAST UPDATED<br> DATE</th>
        </tr>
    </thead>
</table>

<!-- update awb_no -->
<div class="modal fade" id="update_log_modal" tabindex="-1" role="dialog" aria-labelledby="myModalFileUploadLabel" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">

            <input type="hidden" id="update_log_procurement_id">
            <div class="modal-body mx-3">
                <div class="form-group">
                    <label class="col-lg-4 control-label">PROCUREMENT NO</label>
                    <div class="col-lg-7">
                        <span class="form-control" id="update_log_procurement_no" readonly></span>
                    </div>
                </div>
            </div><br>
            <div class="form-group">
                <label class="col-lg-4 control-label">BATCH NUMBER</label>
                <div class="col-lg-7">
                    <span type="text" class="form-control" id="update_batch_no" readonly></span>
                </div>
            </div><br><br>
            <div class="form-group">
                <label class="col-lg-4 control-label">LOGISTICS PARTNER NAME</label>
                <div class="col-lg-7">
                    <input type="text" class="form-control" id="update_log_logistics_name">
                </div>
            </div><br><br>
            <div class="form-group">
                <label class="col-lg-4 control-label">DOCKET NUMBER</label>
                <div class="col-lg-7">
                    <input type="text" class="form-control" id="update_log_docket_no">
                </div>
            </div><br><br>

            <br>
            <div class="modal-footer d-flex justify-content-center">
                <button class="btn btn-success" id="updateawb_submit" onclick="updateLogisticsDetails()" CausesValidation="False">UPDATE</button>
                <button class="btn btn-danger" id="fileupload_modal_close" onclick="closeLogisticsModal()" CausesValidation="False">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- update Dispatch -->
<div class="modal fade" id="update_dispatch_modal" tabindex="-1" role="dialog" aria-labelledby="myModalFileUploadLabel" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">

            <input type="hidden" id="update_dispatch_procurement_id">
            <div class="modal-body mx-3">
                <div class="form-group">
                    <label class="col-lg-4 control-label">PROCUREMENT NO</label>
                    <div class="col-lg-7">
                        <span class="form-control" id="update_disptach_procurement_no" readonly></span>
                    </div>
                </div>
            </div><br>
            <div class="form-group">
                <label class="col-lg-4 control-label">REMARKS</label>
                <div class="col-lg-7">
                    <textarea class="form-control" id="update_dispatch_remarks"></textarea>
                </div>
            </div><br><br>

            <div class="modal-footer d-flex justify-content-center">
                <button class="btn btn-success" id="updateawb_submit" onclick="updateDispatchDetails()" CausesValidation="False">DISPATCH COLLECTED</button>
                <button class="btn btn-danger" id="fileupload_modal_close" onclick="closeDispatchModal()" CausesValidation="False">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- update Intransit -->
<div class="modal fade" id="update_intransit_modal" tabindex="-1" role="dialog" aria-labelledby="myModalFileUploadLabel" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">

            <input type="hidden" id="update_intransit_procurement_id">
            <div class="modal-body mx-3">
                <div class="form-group">
                    <label class="col-lg-4 control-label">PROCUREMENT NO</label>
                    <div class="col-lg-7">
                        <span class="form-control" id="update_intransit_procurement_no" readonly></span>
                    </div>
                </div>
            </div><br>
            <div class="form-group">
                <label class="col-lg-4 control-label">REMARKS</label>
                <div class="col-lg-7">
                    <textarea class="form-control" id="update_intransit_remarks"></textarea>
                </div>
            </div><br><br>

            <div class="modal-footer d-flex justify-content-center">
                <button class="btn btn-success" id="updateawb_submit" onclick="updateIntransitDetails()" CausesValidation="False">IN TRANSIT</button>
                <button class="btn btn-danger" id="fileupload_modal_close" onclick="closeIntransitModal()" CausesValidation="False">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- update Received -->
<div class="modal fade" id="update_received_modal" tabindex="-1" role="dialog" aria-labelledby="myModalFileUploadLabel" aria-hidden="true" data-backdrop="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">

            <input type="hidden" id="update_received_procurement_id">
            <div class="modal-body mx-3">
                <div class="form-group">
                    <label class="col-lg-4 control-label">PROCUREMENT NO</label>
                    <div class="col-lg-7">
                        <span class="form-control" id="update_received_procurement_no" readonly></span>
                    </div>
                </div>
            </div><br>
            <div class="form-group">
                <label class="col-lg-4 control-label">REMARKS</label>
                <div class="col-lg-7">
                    <textarea class="form-control" id="update_received_remarks"></textarea>
                </div>
            </div><br><br>

            <div class="modal-footer d-flex justify-content-center">
                <button class="btn btn-success" id="updateawb_submit" onclick="updateReceivedDetails()" CausesValidation="False">RECEIVED</button>
                <button class="btn btn-danger" id="fileupload_modal_close" onclick="closeReceivedModal()" CausesValidation="False">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {

        getProcurementList('ACCEPTED')

        function getProcurementList(status = '') {

            if (status == '') {
                status = 'ACCEPTED'
            }

            procurementList_table = $('#procurementList_table').DataTable({
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "scrollY": 390,
                "scrollX": true,
                "scrollCollapse": true,
                //"autoWidth": false,
                "aaSorting": [],
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/Procurement/getProcurementList",
                    "data": {
                        "status": status
                    },
                    "type": "GET",
                    "dataSrc": "data"
                },
                "columns": [{
                        "data": "procurement_id",
                        "className": "procurement_id_cls"
                    },
                    {
                        "data": function(data) {

                            if (data.status == 'ACCEPTED') {
                                return '<a class="fa fa-edit" href="<?= base_url() ?>admin/Procurement/updateRaisedLotForm/' + data.procurement_id + '"></a>'
                            } else if (data.status == 'RAISED') {
                                return '<a class="fa fa-edit" href="<?= base_url() ?>admin/Procurement/updateInvoicedLotForm/' + data.procurement_id + '"></a>'

                            } else if (data.status == 'PENDING') {
                                return '<a class="fa fa-edit" href="<?= base_url() ?>admin/Procurement/validateInvoiceForm/' + data.procurement_id + '"></a>'

                            } else if (data.status == 'INVOICE_PENDING') {
                                return '<a class="fa fa-edit" href="<?= base_url() ?>admin/Procurement/updateInvoiceNoForm/' + data.procurement_id + '"></a>'

                            } else if (data.status == 'INVOICED') {
                                let a = '<div style="display:inline-flex"><a class="fa fa-plane" onclick="updateLogistcsModal(this)" title="Logistics Details"></a>'
                                a += '&nbsp;&nbsp;&nbsp;&nbsp;<a class="fa fa-edit" onclick="updateDispatchModal(this)" title="Dispatch Details"></a>'
                                a += '</div>'
                                return a

                            } else if (data.status == 'DISPATCHED') {
                                return '<a class="fa fa-edit" onclick="updateIntransitModal(this)" title="Transit Details">'

                            } else if (data.status == 'IN_TRANSIT') {
                                return '<a class="fa fa-edit" onclick="updateReceivedModal(this)" title="Transit Details">'


                            } else {
                                return null
                            }
                        }
                    },
                    {
                        "data": "procurement_no",
                        "className": "procurement_no_cls"
                    },
                    {
                        "data": "batch_no",
                        "className": "batch_no_cls"
                    },
                    {
                        "data": "source"
                    },
                    {
                        "data": "category"
                    },
                    {
                        "data": "warehouse"
                    },
                    {
                        "data": "amount"
                    },
                    {
                        "data": "lot_accepted_date"
                    },
                    {
                        "data": "accepted_qty"
                    },
                    {
                        "data": "raised_qty"
                    },
                    {
                        "data": "invoiced_qty"
                    },
                    {
                        "data": "created_by"
                    },
                    {
                        "data": "last_updated_by"
                    },
                    {
                        "data": "last_update_date"
                    }
                ]
            });

        }

        $("#procurement_button_accepted").on("change", function() {
            getProcurementList('ACCEPTED')
        })

        $("#procurement_button_raised").on("change", function() {
            getProcurementList('RAISED')
        })

        $("#procurement_button_pending").on("change", function() {
            getProcurementList('PENDING')
        })

        $("#procurement_button_invoice_pending").on("change", function() {
            getProcurementList('INVOICE_PENDING')
        })

        $("#procurement_button_invoiced").on("change", function() {
            getProcurementList('INVOICED')
        })

        $("#procurement_button_dispatched").on("change", function() {
            getProcurementList('DISPATCHED')
        })

        $("#procurement_button_intransit").on("change", function() {
            getProcurementList('IN_TRANSIT')
        })

        $("#procurement_button_received").on("change", function() {
            getProcurementList('RECEIVED')
        })

    })

    function updateLogisticsDetails() {
        let log_procurement_id = parseInt($("#update_log_procurement_id").val())
        let logistics_name = $('#update_log_logistics_name').val()
        let docket_no = $('#update_log_docket_no').val()

        var fields_required = ''

        if (isNaN(log_procurement_id) || log_procurement_id <= 0) {
            return false
        }

        fields_required += checkNull(logistics_name, "Logistics Partner Name, ")
        fields_required += checkNull(docket_no, "Docket No ")


        if (fields_required != '') {
            toastr.error("Fields Required: " + fields_required)
            return false
        }

        var data = {
            "procurement_id": log_procurement_id,
            "logistics_partner_name": logistics_name,
            "docket_no": docket_no

        }

        $.ajax({
            "url": "<?= base_url() ?>admin/Procurement/updateLogisticsDetails",
            "type": "GET",
            "data": {
                "data": data
            },
            "dataType": "json",
            "success": function(data) {

                if (data.status != 1) {
                    toastr.error("Failed to Update Logistics Details")
                    return false
                }

                $("#update_log_modal").modal('hide');
            }
        })
    }

    function updateLogistcsModal(btn) {
        $("#update_log_procurement_id").val('')
        $("#update_log_procurement_no").text('')
        $("#update_batch_no").text('')
        $('#update_log_logistics_name').val('')
        $('#update_log_docket_no').val('')

        var procurement_id = $(btn).closest("tr").find(".procurement_id_cls").text();
        var procurement_no = $(btn).closest("tr").find(".procurement_no_cls").text();
        var batch_no = $(btn).closest("tr").find(".batch_no_cls").text();

        if (procurement_id > 0) {

            $("#update_log_procurement_id").val(procurement_id)
            $("#update_log_procurement_no").text(procurement_no)
            $("#update_batch_no").text(batch_no)
            $("#update_log_modal").modal('show');
        }
    }

    function closeLogisticsModal() {
        $("#update_log_procurement_id").val('')
        $("#update_log_procurement_no").text('')
        $("#update_batch_no").text('')
        $('#update_log_logistics_name').val('')
        $('#update_log_docket_no').val('')
        $("#update_log_modal").modal('hide');

    }

    //Dispatch Details

    function updateDispatchDetails() {
        let log_procurement_id = parseInt($("#update_dispatch_procurement_id").val())
        let remarks = $('#update_dispatch_remarks').val()
        var fields_required = ''

        if (isNaN(log_procurement_id) || log_procurement_id <= 0) {
            return false
        }

        fields_required += checkNull(remarks, "Remarks ")

        if (fields_required != '') {
            toastr.error("Fields Required: " + fields_required)
            return false
        }

        var data = {
            "procurement_id": log_procurement_id,
            "remarks": remarks,
        }

        $.ajax({
            "url": "<?= base_url() ?>admin/Procurement/updateDispatchDetails",
            "type": "GET",
            "data": {
                "data": data
            },
            "dataType": "json",
            "success": function(data) {

                if (data.status != 1) {
                    toastr.error("Failed to Update Dispatch Details")
                    return false
                }

                $("#update_dispatch_modal").modal('hide');
                $("#procurement_button_dispatched").click()
            }
        })
    }

    function updateDispatchModal(btn) {
        $("#update_dispatch_procurement_id").val('')
        $("#update_disptach_procurement_no").text('')
        $('#update_dispatch_remarks').val('')

        var procurement_id = $(btn).closest("tr").find(".procurement_id_cls").text();
        var procurement_no = $(btn).closest("tr").find(".procurement_no_cls").text();

        if (procurement_id > 0) {

            $("#update_dispatch_procurement_id").val(procurement_id)
            $("#update_disptach_procurement_no").text(procurement_no)
            $("#update_dispatch_modal").modal('show');
        }
    }

    function closeDispatchModal() {
        $("#update_dispatch_procurement_id").val('')
        $("#update_disptach_procurement_no").text('')
        $('#update_dispatch_remarks').val('')
        $("#update_dispatch_modal").modal('hide');
    }

    //Intransit Details

    function updateIntransitDetails() {
        let log_procurement_id = parseInt($("#update_intransit_procurement_id").val())
        let remarks = $('#update_intransit_remarks').val()
        var fields_required = ''

        if (isNaN(log_procurement_id) || log_procurement_id <= 0) {
            return false
        }

        fields_required += checkNull(remarks, "Remarks ")

        if (fields_required != '') {
            toastr.error("Fields Required: " + fields_required)
            return false
        }

        var data = {
            "procurement_id": log_procurement_id,
            "remarks": remarks,
        }

        $.ajax({
            "url": "<?= base_url() ?>admin/Procurement/updateIntransitDetails",
            "type": "GET",
            "data": {
                "data": data
            },
            "dataType": "json",
            "success": function(data) {

                if (data.status != 1) {
                    toastr.error("Failed to Update Transit Details")
                    return false
                }

                $("#update_intransit_modal").modal('hide');
                $("#procurement_button_intransit").click()
            }
        })
    }

    function updateIntransitModal(btn) {
        $("#update_intransit_procurement_id").val('')
        $("#update_intransit_procurement_no").text('')
        $('#update_intransit_remarks').val('')

        var procurement_id = $(btn).closest("tr").find(".procurement_id_cls").text();
        var procurement_no = $(btn).closest("tr").find(".procurement_no_cls").text();

        if (procurement_id > 0) {

            $("#update_intransit_procurement_id").val(procurement_id)
            $("#update_intransit_procurement_no").text(procurement_no)
            $("#update_intransit_modal").modal('show');
        }
    }

    function closeIntransitModal() {
        $("#update_intransit_procurement_id").val('')
        $("#update_intransit_procurement_no").text('')
        $('#update_intransit_remarks').val('')
        $("#update_intransit_modal").modal('hide');
    }

    //received Details

    function updateReceivedDetails() {
        let log_procurement_id = parseInt($("#update_received_procurement_id").val())
        let remarks = $('#update_received_remarks').val()
        var fields_required = ''

        if (isNaN(log_procurement_id) || log_procurement_id <= 0) {
            return false
        }

        fields_required += checkNull(remarks, "Remarks ")

        if (fields_required != '') {
            toastr.error("Fields Required: " + fields_required)
            return false
        }

        var data = {
            "procurement_id": log_procurement_id,
            "remarks": remarks,
        }

        $.ajax({
            "url": "<?= base_url() ?>admin/Procurement/updateReceivedDetails",
            "type": "GET",
            "data": {
                "data": data
            },
            "dataType": "json",
            "success": function(data) {

                if (data.status != 1) {
                    toastr.error("Failed to Update received Details")
                    return false
                }

                $("#update_received_modal").modal('hide');
                $("#procurement_button_received").click()
            }
        })
    }

    function updateReceivedModal(btn) {
        $("#update_received_procurement_id").val('')
        $("#update_received_procurement_no").text('')
        $('#update_received_remarks').val('')

        var procurement_id = $(btn).closest("tr").find(".procurement_id_cls").text();
        var procurement_no = $(btn).closest("tr").find(".procurement_no_cls").text();

        if (procurement_id > 0) {

            $("#update_received_procurement_id").val(procurement_id)
            $("#update_received_procurement_no").text(procurement_no)
            $("#update_received_modal").modal('show');
        }
    }

    function closeReceivedModal() {
        $("#update_received_procurement_id").val('')
        $("#update_received_procurement_no").text('')
        $('#update_received_remarks').val('')
        $("#update_received_modal").modal('hide');
    }

    function downloadProcurementData(status = ''){
        if(status == '') return false;

        var win = window.open('<?= base_url() ?>admin/Procurement/getProcurementFKReport?status=' + status, '_blank');
    }
</script>