<input type="hidden" id="invoiced_procurement_id" value="<?= $invoiced_procurement_id ?>">
<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;">
    <div class="col-md-6  col-sm-6 col-xs-6" style="padding:0px">

        <div class="form-group">
            <label class="col-lg-4 control-label">Procurement Number</label>
            <div class="col-lg-6">
                <input type="text" class="form-control" id="invoiced_procurement_no" readonly>
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">Batch NO</label>
            <div class="col-lg-6">
                <input type="text" class="form-control" id="invoiced_batch_no" readonly>
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">Accepted Quantity</label>
            <div class="col-lg-6">
                <input type="number" class="form-control" id="invoiced_accepted_qty" readonly>
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">Lot Invoiced Date</label>
            <div class="col-lg-6">
                <input type="date" class="form-control" id="input_invoiced_date">
            </div>
        </div>


        <div class="form-group">
            <label class="col-lg-4 control-label">Upload Files (Proforma Invoices)</label>
            <div class="col-lg-5">
                <input type="file" class="form-control" id="invoiced_input_upload_file" multiple="multiple" onchange="uploadInvoicedList()">
            </div>
            <div class="col-lg-2">
                <input type="button" id="download_report" class="btn btn-green" onclick="uploadInvoicedFiles()" value="UPLOAD" readonly>
            </div>
            <div class="col-lg-1">
                <a href="<?php echo base_url('assets/sample/procurement/proforma_invoice_272727_sample.csv'); ?>"><button type="button" id="file-save-button" value="Sample file" class="btn btn-success"></i> <i class="fa fa-file-excel-o"></i>&nbsp;Sample file</button></a>
            </div><br>
        </div>
        <div class="form-group">
            <label class="col-lg-4 control-label">SELECTED Invoice FILES</label>
            <div class="col-lg-6">
                <div id="invoiced_fileList"></div>
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">Upload Files (WSN Details)</label>
            <div class="col-lg-5">
                <input type="file" class="form-control" id="wsn_input_upload_file" multiple="multiple" onchange="uploadWSNList()">
            </div>
            <div class="col-lg-2">
                <input type="button" id="download_report" class="btn btn-green" onclick="uploadWSNFiles()" value="UPLOAD" readonly>
            </div>
            <div class="col-lg-1">
                <a href="<?php echo base_url('assets/sample/procurement/Wsn-Details-272728-_sample.csv'); ?>"><button type="button" id="file-save-button" value="Sample file" class="btn btn-success"></i> <i class="fa fa-file-excel-o"></i>&nbsp;Sample file</button></a>
            </div><br>
        </div>
        <div class="form-group">
            <label class="col-lg-4 control-label">SELECTED WSN FILES</label>
            <div class="col-lg-6">
                <div id="wsn_fileList"></div>
            </div>
        </div>
        <div class="form-group">
            <div class="col-lg-12" style="text-align: center;">
                <input type="button" id="download_report" class="btn btn-grey" value="BACK" readonly>
                &nbsp;&nbsp;&nbsp;&nbsp;
                <input type="button" id="download_report" class="btn btn-primary" onclick="updateInvoicedLot()" value="SUBMIT" readonly>
            </div>
        </div>
    </div>
</div>

<script>
    var procurement_id = parseInt($("#invoiced_procurement_id").val())
    var invoice_items = []
    var wsn_items = []

    getProcurementHeader()

    function getProcurementHeader() {

        if (procurement_id <= 0 || isNaN(procurement_id)) {
            return false
        }

        $.ajax({
            "url": "<?= base_url() ?>admin/Procurement/getProcurementHeader",
            "data": {
                "procurement_id": procurement_id
            },
            "dataType": "json",
            "async": false,
            "success": function(data) {

                if (data.status != 1) {
                    toastr.error("Error: Failed to get Procurement Details")
                    return false
                }

                let result = data.result
                $("#invoiced_procurement_no").val(result.procurement_no)
                $("#invoiced_batch_no").val(result.batch_no)
                $("#invoiced_accepted_qty").val(result.accepted_qty)
            }


        })

    }

    function uploadInvoicedList() {
        $("#invoiced_fileList").text('')

        var input = document.getElementById('invoiced_input_upload_file');
        var output = document.getElementById('invoiced_fileList');
        var children = "";
        for (var i = 0; i < input.files.length; ++i) {
            children += '<li>' + input.files.item(i).name + '</li>';
        }
        output.innerHTML = '<ul>' + children + '</ul>';
    }

    function uploadWSNList() {
        $("#wsn_fileList").text('')

        var input = document.getElementById('wsn_input_upload_file');
        var output = document.getElementById('wsn_fileList');
        var children = "";
        for (var i = 0; i < input.files.length; ++i) {
            children += '<li>' + input.files.item(i).name + '</li>';
        }
        output.innerHTML = '<ul>' + children + '</ul>';
    }

    function uploadWSNFiles() {

        var files = document.getElementById("wsn_input_upload_file").files;
        var k = 0;
        if (files.length <= 0) {
            toastr.error("No WSN Files Selected")
            return false
        }
        readMultipleFiles()

        function readMultipleFiles(n = 0) {

            var file = files[n];
            var regex = /^([a-zA-Z0-9\s_\\.\()-:#!@$%^*&])+(.csv|.txt)$/;

            if (regex.test(file.name.toLowerCase())) {

                if (typeof(FileReader) != "undefined") {

                    var reader = new FileReader();
                    let filename = file.name
                    let filename_arr = filename.split('-')
                    reader.onload = function(e) {

                        var csvdata = e.target.result;
                        var rows = CSVToArray(csvdata)

                        for (var i = 1; i < rows.length; i++) {
                            var cells = rows[i]
                            if (cells[0] != '' && cells[0] != null) {
                                wsn_items[k] = {
                                    "wsn": cells[0],
                                    "wid": cells[1],
                                    "fsn": cells[2],
                                    "sku": cells[3],
                                    "listing_id": cells[4],
                                    "tracking_id": cells[5],
                                    "external_order_id": cells[6],
                                    "order_item_id": cells[7],
                                    "dpv_comments": cells[8],
                                    "condition": cells[11],
                                    "serial_no": cells[12],
                                    "qc_remarks": cells[13],
                                    "grade_in_system": cells[14],
                                    "lot_id": filename_arr[2]
                                }
                                k++
                            }
                        }
                        if (k > 0) {
                            $("#invoiced_procurement_submit").prop('disabled', false)
                        }

                        n++;
                        if (n < files.length) {
                            readMultipleFiles(n)
                        }

                    }
                    reader.readAsText(file);
                }
            } else {

                toastr.error(file.name + " Not a valid CSV File")
                return false
            }
        }
    }

    function uploadInvoicedFiles() {

        var files = document.getElementById("invoiced_input_upload_file").files;
        var k = 0;
        readMultipleInvoiceFiles()

        function readMultipleInvoiceFiles(n = 0) {

            var file = files[n];
            var regex = /^([a-zA-Z0-9\s_\\.\()-:#!@$%^*&])+(.csv|.txt)$/;

            if (regex.test(file.name.toLowerCase())) {
                if (typeof(FileReader) != "undefined") {
                    var reader = new FileReader();

                    let filename = file.name
                    let filename_arr = filename.split('_')
                    let filename_ext = filename_arr[2].split('.')

                    reader.onload = function(e) {

                        var csvdata = e.target.result;
                        var rows = CSVToArray(csvdata)

                        for (var i = 1; i < rows.length; i++) {
                            var cells = rows[i]

                            if (cells[0] != '' && cells[0] != null) {
                                invoice_items[k] = {
                                    "fsn": cells[0],
                                    "grade": cells[2],
                                    "quantity": cells[3],
                                    "fsp": cells[4],
                                    "mrp": cells[5],
                                    "ca_grade": cells[6],
                                    "brand_group": cells[7],
                                    "qc_remark": cells[8],
                                    "hsn_sac": cells[9],
                                    "yield_per_unit": cells[10],
                                    "total_exempted_value": cells[11],
                                    "taxable_value": cells[12],
                                    "sgst_utgst_rate": cells[13],
                                    "sgst_utgst": cells[14],
                                    "cgst_rate": cells[15],
                                    "cgst": cells[16],
                                    "igst_rate": cells[17],
                                    "igst": cells[18],
                                    "tcs": cells[19],
                                    "total_yield": cells[20],
                                    "sku": cells[21],
                                    "expiry_date": cells[22],
                                    "lot_id": filename_ext[0]
                                }
                                k++
                            }


                        }
                        if (k > 0) {
                            $("#invoiced_procurement_submit").prop('disabled', false)
                        }

                        n++;
                        if (n < files.length) {
                            readMultipleInvoiceFiles(n)
                        }
                    }
                    reader.readAsText(file);
                }
            } else {

                toastr.error(file.name + " Not a valid CSV File")
                return false
            }
        }
    }

    function CSVToArray(strData, strDelimiter) {

        strDelimiter = (strDelimiter || ",");

        var objPattern = new RegExp(
            (
                "(\\" + strDelimiter + "|\\r?\\n|\\r|^)" +

                "(?:\"([^\"]*(?:\"\"[^\"]*)*)\"|" +

                "([^\"\\" + strDelimiter + "\\r\\n]*))"
            ),
            "gi"
        );

        var arrData = [
            []
        ];

        var arrMatches = null;

        while (arrMatches = objPattern.exec(strData)) {

            var strMatchedDelimiter = arrMatches[1];

            if (
                strMatchedDelimiter.length &&
                strMatchedDelimiter !== strDelimiter
            ) {

                arrData.push([]);

            }

            var strMatchedValue;

            if (arrMatches[2]) {

                strMatchedValue = arrMatches[2].replace(
                    new RegExp("\"\"", "g"),
                    "\""
                );

            } else {
                strMatchedValue = arrMatches[3];

            }

            arrData[arrData.length - 1].push(strMatchedValue);
        }
        return (arrData);
    }

    function updateInvoicedLot() {

        if (procurement_id <= 0 || isNaN(procurement_id)) {
            return false
        }
        let invoiced_date = $("#input_invoiced_date").val()
        //console.log(wsn_items)
        // return false
        if (invoiced_date == '' || invoiced_date == null || invoiced_date == undefined) {
            toastr.error("Error: Please Enter Date")
            return false
        }
        let data = {
            "procurement_id": procurement_id,
            "invoiced_date": invoiced_date,
            "wsn_items": wsn_items,
            "invoice_items": invoice_items
        }

        if (wsn_items.length <= 0) {
            toastr.error("Error: Please Upload WSN Files")
            return false
        }

        if (invoice_items.length <= 0) {
            toastr.error("Error: Please Upload Performa Invoice Files")
            return false
        }

        var jsonObject = JSON.stringify(data)
        $("#invoiced_procurement_submit").prop('disabled', true)
        $.ajax({
            "url": "<?= base_url(); ?>admin/Procurement/updateInvoicedLot",
            "data": jsonObject,
            "dataType": "json",
            "method": "POST",
            "success": function(data) {

                if (data.status != 1) {
                    $("#invoiced_procurement_submit").prop('disabled', false)
                    toastr.error("Failed Add Procurement")
                    return false
                }

                window.location.replace("<?= base_url() ?>admin/Procurement/manage_procurement")
            }
        })
    }
</script>