<input type="hidden" id="validation_procurement_id" value="<?= $validation_procurement_id ?>">
<h4 style="margin-left:5px;">Proforma Invoice Details</h4>
<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="proformaInvoiceList_table">
    <thead>
        <tr>
            <th>PROCUREMENT NO</th>
            <th>Lot No</th>
            <th>Quantity</th>
            <th>Amount</th>
        </tr>
    <tbody>
        <tr class="proformaList_tbody">
            <td colspan="2">Total</td>
            <td class="proforma_total_qty"></td>
            <td class="proforma_total_amount"></td>
        </tr>
    </tbody>
    </thead>
</table>
<hr style="border: 3px solid #e4eaec">
<h4 style="margin-left:5px;">WSN Details</h4>
<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="WSNList_table">
    <thead>
        <tr>
            <th>PROCUREMENT NO</th>
            <th>Lot No</th>
            <th>Quantity</th>
        </tr>
    <tbody>
        <tr class="wsnList_tbody">
            <td colspan="2">Total</td>
            <td class="wsn_total_qty"></td>
        </tr>
    </tbody>
    </thead>
</table>

<div style="width: 100%; text-align:center;">
    <input type="button" value="APPROVE" class="btn btn-green" id="approve_btn_valid" onclick="approveInvoice()"> &nbsp;&nbsp;&nbsp;&nbsp;
    <input type="button" value="REJECT" class="btn btn-danger" id="reject_btn_valid" onclick="rejectInvoice()">
</div>

<script>
    $(document).ready(function() {
        var validation_procurement_id = $("#validation_procurement_id").val()
        getProformaInvoiceDetails()
        getWSNDetails()

        function getProformaInvoiceDetails() {

            proformaInvoiceList_table = $('#proformaInvoiceList_table').DataTable({
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "scrollY": 390,
                "scrollX": true,
                "scrollCollapse": true,
                //"autoWidth": false,
                "aaSorting": [],
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/Procurement/getProformaDetails",
                    "data": {
                        "procurement_id": validation_procurement_id
                    },
                    "type": "GET",
                    "dataSrc": "data"
                },
                "columns": [

                    {
                        "data": "procurement_no"
                    },
                    {
                        "data": "lot_id"
                    },
                    {
                        "data": "quantity"
                    },
                    {
                        "data": "amount"
                    }
                ]
            });

        }

        function getWSNDetails() {

            WSNList_table = $('#WSNList_table').DataTable({
                "paging": true,
                "destroy": true,
                "searching": true,
                "processing": true,
                "serverSide": false,
                "scrollY": 390,
                "scrollX": true,
                "scrollCollapse": true,
                //"autoWidth": false,
                "aaSorting": [],
                "ajax": {
                    "url": "<?php echo base_url(); ?>admin/Procurement/getWSNDetails",
                    "data": {
                        "procurement_id": validation_procurement_id
                    },
                    "type": "GET",
                    "dataSrc": "data"
                },
                "columns": [

                    {
                        "data": "procurement_no"
                    },
                    {
                        "data": "lot_id"
                    },
                    {
                        "data": "quantity"
                    }
                ]
            });

        }
    })

    function approveInvoice() {
        var validation_procurement_id = parseInt($("#validation_procurement_id").val())

        if(isNaN(validation_procurement_id) || validation_procurement_id <= 0){
            toastr.error("No Procurement Selected")
            return false
        }

        $("#approve_btn_valid").prop('disabled', true)
        $("#reject_btn_valid").prop('disabled', true)
        $.ajax({
            "url": "<?= base_url(); ?>admin/Procurement/approveValidateProcurement",
            "data": {"procurement_id": validation_procurement_id},
            "dataType": "json",
            "method": "GET",
            "success": function(data) {

                if (data.status != 1) {
                    $("#approve_btn_valid").prop('disabled', false)
                    $("#reject_btn_valid").prop('disabled', false)
                    toastr.error("Failed Approve Procurement")
                    return false
                }

                window.location.replace("<?= base_url() ?>admin/Procurement/manage_procurement")
            }
        })
    }

    function rejectInvoice() {
        var validation_procurement_id = parseInt($("#validation_procurement_id").val())

        if(isNaN(validation_procurement_id) || validation_procurement_id <= 0){
            toastr.error("No Procurement Selected")
            return false
        }

        $("#approve_btn_valid").prop('disabled', true)
        $("#reject_btn_valid").prop('disabled', true)
        $.ajax({
            "url": "<?= base_url(); ?>admin/Procurement/rejectValidateProcurement",
            "data": {"procurement_id": validation_procurement_id},
            "dataType": "json",
            "method": "GET",
            "success": function(data) {

                if (data.status != 1) {
                    $("#approve_btn_valid").prop('disabled', false)
                    $("#reject_btn_valid").prop('disabled', false)
                    toastr.error("Failed Approve Procurement")
                    return false
                }

                window.location.replace("<?= base_url() ?>admin/Procurement/manage_procurement")
            }
        })
    }
</script>