<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;">
    <div class="col-md-6  col-sm-6 col-xs-6" style="padding:0px">

        <div class="form-group">
            <label class="col-lg-4 control-label">SOURCE</label>
            <div class="col-lg-6">
                <input type="text" class="form-control" id="new_input_source">
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">WAREHOUSE</label>
            <div class="col-lg-6">
                <input type="text" class="form-control" id="new_input_warehouse">
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">CATEGORY</label>
            <div class="col-lg-6">
                <select class="form-control select_box" style="width: 100%;" id="new_input_category">
                    <option value="">SELECT CATEGORY</option>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">Batch No</label>
            <div class="col-lg-6">
                <input type="text" class="form-control" id="new_input_batch_no">
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">Accepted Quantity</label>
            <div class="col-lg-6">
                <input type="number" class="form-control" id="new_input_accepted_qty">
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">Accepted Date</label>
            <div class="col-lg-6">
                <input type="date" class="form-control" id="new_input_accepted_date">
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">PAID AMOUNT</label>
            <div class="col-lg-6">
                <input type="number" class="form-control" id="new_input_amount">
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">PAYMENT Reference NO</label>
            <div class="col-lg-6">
                <input type="text" class="form-control" id="new_input_ref_no">
            </div>
        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">Payment Date</label>
            <div class="col-lg-6">
                <input type="date" class="form-control" id="new_input_payment_date">
            </div>

        </div>

        <div class="form-group">
            <label class="col-lg-4 control-label">Upload File</label>
            <div class="col-lg-6">
                <input type="file" class="form-control" id="new_input_upload_file">
            </div>
            <div class="col-lg-2">
                <a href="<?php echo base_url('assets/sample/procurement/lot_offered_sample.csv'); ?>"><button type="button" id="file-save-button" value="Sample file" class="btn btn-success"></i> <i class="fa fa-file-excel-o"></i>&nbsp;Sample file</button></a>
            </div><br>
        </div>

        <div class="form-group">
            <div class="col-lg-12" style="text-align: center;">
                <input type="button" id="download_report" class="btn btn-grey" value="BACK" readonly>
                &nbsp;&nbsp;&nbsp;&nbsp;
                <input type="button" id="submit_new_procurement" class="btn btn-primary" onclick="submitNewProcurement()" value="SUBMIT" readonly>

            </div>

        </div>
    </div>
</div>

<script>
    dropdown('CATEGORY', 'new_input_category');

    function checkNull(entity = '', message = '') {

        if (entity == '' || entity == null || entity == NaN || entity == undefined || entity == 'NaN' || entity == 0) {
            return message
        }

        return ''
    }

    function dropdown(type, select_id) {
        $.ajax({
            type: "GET",
            url: "<?= base_url() ?>admin/DropDownItems/getItems?type=" + type,
            data: {},
            dataType: "json",
            success: function(data) {

                $.each(data, function(i, v) {
                    $("#" + select_id).append('<option value="' + data[i].name + '">' + data[i].name + '</option>')
                })

            },
            error: function(error) {
                alert(error.responseJSON.message);
            }
        });
    }

    function submitNewProcurement() {
        
        let accepted_quantity = parseInt($("#new_input_accepted_qty").val())
        let accepted_date = $("#new_input_accepted_date").val()
        let batch_no = $("#new_input_batch_no").val()
        let source = $("#new_input_source").val()
        let category = $("#new_input_category").val()
        let warehouse = $("#new_input_warehouse").val()
        let amount = $("#new_input_amount").val()
        let reference_no = $("#new_input_ref_no").val()
        let payment_date = $("#new_input_payment_date").val()
        var items = []
        let fields_required = ''

        fields_required += checkNull(accepted_quantity, 'Accepted Quantity, ')
        fields_required += checkNull(accepted_date, 'Date, ')
        fields_required += checkNull(batch_no, 'Batch No')
        fields_required += checkNull(source, 'Source, ')
        fields_required += checkNull(category, 'Category, ')
        fields_required += checkNull(warehouse, 'Warehouse, ')
        fields_required += checkNull(amount, 'Amount, ')
        fields_required += checkNull(reference_no, 'Reference No, ')
        fields_required += checkNull(payment_date, 'Payment Date')

        if (fields_required != '') {
            toastr.error("Fields Required :" + fields_required)
            return false
        }
        $("#submit_new_procurement").prop('disabled', true)
        var fileUpload = document.getElementById("new_input_upload_file");

        var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.csv|.txt)$/;
        if (regex.test(fileUpload.value.toLowerCase())) {
            if (typeof(FileReader) != "undefined") {
                var reader = new FileReader();

                reader.onload = function(e) {

                    var rows = e.target.result.split("\n");
                    var k = 0;
                    for (var i = 1; i < rows.length; i++) {
                        var cells = rows[i].split(",");

                        if (cells[0] != '') {
                            items[k] = {
                                "fsn": cells[0],
                                "wid": cells[1],
                                "quantity": cells[3],
                                "grade": cells[6],
                                "brand": cells[7],
                                "device_name": cells[8],
                                "rate": cells[9],
                                "discount": cells[10],
                                "discounted_rate": cells[11]
                            }
                        }
                        k++
                    }

                    var data = {
                        "accepted_qty": accepted_quantity,
                        "accepted_date": accepted_date,
                        "batch_no": batch_no,
                        "source": source,
                        "category": category,
                        "warehouse": warehouse,
                        "amount": amount,
                        "reference_no": reference_no,
                        "payment_date": payment_date,
                        "items": items
                    }
                    var jsonObject = JSON.stringify(data)

                    $.ajax({
                        "url": "<?= base_url(); ?>admin/Procurement/addNewProcurement",
                        "data": jsonObject,
                        "dataType": "json",
                        "method": "POST",
                        "success": function(data) {

                            if (data.status != 1) {
                                $("#submit_new_procurement").prop('disabled', false)
                                toastr.error("Failed Add Procurement")
                                return false
                            }

                            window.location.replace("<?= base_url() ?>admin/Procurement/manage_procurement")
                        }
                    })
                }
                reader.readAsText(fileUpload.files[0]);
            }

        } else {

            toastr.error(fileUpload.value + " is not a valid CSV File")
            $("#submit_new_procurement").prop('disabled', false)
            return false
        }
    }
</script>