<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;"> 
    <div class="col-md-7  col-sm-7" style="padding:0px">
    <input type="hidden" id="update_opening_balance_id" value="<?=$opening_balance_id?>">
        <div class="form-group">
            <label class="col-lg-3 control-label">CUSTOMER NAME</label>
            <div class="col-lg-6">
                <input type="text" id="customer_name_update_ob" class="form-control" style="width: 100%;" readonly>
                <input type="hidden" id="customer_id_update_ob">
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">BALANCE AMOUNT</label>
            <div class="col-lg-6">
                <input type="number" id="balance_amount_update_ob" class="form-control" style="width: 100%;">
            </div> 
        </div>

        <div class="form-group">
            <label class="col-lg-3 control-label">DATE</label>
            <div class="col-lg-6">
                <input type="date" id="balance_date_update_ob" class="form-control" style="width: 100%;" value="2020-04-01" readonly>
            </div> 
        </div>

        <div class="form-group">
            
            <div class="col-lg-9" style="text-align: right;">
                <button type="button" id="update_ob_submit" class="btn btn-primary " onclick="submitUpdateOB()">SUBMIT</button>
            </div> 
        </div>
          
    </div>
</div>


<script>
    
    var opening_balance_id = $("#update_opening_balance_id").val()
    getOBHeader()



    function IndianCurrency(rupees){
        
        rupees=parseFloat (rupees)
        
        if(isNaN(rupees) || rupees == 'NaN'){
            return '';
        }
		return rupees.toLocaleString ('en-IN',
										{minimumFractionDigits : 2,
										maximumFractionDigits : 2}
                                    );
                                    
       
	}

    function checkNull(entity, message){
		
        if(entity == '0' || entity == undefined || entity== 0 || entity == '' || entity == null){ 
				return message;
		}		
		return '';
	}

  function getOBHeader(){

      var fields_required = checkNull(opening_balance_id, 'Opening Blance ID')

      if(fields_required != ''){
          return false
      }

        $.ajax({
            "url": "<?=base_url()?>admin/Ledger/getOBHeader",
            "type": "GET",
            "dataType": "json",
            "data": { "opening_balance_id": opening_balance_id},
            "async": false,
            "success": function(data){
                
                if(data.status != 1){
                    toastr.error("Failed to get Opening Balance Data")
                    return false
                }
                $("#balance_amount_update_ob").val(data.data[0].balance_amount)
                $("#balance_date_update_ob").val(data.data[0].balance_date)
                $("#customer_name_update_ob").val(data.data[0].vendor_name)
                $("#customer_id_update_ob").val(data.data[0].vendor_id)

            },
            "error": function (){
                toastr.error("Failed to get Customer List")
            }
        })
    }

    function submitUpdateOB(){

        var customer_id = $("#customer_id_update_ob").val()
        var balance_amount = $("#balance_amount_update_ob").val()
        var balance_date = $("#balance_date_update_ob").val()
        var fields_required = '';
        var data = []

        if(isNaN(parseFloat(balance_amount))){
            alert("Please enter a valid Amount")
            return false
        }

        fields_required += checkNull(customer_id, 'Customer, ')
        fields_required += checkNull(balance_date, 'Date, ')
        fields_required += checkNull(opening_balance_id, 'Opening Balance Id')
        
        if(fields_required != ''){
            alert("Fields Required: "+fields_required)
            return false
        }

        data = {
                    "opening_balance_id": opening_balance_id,
                    "balance_amount": balance_amount,
                    "balance_date": balance_date
                }
        var jsonObject = JSON.stringify(data)

        $.ajax({
            "url": "<?=base_url()?>admin/Ledger/updateOB",
            "type": "POST",
            "data": jsonObject,
            "dataType": "json",
            "success": function(data){

                        if(data.status != 1){
                          
                            toastr.error("Error: Failed to Update Opening Balance")
                            return false
                        }

                        toastr.success("Opening Balance Updated Successfully")
                        window.location.replace("<?=base_url()?>admin/Ledger/manage_ledger/3")
                    },
            "error": function(data){
                        toastr.error("Failed to Update New Opening Balance")
                        return false
                    }
        })
    }
    
</script>