<div class="col-md-12 col-sm-12 col-xs-12 form-horizontal" style="padding:10px; text-align:left;"> 
    <div class="col-md-7 col-sm-7" style="padding:0px">
    
        <div class="form-group">
            <label class="col-lg-3 control-label">SUPPLIER NAME</label>
            <div class="col-lg-5">
                <select id="select_supplier" class="form-control select_box"  style="width:100%" onchange="getSupplierLedgerList()">
                        <option value="">SELECT SUPPLIER</option>
                </select>
            </div> 
        
            <div class="col-lg-2">
                <button type="button" class="btn btn-primary" id="button_supplier_ledger" onclick="getSupplierLedgerList()" >
                SEARCH
                </button>
            </div>

            <div class="col-lg-2">
                <button type="button" class="btn btn-success" id="download_supplier_ledger_excel" onclick="getSupplierLedgerExcel()" >
                    <span class="fa fa-file-excel-o" ></span>&nbsp;&nbsp;Download
                </button>
            </div>

        </div>
    </div>
</div>


<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="supplierLedgerList_table">
    <thead>
        <tr>
            <th>DATE</th>
            <th>BILL TYPE</th>
            <th>REFERENCE<br>NUMBER</th>
            <th>PURCHASE<br> AMOUNT</th>
            <th>PAYMENT <br> AMOUNT</th>
            <th>BALANCE<br> AMOUNT</th>	
        </tr>
    </thead>		
</table>

<script>
    getSupplierList()

    function IndianCurrency(rupees){
        
        rupees=parseFloat (rupees)
        
        if(isNaN(rupees) || rupees == 'NaN'){
            return '';
        }
		return rupees.toLocaleString ('en-IN',
										{minimumFractionDigits : 2,
										maximumFractionDigits : 2}
                                    );
                                    
       
	}

  function getSupplierList(){

    $.ajax({
        "url": "<?=base_url()?>Web_api/getSupplierList/",
        "type": "GET",
        "dataType": "json",
        "async": false,
        "success": function(data){
            
            $.each(data.result, function (i, d) { // loop through data returned from ajax
                var a = '<option value="'+data.result[i].vendor_id+'">'+data.result[i].company+'</option>';
                $("#select_supplier").append(a)
            })
        },
        "error": function (){
            toastr.error("Failed to get Supplier List")
        }
    })
}

    function getSupplierLedgerList(){

        var supplier_id = $("#select_supplier").val()

        if(supplier_id == '' || supplier_id == null || supplier_id == '0'){
            alert('Please Select a Supplier');
            return false
        }

        customerLedgerList_table = $('#supplierLedgerList_table').DataTable({
                                "paging":true,
                                "destroy":true,
                                "searching":true,
                                "processing": true,
                                "serverSide": false,  
                                "scrollY": 390,
                                "scrollX": true,
                                "scrollCollapse": true,
                                //"autoWidth": false,
                                "aaSorting": [],
                                "ajax": {
                                    "url": "<?php echo base_url(); ?>admin/Ledger/getSupplierLedgerList",
                                    "data": { "supplier_id": supplier_id},
                                    "type": "GET",
                                    "dataSrc": "data"
                                },
                                "columns": [
                                
                                    { "data": "date" },	
                                    { "data": "bill_type" },	
                                    { "data": "invoice_no" },
                                    { "data": "",
                                        "render": function(data, type, row){
                                            return IndianCurrency(row.credit)
                                        } 
                                    },
                                    { "data": "",
                                        "render": function(data, type, row){
                                            return IndianCurrency(row.debit)
                                        } 
                                    },
                                    { "data": "",
                                        "render": function(data, type, row){
                                            return IndianCurrency(row.balance)
                                        } 
                                    },
                                ]
                });

       
    }

      function getSupplierLedgerExcel(){

        var supplier_id = $("#select_supplier").val()

        if(supplier_id == '' || supplier_id == null || supplier_id == '0' || supplier_id == 'null'){
            alert("Please select a Supplier")
            return false
        }

        window.open("<?=base_url()?>admin/Ledger/getSupplierLedgerExcel?supplier_id="+supplier_id, '_blank')

    }
</script>