
<table class="table table-striped DataTables" style="margin-left:5px; width:100%;" id="openingBalanceList_table">
    <thead>
        <tr style="width: 100%;">
            
            <th></th>
            <th>CUSTOMER <br> NAME</th>
            <th>BALANCE<br> AMOUNT</th>
            <th>DATE</th>
        </tr>
    </thead>		
</table>

<script>

    
    function IndianCurrency(rupees){
        
        rupees=parseFloat (rupees)
        
        if(isNaN(rupees) || rupees == 'NaN'){
            return '';
        }
		return rupees.toLocaleString ('en-IN',
										{minimumFractionDigits : 2,
										maximumFractionDigits : 2}
                                    );
                                    
       
	}


$(document).ready(function(){

    getOpeningBalanceList();
    
    function getOpeningBalanceList(){

         openingBalanceList_table = $('#openingBalanceList_table').DataTable({
                                "paging":true,
                                "destroy":true,
                                "searching":true,
                                "processing": true,
                                "serverSide": false,  
                                "responsive": true,
                                "scrollY": 390,
                                "scrollX": true,
                                "scrollCollapse": true,
                                "autoWidth": false,
                                //"bSort":false,
                                "aaSorting": [],
                                "ajax": {
                                    "url": "<?php echo base_url(); ?>admin/Ledger/getOpeningBalanceList",
                                    "type": "GET",
                                    "dataSrc": "data"
                                    
                                },
                                "columns": [
                                    
                                    { "data": "",
                                      "render": function(data, type, row){
                                        return '<a class="fa fa-edit" href="<?=base_url()?>admin/Ledger/updateOBForm/'+row.opening_balance_id+'" style="color:black;"></a>'
                                      }
                                    },
                                    { "data": "vendor_name" },	
                                    { "data": "",
                                        "render": function(data, type, row){
                                            return IndianCurrency(row.balance_amount)
                                        } 
                                    },
                                    { "data": "balance_date" },
                                   
                                ]
                });
    }
})


</script>